/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.menu.ActionMenuItem;
import org.iplass.mtp.view.menu.EntityMenuItem;
import org.iplass.mtp.view.menu.MenuItem;
import org.iplass.mtp.view.menu.MenuItemVisitor;
import org.iplass.mtp.view.menu.MenuTree;
import org.iplass.mtp.view.menu.NodeMenuItem;
import org.iplass.mtp.view.menu.UrlMenuItem;
import org.iplass.mtp.web.actionmapping.permission.ActionParameter;
import org.iplass.mtp.web.actionmapping.permission.ActionPermission;

public class MenuAuthVisitor
implements MenuItemVisitor<Boolean> {
    private AuthContext authContext;

    public MenuAuthVisitor(AuthContext authContext) {
        this.authContext = authContext;
    }

    @Override
    public Boolean visit(MenuTree menuTree) {
        menuTree.setMenuItems(this.acceptChild(menuTree.getMenuItems()));
        return true;
    }

    @Override
    public Boolean visitNoMenu(MenuTree menuTree) {
        return true;
    }

    @Override
    public Boolean visit(NodeMenuItem nodeMenuItem) {
        nodeMenuItem.setChilds(this.acceptChild(nodeMenuItem.getChilds()));
        return nodeMenuItem.getChilds() != null;
    }

    @Override
    public Boolean visit(ActionMenuItem actionMenuItem) {
        String param;
        String actionName = actionMenuItem.getActionName();
        if (!this.checkActionPermission(actionName, new HashMap<String, String>(), param = actionMenuItem.getParameter()).booleanValue()) {
            return false;
        }
        actionMenuItem.setChilds(this.acceptChild(actionMenuItem.getChilds()));
        return true;
    }

    @Override
    public Boolean visit(EntityMenuItem entityMenuItem) {
        String entityName = entityMenuItem.getEntityDefinitionName();
        if (!this.authContext.checkPermission((Permission)new EntityPermission(entityName, EntityPermission.Action.REFERENCE))) {
            return false;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("defName", entityName);
        paramMap.put("viewName", entityMenuItem.getViewName());
        String param = entityMenuItem.getParameter();
        if (!this.checkActionPermission("gem/generic/search/view", paramMap, param).booleanValue()) {
            return false;
        }
        entityMenuItem.setChilds(this.acceptChild(entityMenuItem.getChilds()));
        return true;
    }

    @Override
    public Boolean visit(UrlMenuItem urlMenuItem) {
        return true;
    }

    private List<MenuItem> acceptChild(List<MenuItem> childs) {
        if (childs == null || childs.isEmpty()) {
            return null;
        }
        List<MenuItem> validChilds = childs.stream().filter(child -> child.accept(this)).collect(Collectors.toList());
        if (validChilds.isEmpty()) {
            return null;
        }
        return validChilds;
    }

    private Boolean checkActionPermission(String actionName, Map<String, String> paramMap, String param) {
        if (StringUtil.isNotEmpty((String)param)) {
            paramMap.putAll(Arrays.stream(param.split("&")).map(value -> value.split("=")).filter(value -> ((String[])value).length == 2).collect(Collectors.toMap(value -> value[0], value -> value[1])));
        }
        if (this.authContext.checkPermission((Permission)new ActionPermission(actionName, (ActionParameter)new MenuActionParameter(paramMap)))) {
            return true;
        }
        return false;
    }

    private static class MenuActionParameter
    implements ActionParameter {
        private Map<String, String> paramValue;

        public MenuActionParameter(Map<String, String> paramValue) {
            this.paramValue = paramValue;
        }

        public Object getValue(String name) {
            return this.paramValue.get(name);
        }
    }
}

