/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.iplass.gem.command.MenuAuthVisitor;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ActionMappings;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.template.Template;
import org.iplass.mtp.command.annotation.template.Templates;
import org.iplass.mtp.definition.annotation.LocalizedString;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.hint.CacheHint;
import org.iplass.mtp.entity.query.hint.Hint;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.menu.EntityMenuItem;
import org.iplass.mtp.view.menu.MenuItem;
import org.iplass.mtp.view.menu.MenuTree;
import org.iplass.mtp.view.menu.MenuTreeManager;
import org.iplass.mtp.view.top.TopViewDefinitionManager;
import org.iplass.mtp.web.template.TemplateUtil;

@ActionMappings(value={@ActionMapping(name="gem/layout/defaultLayout", displayName="\u6a19\u6e96\u30ec\u30a4\u30a2\u30a6\u30c8", localizedDisplayName={@LocalizedString(localeName="ja", stringValue="\u6a19\u6e96\u30ec\u30a4\u30a2\u30a6\u30c8"), @LocalizedString(localeName="en", stringValue="Default Layout")}, result={@Result(type=Result.Type.JSP, value="/jsp/gem/layout/layout.jsp", templateName="gem/layout/layout")}), @ActionMapping(name="gem/layout/popupLayout", displayName="\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7\u30ec\u30a4\u30a2\u30a6\u30c8", localizedDisplayName={@LocalizedString(localeName="ja", stringValue="\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7\u30ec\u30a4\u30a2\u30a6\u30c8"), @LocalizedString(localeName="en", stringValue="Popup Layout")}, result={@Result(type=Result.Type.JSP, value="/jsp/gem/layout/dialog.jsp", templateName="gem/layout/dialog")}), @ActionMapping(name="gem/index", displayName="TOP\u753b\u9762", localizedDisplayName={@LocalizedString(localeName="ja", stringValue="TOP\u753b\u9762"), @LocalizedString(localeName="en", stringValue="Top View")}, clientCacheType=ActionMapping.ClientCacheType.CACHE, clientCacheMaxAge=0L, command={}, result={@Result(type=Result.Type.JSP, value="/jsp/gem/layout/index.jsp", templateName="gem/layout/index", layoutActionName="gem/layout/defaultLayout")}), @ActionMapping(name="gem/logout", displayName="\u30ed\u30b0\u30a2\u30a6\u30c8", localizedDisplayName={@LocalizedString(localeName="ja", stringValue="\u30ed\u30b0\u30a2\u30a6\u30c8"), @LocalizedString(localeName="en", stringValue="Logout")}, command={}, result={@Result(type=Result.Type.REDIRECT, value=".")})})
@Templates(value={@Template(name="gem/layout/header", displayName="\u30d8\u30c3\u30c0\u30fc", path="/jsp/gem/layout/header.jsp"), @Template(name="gem/layout/footer", displayName="\u30d5\u30c3\u30bf\u30fc", path="/jsp/gem/layout/footer.jsp"), @Template(name="gem/layout/navi", displayName="\u30ca\u30d3", path="/jsp/gem/layout/navi.jsp"), @Template(name="gem/menu/menu", displayName="\u30e1\u30cb\u30e5\u30fc", path="/jsp/gem/menu/menu.jsp"), @Template(name="gem/generic/common/error", displayName="\u30a8\u30e9\u30fc\u753b\u9762", path="/jsp/gem/generic/error.jsp", layoutActionName="gem/layout/defaultLayout"), @Template(name="gem/generic/error", displayName="\u30a8\u30e9\u30fc\u753b\u9762\uff08\u901a\u5e38\uff09", path="/jsp/gem/generic/error.jsp", layoutActionName="gem/layout/defaultLayout"), @Template(name="gem/error/system", displayName="\u30a8\u30e9\u30fc\u753b\u9762\uff08\u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\uff09", path="/jsp/gem/error/Error.jsp", contentType="text/html; charset=utf-8"), @Template(name="gem/auth/PermissionError", displayName="\u6a29\u9650\u30a8\u30e9\u30fc", path="/jsp/gem/error/Error.jsp", contentType="text/html; charset=utf-8")})
@CommandClass(name="gem/MenuCommand", displayName="\u30e1\u30cb\u30e5\u30fc", localizedDisplayName={@LocalizedString(localeName="ja", stringValue="\u30e1\u30cb\u30e5\u30fc"), @LocalizedString(localeName="en", stringValue="Menu")}, readOnly=true)
public final class MenuCommand
implements Command {
    public static final String ACTION_NAME = "gem/index";
    public static final String DEFAULT = "DEFAULT";
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
    private MenuTreeManager mtm = (MenuTreeManager)ManagerLocator.getInstance().getManager(MenuTreeManager.class);
    private TopViewDefinitionManager tm = (TopViewDefinitionManager)ManagerLocator.getInstance().getManager(TopViewDefinitionManager.class);

    public String execute(RequestContext request) {
        AuthContext authContext = AuthContext.getCurrentContext();
        List allMenuNames = this.mtm.definitionList();
        List<String> permitMenuNames = this.checkRole(authContext, allMenuNames);
        List allTopNames = this.tm.definitionList();
        List<String> permitTopNames = this.checkRole(authContext, allTopNames);
        String selectRoleName = (String)request.getSession().getAttribute("roleName");
        MenuTree selectTree = null;
        LinkedHashMap<String, String> sortedRoleMap = null;
        if (permitMenuNames.isEmpty() && permitTopNames.isEmpty()) {
            if (allMenuNames.contains(DEFAULT)) {
                selectTree = (MenuTree)this.mtm.get(DEFAULT);
                sortedRoleMap = new LinkedHashMap();
                selectRoleName = null;
            }
        } else {
            sortedRoleMap = this.getRoleNames(permitMenuNames, permitTopNames);
            if (authContext.getUser().isAdmin() && allMenuNames.contains(DEFAULT)) {
                sortedRoleMap.put(DEFAULT, ((MenuTree)this.mtm.get(DEFAULT)).getName());
            }
            if (StringUtil.isEmpty((String)selectRoleName)) {
                selectRoleName = sortedRoleMap.keySet().iterator().next();
                request.getSession().setAttribute("roleName", (Object)selectRoleName);
            }
            selectTree = (MenuTree)this.mtm.get(selectRoleName);
        }
        if (selectTree == null) {
            List<MenuItem> items = this.createEntityMenuItem();
            selectTree = new MenuTree();
            selectTree.setMenuItems(items);
        }
        MenuAuthVisitor visitor = new MenuAuthVisitor(authContext);
        selectTree.accept(visitor);
        request.setAttribute("role", sortedRoleMap);
        request.setAttribute("roleName", (Object)selectRoleName);
        request.setAttribute("menuTree", (Object)selectTree);
        request.setAttribute("language", (Object)ExecuteContext.getCurrentContext().getLanguage());
        return "SUCCESS";
    }

    private List<String> checkRole(AuthContext authContext, List<String> defNames) {
        if (defNames != null && !defNames.isEmpty()) {
            return defNames.stream().filter(name -> !DEFAULT.equals(name)).filter(name -> authContext.userInRole(name)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private LinkedHashMap<String, String> getRoleNames(List<String> menuNames, List<String> topNames) {
        HashSet<String> roleNames = new HashSet<String>(menuNames);
        roleNames.addAll(topNames);
        if (roleNames.isEmpty()) {
            return new LinkedHashMap<String, String>();
        }
        Query query = new Query().hint((Hint)new CacheHint()).select(new Object[]{"code", "name", "priority"}).from("mtp.auth.Role").where((Condition)new In("code", roleNames.toArray()));
        List roleList = this.em.searchEntity(query).getList();
        LinkedHashMap ret = roleList.stream().map(entity -> {
            MenuTree mt = (MenuTree)this.mtm.get((String)entity.getValue("code"));
            if (mt != null) {
                String displayName;
                if (mt.isShowMenuDisplayName() && StringUtil.isNotEmpty((String)(displayName = TemplateUtil.getMultilingualString((String)mt.getDisplayName(), mt.getLocalizedDisplayNameList())))) {
                    entity.setName(displayName);
                }
                return new RoleInfo((Entity)entity, mt.getDisplayOrder());
            }
            return new RoleInfo((Entity)entity, Integer.MAX_VALUE);
        }).sorted(Comparator.comparing(RoleInfo::getDisplayOrder).thenComparing(Comparator.comparing(RoleInfo::getPriority).reversed()).thenComparing(Comparator.comparing(RoleInfo::getName))).collect(Collectors.toMap(RoleInfo::getCode, RoleInfo::getName, (a, b) -> a, LinkedHashMap::new));
        return ret;
    }

    private List<MenuItem> createEntityMenuItem() {
        List defList = this.edm.definitionList();
        List<MenuItem> items = defList.stream().sorted((name1, name2) -> name1.compareTo((String)name2)).map(name -> {
            EntityMenuItem item = new EntityMenuItem();
            item.setName((String)name);
            item.setEntityDefinitionName((String)name);
            return item;
        }).collect(Collectors.toList());
        return items;
    }

    private static class RoleInfo {
        private final Entity role;
        private final Integer displayOrder;

        public RoleInfo(Entity role, Integer dispOrder) {
            this.role = role;
            this.displayOrder = dispOrder != null ? dispOrder : Integer.MAX_VALUE;
        }

        public Integer getDisplayOrder() {
            return this.displayOrder;
        }

        public Long getPriority() {
            return this.role.getValue("priority") != null ? (Long)this.role.getValue("priority") : Long.valueOf(Long.MIN_VALUE);
        }

        public String getName() {
            return this.role.getName();
        }

        public String getCode() {
            return (String)this.role.getValue("code");
        }
    }
}

