/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command;

import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.iplass.gem.EntityViewHelper;
import org.iplass.gem.GemConfigService;
import org.iplass.gem.Skin;
import org.iplass.gem.Theme;
import org.iplass.gem.command.generic.detail.DetailFormViewData;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.tenant.MetaTenant;
import org.iplass.mtp.impl.tenant.MetaTenantService;
import org.iplass.mtp.impl.tenant.gem.MetaTenantGemInfo;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.gem.TenantGemInfo;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.FormView;
import org.iplass.mtp.view.generic.common.WebApiAutocompletionSetting;
import org.iplass.mtp.view.generic.editor.DateTimeFormatSetting;
import org.iplass.mtp.view.generic.editor.LocalizedDateTimeFormatSetting;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.property.PropertyColumn;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.iplass.mtp.view.generic.element.section.SearchConditionSection;
import org.iplass.mtp.view.generic.element.section.SearchResultSection;
import org.iplass.mtp.view.top.TopViewDefinition;
import org.iplass.mtp.view.top.TopViewDefinitionManager;
import org.iplass.mtp.view.top.parts.CsvDownloadSettingsParts;
import org.iplass.mtp.view.top.parts.TopViewParts;
import org.iplass.mtp.web.template.TemplateUtil;

public class ViewUtil {
    public static Skin getSkin() {
        List<Skin> skins;
        Skin skin = ViewUtil.getCurrentSkin();
        if (skin == null && (skins = ViewUtil.getSkinList()) != null && !skins.isEmpty()) {
            skin = skins.get(0);
        }
        return skin;
    }

    private static Skin getCurrentSkin() {
        Tenant tenant = TemplateUtil.getTenant();
        String skinName = ViewUtil.getTenantGemInfo(tenant).getSkin();
        if (StringUtil.isNotEmpty((String)skinName)) {
            for (Skin skin : ViewUtil.getSkinList()) {
                if (!skinName.equals(skin.getSkinName())) continue;
                return skin;
            }
        }
        return null;
    }

    private static List<Skin> getSkinList() {
        List<Skin> skins = ((GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class)).getSkins();
        if (skins == null) {
            skins = Collections.emptyList();
        }
        return skins;
    }

    public static Theme getTheme() {
        List<Theme> themes;
        Theme theme = ViewUtil.getCurrentTheme();
        if (theme == null && (themes = ViewUtil.getThemeList()) != null && !themes.isEmpty()) {
            theme = themes.get(0);
        }
        return theme;
    }

    private static Theme getCurrentTheme() {
        Tenant tenant = TemplateUtil.getTenant();
        String themeName = ViewUtil.getTenantGemInfo(tenant).getTheme();
        if (StringUtil.isNotEmpty((String)themeName)) {
            for (Theme theme : ViewUtil.getThemeList()) {
                if (!themeName.equals(theme.getThemeName())) continue;
                return theme;
            }
        }
        return null;
    }

    private static List<Theme> getThemeList() {
        List<Theme> themes = ((GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class)).getThemes();
        if (themes == null) {
            themes = Collections.emptyList();
        }
        return themes;
    }

    @Deprecated
    public static String getImagePath() {
        return ViewUtil.getSkinImagePath();
    }

    public static String getSkinImagePath() {
        String contentPath = TemplateUtil.getStaticContentPath();
        Skin skin = ViewUtil.getSkin();
        return contentPath + "/images/gem/skin/" + skin.getPageSkinName();
    }

    public static String getThemeImagePath() {
        String skinImagePath = ViewUtil.getSkinImagePath();
        Theme theme = ViewUtil.getTheme();
        return skinImagePath + "/theme/" + theme.getThemeName();
    }

    public static FormView getFormView(String defName, String viewName, boolean isSearchForm) {
        FormView view = null;
        view = isSearchForm ? ViewUtil.getFormView(defName, viewName, "search") : ViewUtil.getFormView(defName, viewName, "detail");
        return view;
    }

    public static FormView getFormView(String defName, String viewName, String viewType) {
        if (defName == null || defName.isEmpty()) {
            return null;
        }
        EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);
        EntityView ev = (EntityView)evm.get(defName);
        if (ev == null) {
            return null;
        }
        FormView form = null;
        if ("detail".equals(viewType)) {
            form = viewName == null || viewName.isEmpty() ? ev.getDefaultDetailFormView() : ev.getDetailFormView(viewName);
        } else if ("search".equals(viewType) || "searchResult".equals(viewType) || "bulk".equals(viewType)) {
            form = viewName == null || viewName.isEmpty() ? ev.getDefaultSearchFormView() : ev.getSearchFormView(viewName);
        } else if ("multiBulk".equals(viewType)) {
            form = viewName == null || viewName.isEmpty() ? ev.getDefaultBulkFormView() : ev.getBulkFormView(viewName);
        }
        return form;
    }

    public static String getEntityImageColor(String defName, String viewName, boolean isSearchForm) {
        FormView view = ViewUtil.getFormView(defName, viewName, isSearchForm);
        return ViewUtil.getEntityImageColor(view);
    }

    public static String getEntityImageColor(FormView view) {
        if (view == null || view.getImageColor() == null) {
            return null;
        }
        return view.getImageColor();
    }

    public static String getIconTag(FormView view) {
        if (view == null) {
            return "";
        }
        return StringUtil.isNotBlank((String)view.getIconTag()) ? view.getIconTag() : "";
    }

    public static List<PropertyItem> filterPropertyItem(List<Element> elements) {
        return elements.stream().filter(e -> e instanceof PropertyItem).map(e -> (PropertyItem)e).collect(Collectors.toList());
    }

    public static PropertyItem filterPropertyItem(List<Element> elements, String propName) {
        Optional<PropertyItem> property = elements.stream().filter(e -> e instanceof PropertyItem).map(e -> (PropertyItem)e).filter(e -> propName.equals(e.getPropertyName())).findFirst();
        if (property.isPresent()) {
            return property.get();
        }
        return null;
    }

    public static List<PropertyColumn> filterPropertyColumn(List<Element> elements) {
        return elements.stream().filter(e -> e instanceof PropertyColumn).map(e -> (PropertyColumn)e).collect(Collectors.toList());
    }

    public static boolean isConfirmEditSave() {
        GemConfigService gemConfigService = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        return gemConfigService.isConfirmEditSave();
    }

    public static boolean isConfirmEditCancel() {
        GemConfigService gemConfigService = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        return gemConfigService.isConfirmEditCancel();
    }

    @Deprecated
    public static boolean isTopViewEditCancelBackToTop() {
        GemConfigService gemConfigService = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        return gemConfigService.isTopViewEditCancelBackToTop();
    }

    public static boolean isShowSeachCondResetButton() {
        GemConfigService gemConfigService = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        return gemConfigService.isShowSeachCondResetButton();
    }

    public static List<String> getCsvDownloadCharacterCode() {
        GemConfigService gemConfigService = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        return gemConfigService.getCsvDownloadCharacterCode();
    }

    public static int getSearchInterval() {
        GemConfigService gemConfigService = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        return gemConfigService.getSearchInterval();
    }

    public static int getSearchLimit(SearchResultSection resultSection) {
        Integer limit = resultSection.getDispRowCount();
        if (limit != null && limit > 0) {
            return limit;
        }
        GemConfigService gemConfigService = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        return gemConfigService.getSearchResultDispRowCount();
    }

    public static int getCsvDownloadInterval() {
        GemConfigService gemConfigService = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        return gemConfigService.getCsvDownloadInterval();
    }

    public static boolean isEntityViewCsvDownloadSpecifyCharacterCode(SearchConditionSection.CsvDownloadSpecifyCharacterCode csvDownloadSpecifyCharacterCode) {
        boolean entityViewCsvDownloadSpecifyCharacterCode = false;
        switch (csvDownloadSpecifyCharacterCode) {
            case SPECIFY: {
                entityViewCsvDownloadSpecifyCharacterCode = true;
                break;
            }
            case NOT_SPECIFY: {
                entityViewCsvDownloadSpecifyCharacterCode = false;
                break;
            }
            default: {
                CsvDownloadSettingsParts csvDownloadSettingsParts = ViewUtil.getCsvDownloadSettingsParts();
                if (csvDownloadSettingsParts == null) break;
                entityViewCsvDownloadSpecifyCharacterCode = csvDownloadSettingsParts.isSpecfyCharacterCodeEntityView();
            }
        }
        return entityViewCsvDownloadSpecifyCharacterCode;
    }

    private static CsvDownloadSettingsParts getCsvDownloadSettingsParts() {
        String roleName = (String)TemplateUtil.getRequestContext().getSession().getAttribute("roleName");
        if (roleName == null) {
            roleName = "DEFAULT";
        }
        TopViewDefinitionManager manager = (TopViewDefinitionManager)ManagerLocator.getInstance().getManager(TopViewDefinitionManager.class);
        TopViewDefinition td = (TopViewDefinition)manager.get(roleName);
        CsvDownloadSettingsParts csvDownloadSettingsParts = null;
        if (td != null) {
            for (TopViewParts parts : td.getParts()) {
                if (!(parts instanceof CsvDownloadSettingsParts)) continue;
                csvDownloadSettingsParts = (CsvDownloadSettingsParts)parts;
                break;
            }
        }
        return csvDownloadSettingsParts;
    }

    public static boolean isShowPulldownPleaseSelectLabel() {
        GemConfigService gemConfigService = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        return gemConfigService.isShowPulldownPleaseSelectLabel();
    }

    public static boolean isCsvUploadAsync() {
        GemConfigService gemConfigService = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        return gemConfigService.isCsvUploadAsync();
    }

    public static int getCsvUploadStatusPollingInterval() {
        GemConfigService gemConfigService = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        return gemConfigService.getCsvUploadStatusPollingInterval();
    }

    public static List<String> getCssPathList(String skinName) {
        GemConfigService gemConfigService = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        return gemConfigService.getCssPathList(skinName);
    }

    public static final EntityViewHelper getEntityViewHelper() {
        GemConfigService gemConfigService = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        return gemConfigService.getEntityViewHelper();
    }

    public static boolean isDialog(RequestContext context) {
        Boolean isDialog = (Boolean)context.getAttribute("isDialog");
        return isDialog != null && isDialog != false;
    }

    public static boolean dispElement(Element element) {
        return ViewUtil.dispElement(TemplateUtil.getRequestContext(), element);
    }

    public static boolean dispElement(RequestContext context, Element element) {
        DetailFormViewData data = (DetailFormViewData)context.getAttribute("data");
        String execType = data.getExecType();
        return ViewUtil.dispElement(execType, element);
    }

    public static boolean dispElement(String execType, Element element) {
        if (execType == null) {
            return true;
        }
        if (element.getEditDisplayType() == Element.EditDisplayType.INSERT) {
            return Element.EditDisplayType.INSERT.name().toLowerCase().equals(execType.toLowerCase());
        }
        if (element.getEditDisplayType() == Element.EditDisplayType.UPDATE) {
            return Element.EditDisplayType.UPDATE.name().toLowerCase().equals(execType.toLowerCase());
        }
        return true;
    }

    public static String getDispTenantNameWithDispChecked() {
        String dispTenantName = ViewUtil.getDispTenantName();
        Tenant tenant = TemplateUtil.getTenant();
        boolean isDisp = ViewUtil.getTenantGemInfo(tenant).isDispTenantName();
        if (!isDisp) {
            dispTenantName = ((TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class)).getDefaultTenantName();
        }
        return dispTenantName;
    }

    public static String getDispTenantName() {
        Tenant tenant = TemplateUtil.getTenant();
        MetaTenantService metaTenantService = (MetaTenantService)ServiceRegistry.getRegistry().getService(MetaTenantService.class);
        MetaTenant.MetaTenantHandler handler = metaTenantService.getRuntimeByName(tenant.getName());
        MetaTenantGemInfo.MetaTenantGemInfoRuntime metaTenantGemInfoRuntime = (MetaTenantGemInfo.MetaTenantGemInfoRuntime)handler.getConfigRuntime(MetaTenantGemInfo.MetaTenantGemInfoRuntime.class);
        return metaTenantGemInfoRuntime.getScreenTitle();
    }

    public static String getTenantImgUrlWithDispChecked() {
        String tenantImgUrl = ViewUtil.getTenantImgUrl();
        Tenant tenant = TemplateUtil.getTenant();
        boolean isDisp = ViewUtil.getTenantGemInfo(tenant).isDispTenantName();
        if (!isDisp) {
            tenantImgUrl = "";
        }
        return tenantImgUrl;
    }

    public static String getTenantImgUrl() {
        Tenant tenant = TemplateUtil.getTenant();
        String tenantImgUrl = ViewUtil.getTenantGemInfo(tenant).getTenantImageUrl();
        if (!StringUtil.isEmpty((String)tenantImgUrl)) {
            tenantImgUrl = TemplateUtil.getResourceContentPath((String)tenantImgUrl);
        }
        return tenantImgUrl;
    }

    public static String getTenantMiniImgUrl() {
        Tenant tenant = TemplateUtil.getTenant();
        String tenantMiniImgUrl = ViewUtil.getTenantGemInfo(tenant).getTenantMiniImageUrl();
        if (!StringUtil.isEmpty((String)tenantMiniImgUrl)) {
            tenantMiniImgUrl = TemplateUtil.getResourceContentPath((String)tenantMiniImgUrl);
        }
        return tenantMiniImgUrl;
    }

    public static String getTenantLargeImgUrl() {
        Tenant tenant = TemplateUtil.getTenant();
        String tenantLargeImgUrl = ViewUtil.getTenantGemInfo(tenant).getTenantLargeImageUrl();
        if (!StringUtil.isEmpty((String)tenantLargeImgUrl)) {
            tenantLargeImgUrl = TemplateUtil.getResourceContentPath((String)tenantLargeImgUrl);
        }
        return tenantLargeImgUrl;
    }

    public static String getGroupingSeparator() {
        return String.valueOf(DecimalFormatSymbols.getInstance(TemplateUtil.getLocale()).getGroupingSeparator());
    }

    public static boolean isAutocompletionTarget() {
        Object setting = TemplateUtil.getRequestContext().getAttribute("autocompletionSetting");
        return setting != null && setting instanceof WebApiAutocompletionSetting;
    }

    public static String getParamMappingPath(String defName, String viewName) {
        StringBuilder sb = new StringBuilder();
        if (StringUtil.isNotBlank((String)viewName)) {
            sb.append("/").append(viewName);
        }
        sb.append("/").append(defName);
        return sb.toString();
    }

    public static TenantGemInfo getTenantGemInfo(Tenant tenant) {
        return tenant.getTenantConfig(TenantGemInfo.class) != null ? (TenantGemInfo)tenant.getTenantConfig(TenantGemInfo.class) : new TenantGemInfo();
    }

    public static String[] getSearchCondValue(Map<String, List<String>> searchCondMap, String key) {
        List<Object> list = new ArrayList();
        if (searchCondMap != null && searchCondMap.containsKey(key)) {
            list = searchCondMap.get(key);
        }
        return list.size() > 0 ? list.toArray(new String[list.size()]) : null;
    }

    public static DateFormat getDateTimeFormat(String pattern, String datetimeLocale) {
        Locale locale = ExecuteContext.getCurrentContext().getLocale();
        if (datetimeLocale != null) {
            String[] localeValue = datetimeLocale.split("_", 0);
            if (localeValue.length <= 1) {
                locale = new Locale(localeValue[0]);
            } else if (localeValue.length <= 2) {
                locale = new Locale(localeValue[0], localeValue[1]);
            } else if (localeValue.length <= 3) {
                locale = new Locale(localeValue[0], localeValue[1], localeValue[2]);
            }
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
        return format;
    }

    private static LocalizedDateTimeFormatSetting getDateTimeFormatSetting(List<LocalizedDateTimeFormatSetting> list) {
        for (LocalizedDateTimeFormatSetting ldt : list) {
            String localLang = ldt.getLangage();
            String tenantLang = ExecuteContext.getCurrentContext().getLanguage();
            if (!tenantLang.equals(localLang)) continue;
            return ldt;
        }
        return null;
    }

    public static DateTimeFormatSetting getFormatInfo(List<LocalizedDateTimeFormatSetting> ldtInfoList, DateTimeFormatSetting dtfInfo) {
        LocalizedDateTimeFormatSetting ldf;
        DateTimeFormatSetting settingInfo = new DateTimeFormatSetting();
        if (ldtInfoList != null && (ldf = ViewUtil.getDateTimeFormatSetting(ldtInfoList)) != null) {
            settingInfo.setDatetimeFormat(ldf.getDateTimeFormat());
            settingInfo.setDatetimeLocale(ldf.getDateTimeFormatLocale());
            if (settingInfo != null) {
                return settingInfo;
            }
        }
        if (dtfInfo != null) {
            settingInfo.setDatetimeFormat(dtfInfo.getDatetimeFormat());
            settingInfo.setDatetimeLocale(dtfInfo.getDatetimeLocale());
        }
        return settingInfo;
    }
}

