/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;
import org.iplass.mtp.web.ResultStreamWriter;

public abstract class XmlWriter
implements ResultStreamWriter {
    protected static final String CR = "\n";
    protected static final String TAB = "\t";
    protected Stack<String> stackTags;
    protected OutputStream os = null;

    protected void startAttribute(String element) throws IOException {
        this.addTabs();
        this.add("<");
        String e = this.getReplacedString(element);
        this.add(e);
    }

    protected void endAttribute() throws IOException {
        this.add(" />\n");
    }

    protected void addAttribute(String attr, String value) throws IOException {
        String a = this.getReplacedString(attr);
        this.add(" " + a + "=\"" + value + "\"");
    }

    protected void addHeader() throws IOException {
        this.add("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
    }

    protected void addElement(String element) throws IOException {
        this.addTabs();
        this.stackTags.push(element);
        this.add(this.getTag(element, true, false));
    }

    protected void addElement(String element, String name) throws IOException {
        this.addTabs();
        this.stackTags.push(element);
        this.add(this.getTagWithName(element, name));
    }

    protected void closeElement() throws IOException {
        String element = this.stackTags.pop();
        this.addTabs();
        this.add(this.getTag(element, true, true));
    }

    protected void closeElementOnTheLine() throws IOException {
        String element = this.stackTags.pop();
        this.add(this.getTag(element, true, true));
    }

    protected void addElementWithValue(String element, boolean value) throws IOException {
        this.addElementWithValue(element, String.valueOf(value));
    }

    protected void addElementWithValue(String element, char value) throws IOException {
        this.addElementWithValue(element, String.valueOf(value));
    }

    protected void addElementWithValue(String element, char[] value) throws IOException {
        this.addElementWithValue(element, String.valueOf(value));
    }

    protected void addElementWithValue(String element, int value) throws IOException {
        this.addElementWithValue(element, String.valueOf(value));
    }

    protected void addElementWithValue(String element, long value) throws IOException {
        this.addElementWithValue(element, String.valueOf(value));
    }

    protected void addElementWithValue(String element, float value) throws IOException {
        this.addElementWithValue(element, String.valueOf(value));
    }

    protected void addElementWithValue(String element, double value) throws IOException {
        this.addElementWithValue(element, String.valueOf(value));
    }

    protected void addElementWithValue(String element, String value) throws IOException {
        this.addTabs();
        this.add(this.getTag(element, false, false));
        this.add(value);
        this.add(this.getTag(element, false, true));
    }

    protected String getTag(String element, boolean isElement, boolean isClose) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        if (isClose) {
            sb.append("/");
        }
        String e = this.getReplacedString(element);
        sb.append(e);
        sb.append(">");
        if (isClose || isElement) {
            sb.append(CR);
        }
        return sb.toString();
    }

    protected String getTagWithName(String element, String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        String e = this.getReplacedString(element);
        sb.append(e);
        sb.append(" name = \"");
        sb.append(name);
        sb.append("\">");
        return sb.toString();
    }

    protected void addTabs() throws IOException {
        int count = this.stackTags.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            sb.append(TAB);
        }
        this.add(sb.toString());
    }

    protected String getEncodeValue(String value) {
        return value;
    }

    protected void add(String text) throws IOException {
        if (text == null) {
            return;
        }
        this.os.write(text.getBytes("UTF-8"));
    }

    protected String getReplacedString(String element) {
        return element;
    }
}

