/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.auth;

import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.login.token.SimpleAuthTokenCredential;
import org.iplass.mtp.auth.login.token.SimpleAuthTokenInfo;
import org.iplass.mtp.auth.token.AuthTokenInfo;
import org.iplass.mtp.auth.token.AuthTokenInfoList;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.command.annotation.webapi.WebApiTokenCheck;
import org.iplass.mtp.view.top.TopViewDefinition;
import org.iplass.mtp.view.top.TopViewDefinitionManager;
import org.iplass.mtp.view.top.parts.ApplicationMaintenanceParts;
import org.iplass.mtp.view.top.parts.TopViewParts;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/auth/generateAuthToken", accepts={RequestType.REST_FORM}, methods={MethodType.POST}, tokenCheck=@WebApiTokenCheck(useFixedToken=true), results={"token"}, checkXRequestedWithHeader=true)
@CommandClass(name="gem/auth/GenerateAuthTokenCommand", displayName="\u8a8d\u8a3c\u30c8\u30fc\u30af\u30f3\u751f\u6210")
public class GenerateAuthTokenCommand
implements Command {
    public static final String WEBAPI_NAME = "gem/auth/generateAuthToken";
    private String tokenType = "SAT";

    public String execute(RequestContext request) {
        TopViewDefinition topView;
        TopViewDefinitionManager tvdm = (TopViewDefinitionManager)ManagerLocator.manager(TopViewDefinitionManager.class);
        String roleName = (String)request.getSession().getAttribute("roleName");
        if (roleName == null) {
            roleName = "DEFAULT";
        }
        if ((topView = (TopViewDefinition)tvdm.get(roleName)) == null) {
            return "ERROR";
        }
        boolean usePersonalAccessToken = false;
        for (TopViewParts parts : topView.getParts()) {
            if (!(parts instanceof ApplicationMaintenanceParts)) continue;
            ApplicationMaintenanceParts amp = (ApplicationMaintenanceParts)parts;
            usePersonalAccessToken = amp.isUsePersonalAccessToken();
            break;
        }
        if (!usePersonalAccessToken) {
            throw new ApplicationException("generate personal access token is not allowed.");
        }
        AuthTokenInfoList infoList = AuthContext.getCurrentContext().getAuthTokenInfos();
        if (infoList == null) {
            return "ERROR";
        }
        String application = request.getParam("application");
        if (application == null) {
            return "ERROR";
        }
        SimpleAuthTokenInfo tokenInfo = new SimpleAuthTokenInfo(this.tokenType, application);
        SimpleAuthTokenCredential credential = (SimpleAuthTokenCredential)infoList.generateNewToken((AuthTokenInfo)tokenInfo);
        request.setAttribute("token", (Object)credential.getToken());
        return "SUCCESS";
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }
}

