/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.auth;

import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.auth.AuthCommandConstants;
import org.iplass.gem.command.auth.CredentialExpiredState;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthManager;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.CredentialExpiredException;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.auth.login.LoginFailedException;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ActionMappings;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.template.Template;
import org.iplass.mtp.command.annotation.template.Templates;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.token.TokenStore;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.TenantAuthInfo;
import org.iplass.mtp.tenant.web.TenantWebInfo;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.web.actionmapping.definition.HttpMethodType;
import org.iplass.mtp.web.template.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMappings(value={@ActionMapping(name="gem/auth/login", clientCacheType=ActionMapping.ClientCacheType.NO_CACHE, privilaged=true, command={}, result={@Result(type=Result.Type.TEMPLATE, value="gem/auth/Login")}), @ActionMapping(name="gem/auth/dologin", allowMethod={HttpMethodType.POST}, clientCacheType=ActionMapping.ClientCacheType.NO_CACHE, privilaged=true, result={@Result(status="SUCCESS", type=Result.Type.REDIRECT, value="mtp.auth.redirectPath"), @Result(status="EXPIRE", type=Result.Type.TEMPLATE, value="gem/auth/Expire"), @Result(status="TWOSTEP", type=Result.Type.TEMPLATE, value="gem/auth/Verify2nd"), @Result(status="ERROR", type=Result.Type.TEMPLATE, value="gem/auth/Login"), @Result(exception=ApplicationException.class, type=Result.Type.TEMPLATE, value="gem/auth/Login")})})
@Templates(value={@Template(name="gem/auth/Login", path="/jsp/gem/auth/Login.jsp", contentType="text/html; charset=utf-8"), @Template(name="gem/auth/Expire", path="/jsp/gem/auth/Expire.jsp", contentType="text/html; charset=utf-8"), @Template(name="gem/auth/Verify2nd", path="/jsp/gem/auth/Verify2nd.jsp", contentType="text/html; charset=utf-8"), @Template(name="gem/auth/LastLoginParts", displayName="\u6700\u7d42\u30ed\u30b0\u30a4\u30f3\u65e5\u6642\u30d1\u30fc\u30c4", path="/jsp/gem/auth/lastLoginParts.jsp"), @Template(name="gem/generic/editor/EntitySelectPropertyEditorJsp", displayName="\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u9078\u629e\u30d7\u30ed\u30d1\u30c6\u30a3\u30a8\u30c7\u30a3\u30bf", path="/jsp/gem/generic/editor/EntitySelectPropertyEditor.jsp"), @Template(name="gem/generic/editor/AuthenticationPolicySelectPropertyEditorJsp", displayName="\u8a8d\u8a3c\u30dd\u30ea\u30b7\u30fc\u9078\u629e\u30d7\u30ed\u30d1\u30c6\u30a3\u30a8\u30c7\u30a3\u30bf", path="/jsp/gem/generic/editor/AuthenticationPolicySelectPropertyEditor.jsp")})
@CommandClass(name="gem/auth/LoginCommand", displayName="\u30ed\u30b0\u30a4\u30f3\u51e6\u7406")
public final class LoginCommand
implements Command,
AuthCommandConstants {
    private static Logger logger = LoggerFactory.getLogger(LoginCommand.class);
    public static final String ACTION_VIEW_LOGIN = "gem/auth/login";
    public static final String ACTION_LOGIN = "gem/auth/dologin";
    public static final String CMD_EXEC_EXPIRE = "EXPIRE";
    public static final String CMD_EXEC_TWOSTEP = "TWOSTEP";
    private boolean checkLoginToken = true;
    private AuthManager auth = (AuthManager)ManagerLocator.getInstance().getManager(AuthManager.class);

    public boolean isCheckLoginToken() {
        return this.checkLoginToken;
    }

    public void setCheckLoginToken(boolean checkLoginToken) {
        this.checkLoginToken = checkLoginToken;
    }

    private boolean isRememberMe(RequestContext request) {
        String val = request.getParam("rememberMe");
        return val != null && val.equals("1");
    }

    public String execute(RequestContext request) {
        TokenStore ts;
        if (this.checkLoginToken && ((ts = TokenStore.getTokenStore((SessionContext)request.getSession())) == null || !ts.isValid(request.getParam("_t"), true))) {
            request.setAttribute("mtp.auth.error", (Object)new ApplicationException(LoginCommand.resourceString("auth.Login.invalidToken", new Object[0])));
            return "ERROR";
        }
        String id = request.getParam("id");
        String pass = request.getParam("password");
        String redirectPath = request.getParam("backurl");
        boolean rememberMe = this.isRememberMe(request);
        try {
            IdPasswordCredential cre = new IdPasswordCredential(id, pass);
            if (((TenantAuthInfo)ExecuteContext.getCurrentContext().getCurrentTenant().getTenantConfig(TenantAuthInfo.class)).isUseRememberMe()) {
                cre.setAuthenticationFactor("rememberMe", (Object)rememberMe);
            }
            this.auth.login((Credential)cre);
            LoginCommand.setRedirectPathAfterLogin(request, redirectPath);
            return "SUCCESS";
        }
        catch (LoginFailedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            request.setAttribute("mtp.auth.error", (Object)e);
            if (redirectPath != null) {
                request.setAttribute("redirectPath", (Object)redirectPath);
            }
            return "ERROR";
        }
        catch (CredentialExpiredException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return LoginCommand.handleCredentialExpiredException(request, id, null, null, redirectPath, rememberMe, e);
        }
    }

    static void setRedirectPathAfterLogin(RequestContext request, String redirectPath) {
        if (LoginCommand.checkRedirectPath(redirectPath)) {
            request.setAttribute("mtp.auth.redirectPath", (Object)redirectPath);
        } else {
            String menuUrl;
            Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
            String string = menuUrl = tenant.getTenantConfig(TenantWebInfo.class) != null ? ((TenantWebInfo)tenant.getTenantConfig(TenantWebInfo.class)).getHomeUrl() : null;
            if (menuUrl != null && menuUrl.length() != 0) {
                request.setAttribute("mtp.auth.redirectPath", (Object)(TemplateUtil.getTenantContextPath() + menuUrl));
            } else {
                request.setAttribute("mtp.auth.redirectPath", (Object)(TemplateUtil.getTenantContextPath() + "/gem/"));
            }
        }
    }

    static String handleCredentialExpiredException(RequestContext request, String id, String token, Credential secondaryCredential, String redirectPath, boolean rememberMe, CredentialExpiredException e) {
        if (((AuthManager)ManagerLocator.getInstance().getManager(AuthManager.class)).canUpdateCredential(e.getPolicyName())) {
            CredentialExpiredState state = new CredentialExpiredState(id, token, secondaryCredential, rememberMe && ((TenantAuthInfo)ExecuteContext.getCurrentContext().getCurrentTenant().getTenantConfig(TenantAuthInfo.class)).isUseRememberMe(), secondaryCredential != null, redirectPath, e.getPolicyName());
            request.getSession().setAttribute("mtp.auth.expire.state", (Object)state);
            if (!e.isInitialLogin()) {
                request.setAttribute("mtp.auth.error", (Object)e);
            }
            Transaction.getCurrent().setRollbackOnly();
            return CMD_EXEC_EXPIRE;
        }
        throw e;
    }

    static boolean checkRedirectPath(String redirectPath) {
        if (redirectPath == null) {
            return false;
        }
        if (!WebUtil.isValidInternalUrl((String)redirectPath)) {
            if (logger.isDebugEnabled()) {
                logger.debug("invalid redirect url: " + redirectPath);
            }
            return false;
        }
        return true;
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

