/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.auth;

import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.auth.AuthCommandConstants;
import org.iplass.gem.command.auth.LoginCommand;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.AuthManager;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.CredentialExpiredException;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.auth.login.LoginFailedException;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ActionMappings;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.template.Template;
import org.iplass.mtp.web.actionmapping.definition.HttpMethodType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMappings(value={@ActionMapping(name="gem/auth/reAuth", clientCacheType=ActionMapping.ClientCacheType.NO_CACHE, command={}, result={@Result(type=Result.Type.TEMPLATE, value="gem/auth/ReAuth")}), @ActionMapping(name="gem/auth/doReAuth", allowMethod={HttpMethodType.POST}, clientCacheType=ActionMapping.ClientCacheType.NO_CACHE, result={@Result(status="SUCCESS", type=Result.Type.REDIRECT, value="mtp.auth.redirectPath"), @Result(status="EXPIRE", type=Result.Type.DYNAMIC, value="expirePath"), @Result(status="TWOSTEP", type=Result.Type.TEMPLATE, value="gem/auth/Verify2nd"), @Result(status="ERROR", type=Result.Type.TEMPLATE, value="gem/auth/ReAuth"), @Result(exception=ApplicationException.class, type=Result.Type.TEMPLATE, value="gem/auth/ReAuth")})})
@CommandClass(name="gem/auth/ReAuthCommand", displayName="\u518d\u8a8d\u8a3c\u51e6\u7406")
@Template(name="gem/auth/ReAuth", path="/jsp/gem/auth/ReAuth.jsp", contentType="text/html; charset=utf-8")
public final class ReAuthCommand
implements Command,
AuthCommandConstants {
    private static Logger logger = LoggerFactory.getLogger(ReAuthCommand.class);
    public static final String ACTION_VIEW_RE_AUTH = "gem/auth/reAuth";
    public static final String ACTION_RE_AUTH = "gem/auth/doReAuth";
    public static final String CMD_EXEC_EXPIRE = "EXPIRE";
    public static final String CMD_EXEC_TWOSTEP = "TWOSTEP";
    private AuthManager am = (AuthManager)ManagerLocator.getInstance().getManager(AuthManager.class);

    private boolean rememberMe(AuthContext authContext) {
        return false;
    }

    public String execute(RequestContext request) {
        AuthContext authContext = AuthContext.getCurrentContext();
        String accountId = authContext.getUser().getAccountId();
        String redirectPath = request.getParam("backurl");
        boolean remMe = this.rememberMe(authContext);
        try {
            if (!authContext.isAuthenticated()) {
                throw new ApplicationException(ReAuthCommand.resourceString("auth.Login.noLogin", new Object[0]));
            }
            IdPasswordCredential cre = new IdPasswordCredential(accountId, request.getParam("password"));
            if (remMe) {
                cre.setAuthenticationFactor("rememberMe", (Object)remMe);
            }
            this.am.reAuth((Credential)cre);
            LoginCommand.setRedirectPathAfterLogin(request, redirectPath);
            return "SUCCESS";
        }
        catch (LoginFailedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            request.setAttribute("mtp.auth.error", (Object)e);
            if (redirectPath != null) {
                request.setAttribute("redirectPath", (Object)redirectPath);
            }
            return "ERROR";
        }
        catch (CredentialExpiredException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return LoginCommand.handleCredentialExpiredException(request, accountId, null, null, redirectPath, remMe, e);
        }
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

