/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.auth;

import java.util.List;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.auth.AuthCommandConstants;
import org.iplass.gem.command.generic.detail.DetailViewCommand;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.AuthManager;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.CommandConfig;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ActionMappings;
import org.iplass.mtp.command.annotation.action.ParamMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.action.TokenCheck;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.entity.permission.EntityPropertyPermission;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.TenantAuthInfo;

@ActionMappings(value={@ActionMapping(name="gem/auth/password/reset", paramMapping={@ParamMapping(name="viewName", mapFrom="${0}")}, clientCacheType=ActionMapping.ClientCacheType.NO_CACHE, command={@CommandConfig(commandClass=DetailViewCommand.class, value="cmd.detail=false;"), @CommandConfig(commandClass=ResetPasswordCommand.class)}, result={@Result(status="SUCCESS", type=Result.Type.TEMPLATE, value="gem/generic/detail/view"), @Result(status="ERROR", type=Result.Type.TEMPLATE, value="gem/generic/detail/edit")}, tokenCheck=@TokenCheck), @ActionMapping(name="gem/auth/password/ref/reset", paramMapping={@ParamMapping(name="viewName", mapFrom="${0}")}, clientCacheType=ActionMapping.ClientCacheType.NO_CACHE, command={@CommandConfig(commandClass=DetailViewCommand.class, value="cmd.detail=false;"), @CommandConfig(commandClass=ResetPasswordCommand.class)}, result={@Result(status="SUCCESS", type=Result.Type.TEMPLATE, value="gem/generic/detail/ref/view"), @Result(status="ERROR", type=Result.Type.TEMPLATE, value="gem/generic/detail/ref/edit")}, tokenCheck=@TokenCheck)})
@CommandClass(name="gem/auth/ResetPasswordCommand", displayName="\u30d1\u30b9\u30ef\u30fc\u30c9\u30ea\u30bb\u30c3\u30c8")
public final class ResetPasswordCommand
implements Command,
AuthCommandConstants {
    public static final String ACTION_NAME = "gem/auth/password/reset";
    public static final String ACTION_REF_NAME = "gem/auth/password/ref/reset";
    private AuthManager am = (AuthManager)ManagerLocator.getInstance().getManager(AuthManager.class);

    public String execute(RequestContext request) {
        String oid = request.getParam("oid");
        if (oid == null) {
            throw new SystemException("oid is null");
        }
        EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        Entity user = (Entity)EntityPermission.doQueryAs((EntityPermission.Action)EntityPermission.Action.UPDATE, () -> (Entity)em.searchEntity(new Query().select(new Object[]{"accountId", "accountPolicy"}).from("mtp.auth.User").where((Condition)new Equals("oid", (Object)oid))).getFirst());
        String id = null;
        if (user != null) {
            id = (String)user.getValue("accountId");
        }
        if (id == null) {
            request.setAttribute("message", (Object)ResetPasswordCommand.resourceString("command.auth.ResetPasswordCommand.onlyAdmin", new Object[0]));
            return "ERROR";
        }
        String execType = request.getParam("execType");
        if (!"update".equals(execType)) {
            request.setAttribute("message", (Object)ResetPasswordCommand.resourceString("command.auth.ResetPasswordCommand.onlyUpdate", new Object[0]));
            return "ERROR";
        }
        if (!this.am.canResetCredential((String)user.getValue("accountPolicy"))) {
            request.setAttribute("message", (Object)ResetPasswordCommand.resourceString("command.auth.ResetPasswordCommand.notSupport", new Object[0]));
            return "ERROR";
        }
        Tenant tenant = AuthContext.getCurrentContext().getTenant();
        if (!ResetPasswordCommand.isUserAdminRole(tenant)) {
            request.setAttribute("message", (Object)ResetPasswordCommand.resourceString("command.auth.ResetPasswordCommand.onlyAdmin", new Object[0]));
            return "ERROR";
        }
        if (!AuthContext.getCurrentContext().checkPermission((Permission)new EntityPropertyPermission("mtp.auth.User", "password", EntityPropertyPermission.Action.UPDATE))) {
            request.setAttribute("message", (Object)ResetPasswordCommand.resourceString("command.auth.ResetPasswordCommand.onlyAdmin", new Object[0]));
            return "ERROR";
        }
        IdPasswordCredential credential = new IdPasswordCredential(id, null);
        this.am.resetCredential((Credential)credential, (String)user.getValue("accountPolicy"));
        return "SUCCESS";
    }

    static boolean isUserAdminRole(Tenant tenant) {
        AuthContext auth = AuthContext.getCurrentContext();
        if (auth.getUser().isAdmin()) {
            return true;
        }
        List userAdminRoles = ((TenantAuthInfo)tenant.getTenantConfig(TenantAuthInfo.class)).getUserAdminRoles();
        if (userAdminRoles != null) {
            for (String role : userAdminRoles) {
                if (!auth.userInRole(role)) continue;
                return true;
            }
        }
        return false;
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

