/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.auth;

import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.auth.AuthCommandConstants;
import org.iplass.gem.command.auth.ResetPasswordCommand;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.AuthManager;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.CredentialUpdateException;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.CommandConfig;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ActionMappings;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.action.TokenCheck;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.entity.permission.EntityPropertyPermission;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.AuthenticationPolicyService;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAuthenticationPolicy;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.web.actionmapping.definition.HttpMethodType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMappings(value={@ActionMapping(name="gem/auth/specificpassword", allowMethod={HttpMethodType.POST}, clientCacheType=ActionMapping.ClientCacheType.CACHE, needTrustedAuthenticate=true, command={}, result={@Result(type=Result.Type.JSP, value="/jsp/gem/auth/specificPassword.jsp", templateName="gem/auth/SpecificPassword", layoutActionName="gem/layout/popupLayout")}), @ActionMapping(name="gem/auth/specificpassword/reset", allowMethod={HttpMethodType.POST}, clientCacheType=ActionMapping.ClientCacheType.NO_CACHE, needTrustedAuthenticate=true, command={@CommandConfig(commandClass=ResetSpecificPasswordCommand.class)}, result={@Result(type=Result.Type.JSP, value="/jsp/gem/auth/specificPassword.jsp", templateName="gem/auth/SpecificPassword", layoutActionName="gem/layout/popupLayout")}, tokenCheck=@TokenCheck)})
@CommandClass(name="gem/auth/ResetSpecificPasswordCommand", description="\u30d1\u30b9\u30ef\u30fc\u30c9\u6307\u5b9a\u30ea\u30bb\u30c3\u30c8")
public class ResetSpecificPasswordCommand
implements Command,
AuthCommandConstants {
    private static final Logger logger = LoggerFactory.getLogger(ResetSpecificPasswordCommand.class);
    public static final String ACTION_VIEW_SPECIFIC_PASSWORD = "gem/auth/specificpassword";
    public static final String ACTION_RESET_SPECIFIC_PASSWORD = "gem/auth/specificpassword/reset";
    private AuthManager am = (AuthManager)ManagerLocator.getInstance().getManager(AuthManager.class);

    public String execute(RequestContext request) {
        String execType;
        User current = AuthContext.getCurrentContext().getUser();
        if (current == null || current.isAnonymous()) {
            throw new SystemException("not logined");
        }
        String oid = request.getParam("oid");
        if (oid == null) {
            throw new SystemException("oid is null");
        }
        EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        Entity user = (Entity)EntityPermission.doQueryAs((EntityPermission.Action)EntityPermission.Action.UPDATE, () -> (Entity)em.searchEntity(new Query().select(new Object[]{"accountId", "accountPolicy"}).from("mtp.auth.User").where((Condition)new Equals("oid", (Object)oid))).getFirst());
        String id = null;
        if (user != null) {
            id = (String)user.getValue("accountId");
        }
        if (id == null) {
            request.setAttribute("message", (Object)ResetSpecificPasswordCommand.resourceString("command.auth.ResetPasswordCommand.onlyAdmin", new Object[0]));
            return "ERROR";
        }
        AuthenticationPolicyService aps = (AuthenticationPolicyService)ServiceRegistry.getRegistry().getService(AuthenticationPolicyService.class);
        MetaAuthenticationPolicy.AuthenticationPolicyRuntime policy = aps.getOrDefault((String)user.getValue("accountPolicy"));
        if (!policy.isResetPasswordWithSpecificPassword()) {
            request.setAttribute("mtp.auth.error", (Object)new ApplicationException(ResetSpecificPasswordCommand.resourceString("command.auth.ResetSpecificPasswordCommand.notAllowed", new Object[0])));
            return "ERROR";
        }
        String password = null;
        if (!this.isResetRandomPassword(request)) {
            String newPass2;
            String newPass1 = request.getParam("newPassword");
            if (!this.checkSame(newPass1, newPass2 = request.getParam("confirmPassword"))) {
                request.setAttribute("mtp.auth.passwordExpire.id", (Object)id);
                request.setAttribute("mtp.auth.error", (Object)new ApplicationException(ResetSpecificPasswordCommand.resourceString("command.auth.UpdatePasswordCommand.notMatch", new Object[0])));
                return "ERROR";
            }
            password = newPass1;
        }
        if (!"update".equals(execType = request.getParam("execType"))) {
            request.setAttribute("message", (Object)ResetSpecificPasswordCommand.resourceString("command.auth.ResetPasswordCommand.onlyUpdate", new Object[0]));
            return "ERROR";
        }
        if (!this.am.canResetCredential((String)user.getValue("accountPolicy"))) {
            request.setAttribute("message", (Object)ResetSpecificPasswordCommand.resourceString("command.auth.ResetPasswordCommand.notSupport", new Object[0]));
            return "ERROR";
        }
        Tenant tenant = AuthContext.getCurrentContext().getTenant();
        if (!ResetPasswordCommand.isUserAdminRole(tenant)) {
            request.setAttribute("message", (Object)ResetSpecificPasswordCommand.resourceString("command.auth.ResetPasswordCommand.onlyAdmin", new Object[0]));
            return "ERROR";
        }
        if (!AuthContext.getCurrentContext().checkPermission((Permission)new EntityPropertyPermission("mtp.auth.User", "password", EntityPropertyPermission.Action.UPDATE))) {
            request.setAttribute("message", (Object)ResetSpecificPasswordCommand.resourceString("command.auth.ResetPasswordCommand.onlyAdmin", new Object[0]));
            return "ERROR";
        }
        IdPasswordCredential credential = new IdPasswordCredential(id, password);
        try {
            this.am.resetCredential((Credential)credential, (String)user.getValue("accountPolicy"));
            return "SUCCESS";
        }
        catch (CredentialUpdateException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            request.setAttribute("mtp.auth.error", (Object)e);
            return "ERROR";
        }
    }

    private boolean isResetRandomPassword(RequestContext request) {
        String val = request.getParam("resetRandomPassword");
        return val != null && val.equals("1");
    }

    private boolean checkSame(String pass1, String pass2) {
        if (pass1 == null) {
            return false;
        }
        if (pass2 == null) {
            return false;
        }
        return pass1.equals(pass2);
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

