/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.auth;

import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.login.rememberme.RememberMeTokenInfo;
import org.iplass.mtp.auth.login.token.SimpleAuthTokenInfo;
import org.iplass.mtp.auth.oauth.AccessTokenInfo;
import org.iplass.mtp.auth.token.AuthTokenInfo;
import org.iplass.mtp.auth.token.AuthTokenInfoList;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.command.annotation.webapi.WebApiTokenCheck;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@ActionMapping(name="gem/auth/application", needTrustedAuthenticate=true, command={}, result={@Result(type=Result.Type.JSP, value="/jsp/gem/auth/application.jsp", templateName="gem/auth/application", layoutActionName="gem/layout/defaultLayout")})
@WebApi(name="gem/auth/revokeapplication", accepts={RequestType.REST_JSON}, restJson=@RestJson(parameterName="param"), methods={MethodType.POST}, tokenCheck=@WebApiTokenCheck(useFixedToken=true), checkXRequestedWithHeader=true)
@CommandClass(name="gem/auth/RevokeApplicationCommand", displayName="\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u524a\u9664")
public class RevokeApplicationCommand
implements Command {
    public static final String VIEW_ACTION_NAME = "gem/auth/application";
    public static final String WEBAPI_NAME = "gem/auth/revokeapplication";

    public String execute(RequestContext request) {
        AuthTokenInfoList infoList = AuthContext.getCurrentContext().getAuthTokenInfos();
        if (infoList == null) {
            return "ERROR";
        }
        String target = request.getParam("target");
        if (target != null) {
            if (target.equals("one-token")) {
                String key;
                String type = request.getParam("tokenType");
                AuthTokenInfo info = infoList.get(type, key = request.getParam("tokenKey"));
                if (info != null) {
                    infoList.remove(type, key);
                }
            } else {
                for (AuthTokenInfo info : infoList.getList()) {
                    if (info instanceof AccessTokenInfo) {
                        if (!target.equals("all-app")) continue;
                        infoList.remove(info.getType(), info.getKey());
                        continue;
                    }
                    if (info instanceof RememberMeTokenInfo) {
                        if (!target.equals("all-rememberme")) continue;
                        infoList.remove(info.getType(), info.getKey());
                        continue;
                    }
                    if (!(info instanceof SimpleAuthTokenInfo) || !target.equals("all-sat")) continue;
                    infoList.remove(info.getType(), info.getKey());
                }
            }
        }
        return "SUCCESS";
    }
}

