/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.auth;

import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.auth.AuthCommandConstants;
import org.iplass.gem.command.auth.CredentialExpiredState;
import org.iplass.gem.command.auth.LoginCommand;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.AuthManager;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.CredentialUpdateException;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.CommandConfig;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.token.TokenStore;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.web.actionmapping.definition.HttpMethodType;
import org.iplass.mtp.web.template.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMapping(name="gem/auth/expiredpassword/update", allowMethod={HttpMethodType.POST}, clientCacheType=ActionMapping.ClientCacheType.NO_CACHE, privilaged=true, command={@CommandConfig(value="cmd.checkLoginToken=true")}, result={@Result(status="SUCCESS", type=Result.Type.REDIRECT, value="mtp.auth.redirectPath"), @Result(status="ERROR", type=Result.Type.TEMPLATE, value="gem/auth/Expire"), @Result(status="TOKEN_ERROR", type=Result.Type.TEMPLATE, value="gem/auth/Login")})
@CommandClass(name="gem/auth/UpdateExpirePasswordCommand", displayName="\u6709\u52b9\u671f\u9650\u5207\u308c\u30d1\u30b9\u30ef\u30fc\u30c9\u66f4\u65b0")
public final class UpdateExpirePasswordCommand
implements Command,
AuthCommandConstants {
    private static Logger logger = LoggerFactory.getLogger(UpdateExpirePasswordCommand.class);
    public static final String ACTION_UPDATE_EXP_PASSWORD = "gem/auth/expiredpassword/update";
    private boolean checkLoginToken;
    private AuthManager am = (AuthManager)ManagerLocator.getInstance().getManager(AuthManager.class);

    public boolean isCheckLoginToken() {
        return this.checkLoginToken;
    }

    public void setCheckLoginToken(boolean checkLoginToken) {
        this.checkLoginToken = checkLoginToken;
    }

    public String execute(RequestContext request) {
        String newPass2;
        TokenStore ts;
        if (this.checkLoginToken && ((ts = TokenStore.getTokenStore((SessionContext)request.getSession())) == null || !ts.isValid(request.getParam("_t"), true))) {
            return "TOKEN_ERROR";
        }
        CredentialExpiredState state = (CredentialExpiredState)request.getSession().getAttribute("mtp.auth.expire.state");
        if (state == null) {
            throw new SystemException("CredentialExpiredState is null");
        }
        String oldPass = request.getParam("password");
        String newPass1 = request.getParam("newPassword");
        if (!this.checkSame(newPass1, newPass2 = request.getParam("confirmPassword"))) {
            request.setAttribute("mtp.auth.error", (Object)new ApplicationException(UpdateExpirePasswordCommand.resourceString("command.auth.UpdatePasswordCommand.notMatch", new Object[0])));
            return "ERROR";
        }
        if (!this.checkNotSame(oldPass, newPass1)) {
            request.setAttribute("mtp.auth.error", (Object)new ApplicationException(UpdateExpirePasswordCommand.resourceString("command.auth.UpdatePasswordCommand.notSame", new Object[0])));
            return "ERROR";
        }
        IdPasswordCredential oldCredential = new IdPasswordCredential(state.getId(), oldPass);
        IdPasswordCredential newCredential = new IdPasswordCredential(state.getId(), newPass1);
        try {
            this.am.updateCredential((Credential)oldCredential, (Credential)newCredential, state.getPolicyName());
            IdPasswordCredential cre = newCredential;
            if (state.isRememberMe()) {
                cre.setAuthenticationFactor("rememberMe", (Object)Boolean.TRUE);
            }
            this.am.login((Credential)cre);
            String redirectPath = state.getRedirectPath();
            if (LoginCommand.checkRedirectPath(redirectPath)) {
                request.setAttribute("mtp.auth.redirectPath", (Object)redirectPath);
            } else {
                Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
                String menuUrl = WebUtil.getTenantWebInfo((Tenant)tenant).getHomeUrl();
                if (menuUrl != null && menuUrl.length() != 0) {
                    request.setAttribute("mtp.auth.redirectPath", (Object)(TemplateUtil.getTenantContextPath() + menuUrl));
                } else {
                    request.setAttribute("mtp.auth.redirectPath", (Object)(TemplateUtil.getTenantContextPath() + "/gem/"));
                }
            }
            return "SUCCESS";
        }
        catch (CredentialUpdateException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            request.setAttribute("mtp.auth.error", (Object)e);
            return "ERROR";
        }
    }

    private boolean checkSame(String pass1, String pass2) {
        if (pass1 == null) {
            return false;
        }
        if (pass2 == null) {
            return false;
        }
        return pass1.equals(pass2);
    }

    private boolean checkNotSame(String oldPass, String newPass) {
        if (oldPass == null) {
            return false;
        }
        if (newPass == null) {
            return false;
        }
        return !oldPass.equals(newPass);
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

