/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.auth;

import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.auth.AuthCommandConstants;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.AuthManager;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.CredentialUpdateException;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.web.actionmapping.definition.HttpMethodType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMapping(name="gem/auth/password/update", allowMethod={HttpMethodType.POST}, clientCacheType=ActionMapping.ClientCacheType.NO_CACHE, needTrustedAuthenticate=true, result={@Result(type=Result.Type.TEMPLATE, value="gem/auth/Password")})
@CommandClass(name="gem/auth/UpdatePasswordCommand", displayName="\u30d1\u30b9\u30ef\u30fc\u30c9\u66f4\u65b0")
public final class UpdatePasswordCommand
implements Command,
AuthCommandConstants {
    private static Logger logger = LoggerFactory.getLogger(UpdatePasswordCommand.class);
    @Deprecated
    public static final String ACTION_VIEW_UPDATE_PASSWORD = "gem/auth/password";
    public static final String ACTION_DO_UPDATE_PASSWORD = "gem/auth/password/update";
    private AuthManager am = (AuthManager)ManagerLocator.getInstance().getManager(AuthManager.class);

    public String execute(RequestContext request) {
        String newPass2;
        String id = null;
        User current = AuthContext.getCurrentContext().getUser();
        if (current == null || current.isAnonymous()) {
            throw new SystemException("not logined");
        }
        id = current.getAccountId();
        String oldPass = request.getParam("password");
        String newPass1 = request.getParam("newPassword");
        if (!this.checkSame(newPass1, newPass2 = request.getParam("confirmPassword"))) {
            request.setAttribute("mtp.auth.passwordExpire.id", (Object)id);
            request.setAttribute("mtp.auth.error", (Object)new ApplicationException(UpdatePasswordCommand.resourceString("command.auth.UpdatePasswordCommand.notMatch", new Object[0])));
            return "ERROR";
        }
        if (!this.checkNotSame(oldPass, newPass1)) {
            request.setAttribute("mtp.auth.passwordExpire.id", (Object)id);
            request.setAttribute("mtp.auth.error", (Object)new ApplicationException(UpdatePasswordCommand.resourceString("command.auth.UpdatePasswordCommand.notSame", new Object[0])));
            return "ERROR";
        }
        IdPasswordCredential oldCredential = new IdPasswordCredential(id, oldPass);
        IdPasswordCredential newCredential = new IdPasswordCredential(id, newPass1);
        try {
            this.am.updateCredential((Credential)oldCredential, (Credential)newCredential, current.getAccountPolicy());
            return "SUCCESS";
        }
        catch (CredentialUpdateException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            request.setAttribute("mtp.auth.passwordExpire.id", (Object)id);
            request.setAttribute("mtp.auth.error", (Object)e);
            return "ERROR";
        }
    }

    private boolean checkSame(String pass1, String pass2) {
        if (pass1 == null) {
            return false;
        }
        if (pass2 == null) {
            return false;
        }
        return pass1.equals(pass2);
    }

    private boolean checkNotSame(String oldPass, String newPass) {
        if (oldPass == null) {
            return false;
        }
        if (newPass == null) {
            return false;
        }
        return !oldPass.equals(newPass);
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

