/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.ViewUtil;
import org.iplass.gem.command.auth.UserRegistrationInterrupter;
import org.iplass.gem.command.generic.ResultType;
import org.iplass.gem.command.generic.detail.DetailCommandBase;
import org.iplass.gem.command.generic.detail.DetailCommandContext;
import org.iplass.gem.command.generic.detail.RegistrationCommandBase;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.view.generic.DetailFormView;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.OutputType;
import org.iplass.mtp.view.generic.editor.JoinPropertyEditor;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.iplass.mtp.view.generic.element.section.DefaultSection;
import org.iplass.mtp.view.generic.element.section.Section;
import org.iplass.mtp.view.top.TopViewDefinition;
import org.iplass.mtp.view.top.TopViewDefinitionManager;
import org.iplass.mtp.view.top.parts.TopViewParts;
import org.iplass.mtp.view.top.parts.UserMaintenanceParts;

@ActionMapping(name="gem/auth/updateUser", displayName="\u66f4\u65b0", needTrustedAuthenticate=true, result={@Result(type=Result.Type.TEMPLATE, value="gem/auth/Password")})
@CommandClass(name="gem/auth/UpdateUserCommand", displayName="\u30e6\u30fc\u30b6\u60c5\u5831\u66f4\u65b0")
public final class UpdateUserCommand
extends DetailCommandBase {
    public static final String ACTION_NAME = "gem/auth/updateUser";
    private EntityViewManager evm;
    private TopViewDefinitionManager tdm;

    public UpdateUserCommand() {
        this.em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        this.evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);
        this.tdm = (TopViewDefinitionManager)ManagerLocator.getInstance().getManager(TopViewDefinitionManager.class);
    }

    public String execute(RequestContext request) {
        String roleName = request.getParam("roleName");
        request.setAttribute("updateUserInfo", (Object)"true");
        EntityView ev = (EntityView)this.evm.get("mtp.auth.User");
        DetailFormView view = null;
        TopViewDefinition td = (TopViewDefinition)this.tdm.get(roleName);
        UserMaintenanceParts parts = null;
        if (td != null) {
            for (TopViewParts tmp : td.getParts()) {
                if (!(tmp instanceof UserMaintenanceParts)) continue;
                parts = (UserMaintenanceParts)tmp;
                break;
            }
            if (parts != null && ev != null) {
                view = ev.getDetailFormView(parts.getViewName());
            }
        }
        if (view == null) {
            request.setAttribute("message", (Object)UpdateUserCommand.resourceString("command.auth.UpdateUserCommand.viewErr", new Object[0]));
            return "ERROR_VIEW";
        }
        if (view.getInterrupterName() == null || view.getInterrupterName().isEmpty()) {
            view.setInterrupterName(UserRegistrationInterrupter.class.getName());
        }
        DetailCommandContext context = this.getContext(request);
        context.setView(view);
        if (context.hasErrors()) {
            ValidateError[] errors = context.getErrors().toArray(new ValidateError[context.getErrors().size()]);
            request.setAttribute("errorProperty", (Object)errors);
            request.setAttribute("message", (Object)UpdateUserCommand.resourceString("command.auth.UpdateUserCommand.inputErr", new Object[0]));
            return "ERROR";
        }
        User user = AuthContext.getCurrentContext().getUser();
        Entity updateEntity = this.em.load(user.getOid(), "mtp.auth.User");
        Entity newEntity = context.createEntity();
        List<PropertyItem> properties = this.getProperty(view, newEntity);
        for (PropertyItem property : properties) {
            Object propValue = newEntity.getValue(property.getPropertyName());
            updateEntity.setValue(property.getPropertyName(), propValue);
        }
        RegistrationCommandBase.EditResult ret = (RegistrationCommandBase.EditResult)AuthContext.doPrivileged(() -> this.updateEntity(context, updateEntity));
        if (ret.getResultType() == ResultType.ERROR) {
            ArrayList<ValidateError> tmpList = new ArrayList<ValidateError>();
            if (ret.getErrors() != null) {
                tmpList.addAll(Arrays.asList(ret.getErrors()));
            }
            ValidateError[] errors = tmpList.toArray(new ValidateError[tmpList.size()]);
            request.setAttribute("errorProperty", (Object)errors);
            request.setAttribute("message", (Object)ret.getMessage());
            return "ERROR";
        }
        AuthContext.getCurrentContext().refresh();
        return "SUCCESS";
    }

    private List<PropertyItem> getProperty(DetailFormView view, Entity entity) {
        ArrayList<PropertyItem> propList = new ArrayList<PropertyItem>();
        for (Section section : view.getSections()) {
            if (!(section instanceof DefaultSection) || !EntityViewUtil.isDisplayElement("mtp.auth.User", section.getElementRuntimeId(), OutputType.EDIT, entity) || !ViewUtil.dispElement("update", (Element)section)) continue;
            propList.addAll(this.getProperty((DefaultSection)section, entity));
        }
        return propList;
    }

    private List<PropertyItem> getProperty(DefaultSection section, Entity entity) {
        ArrayList<PropertyItem> propList = new ArrayList<PropertyItem>();
        for (Element elem : section.getElements()) {
            if (elem instanceof PropertyItem) {
                PropertyItem prop = (PropertyItem)elem;
                if (prop.getEditor() instanceof JoinPropertyEditor) {
                    JoinPropertyEditor je = (JoinPropertyEditor)prop.getEditor();
                    for (NestProperty nest : je.getProperties()) {
                        PropertyItem dummy = new PropertyItem();
                        dummy.setDispFlag(true);
                        dummy.setPropertyName(nest.getPropertyName());
                        dummy.setEditor(nest.getEditor());
                        propList.add(dummy);
                    }
                }
                if (!EntityViewUtil.isDisplayElement("mtp.auth.User", prop.getElementRuntimeId(), OutputType.EDIT, entity) || !ViewUtil.dispElement("update", (Element)prop)) continue;
                propList.add(prop);
                continue;
            }
            if (!(elem instanceof DefaultSection)) continue;
            propList.addAll(this.getProperty((DefaultSection)elem, entity));
        }
        return propList;
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

