/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.binary;

import java.util.List;
import org.iplass.gem.BinaryDownloadLoggingTargetProperty;
import org.iplass.gem.GemConfigService;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ActionMappings;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.web.actionmapping.definition.result.ContentDispositionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMappings(value={@ActionMapping(name="gem/binary/download", displayName="\u30d0\u30a4\u30ca\u30ea\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9", result={@Result(type=Result.Type.STREAM, useContentDisposition=true, acceptRanges=true)}), @ActionMapping(name="gem/binary/ref", displayName="\u30d0\u30a4\u30ca\u30ea\u53c2\u7167", result={@Result(type=Result.Type.STREAM, useContentDisposition=true, contentDispositionType=ContentDispositionType.INLINE, acceptRanges=true)}), @ActionMapping(name="gem/binary/pdfviewer", displayName="PDF\u30d3\u30e5\u30fc\u30a2", command={}, result={@Result(type=Result.Type.JSP, value="/jsp/gem/binary/pdfviewer.jsp", templateName="gem/binary/pdfviewer", useContentDisposition=true, contentDispositionType=ContentDispositionType.INLINE, acceptRanges=true)}), @ActionMapping(name="gem/binary/imgviewer", displayName="\u753b\u50cf\u30d3\u30e5\u30fc\u30a2", result={@Result(type=Result.Type.JSP, value="/jsp/gem/binary/imgviewer.jsp", templateName="gem/binary/imgviewer", useContentDisposition=true, contentDispositionType=ContentDispositionType.INLINE, acceptRanges=true)})})
@CommandClass(name="gem/binary/DownloadCommand", displayName="\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9")
public final class DownloadCommand
implements Command {
    public static final String DOWNLOAD_ACTION_NAME = "gem/binary/download";
    public static final String REFERENCE_ACTION_NAME = "gem/binary/ref";
    public static final String PDFVIEWER_ACTION_NAME = "gem/binary/pdfviewer";
    public static final String IMGVIEWER_ACTION_NAME = "gem/binary/imgviewer";
    private GemConfigService service = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"mtp.audit.download");

    public String execute(RequestContext request) {
        Long lobId = request.getParamAsLong("id");
        String defName = request.getParam("defName");
        String propName = request.getParam("propName");
        if (defName != null && propName != null) {
            EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
            BinaryReference br = em.loadBinaryReference(lobId.longValue());
            List<BinaryDownloadLoggingTargetProperty> targetProperties = this.service.getBinaryDownloadLoggingTargetProperty();
            for (BinaryDownloadLoggingTargetProperty targetProperty : targetProperties) {
                if (!defName.equals(targetProperty.getEntityName()) || !propName.equals(targetProperty.getPropertyName())) continue;
                auditLogger.info("BinaryPropertyDataDownload," + br.getName() + ",lobId:" + lobId + " entityName:" + defName + " propertyName:" + propName);
            }
            if (br != null && defName.equals(br.getDefinitionName()) && propName.equals(br.getPropertyName())) {
                request.setAttribute("streamData", (Object)br);
            }
        } else {
            SessionContext session = request.getSession(false);
            if (session != null) {
                request.setAttribute("streamData", (Object)session.loadFromTemporary(lobId.longValue()));
            }
        }
        return "SUCCESS";
    }
}

