/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.binary;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.XmlWriter;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.command.UploadFileHandle;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.impl.web.token.TokenStore;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionManager;
import org.iplass.mtp.transaction.TransactionStatus;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMapping(name="gem/binary/upload", displayName="\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9", result={@Result(type=Result.Type.STREAM, useContentDisposition=false)})
@CommandClass(name="gem/binary/UploadCommand", displayName="\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9")
public final class UploadCommand
implements Command {
    private static Logger logger = LoggerFactory.getLogger(UploadCommand.class);
    public static final String ACTION_NAME = "gem/binary/upload";

    public String execute(RequestContext request) {
        TokenStore ts;
        String token = request.getParam("_t");
        if (StringUtil.isNotBlank((String)token) && ((ts = TokenStore.getTokenStore((SessionContext)request.getSession())) == null || !ts.isValid(token, false))) {
            request.setAttribute("streamData", (Object)new ResultXmlWriter(UploadCommand.resourceString("command.binary.UploadCommand.failedMsg", new Object[0])));
            return "FAILURE";
        }
        try {
            UploadFileHandle file = request.getParamAsFile("filePath");
            request.setAttribute("contentType", (Object)"application/xml");
            if (file != null && file.getSize() > 0L) {
                BinaryReference br = file.toBinaryReference();
                ResultXmlWriter xml = new ResultXmlWriter(br.getName(), br.getType(), br.getLobId());
                request.setAttribute("streamData", (Object)xml);
                return "SUCCESS";
            }
        }
        catch (RuntimeException e) {
            Transaction t = ((TransactionManager)ManagerLocator.getInstance().getManager(TransactionManager.class)).currentTransaction();
            if (t != null && t.getStatus() == TransactionStatus.ACTIVE) {
                t.setRollbackOnly();
            }
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            if (e instanceof ApplicationException) {
                request.setAttribute("streamData", (Object)new ResultXmlWriter(e.getMessage()));
                return "FAILURE";
            }
            request.setAttribute("streamData", (Object)new ResultXmlWriter(UploadCommand.resourceString("command.binary.UploadCommand.failedMsg", new Object[0])));
            return "FAILURE";
        }
        request.setAttribute("streamData", (Object)new ResultXmlWriter(UploadCommand.resourceString("command.binary.UploadCommand.failedMsg", new Object[0])));
        return "FAILURE";
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }

    class ResultXmlWriter
    extends XmlWriter {
        String _name;
        String _type;
        Long _lobId;
        String _error;

        public ResultXmlWriter(String name, String type, Long lobId) {
            this._name = name;
            this._type = type;
            this._lobId = lobId;
        }

        public ResultXmlWriter(String error) {
            this._error = error;
        }

        public void write(OutputStream out) throws IOException {
            this.os = out;
            this.stackTags = new Stack();
            this.addHeader();
            this.addElement("Result");
            this.addElementWithValue("name", StringUtil.escapeXml10((String)this._name, (boolean)true));
            this.addElementWithValue("type", StringUtil.escapeXml10((String)this._type, (boolean)true));
            this.addElementWithValue("lobId", this._lobId != null ? this._lobId.toString() : "");
            this.addElementWithValue("error", StringUtil.escapeXml10((String)this._error, (boolean)true));
            this.closeElement();
        }
    }
}

