/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.calendar;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.iplass.gem.command.generic.detail.DetailFormViewData;
import org.iplass.gem.command.generic.detail.DetailViewCommand;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ParamMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.DateProperty;
import org.iplass.mtp.entity.definition.properties.DateTimeProperty;
import org.iplass.mtp.entity.definition.properties.TimeProperty;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.view.calendar.EntityCalendar;
import org.iplass.mtp.view.calendar.EntityCalendarItem;
import org.iplass.mtp.view.calendar.EntityCalendarManager;
import org.iplass.mtp.web.template.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMapping(name="gem/calendar/add", displayName="\u8ffd\u52a0", paramMapping={@ParamMapping(name="viewName", mapFrom="${0}")}, result={@Result(status="SUCCESS", type=Result.Type.TEMPLATE, value="gem/generic/detail/ref/edit"), @Result(status="ERROR_VIEW", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/popupLayout"), @Result(status="ERROR_NODATA", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/popupLayout")})
@CommandClass(name="gem/calendar/AddCalendarCommand", displayName="\u8ffd\u52a0")
public final class AddCalendarCommand
implements Command {
    private static Logger logger = LoggerFactory.getLogger(AddCalendarCommand.class);
    public static final String ACTION_NANE = "gem/calendar/add";
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private EntityCalendarManager ecm = (EntityCalendarManager)ManagerLocator.getInstance().getManager(EntityCalendarManager.class);

    public String execute(RequestContext request) {
        DetailViewCommand command = new DetailViewCommand();
        command.setDetail(true);
        String ret = command.execute(request);
        if (!"SUCCESS".equals(ret)) {
            return ret;
        }
        Long date = this.dateToLong(request.getParam("date"));
        String defName = request.getParam("defName");
        String calendarName = request.getParam("calendarName");
        if (date != null) {
            EntityCalendar ec = (EntityCalendar)this.ecm.get(calendarName);
            EntityCalendarItem item = ec.getItem(defName);
            EntityDefinition ed = this.edm.get(defName);
            Entity entity = null;
            if (ed != null && item != null) {
                entity = this.newEntity(ed);
                if (item.getCalendarSearchType() == EntityCalendarItem.CalendarSearchType.DATE) {
                    this.setValue(ed, item.getPropertyName(), entity, date);
                } else if (item.getCalendarSearchType() == EntityCalendarItem.CalendarSearchType.PERIOD) {
                    this.setValue(ed, item.getFromPropertyName(), entity, date);
                    this.setValue(ed, item.getToPropertyName(), entity, date);
                }
            }
            if (entity != null) {
                DetailFormViewData data = (DetailFormViewData)request.getAttribute("data");
                data.setEntity(entity);
            }
        }
        return "SUCCESS";
    }

    private void setValue(EntityDefinition ed, String propName, Entity entity, Long date) {
        if (propName != null) {
            PropertyDefinition pd = ed.getProperty(propName);
            entity.setValue(propName, (Object)this.newValue(pd, date));
        }
    }

    private java.util.Date newValue(PropertyDefinition pd, Long date) {
        java.util.Date d = null;
        if (pd != null) {
            if (pd instanceof DateProperty) {
                d = new Date(date);
            } else if (pd instanceof DateTimeProperty) {
                d = new Timestamp(date);
            } else if (pd instanceof TimeProperty) {
                d = new Timestamp(date);
            }
        }
        return d;
    }

    private Long dateToLong(String str) {
        SimpleDateFormat format = DateUtil.getSimpleDateFormat((String)TemplateUtil.getLocaleFormat().getServerDateFormat(), (boolean)false);
        format.setLenient(false);
        try {
            return format.parse(str).getTime();
        }
        catch (ParseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    private Entity newEntity(EntityDefinition entityDefinition) {
        GenericEntity res = null;
        if (entityDefinition.getMapping() != null && entityDefinition.getMapping().getMappingModelClass() != null) {
            try {
                res = (Entity)Class.forName(entityDefinition.getMapping().getMappingModelClass()).newInstance();
            }
            catch (InstantiationException e) {
                throw new EntityRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new EntityRuntimeException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new EntityRuntimeException((Throwable)e);
            }
        } else {
            res = new GenericEntity();
        }
        res.setDefinitionName(entityDefinition.getName());
        return res;
    }
}

