/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.calendar;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StrTokenizer;
import org.iplass.gem.command.calendar.CalendarData;
import org.iplass.gem.command.calendar.CalendarEntityData;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.template.Template;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.DateProperty;
import org.iplass.mtp.entity.definition.properties.DateTimeProperty;
import org.iplass.mtp.entity.definition.properties.TimeProperty;
import org.iplass.mtp.entity.query.PreparedQuery;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.expr.Not;
import org.iplass.mtp.entity.query.condition.expr.Or;
import org.iplass.mtp.entity.query.condition.expr.Paren;
import org.iplass.mtp.entity.query.condition.predicate.Between;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.Greater;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.condition.predicate.IsNotNull;
import org.iplass.mtp.entity.query.condition.predicate.IsNull;
import org.iplass.mtp.entity.query.condition.predicate.Lesser;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.entity.query.condition.predicate.Like;
import org.iplass.mtp.entity.query.condition.predicate.NotEquals;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.util.CollectionUtil;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.calendar.EntityCalendar;
import org.iplass.mtp.view.calendar.EntityCalendarItem;
import org.iplass.mtp.view.calendar.EntityCalendarManager;
import org.iplass.mtp.view.filter.EntityFilter;
import org.iplass.mtp.view.filter.EntityFilterItem;
import org.iplass.mtp.view.filter.EntityFilterManager;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/calendar/getCalendar", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="params"), results={"calendarData"}, checkXRequestedWithHeader=true)
@Template(name="gem/calendar/calendarParts", displayName="\u30ab\u30ec\u30f3\u30c0\u30fc\u90e8\u54c1", path="/jsp/gem/calendar/calendarParts.jsp")
@CommandClass(name="gem/calendar/GetCalendarCommand", displayName="\u30ab\u30ec\u30f3\u30c0\u30fc")
public final class GetCalendarCommand
implements Command {
    public static final String WEBAPI_NAME = "gem/calendar/getCalendar";
    private EntityCalendarManager ecm = (EntityCalendarManager)ManagerLocator.getInstance().getManager(EntityCalendarManager.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private EntityFilterManager efm = null;
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);

    public GetCalendarCommand() {
        this.efm = (EntityFilterManager)ManagerLocator.getInstance().getManager(EntityFilterManager.class);
    }

    public String execute(RequestContext request) {
        Map json = (Map)request.getAttribute("params");
        String calendarName = (String)json.get("calendarName");
        String calendarType = (String)json.get("calendarType");
        java.util.Date from = this.convDate((String)json.get("from"));
        java.util.Date to = this.convDate((String)json.get("to"));
        ArrayList<CalendarData> calendarList = new ArrayList<CalendarData>();
        EntityCalendar cd = (EntityCalendar)this.ecm.get(calendarName);
        if (cd != null) {
            for (EntityCalendarItem item : cd.getItems()) {
                Boolean withoutEntityFlg;
                Map entityFilter = (Map)json.get(item.getDefinitionName());
                Boolean bl = withoutEntityFlg = entityFilter != null ? (Boolean)entityFilter.get("withoutEntity") : null;
                if (withoutEntityFlg != null && withoutEntityFlg.booleanValue()) continue;
                if (item.getCalendarSearchType() == EntityCalendarItem.CalendarSearchType.DATE) {
                    this.searchDate(from, to, calendarList, item, calendarType, entityFilter, calendarName);
                    continue;
                }
                if (item.getCalendarSearchType() != EntityCalendarItem.CalendarSearchType.PERIOD) continue;
                this.searchPeriod(from, to, calendarList, item, calendarType, entityFilter, calendarName);
            }
        }
        request.setAttribute("calendarData", calendarList);
        return "SUCCESS";
    }

    private void searchDate(java.util.Date from, java.util.Date to, List<CalendarData> calendarlist, EntityCalendarItem item, String type, Map<String, Object> entityFilter, String calendarName) {
        String defName = item.getDefinitionName();
        String propertyName = item.getPropertyName();
        EntityDefinition ed = this.edm.get(defName);
        PropertyDefinition pd = ed.getProperty(propertyName);
        Query q = new Query();
        q.select(new Object[]{"oid", "name", propertyName});
        q.from(defName);
        Where where = new Where();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        boolean isDateProperty = false;
        if (pd instanceof DateProperty) {
            conditions.add((Condition)new Between(propertyName, (Object)new Date(from.getTime()), (Object)new Date(to.getTime())));
            isDateProperty = true;
        } else if (pd instanceof DateTimeProperty) {
            conditions.add((Condition)new Between(propertyName, (Object)new Timestamp(from.getTime()), (Object)new Timestamp(to.getTime())));
        } else if (pd instanceof TimeProperty) {
            conditions.add((Condition)new Between(propertyName, (Object)new Time(from.getTime()), (Object)new Time(to.getTime())));
        }
        this.setFilter(item, entityFilter, conditions);
        where.setCondition((Condition)new And(conditions));
        q.setWhere(where);
        q.order(new SortSpec[]{new SortSpec("oid", SortSpec.SortType.ASC), new SortSpec(propertyName, SortSpec.SortType.ASC)});
        if (item.getLimit() != null) {
            q.limit(item.getLimit().intValue());
        } else {
            q.limit(1000);
        }
        List list = this.em.searchEntity(q).getList();
        SimpleDateFormat format = DateUtil.getSimpleDateFormat((String)"HH:mm", (boolean)false);
        for (Entity e : list) {
            java.util.Date date = (java.util.Date)e.getValue(propertyName);
            String time = isDateProperty ? null : this.timeToString(date, format);
            CalendarData calendarData = new CalendarData(type);
            if (item.getDisplayTime().booleanValue()) {
                calendarData.setTitle(this.createTitle(e.getName(), time));
            } else {
                calendarData.setTitle(e.getName());
            }
            calendarData.setStart(this.dateTimeToString(date));
            calendarData.setCalendarEntityData(new CalendarEntityData(e, time, item));
            calendarData.setTextColor(item.getEntityColor());
            if (StringUtil.isNotEmpty((String)item.getColorConfig())) {
                String resultColor = this.ecm.getColorConfigResult(calendarName, e);
                calendarData.setTextColor(resultColor);
            }
            calendarlist.add(calendarData);
        }
    }

    private void searchPeriod(java.util.Date from, java.util.Date to, List<CalendarData> calendarList, EntityCalendarItem item, String type, Map<String, Object> entityFilter, String calendarName) {
        String defName = item.getDefinitionName();
        String fromPropertyName = item.getFromPropertyName();
        String toPropertyName = item.getToPropertyName();
        EntityDefinition ed = this.edm.get(defName);
        PropertyDefinition fromPd = ed.getProperty(fromPropertyName);
        PropertyDefinition toPd = ed.getProperty(toPropertyName);
        Calendar cal = DateUtil.getCalendar((boolean)true);
        cal.setTime(to);
        cal.set(10, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        java.util.Date _to = cal.getTime();
        Query q = new Query();
        q.select(new Object[]{"oid", "name", fromPropertyName, toPropertyName});
        q.from(defName);
        Where where = new Where();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        boolean isDateProperty_from = false;
        if (fromPd instanceof DateProperty) {
            conditions.add((Condition)new Lesser(fromPropertyName, (Object)new Date(_to.getTime())));
            isDateProperty_from = true;
        } else if (fromPd instanceof DateTimeProperty) {
            conditions.add((Condition)new Lesser(fromPropertyName, (Object)new Timestamp(_to.getTime())));
        } else if (fromPd instanceof TimeProperty) {
            conditions.add((Condition)new Lesser(fromPropertyName, (Object)new Time(_to.getTime())));
        }
        boolean isDateProperty_to = false;
        if (toPd instanceof DateProperty) {
            conditions.add((Condition)new GreaterEqual(toPropertyName, (Object)new Date(from.getTime())));
            isDateProperty_to = true;
        } else if (toPd instanceof DateTimeProperty) {
            conditions.add((Condition)new GreaterEqual(toPropertyName, (Object)new Timestamp(from.getTime())));
        } else if (toPd instanceof TimeProperty) {
            conditions.add((Condition)new GreaterEqual(toPropertyName, (Object)new Time(from.getTime())));
        }
        this.setFilter(item, entityFilter, conditions);
        where.setCondition((Condition)new And(conditions));
        q.setWhere(where);
        q.order(new SortSpec[]{new SortSpec("oid", SortSpec.SortType.ASC), new SortSpec(fromPropertyName, SortSpec.SortType.ASC), new SortSpec(toPropertyName, SortSpec.SortType.ASC)});
        if (item.getLimit() != null) {
            q.limit(item.getLimit().intValue());
        } else {
            q.limit(1000);
        }
        List list = this.em.searchEntity(q).getList();
        cal = DateUtil.getCalendar((boolean)true);
        SimpleDateFormat format = DateUtil.getSimpleDateFormat((String)"HH:mm", (boolean)false);
        for (Entity e : list) {
            java.util.Date toDate = (java.util.Date)e.getValue(toPropertyName);
            java.util.Date fromDate = (java.util.Date)e.getValue(fromPropertyName);
            String stoDate = this.dateTimeToString(fromDate);
            String toTime = isDateProperty_to ? null : this.timeToString(toDate, format);
            String sfromDate = fromDate != null ? this.dateTimeToString(toDate) : null;
            String fromTime = isDateProperty_from ? null : this.timeToString(fromDate, format);
            CalendarData calendarData = new CalendarData(type);
            calendarData.setTitle(e.getName());
            calendarData.setStart(stoDate);
            calendarData.setTextColor(item.getEntityColor());
            if (StringUtil.isNotEmpty((String)item.getColorConfig())) {
                String resultColor = this.ecm.getColorConfigResult(calendarName, e);
                calendarData.setTextColor(resultColor);
            }
            if (this.isAllDayEvent(fromDate, toDate)) {
                calendarData.setAllDay(true);
            }
            if (calendarData.isAllDay() || this.isMinMinutesLesser(fromDate, toDate, type)) {
                calendarData.setEnd(sfromDate);
            }
            if (item.getDisplayTime().booleanValue()) {
                calendarData.setTime(this.createTime(fromTime, toTime));
            }
            calendarData.setCalendarEntityData(new CalendarEntityData(e, toTime, item));
            calendarList.add(calendarData);
        }
    }

    private java.util.Date convDate(String str) {
        try {
            SimpleDateFormat format = DateUtil.getSimpleDateFormat((String)"yyyyMMdd", (boolean)false);
            return new java.util.Date(format.parse(str).getTime());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private String dateTimeToString(java.util.Date date) {
        SimpleDateFormat format = DateUtil.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm:ss", (boolean)false);
        return format.format(date);
    }

    private String timeToString(java.util.Date date, SimpleDateFormat format) {
        return format.format(date);
    }

    private String createTitle(String name, String time) {
        StringBuilder sb = new StringBuilder();
        if (time != null) {
            sb.append(time).append("-");
        }
        sb.append(name);
        return sb.toString();
    }

    private String createTime(String fromTime, String toTime) {
        StringBuilder sb = new StringBuilder();
        sb.append(fromTime);
        if (toTime != null && !toTime.equals(fromTime)) {
            sb.append("-").append(toTime);
        }
        return sb.toString();
    }

    private boolean isAllDayEvent(java.util.Date toDate, java.util.Date formDate) {
        if (toDate == null || formDate == null) {
            return false;
        }
        Calendar toCal = Calendar.getInstance();
        Calendar fromCal = Calendar.getInstance();
        toCal.setTime(toDate);
        fromCal.setTime(formDate);
        return fromCal.get(5) - toCal.get(5) != 0;
    }

    private boolean isMinMinutesLesser(java.util.Date toDate, java.util.Date formDate, String type) {
        if (toDate == null || formDate == null || EntityCalendar.CalendarType.MONTH.toString().equals(type)) {
            return false;
        }
        Calendar toCal = Calendar.getInstance();
        Calendar fromCal = Calendar.getInstance();
        toCal.setTime(toDate);
        fromCal.setTime(formDate);
        long minMinutes = EntityCalendar.CalendarType.DAY.toString().equals(type) ? 1800000L : 3600000L;
        return fromCal.getTimeInMillis() - toCal.getTimeInMillis() > minMinutes;
    }

    private void setFilter(EntityCalendarItem item, Map<String, Object> entityFilter, ArrayList<Condition> conditions) {
        if (item.getFilterCondition() != null && !item.getFilterCondition().isEmpty()) {
            conditions.add(new PreparedQuery(item.getFilterCondition()).condition(null));
        }
        if (entityFilter == null) {
            return;
        }
        String fixFilter = (String)entityFilter.get("fixFilter");
        if (fixFilter != null) {
            String entityCondition = this.getEntityFilterCondition(item.getDefinitionName(), fixFilter);
            if (entityCondition != null) {
                conditions.add(new PreparedQuery(entityCondition).condition(null));
            }
        } else {
            List filterList = (List)entityFilter.get("valueList");
            if (CollectionUtil.isNotEmpty((Collection)filterList)) {
                HashMap<String, ArrayList<Condition>> conditionMap = new HashMap<String, ArrayList<Condition>>();
                for (Map map : filterList) {
                    Map property = (Map)map.get("property");
                    Map condition = (Map)map.get("condition");
                    Map keyword = (Map)map.get("keyword");
                    Condition c = this.convertDetailCondition(FilterCondition.valueOf((String)condition.get("value")), (String)property.get("value"), PropertyDefinitionType.valueOf((String)((String)property.get("type"))), keyword);
                    if (c == null) continue;
                    ArrayList<Condition> propertyCondition = (ArrayList<Condition>)conditionMap.get((String)property.get("value"));
                    if (propertyCondition == null) {
                        propertyCondition = new ArrayList<Condition>();
                        conditionMap.put((String)property.get("value"), propertyCondition);
                    }
                    propertyCondition.add(c);
                }
                for (Map.Entry entry : conditionMap.entrySet()) {
                    ArrayList c = (ArrayList)entry.getValue();
                    if (c.size() > 1) {
                        conditions.add((Condition)new Paren((Condition)new Or((List)c)));
                        continue;
                    }
                    conditions.add((Condition)c.get(0));
                }
            }
        }
    }

    private String getEntityFilterCondition(String defname, String filterName) {
        String condition = null;
        if (defname == null || filterName == null) {
            return condition;
        }
        EntityFilter ef = (EntityFilter)this.efm.get(defname);
        if (ef == null) {
            return condition;
        }
        for (EntityFilterItem efi : ef.getItems()) {
            if (!filterName.equals(efi.getName())) continue;
            condition = efi.getCondition();
            break;
        }
        return condition;
    }

    public Condition convertDetailCondition(FilterCondition condition, String property, PropertyDefinitionType type, Map<String, Object> keyword) {
        IsNotNull filter = null;
        Object value = keyword != null ? keyword.get("data-range-from") : null;
        Object convValue = this.convertFilterValue(type, value);
        if (PropertyDefinitionType.REFERENCE.equals((Object)type)) {
            property = property + "." + "name";
        }
        switch (condition) {
            case EQ: {
                filter = new Equals(property, convValue);
                break;
            }
            case NE: {
                filter = new NotEquals(property, convValue);
                break;
            }
            case SW: {
                filter = new Like(property, (String)value, Like.MatchPattern.PREFIX);
                break;
            }
            case LW: {
                filter = new Like(property, (String)value, Like.MatchPattern.POSTFIX);
                break;
            }
            case IC: {
                filter = new Like(property, (String)value, Like.MatchPattern.PARTIAL);
                break;
            }
            case NIC: {
                filter = new Paren((Condition)new Not((Condition)new Like(property, (String)value, Like.MatchPattern.PARTIAL)));
                break;
            }
            case IN: {
                StrTokenizer st = StrTokenizer.getCSVInstance((String)((String)value));
                String[] values = st.getTokenArray();
                Object[] ret = new Object[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = this.convertFilterValue(type, values[i]);
                }
                filter = new In(property, ret);
                break;
            }
            case LT: {
                filter = new Lesser(property, convValue);
                break;
            }
            case GT: {
                filter = new Greater(property, convValue);
                break;
            }
            case LE: {
                filter = new LesserEqual(property, convValue);
                break;
            }
            case GE: {
                filter = new GreaterEqual(property, convValue);
                break;
            }
            case RG: {
                GreaterEqual fromCond = null;
                LesserEqual toCond = null;
                Object to = this.convertFilterValue(type, keyword.get("data-range-to"));
                if (convValue != null) {
                    fromCond = new GreaterEqual(property, convValue);
                }
                if (to != null) {
                    toCond = new LesserEqual(property, to);
                }
                if (fromCond != null && toCond != null) {
                    filter = new And(new Condition[]{fromCond, toCond});
                    break;
                }
                if (fromCond != null && toCond == null) {
                    filter = fromCond;
                    break;
                }
                if (fromCond != null || toCond == null) break;
                filter = toCond;
                break;
            }
            case NNL: {
                filter = new IsNotNull(property);
                break;
            }
            case NL: {
                filter = new IsNull(property);
                break;
            }
        }
        return filter;
    }

    private Object convertFilterValue(PropertyDefinitionType type, Object val) {
        if (val == null) {
            return null;
        }
        if (type == null) {
            return val;
        }
        if (!(val instanceof String)) {
            return val;
        }
        String s = (String)val;
        switch (type) {
            case BINARY: 
            case EXPRESSION: 
            case BOOLEAN: {
                return ConvertUtil.convertFromString(Boolean.class, (String)s);
            }
            case DATETIME: {
                return ConvertUtil.convertFromString(Timestamp.class, (String)s);
            }
            case DATE: {
                return ConvertUtil.convertFromString(Date.class, (String)s);
            }
            case TIME: {
                return ConvertUtil.convertFromString(Time.class, (String)s);
            }
            case INTEGER: {
                return ConvertUtil.convertFromString(Long.class, (String)s);
            }
            case DECIMAL: {
                return ConvertUtil.convertFromString(BigDecimal.class, (String)s);
            }
            case FLOAT: {
                return ConvertUtil.convertFromString(Double.class, (String)s);
            }
        }
        return val;
    }

    protected static enum FilterCondition {
        EQ,
        NE,
        SW,
        LW,
        IC,
        NIC,
        IN,
        LT,
        GT,
        LE,
        GE,
        RG,
        RD,
        RDT,
        NNL,
        NL;

    }
}

