/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.calendar;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.template.Template;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.DateProperty;
import org.iplass.mtp.entity.definition.properties.DateTimeProperty;
import org.iplass.mtp.entity.definition.properties.TimeProperty;
import org.iplass.mtp.entity.query.PreparedQuery;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Between;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.view.calendar.EntityCalendar;
import org.iplass.mtp.view.calendar.EntityCalendarItem;
import org.iplass.mtp.view.calendar.EntityCalendarManager;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/calendar/getCalendarWidget", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="params"), results={"calendarWidgetList"}, checkXRequestedWithHeader=true)
@Template(name="gem/calendar/calendarWidget", displayName="\u30ab\u30ec\u30f3\u30c0\u30fc\u30a6\u30a3\u30b8\u30a7\u30c3\u30c8", path="/jsp/gem/calendar/calendarWidget.jsp")
@CommandClass(name="gem/calendar/GetCalendarWidgetCommand", displayName="\u30ab\u30ec\u30f3\u30c0\u30fc\u30a6\u30a3\u30b8\u30a7\u30c3\u30c8")
public final class GetCalendarWidgetCommand
implements Command {
    public static final String WEBAPI_NAME = "gem/calendar/getCalendarWidget";
    private EntityCalendarManager ecm = (EntityCalendarManager)ManagerLocator.getInstance().getManager(EntityCalendarManager.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);

    public String execute(RequestContext request) {
        Map json = (Map)request.getAttribute("params");
        String calendarName = (String)json.get("calendarName");
        java.util.Date targetDate = this.stringToTime((String)json.get("targetDate"));
        HashSet<String> linkList = new HashSet<String>();
        EntityCalendar cd = (EntityCalendar)this.ecm.get(calendarName);
        if (cd != null) {
            for (EntityCalendarItem item : cd.getItems()) {
                this.searchData(linkList, item, targetDate);
            }
        }
        request.setAttribute("calendarWidgetList", linkList);
        return "SUCCESS";
    }

    private void searchData(Set<String> linkList, EntityCalendarItem item, java.util.Date targetDate) {
        String defName = item.getDefinitionName();
        String propertyName = EntityCalendarItem.CalendarSearchType.DATE.equals((Object)item.getCalendarSearchType()) ? item.getPropertyName() : item.getFromPropertyName();
        EntityDefinition ed = this.edm.get(defName);
        PropertyDefinition pd = ed.getProperty(propertyName);
        targetDate = targetDate != null ? targetDate : new java.util.Date();
        Calendar fromCal = Calendar.getInstance();
        fromCal.setTime(targetDate);
        fromCal.set(5, 1);
        fromCal.set(11, 0);
        fromCal.set(12, 0);
        fromCal.set(13, 0);
        fromCal.set(14, 0);
        Calendar toCal = Calendar.getInstance();
        toCal.setTime(targetDate);
        toCal.set(11, 23);
        toCal.set(12, 59);
        toCal.set(13, 59);
        toCal.set(14, 999);
        Query q = new Query();
        q.select(new Object[]{"oid", "name", propertyName});
        q.from(defName);
        Where where = new Where();
        ArrayList<Object> conditions = new ArrayList<Object>();
        if (pd instanceof DateProperty) {
            conditions.add(new Between(propertyName, (Object)new Date(fromCal.getTimeInMillis()), (Object)new Date(toCal.getTimeInMillis())));
        } else if (pd instanceof DateTimeProperty) {
            conditions.add(new Between(propertyName, (Object)new Timestamp(fromCal.getTimeInMillis()), (Object)new Timestamp(toCal.getTimeInMillis())));
        } else if (pd instanceof TimeProperty) {
            conditions.add(new Between(propertyName, (Object)new Time(fromCal.getTimeInMillis()), (Object)new Time(toCal.getTimeInMillis())));
        }
        if (item.getFilterCondition() != null && !item.getFilterCondition().isEmpty()) {
            conditions.add(new PreparedQuery(item.getFilterCondition()).condition(null));
        }
        where.setCondition((Condition)new And(conditions));
        q.setWhere(where);
        q.order(new SortSpec[]{new SortSpec("oid", SortSpec.SortType.ASC), new SortSpec(propertyName, SortSpec.SortType.ASC)});
        if (item.getLimit() != null) {
            q.limit(item.getLimit().intValue());
        } else {
            q.limit(1000);
        }
        List list = this.em.searchEntity(q).getList();
        SimpleDateFormat format = DateUtil.getSimpleDateFormat((String)"yyyyMMdd", (boolean)false);
        for (Entity entity : list) {
            java.util.Date date = (java.util.Date)entity.getValue(propertyName);
            linkList.add(this.timeToString(date, format));
        }
    }

    private String timeToString(java.util.Date date, SimpleDateFormat format) {
        return format.format(date);
    }

    private java.util.Date stringToTime(String time) {
        SimpleDateFormat format = DateUtil.getSimpleDateFormat((String)"yyyyMMdd", (boolean)false);
        java.util.Date date = null;
        try {
            date = format.parse(time);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }
}

