/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.calendar.ref;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.iplass.gem.command.calendar.ref.CalendarFilterData;
import org.iplass.gem.command.calendar.ref.CalendarFilterPropertyItem;
import org.iplass.gem.command.generic.search.SearchFormViewData;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.view.calendar.EntityCalendar;
import org.iplass.mtp.view.calendar.EntityCalendarItem;
import org.iplass.mtp.view.calendar.EntityCalendarManager;
import org.iplass.mtp.view.filter.EntityFilter;
import org.iplass.mtp.view.filter.EntityFilterManager;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.FormViewUtil;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.generic.editor.BinaryPropertyEditor;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.iplass.mtp.web.template.TemplateUtil;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebApi(name="gem/calendar/ref/getCalendarFilter", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"calendarFilterData"}, checkXRequestedWithHeader=true)
@CommandClass(name="gem/calendar/ref/GetCalendarFilterCommand", displayName="\u30ab\u30ec\u30f3\u30c0\u30fc\u30d5\u30a3\u30eb\u30bf\u30fc\u53d6\u5f97")
public final class GetCalendarFilterCommand
implements Command {
    public static final String WEBAPI_NAME = "gem/calendar/ref/getCalendarFilter";
    private static Logger logger = LoggerFactory.getLogger(GetCalendarFilterCommand.class);
    private EntityCalendarManager ecm = (EntityCalendarManager)ManagerLocator.getInstance().getManager(EntityCalendarManager.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private EntityFilterManager efm = (EntityFilterManager)ManagerLocator.getInstance().getManager(EntityFilterManager.class);
    EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);

    public String execute(RequestContext request) {
        String calendarName = request.getParam("calendarName");
        EntityCalendar ec = (EntityCalendar)this.ecm.get(calendarName);
        ArrayList<CalendarFilterData> calendarFilterDataList = new ArrayList<CalendarFilterData>();
        if (ec != null) {
            for (EntityCalendarItem item : ec.getItems()) {
                String defName = item.getDefinitionName();
                CalendarFilterData cfd = new CalendarFilterData();
                EntityDefinition ed = this.edm.get(defName);
                cfd.setEntityDefinition(ed);
                SearchFormViewData viewData = new SearchFormViewData();
                viewData.setEntityDefinition(ed);
                EntityView entityView = (EntityView)this.evm.get(defName);
                String viewName = item.getViewName();
                SearchFormView view = FormViewUtil.getSearchFormView(ed, entityView, viewName);
                if (view == null) {
                    logger.warn("Entity [" + defName + "] is not defined SearchView [" + viewName + "], skip calendar condition.");
                    continue;
                }
                ArrayList<CalendarFilterPropertyItem> piList = new ArrayList<CalendarFilterPropertyItem>();
                List properties = view.getCondSection().getElements().stream().filter(e -> e instanceof PropertyItem).map(e -> (PropertyItem)e).collect(Collectors.toList());
                for (PropertyItem pi : properties) {
                    if (pi.isHideDetail()) continue;
                    PropertyEditor pe = pi.getEditor();
                    if (pe instanceof ReferencePropertyEditor) {
                        ReferencePropertyEditor rpe = (ReferencePropertyEditor)pe;
                        if (!rpe.getNestProperties().isEmpty()) {
                            this.getNestPropertyItem(pi, rpe, ed, piList);
                            continue;
                        }
                        PropertyDefinition pd = ed.getProperty(pi.getPropertyName());
                        CalendarFilterPropertyItem cpi = new CalendarFilterPropertyItem();
                        cpi.setPropertyName(pi.getPropertyName());
                        cpi.setDisplayName(TemplateUtil.getMultilingualString((String)pi.getDisplayLabel(), pi.getLocalizedDisplayLabelList(), (String)pd.getDisplayName(), (List)pd.getLocalizedDisplayNameList()));
                        cpi.setPropertyEditor(pi.getEditor(), pd);
                        cpi.setPropertyType(pd.getType().toString());
                        piList.add(cpi);
                        continue;
                    }
                    if (pe instanceof BinaryPropertyEditor) continue;
                    PropertyDefinition pd = ed.getProperty(pi.getPropertyName());
                    CalendarFilterPropertyItem cpi = new CalendarFilterPropertyItem();
                    cpi.setPropertyName(pi.getPropertyName());
                    cpi.setDisplayName(TemplateUtil.getMultilingualString((String)pi.getDisplayLabel(), pi.getLocalizedDisplayLabelList(), (String)pd.getDisplayName(), (List)pd.getLocalizedDisplayNameList()));
                    cpi.setPropertyEditor(pi.getEditor(), pd);
                    cpi.setPropertyType(pd.getType().toString());
                    piList.add(cpi);
                }
                cfd.setCalendarFilterPropertyItemList(piList);
                EntityFilter ef = (EntityFilter)this.efm.get(defName);
                cfd.setEntityFilterIteList(ef != null ? ef.getItems() : null);
                calendarFilterDataList.add(cfd);
            }
        }
        request.setAttribute("calendarFilterData", calendarFilterDataList);
        return "SUCCESS";
    }

    private void getNestPropertyItem(PropertyItem pi, ReferencePropertyEditor rpe, EntityDefinition ed, List<CalendarFilterPropertyItem> piList) {
        if (rpe.isUseNestConditionWithProperty()) {
            CalendarFilterPropertyItem cpi = new CalendarFilterPropertyItem();
            PropertyDefinition pd = ed.getProperty(pi.getPropertyName());
            cpi.setPropertyName(pi.getPropertyName());
            cpi.setDisplayName(TemplateUtil.getMultilingualString((String)pi.getDisplayLabel(), pi.getLocalizedDisplayLabelList(), (String)pd.getDisplayName(), (List)pd.getLocalizedDisplayNameList()));
            cpi.setPropertyEditor(pi.getEditor(), pd);
            cpi.setPropertyType(pd.getType().toString());
            piList.add(cpi);
        }
        List<NestProperty> npList = rpe.getNestProperties();
        for (NestProperty np : npList) {
            String npName = pi.getPropertyName() + "." + np.getPropertyName();
            PropertyDefinition pd = ed.getProperty(np.getPropertyName());
            if (pd instanceof ReferenceProperty && np.getEditor() instanceof ReferencePropertyEditor && !((ReferencePropertyEditor)np.getEditor()).getNestProperties().isEmpty()) {
                this.getLastPropertyItem(npName, np, (ReferencePropertyEditor)np.getEditor(), this.edm.get(((ReferenceProperty)pd).getObjectDefinitionName()), piList);
                continue;
            }
            CalendarFilterPropertyItem cpi = new CalendarFilterPropertyItem();
            cpi.setPropertyName(npName);
            cpi.setDisplayName(TemplateUtil.getMultilingualString((String)np.getDisplayLabel(), np.getLocalizedDisplayLabelList(), (String)pd.getDisplayName(), (List)pd.getLocalizedDisplayNameList()));
            cpi.setPropertyEditor(np.getEditor(), pd);
            cpi.setPropertyType(pd.getType().toString());
            piList.add(cpi);
        }
    }

    private void getLastPropertyItem(String npName, NestProperty nestProperty, ReferencePropertyEditor rpe, EntityDefinition ed, List<CalendarFilterPropertyItem> piList) {
        if (rpe.isUseNestConditionWithProperty()) {
            CalendarFilterPropertyItem cpi = new CalendarFilterPropertyItem();
            PropertyDefinition pd = ed.getProperty(nestProperty.getPropertyName());
            cpi.setPropertyName(npName);
            cpi.setDisplayName(TemplateUtil.getMultilingualString((String)nestProperty.getDisplayLabel(), nestProperty.getLocalizedDisplayLabelList(), (String)pd.getDisplayName(), (List)pd.getLocalizedDisplayNameList()));
            cpi.setPropertyEditor(nestProperty.getEditor(), pd);
            cpi.setPropertyType(pd.getType().toString());
            piList.add(cpi);
        }
        List<NestProperty> npList = rpe.getNestProperties();
        for (NestProperty np : npList) {
            npName = npName + "." + np.getPropertyName();
            PropertyDefinition pd = ed.getProperty(np.getPropertyName());
            if (pd instanceof ReferenceProperty && np.getEditor() instanceof ReferencePropertyEditor && !((ReferencePropertyEditor)np.getEditor()).getNestProperties().isEmpty()) {
                this.getLastPropertyItem(npName, np, (ReferencePropertyEditor)np.getEditor(), this.edm.get(((ReferenceProperty)pd).getObjectDefinitionName()), piList);
                continue;
            }
            CalendarFilterPropertyItem cpi = new CalendarFilterPropertyItem();
            cpi.setPropertyName(npName);
            cpi.setDisplayName(TemplateUtil.getMultilingualString((String)np.getDisplayLabel(), np.getLocalizedDisplayLabelList(), (String)pd.getDisplayName(), (List)pd.getLocalizedDisplayNameList()));
            cpi.setPropertyEditor(np.getEditor(), pd);
            cpi.setPropertyType(pd.getType().toString());
            piList.add(cpi);
        }
    }
}

