/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.fulltext;

import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import org.iplass.gem.command.CreateSearchResultUtil;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.ViewUtil;
import org.iplass.gem.command.fulltext.FullTextSearchResult;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.fulltextsearch.FulltextSearchCondition;
import org.iplass.mtp.entity.fulltextsearch.FulltextSearchManager;
import org.iplass.mtp.entity.fulltextsearch.FulltextSearchOption;
import org.iplass.mtp.entity.fulltextsearch.FulltextSearchRuntimeException;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.util.CollectionUtil;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.FormViewUtil;
import org.iplass.mtp.view.generic.NullOrderType;
import org.iplass.mtp.view.generic.OutputType;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.generic.editor.JoinPropertyEditor;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.RangePropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.editor.UserPropertyEditor;
import org.iplass.mtp.view.generic.element.property.PropertyColumn;
import org.iplass.mtp.view.generic.element.section.SearchConditionSection;
import org.iplass.mtp.view.generic.element.section.SearchResultSection;
import org.iplass.mtp.view.generic.element.section.SortSetting;
import org.iplass.mtp.view.top.TopViewDefinition;
import org.iplass.mtp.view.top.TopViewDefinitionManager;
import org.iplass.mtp.view.top.parts.FulltextSearchViewParts;
import org.iplass.mtp.view.top.parts.TopViewParts;
import org.iplass.mtp.web.template.TemplateUtil;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebApi(name="gem/fulltext/search", displayName="\u5168\u6587\u691c\u7d22", accepts={RequestType.REST_FORM}, methods={MethodType.POST}, results={"message", "data", "searchDefName", "fulltextKey", "searchCond"}, checkXRequestedWithHeader=true)
@CommandClass(name="gem/fulltext/FullTextSearchCommand", displayName="\u5168\u6587\u691c\u7d22")
public final class FullTextSearchCommand
implements Command {
    public static final String SEARCH_WEB_API_NAME = "gem/fulltext/search";
    private static Logger logger = LoggerFactory.getLogger(FullTextSearchCommand.class);

    public String execute(RequestContext request) {
        String roleName = (String)request.getSession().getAttribute("roleName");
        String fulltextKey = request.getParam("fulltextKey");
        if (!StringUtil.isNotEmpty((String)fulltextKey)) {
            request.setAttribute("message", (Object)this.getRS("research", new Object[0]));
            return "FAILURE";
        }
        fulltextKey = fulltextKey.replaceAll("\u3000", " ");
        String[] searchDefNames = request.getParams("searchDefName");
        List<String> defNameList = this.getSelectedDefNameList(searchDefNames);
        Map<String, String> sortKeyMap = this.getSelectedSortKeyMap(searchDefNames, request);
        Map<String, String> sortTypeMap = this.getSelectedSortTypeMap(searchDefNames, request);
        StringBuilder searchCond = new StringBuilder();
        if (!defNameList.isEmpty()) {
            defNameList.stream().map(defName -> "&searchDefName=" + defName).forEach(param -> searchCond.append((String)param));
            searchCond.deleteCharAt(0);
        }
        searchCond.append("&fulltextKey=" + fulltextKey);
        request.setAttribute("searchCond", (Object)searchCond.toString());
        request.setAttribute("fulltextKey", (Object)fulltextKey);
        if (!defNameList.isEmpty()) {
            request.setAttribute("searchDefName", defNameList);
        }
        List<EntitySearchInfo> searchCondList = this.getEntitySearchInfo(roleName, defNameList, sortKeyMap, sortTypeMap);
        FulltextSearchOption option = this.getFulltextSearchOption(searchCondList);
        EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        List searchResult = null;
        try {
            searchResult = em.fulltextSearchEntity(fulltextKey, option).getList();
        }
        catch (FulltextSearchRuntimeException e) {
            logger.error("fulltext search error.", (Throwable)e);
            request.setAttribute("message", (Object)this.getRS("validString", new Object[0]));
            return "FAILURE";
        }
        if (CollectionUtil.isEmpty((Collection)searchResult)) {
            request.setAttribute("message", (Object)this.getRS("nodata", new Object[0]));
            return "FAILURE";
        }
        FulltextSearchManager fsm = (FulltextSearchManager)ManagerLocator.getInstance().getManager(FulltextSearchManager.class);
        int maxRow = fsm.getMaxRows();
        boolean isThrowExceptionWhenOverLimit = fsm.isThrowExceptionWhenOverLimit();
        if (maxRow <= searchResult.size()) {
            if (isThrowExceptionWhenOverLimit) {
                request.setAttribute("message", (Object)this.getRS("maxRows", maxRow));
                return "FAILURE";
            }
            request.setAttribute("message", (Object)this.getRS("overLimit", maxRow));
        }
        Map crawlDateMap = fsm.getLastCrawlTimestamp(option.getConditions().keySet().toArray(new String[0]));
        Map<String, List<Entity>> entityMap = searchResult.parallelStream().collect(Collectors.groupingBy(Entity::getDefinitionName));
        AuthContext auth = AuthContext.getCurrentContext();
        EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
        List resultList = searchCondList.stream().map(search -> {
            search.setSearchResult((List)entityMap.get(search.getDefinitionName()));
            search.setCrawlDate((Timestamp)crawlDateMap.get(search.getDefinitionName()));
            return search;
        }).filter(search -> search.getSearchResult() != null).map(search -> this.getResultInfo((EntitySearchInfo)search, edm, auth)).collect(Collectors.toList());
        Set<String> userOidSet = resultList.stream().map(res -> res.getUserOid()).flatMap(oidSet -> oidSet.stream()).collect(Collectors.toSet());
        if (!userOidSet.isEmpty()) {
            HashMap<String, Entity> userInfoMap = new HashMap<String, Entity>();
            FulltextSearchViewParts parts = this.getTopViewParts(roleName);
            if (parts.isShowUserNameWithPrivilegedValue()) {
                AuthContext.doPrivileged(() -> this.getUserInfoMap(em, userInfoMap, userOidSet));
            } else {
                this.getUserInfoMap(em, userInfoMap, userOidSet);
            }
            request.setAttribute("userInfoMap", userInfoMap);
        }
        List resultData = resultList.stream().sorted(Comparator.comparing(EntityResultInfo::getDefinitionName)).map(res -> res.toFullTextSearchResult()).collect(Collectors.toList());
        request.setAttribute("data", resultData);
        return "SUCCESS";
    }

    private List<String> getSelectedDefNameList(String[] searchDefNames) {
        if (searchDefNames != null) {
            return Arrays.stream(searchDefNames).filter(defName -> StringUtil.isNotEmpty((String)defName)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Map<String, String> getSelectedSortKeyMap(String[] searchDefNames, RequestContext request) {
        if (searchDefNames != null) {
            return Arrays.stream(searchDefNames).filter(defName -> StringUtil.isNotEmpty((String)defName) && StringUtil.isNotEmpty((String)request.getParam("sortKey_" + defName))).collect(Collectors.toMap(defName -> defName, defName -> request.getParam("sortKey_" + defName)));
        }
        return Collections.emptyMap();
    }

    private Map<String, String> getSelectedSortTypeMap(String[] searchDefNames, RequestContext request) {
        if (searchDefNames != null) {
            return Arrays.stream(searchDefNames).filter(defName -> StringUtil.isNotEmpty((String)defName) && StringUtil.isNotEmpty((String)request.getParam("sortType_" + defName))).collect(Collectors.toMap(defName -> defName, defName -> request.getParam("sortType_" + defName)));
        }
        return Collections.emptyMap();
    }

    private List<EntitySearchInfo> getEntitySearchInfo(String roleName, List<String> selectedDefNameList, Map<String, String> sortKeyMap, Map<String, String> sortTypeMap) {
        FulltextSearchViewParts parts = this.getTopViewParts(roleName);
        EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);
        EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
        if (parts == null) {
            List defList = selectedDefNameList.isEmpty() ? edm.definitionList() : selectedDefNameList;
            return defList.stream().map(defName -> edm.get(defName)).filter(ed -> ed != null && ed.isCrawl()).map(ed -> {
                String sortKey = (String)sortKeyMap.get(ed.getName());
                String sortType = (String)sortTypeMap.get(ed.getName());
                return this.getSearchInfo((EntityDefinition)ed, null, evm, edm, sortKey, sortType);
            }).filter(i -> i != null).collect(Collectors.toList());
        }
        Map<String, Boolean> isShowEntities = parts.getDispEntities();
        if (isShowEntities != null) {
            Map<String, String> viewNames = parts.getViewNames();
            return isShowEntities.entrySet().stream().filter(p -> (Boolean)p.getValue()).filter(p -> selectedDefNameList.isEmpty() || selectedDefNameList.contains(p.getKey())).map(p -> edm.get((String)p.getKey())).filter(ed -> ed != null && ed.isCrawl()).map(ed -> {
                String viewName = null;
                if (viewNames != null) {
                    viewName = (String)viewNames.get(ed.getName());
                }
                String sortKey = (String)sortKeyMap.get(ed.getName());
                String sortType = (String)sortTypeMap.get(ed.getName());
                return this.getSearchInfo((EntityDefinition)ed, viewName, evm, edm, sortKey, sortType);
            }).filter(i -> i != null).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private FulltextSearchOption getFulltextSearchOption(List<EntitySearchInfo> searchCondList) {
        FulltextSearchOption option = new FulltextSearchOption();
        searchCondList.stream().forEach(info -> {
            List<SortSetting> sortSettings = this.getSortSetting((EntitySearchInfo)info);
            EntityDefinition ed = info.getEntityDefinition();
            OrderBy order = this.getOrderBy(ed, sortSettings);
            FulltextSearchCondition cond = new FulltextSearchCondition(info.getProperties(), order);
            option.getConditions().put(info.getDefinitionName(), cond);
        });
        return option;
    }

    private FulltextSearchViewParts getTopViewParts(String roleName) {
        Optional<TopViewParts> fulltextParts;
        TopViewDefinitionManager tvdm;
        TopViewDefinition definition;
        if (roleName == null) {
            roleName = "DEFAULT";
        }
        if ((definition = (TopViewDefinition)(tvdm = (TopViewDefinitionManager)ManagerLocator.getInstance().getManager(TopViewDefinitionManager.class)).get(roleName)) != null && definition.getParts() != null && (fulltextParts = definition.getParts().stream().filter(part -> part instanceof FulltextSearchViewParts).findFirst()).isPresent()) {
            return (FulltextSearchViewParts)fulltextParts.get();
        }
        return null;
    }

    private EntitySearchInfo getSearchInfo(EntityDefinition ed, String viewName, EntityViewManager evm, EntityDefinitionManager edm, String sortKey, String sortType) {
        EntitySearchInfo search = new EntitySearchInfo(ed);
        search.setEntityDefinition(ed);
        String defName = ed.getName();
        EntityView view = (EntityView)evm.get(defName);
        SearchFormView searchFormView = FormViewUtil.getSearchFormView(ed, view, viewName);
        if (searchFormView == null) {
            logger.warn("Entity [" + defName + "] is not defined SearchView [" + viewName + "], skip fulltext search target.");
            return null;
        }
        search.setSearchFormView(searchFormView);
        search.setDetailViewName(viewName);
        search.setSortKey(sortKey);
        search.setSortType(sortType);
        SearchResultSection resultSection = searchFormView.getResultSection();
        ArrayList<String> select = new ArrayList<String>();
        select.add("oid");
        select.add("version");
        List properties = resultSection.getElements().stream().filter(e -> e instanceof PropertyColumn).map(e -> (PropertyColumn)e).collect(Collectors.toList());
        for (PropertyColumn p : properties) {
            if (!EntityViewUtil.isDisplayElement(ed.getName(), p.getElementRuntimeId(), OutputType.SEARCHRESULT, null)) continue;
            String propName = p.getPropertyName();
            if (p.getEditor() instanceof ReferencePropertyEditor) {
                List<NestProperty> nest = ((ReferencePropertyEditor)p.getEditor()).getNestProperties();
                this.addSearchProperty(select, ed, propName, p.getEditor(), nest.toArray(new NestProperty[nest.size()]));
                continue;
            }
            if (p.getEditor() instanceof JoinPropertyEditor) {
                this.addSearchProperty(select, ed, propName, p.getEditor(), new NestProperty[0]);
                JoinPropertyEditor je = (JoinPropertyEditor)p.getEditor();
                for (NestProperty nest : je.getProperties()) {
                    this.addSearchProperty(select, ed, nest.getPropertyName(), nest.getEditor(), new NestProperty[0]);
                }
                continue;
            }
            if (p.getEditor() instanceof RangePropertyEditor) {
                this.addSearchProperty(select, ed, propName, p.getEditor(), new NestProperty[0]);
                RangePropertyEditor de = (RangePropertyEditor)((Object)p.getEditor());
                if (!StringUtil.isNotBlank((String)de.getToPropertyName())) continue;
                this.addSearchProperty(select, ed, de.getToPropertyName(), de.getToEditor(), new NestProperty[0]);
                continue;
            }
            this.addSearchProperty(select, ed, propName, p.getEditor(), new NestProperty[0]);
        }
        search.setProperties(select);
        return search;
    }

    private void addSearchProperty(List<String> select, EntityDefinition ed, String propName, PropertyEditor editor, NestProperty ... nest) {
        PropertyDefinition pd = EntityViewUtil.getPropertyDefinition(propName, ed);
        if (pd instanceof ReferenceProperty) {
            if (!select.contains(propName + "." + "name")) {
                select.add(propName + "." + "name");
            }
            if (!select.contains(propName + "." + "oid")) {
                select.add(propName + "." + "oid");
            }
            if (!select.contains(propName + "." + "version")) {
                select.add(propName + "." + "version");
            }
            if (editor instanceof ReferencePropertyEditor) {
                this.addDisplayLabelProperty(select, ed, propName, (ReferencePropertyEditor)editor);
            }
            if (nest != null && nest.length > 0) {
                EntityDefinition red = this.getReferenceEntityDefinition((ReferenceProperty)pd);
                for (NestProperty np : nest) {
                    List<NestProperty> _nest;
                    Object rpe;
                    PropertyDefinition rpd = red.getProperty(np.getPropertyName());
                    if (rpd == null || "oid".equals(np.getPropertyName()) || "name".equals(np.getPropertyName()) || "version".equals(np.getPropertyName())) continue;
                    String nestPropName = propName + "." + np.getPropertyName();
                    if (rpd instanceof ReferenceProperty) {
                        if (!select.contains(nestPropName + "." + "name")) {
                            select.add(nestPropName + "." + "name");
                        }
                        if (!select.contains(nestPropName + "." + "oid")) {
                            select.add(nestPropName + "." + "oid");
                        }
                        if (!select.contains(nestPropName + "." + "version")) {
                            select.add(nestPropName + "." + "version");
                        }
                    } else if (!select.contains(nestPropName)) {
                        select.add(nestPropName);
                    }
                    if (np.getEditor() instanceof ReferencePropertyEditor) {
                        rpe = (ReferencePropertyEditor)np.getEditor();
                        if (!((ReferencePropertyEditor)rpe).getNestProperties().isEmpty()) {
                            _nest = ((ReferencePropertyEditor)rpe).getNestProperties();
                            this.addSearchProperty(select, ed, nestPropName, (PropertyEditor)rpe, _nest.toArray(new NestProperty[_nest.size()]));
                        }
                        this.addDisplayLabelProperty(select, ed, nestPropName, (ReferencePropertyEditor)rpe);
                        continue;
                    }
                    if (np.getEditor() instanceof JoinPropertyEditor) {
                        JoinPropertyEditor je = (JoinPropertyEditor)np.getEditor();
                        this.addSearchProperty(select, ed, nestPropName, je.getEditor(), new NestProperty[0]);
                        if (je.getProperties().isEmpty()) continue;
                        _nest = je.getProperties();
                        this.addSearchProperty(select, ed, propName, editor, _nest.toArray(new NestProperty[_nest.size()]));
                        continue;
                    }
                    if (!(np.getEditor() instanceof RangePropertyEditor)) continue;
                    rpe = (RangePropertyEditor)((Object)np.getEditor());
                    this.addSearchProperty(select, ed, nestPropName, rpe.getEditor(), new NestProperty[0]);
                    String nestToPropName = propName + "." + rpe.getToPropertyName();
                    this.addSearchProperty(select, ed, nestToPropName, rpe.getToEditor(), new NestProperty[0]);
                }
            }
        } else if (!select.contains(propName)) {
            select.add(propName);
        }
    }

    protected void addDisplayLabelProperty(List<String> select, EntityDefinition ed, String propName, ReferencePropertyEditor rpe) {
        if (rpe.getDisplayLabelItem() == null) {
            return;
        }
        PropertyDefinition pd = EntityViewUtil.getPropertyDefinition(propName, ed);
        if (pd instanceof ReferenceProperty && !select.contains(propName + "." + rpe.getDisplayLabelItem())) {
            select.add(propName + "." + rpe.getDisplayLabelItem());
        }
    }

    private EntityDefinition getReferenceEntityDefinition(ReferenceProperty rp) {
        EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
        return edm.get(rp.getObjectDefinitionName());
    }

    protected SearchConditionSection getConditionSection(SearchFormView form) {
        return form != null ? form.getCondSection() : null;
    }

    protected List<SortSetting> getSortSetting(EntitySearchInfo info) {
        SearchConditionSection section;
        PropertyDefinition pd;
        ArrayList<SortSetting> setting = new ArrayList<SortSetting>();
        String sortKey = info.getSortKey();
        if (StringUtil.isNotBlank((String)sortKey) && (pd = EntityViewUtil.getPropertyDefinition(sortKey, info.getEntityDefinition())) != null) {
            SortSetting ss = new SortSetting();
            ss.setSortKey(sortKey);
            String sortType = info.getSortType();
            if (StringUtil.isBlank((String)sortType)) {
                ss.setSortType(SearchConditionSection.ConditionSortType.DESC);
            } else {
                ss.setSortType(SearchConditionSection.ConditionSortType.valueOf(sortType));
            }
            SearchResultSection section2 = info.getSearchFormView().getResultSection();
            PropertyColumn property = this.getLayoutPropertyColumn(sortKey, section2);
            if (property != null) {
                ss.setNullOrderType(property.getNullOrderType());
                setting.add(ss);
            }
        }
        if ((section = info.getSearchFormView().getCondSection()) != null && section.isFulltextSearchSorted() && !section.getSortSetting().isEmpty()) {
            setting.addAll(section.getSortSetting());
        }
        return setting;
    }

    protected PropertyColumn getLayoutPropertyColumn(String propName, SearchResultSection section) {
        Optional<PropertyColumn> property = section.getElements().stream().filter(e -> e instanceof PropertyColumn).map(e -> (PropertyColumn)e).filter(e -> propName.equals(e.getPropertyName())).findFirst();
        if (property.isPresent()) {
            return property.get();
        }
        return null;
    }

    private OrderBy getOrderBy(EntityDefinition ed, List<SortSetting> setting) {
        OrderBy orderBy = null;
        if (setting != null && !setting.isEmpty()) {
            for (SortSetting ss : setting) {
                if (ss.getSortKey() == null) continue;
                String key = null;
                PropertyDefinition pd = EntityViewUtil.getPropertyDefinition(ss.getSortKey(), ed);
                key = pd instanceof ReferenceProperty ? ss.getSortKey() + "." + "oid" : ss.getSortKey();
                SortSpec.SortType type = SortSpec.SortType.valueOf((String)ss.getSortType().name());
                SortSpec.NullOrderingSpec nullOrderingSpec = this.getNullOrderingSpec(ss.getNullOrderType());
                if (orderBy == null) {
                    orderBy = new OrderBy();
                }
                orderBy.add((Object)key, type, nullOrderingSpec);
            }
        }
        return orderBy;
    }

    private EntityResultInfo getResultInfo(EntitySearchInfo serchCond, EntityDefinitionManager edm, AuthContext auth) {
        EntityResultInfo result = new EntityResultInfo(serchCond);
        SearchFormView formView = serchCond.getSearchFormView();
        String mappingPath = ViewUtil.getParamMappingPath(serchCond.getDefinitionName(), serchCond.getDetailViewName());
        if (StringUtil.isNotEmpty((String)formView.getViewActionName())) {
            result.setViewUrl(formView.getViewActionName() + mappingPath);
        } else {
            result.setViewUrl("gem/generic/detail/view" + mappingPath);
        }
        if (StringUtil.isNotEmpty((String)formView.getEditActionName())) {
            result.setDetailUrl(formView.getEditActionName() + mappingPath);
        } else {
            result.setDetailUrl("gem/generic/detail/edit" + mappingPath);
        }
        result.setDisplayName(TemplateUtil.getMultilingualString((String)formView.getTitle(), formView.getLocalizedTitleList(), (String)serchCond.getEntityDefinition().getDisplayName(), (List)serchCond.getEntityDefinition().getLocalizedDisplayNameList()));
        SearchResultSection resultSection = formView.getResultSection();
        boolean canUpdate = auth.checkPermission((Permission)new EntityPermission(serchCond.getDefinitionName(), EntityPermission.Action.UPDATE));
        boolean canDelete = auth.checkPermission((Permission)new EntityPermission(serchCond.getDefinitionName(), EntityPermission.Action.DELETE));
        boolean isHideDetailLink = resultSection.isHideDetailLink();
        result.setShowDetailLink(!isHideDetailLink && (canUpdate || canDelete));
        this.createColModel(result, resultSection, serchCond.getEntityDefinition(), edm);
        return result;
    }

    private void createColModel(EntityResultInfo result, SearchResultSection resultSection, EntityDefinition ed, EntityDefinitionManager edm) {
        ArrayList<FullTextSearchResult.ColModel> colModels = new ArrayList<FullTextSearchResult.ColModel>();
        ArrayList<String> userPropertyNames = new ArrayList<String>();
        Integer fixedCount = 0;
        FullTextSearchResult.ColModel colModel = new FullTextSearchResult.ColModel("orgOid", "oid");
        colModel.setHidden(true);
        colModel.setFrozen(true);
        colModels.add(colModel);
        colModel = new FullTextSearchResult.ColModel("orgVersion", "version");
        colModel.setHidden(true);
        colModel.setFrozen(true);
        colModels.add(colModel);
        colModel = new FullTextSearchResult.ColModel("score", "score");
        colModel.setHidden(true);
        colModel.setFrozen(true);
        colModels.add(colModel);
        colModel = new FullTextSearchResult.ColModel("_mtpDetailLink", "");
        colModel.setFrozen(true);
        colModel.setWidth(Integer.parseInt(this.getRS("detailLinkWidth", new Object[0])));
        colModel.setAlign("center");
        colModel.setClasses("detail-links");
        colModels.add(colModel);
        List properties = resultSection.getElements().stream().filter(e -> e instanceof PropertyColumn).map(e -> (PropertyColumn)e).collect(Collectors.toList());
        for (PropertyColumn property : properties) {
            String propName = property.getPropertyName();
            PropertyDefinition pd = EntityViewUtil.getPropertyDefinition(propName, ed);
            String displayLabel = TemplateUtil.getMultilingualString((String)property.getDisplayLabel(), property.getLocalizedDisplayLabelList(), (String)pd.getDisplayName(), (List)pd.getLocalizedDisplayNameList());
            if (!EntityViewUtil.isDisplayElement(ed.getName(), property.getElementRuntimeId(), OutputType.SEARCHRESULT, null)) continue;
            if (!(pd instanceof ReferenceProperty)) {
                String style;
                String sortPropName = StringUtil.escapeHtml((String)propName);
                boolean frozen = false;
                Integer width = property.getWidth() > 0 ? Integer.valueOf(property.getWidth()) : null;
                String align = property.getTextAlign() != null ? property.getTextAlign().name().toLowerCase() : null;
                String string = style = property.getStyle() != null ? property.getStyle() : "";
                if (property.getEditor() instanceof UserPropertyEditor) {
                    userPropertyNames.add(propName);
                }
                colModel = new FullTextSearchResult.ColModel(sortPropName, displayLabel);
                colModel.setFrozen(frozen);
                colModel.setWidth(width);
                colModel.setAlign(align);
                colModel.setClasses(style);
                colModel.setSortable(true);
                colModels.add(colModel);
                continue;
            }
            if (!(property.getEditor() instanceof ReferencePropertyEditor)) continue;
            List<NestProperty> nest = ((ReferencePropertyEditor)property.getEditor()).getNestProperties();
            if (nest.isEmpty()) {
                String sortPropName = StringUtil.escapeHtml((String)propName);
                boolean frozen = false;
                Integer width = property.getWidth() > 0 ? Integer.valueOf(property.getWidth()) : null;
                String align = property.getTextAlign() != null ? property.getTextAlign().name().toLowerCase() : null;
                String style = property.getStyle() != null ? property.getStyle() : null;
                colModel = new FullTextSearchResult.ColModel(sortPropName, displayLabel);
                colModel.setFrozen(frozen);
                colModel.setWidth(width);
                colModel.setAlign(align);
                colModel.setClasses(style);
                colModel.setSortable(true);
                colModels.add(colModel);
                continue;
            }
            String style = property.getStyle() != null ? property.getStyle() : null;
            fixedCount = this.createNestColModel(colModels, userPropertyNames, nest, propName, (ReferenceProperty)pd, style, fixedCount, edm);
        }
        result.setColModel(colModels);
        result.setUserPropertyName(userPropertyNames);
    }

    private int createNestColModel(List<FullTextSearchResult.ColModel> colModels, List<String> userPropertyNames, List<NestProperty> nest, String propName, ReferenceProperty rp, String style, int fixedCount, EntityDefinitionManager edm) {
        EntityDefinition red = edm.get(rp.getObjectDefinitionName());
        int colCount = 0;
        for (NestProperty np : nest) {
            String nestStyle;
            PropertyDefinition rpd = red.getProperty(np.getPropertyName());
            if (np.getEditor() == null) continue;
            String nestPropName = propName + "." + np.getPropertyName();
            String string = nestStyle = StringUtil.isNotEmpty((String)style) ? style + "_col" + colCount++ : null;
            if (rpd instanceof ReferenceProperty && np.getEditor() instanceof ReferencePropertyEditor && !((ReferencePropertyEditor)np.getEditor()).getNestProperties().isEmpty()) {
                fixedCount = this.createNestColModel(colModels, userPropertyNames, ((ReferencePropertyEditor)np.getEditor()).getNestProperties(), nestPropName, (ReferenceProperty)rpd, nestStyle, fixedCount, edm);
                continue;
            }
            String sortPropName = StringUtil.escapeHtml((String)nestPropName);
            String displayLabel = TemplateUtil.getMultilingualString((String)np.getDisplayLabel(), np.getLocalizedDisplayLabelList(), (String)rpd.getDisplayName(), (List)rpd.getLocalizedDisplayNameList());
            boolean frozen = false;
            Integer width = np.getWidth() > 0 ? Integer.valueOf(np.getWidth()) : null;
            String align = np.getTextAlign() != null ? np.getTextAlign().name().toLowerCase() : null;
            FullTextSearchResult.ColModel colModel = new FullTextSearchResult.ColModel(sortPropName, displayLabel);
            colModel.setFrozen(frozen);
            colModel.setWidth(width);
            colModel.setAlign(align);
            colModel.setClasses(nestStyle);
            colModels.add(colModel);
            if (!(np.getEditor() instanceof UserPropertyEditor)) continue;
            userPropertyNames.add(nestPropName);
        }
        return fixedCount;
    }

    private void getUserInfoMap(EntityManager em, final Map<String, Entity> userInfoMap, Set<String> userOidSet) {
        Query q = new Query().select(new Object[]{"oid", "name"}).from("mtp.auth.User").where((Condition)new In("oid", userOidSet.toArray()));
        em.searchEntity(q, (Predicate)new Predicate<Entity>(){

            @Override
            public boolean test(Entity dataModel) {
                if (!userInfoMap.containsKey(dataModel.getOid())) {
                    userInfoMap.put(dataModel.getOid(), dataModel);
                }
                return true;
            }
        });
    }

    protected SortSpec.NullOrderingSpec getNullOrderingSpec(NullOrderType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case FIRST: {
                return SortSpec.NullOrderingSpec.FIRST;
            }
            case LAST: {
                return SortSpec.NullOrderingSpec.LAST;
            }
        }
        return null;
    }

    private String getRS(String key, Object ... args) {
        return FullTextSearchCommand.resourceString("command.fulltext.FullTextSearchCommand." + key, args);
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }

    private class EntityResultInfo {
        private EntitySearchInfo searchInfo;
        private String displayName;
        private String viewUrl;
        private String detailUrl;
        private boolean showDetailLink;
        private List<FullTextSearchResult.ColModel> colModel;
        private List<String> userPropertyName;

        public EntityResultInfo(EntitySearchInfo view) {
            this.searchInfo = view;
        }

        public String getDefinitionName() {
            return this.searchInfo.getDefinitionName();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getViewUrl() {
            return this.viewUrl;
        }

        public void setViewUrl(String viewUrl) {
            this.viewUrl = viewUrl;
        }

        public String getDetailUrl() {
            return this.detailUrl;
        }

        public void setDetailUrl(String detailUrl) {
            this.detailUrl = detailUrl;
        }

        public boolean isShowDetailLink() {
            return this.showDetailLink;
        }

        public void setShowDetailLink(boolean showDetailLink) {
            this.showDetailLink = showDetailLink;
        }

        public List<FullTextSearchResult.ColModel> getColModel() {
            return this.colModel;
        }

        public void setColModel(List<FullTextSearchResult.ColModel> colModel) {
            this.colModel = colModel;
        }

        public List<String> getUserPropertyName() {
            return this.userPropertyName;
        }

        public void setUserPropertyName(List<String> userPropertyName) {
            this.userPropertyName = userPropertyName;
        }

        public Set<String> getUserOid() {
            if (this.getUserPropertyName() == null) {
                return Collections.emptySet();
            }
            return this.searchInfo.getSearchResult().stream().map(entity -> this.getUserPropertyName().stream().map(propName -> (String)entity.getValue(propName)).collect(Collectors.toSet())).flatMap(oidSet -> oidSet.stream()).filter(oid -> oid != null).collect(Collectors.toSet());
        }

        public FullTextSearchResult toFullTextSearchResult() {
            FullTextSearchResult result = new FullTextSearchResult();
            result.setDefName(this.getDefinitionName());
            result.setDisplayName(this.getDisplayName());
            result.setViewAction(this.getViewUrl());
            result.setDetailAction(this.getDetailUrl());
            result.setShowDetailLink(this.isShowDetailLink());
            String crawlDate = "-";
            if (this.searchInfo.getCrawlDate() != null) {
                SimpleDateFormat format = DateUtil.getSimpleDateFormat((String)TemplateUtil.getLocaleFormat().getOutputDatetimeSecFormat(), (boolean)true);
                crawlDate = format.format(this.searchInfo.getCrawlDate());
            }
            result.setCrawlDate(FullTextSearchCommand.resourceString("fulltext.search.crawlDate", new Object[]{crawlDate}));
            result.setColModels(this.getColModel());
            try {
                result.setValues(CreateSearchResultUtil.getResultData(this.searchInfo.getSearchResult(), this.searchInfo.getEntityDefinition(), this.searchInfo.getSearchFormView().getResultSection(), this.searchInfo.getSearchFormView().getName()).toResponse());
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
            catch (ServletException e) {
                throw new SystemException((Throwable)e);
            }
            return result;
        }
    }

    private class EntitySearchInfo {
        private EntityDefinition ed;
        private String detailViewName;
        private SearchFormView searchFormView;
        private List<String> properties;
        private List<Entity> searchResult;
        private Timestamp crawlDate;
        private String sortKey;
        private String sortType;

        public EntitySearchInfo(EntityDefinition ed) {
            this.setEntityDefinition(ed);
        }

        public EntityDefinition getEntityDefinition() {
            return this.ed;
        }

        public void setEntityDefinition(EntityDefinition ed) {
            this.ed = ed;
        }

        public String getDefinitionName() {
            return this.ed.getName();
        }

        public SearchFormView getSearchFormView() {
            return this.searchFormView;
        }

        public void setSearchFormView(SearchFormView searchFormView) {
            this.searchFormView = searchFormView;
        }

        public String getDetailViewName() {
            return this.detailViewName;
        }

        public void setDetailViewName(String detailViewName) {
            this.detailViewName = detailViewName;
        }

        public List<String> getProperties() {
            return this.properties;
        }

        public void setProperties(List<String> properties) {
            this.properties = properties;
        }

        public List<Entity> getSearchResult() {
            return this.searchResult;
        }

        public void setSearchResult(List<Entity> searchResult) {
            this.searchResult = searchResult;
        }

        public Timestamp getCrawlDate() {
            return this.crawlDate;
        }

        public void setCrawlDate(Timestamp crawlDate) {
            this.crawlDate = crawlDate;
        }

        public String getSortKey() {
            return this.sortKey;
        }

        public void setSortKey(String sortKey) {
            this.sortKey = sortKey;
        }

        public String getSortType() {
            return this.sortType;
        }

        public void setSortType(String sortType) {
            this.sortType = sortType;
        }
    }
}

