/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.fulltext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ActionMappings;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.util.StringUtil;

@ActionMappings(value={@ActionMapping(name="gem/fulltext/searchview", displayName="\u5168\u6587\u691c\u7d22\u753b\u9762\u8868\u793a", result={@Result(status="SUCCESS", type=Result.Type.JSP, value="/jsp/gem/fulltext/search.jsp", templateName="gem/fulltext/search", layoutActionName="gem/layout/defaultLayout"), @Result(status="ERROR_VIEW", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/defaultLayout")})})
@CommandClass(name="gem/fulltext/FullTextSearchViewCommand", displayName="\u5168\u6587\u691c\u7d22\u753b\u9762\u8868\u793a")
public final class FullTextSearchViewCommand
implements Command {
    public static final String SEARCH_VIEW_ACTION_NAME = "gem/fulltext/searchview";

    public String execute(RequestContext request) {
        String searchCond = request.getParam("searchCond");
        String fulltextKey = null;
        List<String> defNames = null;
        if (StringUtil.isNotEmpty((String)searchCond)) {
            fulltextKey = this.getSeachCondKeyword(searchCond);
            defNames = this.getSeachCondDefNames(searchCond);
        } else {
            fulltextKey = request.getParam("fulltextKey");
            if (StringUtil.isEmpty((String)fulltextKey)) {
                fulltextKey = "";
            }
            defNames = new ArrayList<String>();
            String defName = request.getParam("searchDefName");
            if (StringUtil.isNotEmpty((String)defName)) {
                defNames.add(defName);
            }
        }
        request.setAttribute("fulltextKey", (Object)fulltextKey);
        request.setAttribute("searchDefName", defNames);
        return "SUCCESS";
    }

    private String getSeachCondKeyword(String src) {
        if (StringUtil.isBlank((String)src) || !src.contains("fulltextKey=")) {
            return "";
        }
        String tmp = src.substring(src.indexOf("fulltextKey="));
        tmp = tmp.substring("fulltextKey=".length());
        return tmp;
    }

    private List<String> getSeachCondDefNames(String src) {
        String[] params;
        if (StringUtil.isBlank((String)src) || !src.contains("searchDefName=")) {
            return Collections.emptyList();
        }
        ArrayList<String> defNames = new ArrayList<String>();
        for (String param : params = src.split("&")) {
            if (!param.startsWith("searchDefName=")) continue;
            defNames.add(param.substring("searchDefName=".length()));
        }
        return defNames;
    }
}

