/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.FormView;
import org.iplass.mtp.web.template.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericCommandContext {
    private static Logger logger = LoggerFactory.getLogger(GenericCommandContext.class);
    protected RequestContext request;
    protected String defName;
    protected String viewName;
    protected EntityDefinition entityDefinition;
    protected EntityView entityView;

    public GenericCommandContext(RequestContext request) {
        this.request = request;
        this.defName = this.getParam("defName");
        this.viewName = this.getParam("viewName");
    }

    public GenericCommandContext(RequestContext request, String defName) {
        this(request);
        this.defName = defName;
    }

    public GenericCommandContext(RequestContext request, String defName, String viewName) {
        this(request, defName);
        this.viewName = viewName;
    }

    protected RequestContext getRequest() {
        return this.request;
    }

    public EntityDefinition getEntityDefinition() {
        return this.entityDefinition;
    }

    public void setEntityDefinition(EntityDefinition entityDefinition) {
        this.entityDefinition = entityDefinition;
    }

    public EntityView getEntityView() {
        return this.entityView;
    }

    public void setEntityView(EntityView entityView) {
        this.entityView = entityView;
    }

    public abstract List<ValidateError> getErrors();

    public abstract void addError(ValidateError var1);

    public abstract boolean hasErrors();

    public boolean isVersioned() {
        return this.entityDefinition.getVersionControlType() != VersionControlType.NONE;
    }

    public String getDefinitionName() {
        return this.defName;
    }

    public PropertyDefinition getProperty(String propName) {
        return this.entityDefinition.getProperty(propName);
    }

    public List<PropertyDefinition> getPropertyList() {
        return this.entityDefinition.getPropertyList();
    }

    public String getParam(String name) {
        return this.request.getParam(name);
    }

    public Long getLongValue(String name) {
        try {
            return this.request.getParamAsLong(name);
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            ValidateError error = new ValidateError();
            error.setPropertyName(name);
            error.addErrorMessage(GenericCommandContext.resourceString("command.generic.GenericCommandContext.incorrect", new Object[0]));
            this.addError(error);
            return null;
        }
    }

    public Double getDoubleValue(String name) {
        try {
            return this.request.getParamAsDouble(name);
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            ValidateError error = new ValidateError();
            error.setPropertyName(name);
            error.addErrorMessage(GenericCommandContext.resourceString("command.generic.GenericCommandContext.incorrect", new Object[0]));
            this.addError(error);
            return null;
        }
    }

    public BigDecimal getDecimalValue(String name) {
        try {
            return this.request.getParamAsBigDecimal(name);
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            ValidateError error = new ValidateError();
            error.setPropertyName(name);
            error.addErrorMessage(GenericCommandContext.resourceString("command.generic.GenericCommandContext.incorrect", new Object[0]));
            this.addError(error);
            return null;
        }
    }

    public Date getDateValue(String name) {
        try {
            return this.request.getParamAsDate(name, TemplateUtil.getLocaleFormat().getServerDateFormat());
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            ValidateError error = new ValidateError();
            error.setPropertyName(name);
            error.addErrorMessage(GenericCommandContext.resourceString("command.generic.GenericCommandContext.incorrect", new Object[0]));
            this.addError(error);
            return null;
        }
    }

    public Time getTimeValue(String name) {
        try {
            return this.request.getParamAsTime(name, "HHmmssSSS");
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            ValidateError error = new ValidateError();
            error.setPropertyName(name);
            error.addErrorMessage(GenericCommandContext.resourceString("command.generic.GenericCommandContext.incorrect", new Object[0]));
            this.addError(error);
            return null;
        }
    }

    public Timestamp getTimestampValue(String name) {
        try {
            return this.request.getParamAsTimestamp(name, TemplateUtil.getLocaleFormat().getServerDateTimeFormat());
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            ValidateError error = new ValidateError();
            error.setPropertyName(name);
            error.addErrorMessage(GenericCommandContext.resourceString("command.generic.GenericCommandContext.incorrect", new Object[0]));
            this.addError(error);
            return null;
        }
    }

    public String[] getParams(String name) {
        try {
            return this.request.getParams(name);
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            ValidateError error = new ValidateError();
            error.setPropertyName(name);
            error.addErrorMessage(GenericCommandContext.resourceString("command.generic.GenericCommandContext.incorrect", new Object[0]));
            this.addError(error);
            return null;
        }
    }

    public Long[] getLongValues(String name) {
        try {
            return this.request.getParamsAsLong(name);
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            ValidateError error = new ValidateError();
            error.setPropertyName(name);
            error.addErrorMessage(GenericCommandContext.resourceString("command.generic.GenericCommandContext.incorrect", new Object[0]));
            this.addError(error);
            return null;
        }
    }

    public Double[] getDoubleValues(String name) {
        try {
            return this.request.getParamsAsDouble(name);
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            ValidateError error = new ValidateError();
            error.setPropertyName(name);
            error.addErrorMessage(GenericCommandContext.resourceString("command.generic.GenericCommandContext.incorrect", new Object[0]));
            this.addError(error);
            return null;
        }
    }

    public BigDecimal[] getDecimalValues(String name) {
        try {
            return this.request.getParamsAsBigDecimal(name);
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            ValidateError error = new ValidateError();
            error.setPropertyName(name);
            error.addErrorMessage(GenericCommandContext.resourceString("command.generic.GenericCommandContext.incorrect", new Object[0]));
            this.addError(error);
            return null;
        }
    }

    public Date[] getDateValues(String name) {
        try {
            return this.request.getParamsAsDate(name, TemplateUtil.getLocaleFormat().getServerDateFormat());
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            ValidateError error = new ValidateError();
            error.setPropertyName(name);
            error.addErrorMessage(GenericCommandContext.resourceString("command.generic.GenericCommandContext.incorrect", new Object[0]));
            this.addError(error);
            return null;
        }
    }

    public Time[] getTimeValues(String name) {
        try {
            return this.request.getParamsAsTime(name, "HHmmssSSS");
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            ValidateError error = new ValidateError();
            error.setPropertyName(name);
            error.addErrorMessage(GenericCommandContext.resourceString("command.generic.GenericCommandContext.incorrect", new Object[0]));
            this.addError(error);
            return null;
        }
    }

    public Timestamp[] getTimestampValues(String name) {
        try {
            return this.request.getParamsAsTimestamp(name, TemplateUtil.getLocaleFormat().getServerDateTimeFormat());
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            ValidateError error = new ValidateError();
            error.setPropertyName(name);
            error.addErrorMessage(GenericCommandContext.resourceString("command.generic.GenericCommandContext.incorrect", new Object[0]));
            this.addError(error);
            return null;
        }
    }

    public String getViewName() {
        return this.viewName;
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }

    public abstract <T extends FormView> T getView();

    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }
}

