/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.bulk;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.iplass.gem.GemConfigService;
import org.iplass.gem.command.CommandUtil;
import org.iplass.gem.command.generic.bulk.BulkUpdateInterrupterHandler;
import org.iplass.gem.command.generic.detail.NestTableReferenceRegistHandler;
import org.iplass.gem.command.generic.detail.ReferenceRegistHandler;
import org.iplass.gem.command.generic.detail.RegistrationCommandContext;
import org.iplass.gem.command.generic.detail.RegistrationPropertyBaseHandler;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.BulkOperationInterrupter;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.FormViewUtil;
import org.iplass.mtp.view.generic.OutputType;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.generic.editor.CustomPropertyEditor;
import org.iplass.mtp.view.generic.editor.DateRangePropertyEditor;
import org.iplass.mtp.view.generic.editor.JoinPropertyEditor;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.NumericRangePropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.RangePropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.element.property.PropertyColumn;
import org.iplass.mtp.view.generic.element.section.SearchResultSection;
import org.iplass.mtp.web.template.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkCommandContext
extends RegistrationCommandContext {
    private static Logger logger = LoggerFactory.getLogger(BulkCommandContext.class);
    private SearchFormView view;
    private GemConfigService gemConfig = null;
    private BulkUpdateInterrupterHandler bulkUpdateInterrupterHandler = null;
    private List<BulkCommandParams> bulkCommandParams = new ArrayList<BulkCommandParams>();
    private List<BulkUpdatedProperty> updatedProps = new ArrayList<BulkUpdatedProperty>();
    private Set<String> skipProps = new HashSet<String>(){
        {
            this.add("oid");
            this.add("version");
            this.add("updateDate");
        }
    };

    @Override
    protected Logger getLogger() {
        return logger;
    }

    public BulkCommandContext(RequestContext request, EntityManager entityLoader, EntityDefinitionManager definitionLoader) {
        super(request, entityLoader, definitionLoader);
        this.gemConfig = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        this.init();
    }

    private void init() {
        this.populateBulkCommandParam("oid", String.class, true, true, false);
        this.populateBulkCommandParam("version", Long.class, false, true, false);
        this.populateBulkCommandParam("timestamp", Long.class, false, false, true);
        this.populateBulkUpdatedProperty("bulkUpdatedPropNm", true);
        this.populateBulkUpdatedProperty("bulkUpdatedPropVl", false);
    }

    private void populateBulkCommandParam(String name, Class<?> cls, boolean create, boolean notBlank, boolean checkDiff) {
        String[] param = (String[])this.request.getAttribute(name);
        if (param == null || param.length == 0) {
            param = this.getParams(name);
        }
        if (param != null) {
            for (int i = 0; i < param.length; ++i) {
                boolean hasDiffPropValue;
                Object[] params = this.splitRowParam(param[i]);
                Integer targetRow = Integer.parseInt(params[0]);
                String targetParam = params[1];
                if (StringUtil.isBlank((String)targetParam) && notBlank) {
                    this.getLogger().error("can not be empty. name=" + name + ", param=" + param[i]);
                    throw new ApplicationException(BulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.invalidFormat", new Object[0]));
                }
                BulkCommandParams bulkParams = this.getBulkCommandParams(targetRow);
                if (create) {
                    if (bulkParams != null) {
                        this.getLogger().error("duplicate row. row=" + targetRow);
                        throw new ApplicationException(BulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.duplicateRow", new Object[0]));
                    }
                    this.bulkCommandParams.add(new BulkCommandParams(targetRow, targetParam));
                } else {
                    if (bulkParams == null) {
                        this.getLogger().error("selected row does not exist. params=" + Arrays.toString(params));
                        throw new ApplicationException(BulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.invalidRow", new Object[0]));
                    }
                    bulkParams.setValue(name, ConvertUtil.convertFromString(cls, (String)targetParam));
                }
                if (!checkDiff || i != param.length - 1 || !(hasDiffPropValue = this.hasDifferentPropertyValue(name))) continue;
                this.getLogger().error("has different prop value. name=" + name + ", bulkCommandParams=" + this.bulkCommandParams.toString());
                throw new ApplicationException(BulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.diffPropVal", new Object[0]));
            }
        }
    }

    private void populateBulkUpdatedProperty(String name, boolean create) {
        String[] param = this.request.getParams(name);
        if (param != null) {
            for (int i = 0; i < param.length; ++i) {
                String[] params = this.splitRowParam(param[i]);
                Integer updateNo = Integer.parseInt(params[0]);
                String targetParam = params[1];
                BulkUpdatedProperty updatedProp = this.getBulkUpdatedProperty(updateNo);
                if (create) {
                    if (updatedProp != null) {
                        this.getLogger().error("duplicate updateNo. updateNo=" + updateNo);
                        throw new ApplicationException(BulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.duplicateUpdateNo", new Object[0]));
                    }
                    this.updatedProps.add(new BulkUpdatedProperty(updateNo, targetParam));
                    continue;
                }
                if (updatedProp == null) {
                    this.getLogger().error("updateNo does not exist. params=" + param[i]);
                    throw new ApplicationException(BulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.invalidUpdateNo", new Object[0]));
                }
                updatedProp.setValue(name, targetParam);
            }
        }
    }

    private String[] splitRowParam(String rowParam) {
        if (rowParam.indexOf("_") == -1) {
            this.getLogger().error("invalid parameter format. rowParam=" + rowParam);
            throw new ApplicationException(BulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.invalidFormat", new Object[0]));
        }
        String targetRow = rowParam.substring(0, rowParam.indexOf("_"));
        String targetParam = rowParam.substring(rowParam.indexOf("_") + 1);
        String[] params = new String[]{targetRow, targetParam};
        return params;
    }

    private BulkCommandParams getBulkCommandParams(Integer row) {
        List paramsList = this.bulkCommandParams.stream().filter(p -> p.getRow().equals(row)).collect(Collectors.toList());
        if (paramsList.size() == 0) {
            return null;
        }
        if (paramsList.size() > 1) {
            this.getLogger().error("duplicate row. paramsList=" + paramsList);
            throw new ApplicationException(BulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.duplicateRow", new Object[0]));
        }
        return (BulkCommandParams)paramsList.get(0);
    }

    private boolean hasDifferentPropertyValue(String propName) {
        Set<String> oids = this.getOids();
        for (String oid : oids) {
            Iterator<Long> iterator = this.getVersions(oid).iterator();
            if (!iterator.hasNext()) continue;
            Long version = iterator.next();
            List propValues = this.bulkCommandParams.stream().filter(p -> p.getOid().equals(oid) && p.getVersion().equals(version)).map(p -> p.getValue(propName)).collect(Collectors.toList());
            Object first = propValues.get(0);
            if (first == null) {
                return propValues.stream().anyMatch(v -> v != null);
            }
            return propValues.stream().anyMatch(v -> !first.equals(v));
        }
        return false;
    }

    private BulkUpdatedProperty getBulkUpdatedProperty(Integer updateNo) {
        List updatedPropList = this.updatedProps.stream().filter(p -> p.getUpdateNo().equals(updateNo)).collect(Collectors.toList());
        if (updatedPropList.size() == 0) {
            return null;
        }
        if (updatedPropList.size() > 1) {
            this.getLogger().error("duplicate updateNo. updatedPropList=" + updatedPropList);
            throw new ApplicationException(BulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.duplicateUpdateNo", new Object[0]));
        }
        return (BulkUpdatedProperty)updatedPropList.get(0);
    }

    @Override
    protected Object createReference(PropertyDefinition p, String prefix) {
        ReferenceProperty rp = (ReferenceProperty)p;
        String defName = rp.getObjectDefinitionName();
        Long count = this.getLongValue(prefix + p.getName() + "_count");
        if (p.getMultiplicity() == 1) {
            Entity entity = null;
            if (count == null) {
                String key2 = this.getParam(prefix + p.getName());
                entity = this.getRefEntity(rp.getObjectDefinitionName(), key2);
            } else {
                List<Entity> list = this.getRefTableValues(rp, defName, count, prefix);
                if (list.size() > 0) {
                    entity = list.get(0);
                }
            }
            return entity;
        }
        List<Object> list = null;
        if (count == null) {
            String[] params = this.getParams(prefix + p.getName());
            if (params != null) {
                list = Arrays.stream(params).map(key -> this.getRefEntity(rp.getObjectDefinitionName(), (String)key)).filter(value -> value != null).collect(Collectors.toList());
            }
        } else {
            list = this.getRefTableValues(rp, defName, count, prefix);
        }
        if (list != null && !list.isEmpty()) {
            EntityDefinition ed = this.getEntityDefinition();
            this.setEntityDefinition(this.definitionManager.get(defName));
            Entity emptyEntity = this.newEntity();
            this.setEntityDefinition(ed);
            Object[] array = (Object[])Array.newInstance(emptyEntity.getClass(), list.size());
            return list.toArray(array);
        }
        return null;
    }

    private Entity getRefEntity(String definitionName, String key) {
        Entity entity = null;
        String oid = null;
        Long version = null;
        if (key != null) {
            int lastIndex = key.lastIndexOf("_");
            if (lastIndex < 0) {
                oid = key;
            } else {
                oid = key.substring(0, lastIndex);
                version = CommandUtil.getLong(key.substring(lastIndex + 1));
            }
        }
        if (StringUtil.isNotBlank(oid)) {
            entity = this.gemConfig.isLoadWithReference() ? this.entityManager.load(oid, version, definitionName) : this.entityManager.load(oid, version, definitionName, new LoadOption(false, false));
        }
        return entity;
    }

    private List<Entity> getRefTableValues(ReferenceProperty p, String defName, Long count, String prefix) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        EntityDefinition ed = this.getEntityDefinition();
        EntityDefinition red = this.definitionManager.get(defName);
        this.setEntityDefinition(red);
        int i = 0;
        while ((long)i < count) {
            String paramPrefix = prefix + p.getName() + "[" + Integer.toString(i) + "].";
            String errorPrefix = i != list.size() ? prefix + p.getName() + "[" + Integer.toString(list.size()) + "]." : null;
            Entity entity = this.createEntityInternal(paramPrefix, errorPrefix);
            entity.setValue("##refReload", (Object)Boolean.FALSE);
            if (entity.getOid() != null && entity.getOid().equals("null")) {
                entity.setOid(null);
            }
            String checkPrefix = errorPrefix != null ? errorPrefix : paramPrefix;
            boolean hasError = this.getErrors().stream().filter(error -> error.getPropertyName().startsWith(checkPrefix)).findFirst().isPresent();
            if (hasError || !this.isEmpty(entity)) {
                entity.setDefinitionName(defName);
                entity.setValue("##refIndex", (Object)list.size());
                Long orderIndex = this.getLongValue("tableOrderIndex[" + i + "]");
                if (orderIndex != null) {
                    entity.setValue("##refTableOrderIndex", (Object)orderIndex);
                }
                list.add(entity);
            }
            ++i;
        }
        this.setEntityDefinition(ed);
        Optional<PropertyColumn> ret = this.getProperty().stream().filter(pc -> pc.getPropertyName().equals(p.getName())).findFirst();
        if (ret.isPresent()) {
            this.addNestTableRegistHandler(p, list, red, ret.get());
        }
        return list;
    }

    private void addNestTableRegistHandler(ReferenceProperty p, List<Entity> list, EntityDefinition red, PropertyColumn property) {
        ReferenceRegistHandler handler;
        if (!NestTableReferenceRegistHandler.canRegist(property, this.getRegistrationPropertyBaseHandler())) {
            return;
        }
        ReferencePropertyEditor editor = (ReferencePropertyEditor)property.getBulkUpdateEditor();
        List<Entity> target = null;
        if (StringUtil.isNotBlank((String)editor.getTableOrderPropertyName())) {
            PropertyDefinition pd = red.getProperty(editor.getTableOrderPropertyName());
            target = EntityViewUtil.sortByOrderProperty(list, "##refTableOrderIndex");
            for (int i = 0; i < target.size(); ++i) {
                target.get(i).setValue(editor.getTableOrderPropertyName(), ConvertUtil.convert((Class)pd.getJavaType(), (Object)i));
            }
        } else {
            target = list;
        }
        if ((handler = NestTableReferenceRegistHandler.get(this, list, red, p, property, editor.getNestProperties(), this.getRegistrationPropertyBaseHandler())) != null) {
            handler.setForceUpdate(editor.isForceUpadte());
            this.getReferenceRegistHandlers().add(handler);
        }
    }

    private boolean isEmpty(Entity entity) {
        for (PropertyDefinition pd : this.getPropertyList()) {
            Object[] obj;
            if (!(pd.getMultiplicity() != 1 ? (obj = (Object[])entity.getValue(pd.getName())) != null && obj.length > 0 : entity.getValue(pd.getName()) != null)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getInterrupterName() {
        return this.getView().getResultSection().getInterrupterName();
    }

    @Override
    protected String getLoadEntityInterrupterName() {
        return this.getView().getResultSection().getLoadEntityInterrupterName();
    }

    protected RegistrationPropertyBaseHandler<PropertyColumn> createRegistrationPropertyBaseHandler() {
        return new RegistrationPropertyBaseHandler<PropertyColumn>(){

            @Override
            public boolean isDispProperty(PropertyColumn property) {
                return EntityViewUtil.isDisplayElement(BulkCommandContext.this.entityDefinition.getName(), property.getElementRuntimeId(), OutputType.BULK, null) && property.getBulkUpdateEditor() != null;
            }

            @Override
            public PropertyEditor getEditor(PropertyColumn property) {
                return property.getBulkUpdateEditor();
            }
        };
    }

    public Set<String> getOids() {
        return this.bulkCommandParams.stream().map(p -> p.getOid()).collect(Collectors.toSet());
    }

    public SearchFormView getView() {
        String viewName = this.getViewName();
        if (this.view == null) {
            this.view = FormViewUtil.getSearchFormView(this.entityDefinition, this.entityView, viewName);
        }
        return this.view;
    }

    public void setView(SearchFormView view) {
        this.view = view;
    }

    public SearchResultSection.ExclusiveControlPoint getExclusiveControlPoint() {
        return this.getView().getResultSection().getExclusiveControlPoint();
    }

    @Override
    public boolean isNewVersion() {
        return false;
    }

    @Override
    protected boolean isPurgeCompositionedEntity() {
        return this.getView().getResultSection().isPurgeCompositionedEntity();
    }

    @Override
    protected boolean isLocalizationData() {
        return this.getView().isLocalizationData();
    }

    @Override
    protected boolean isForceUpadte() {
        return this.getView().getResultSection().isForceUpadte();
    }

    @Override
    public boolean hasUpdatableMappedByReference() {
        List<PropertyColumn> properties = this.getProperty();
        for (PropertyColumn property : properties) {
            ReferencePropertyEditor editor;
            String mappedBy;
            PropertyDefinition pd = this.getProperty(property.getPropertyName());
            if (!(pd instanceof ReferenceProperty) || StringUtil.isBlank((String)(mappedBy = ((ReferenceProperty)pd).getMappedBy())) || !(property.getBulkUpdateEditor() instanceof ReferencePropertyEditor) || (editor = (ReferencePropertyEditor)property.getBulkUpdateEditor()).getDisplayType() != ReferencePropertyEditor.ReferenceDisplayType.NESTTABLE) continue;
            return true;
        }
        return false;
    }

    public String getSearchCond() {
        return this.getParam("searchCond");
    }

    public String getExecType() {
        return this.getParam("execType");
    }

    public Integer getRow(String oid, Long version) {
        Integer row = null;
        Optional<Integer> rw = this.bulkCommandParams.stream().filter(p -> p.getOid().equals(oid) && p.getVersion().equals(version)).map(p -> p.getRow()).findFirst();
        if (rw.isPresent()) {
            row = rw.get();
        }
        return row;
    }

    public Set<Long> getVersions(String oid) {
        return this.bulkCommandParams.stream().filter(p -> p.getOid().equals(oid)).map(p -> p.getVersion()).collect(Collectors.toSet());
    }

    public Timestamp getTimestamp(String oid, Long version) {
        Timestamp ts = null;
        Optional<Long> updateDate = this.bulkCommandParams.stream().filter(p -> p.getOid().equals(oid) && p.getVersion().equals(version)).map(p -> p.getUpdateDate()).findFirst();
        if (updateDate.isPresent() && updateDate.get() != null) {
            ts = new Timestamp(updateDate.get());
        }
        return ts;
    }

    public Boolean getSelectAllPage() {
        return this.request.getParamAsBoolean("selectAllPage");
    }

    public String getSelectAllType() {
        return this.getParam("selectAllType");
    }

    public String getBulkUpdatePropName() {
        return this.getParam("bulkUpdatePropNm");
    }

    public List<BulkUpdatedProperty> getUpdatedProps() {
        return this.updatedProps;
    }

    public Object getBulkUpdatePropertyValue(String propertyName) {
        PropertyDefinition p = this.entityDefinition.getProperty(propertyName);
        return this.getPropValue(p, "");
    }

    public Entity createEntity(String oid, Long version, Timestamp updateDate) {
        Entity entity = this.createEntityInternal("", null);
        entity.setOid(oid);
        entity.setUpdateDate(updateDate);
        entity.setVersion(version);
        this.getRegistrationInterrupterHandler().dataMapping(entity);
        this.validate(entity);
        return entity;
    }

    private Entity createEntityInternal(String paramPrefix, String errorPrefix) {
        Entity entity = this.newEntity();
        for (PropertyColumn pc : this.getProperty()) {
            PropertyDefinition p = this.getProperty(pc.getPropertyName());
            if (p == null || this.skipProps.contains(p.getName())) continue;
            Object value = this.getPropValue(p, paramPrefix);
            entity.setValue(p.getName(), value);
            if (errorPrefix == null) continue;
            String name = paramPrefix + p.getName();
            String errorName = errorPrefix + p.getName();
            this.getErrors().stream().filter(error -> error.getPropertyName().equals(name)).forEach(error -> error.setPropertyName(errorName));
        }
        return entity;
    }

    protected void validate(Entity entity) {
        for (PropertyColumn property : this.getProperty()) {
            PropertyEditor editor;
            if (property.getBulkUpdateEditor() instanceof DateRangePropertyEditor) {
                editor = (DateRangePropertyEditor)property.getBulkUpdateEditor();
                this.checkDateRange((DateRangePropertyEditor)editor, entity, property.getPropertyName(), ((DateRangePropertyEditor)editor).getToPropertyName(), "");
                continue;
            }
            if (property.getBulkUpdateEditor() instanceof NumericRangePropertyEditor) {
                editor = (NumericRangePropertyEditor)property.getBulkUpdateEditor();
                this.checkNumericRange((NumericRangePropertyEditor)editor, entity, property.getPropertyName(), ((NumericRangePropertyEditor)editor).getToPropertyName(), "");
                continue;
            }
            if (!(property.getBulkUpdateEditor() instanceof ReferencePropertyEditor)) continue;
            editor = (ReferencePropertyEditor)property.getBulkUpdateEditor();
            Object val = entity.getValue(property.getPropertyName());
            Entity[] ary = null;
            if (val != null) {
                if (val instanceof Entity) {
                    ary = new Entity[]{(Entity)val};
                } else if (val instanceof Entity[]) {
                    ary = (Entity[])val;
                }
            }
            if (((ReferencePropertyEditor)editor).getDisplayType() != ReferencePropertyEditor.ReferenceDisplayType.NESTTABLE || ary == null || ary.length <= 0 || ((ReferencePropertyEditor)editor).getNestProperties() == null || ((ReferencePropertyEditor)editor).getNestProperties().isEmpty()) continue;
            for (int i = 0; i < ary.length; ++i) {
                String errorPrefix = property.getPropertyName() + "[" + i + "].";
                for (NestProperty np : ((ReferencePropertyEditor)editor).getNestProperties()) {
                    CustomPropertyEditor de;
                    if (np.getEditor() instanceof DateRangePropertyEditor) {
                        de = (DateRangePropertyEditor)np.getEditor();
                        this.checkDateRange((DateRangePropertyEditor)de, ary[i], np.getPropertyName(), ((DateRangePropertyEditor)de).getToPropertyName(), errorPrefix);
                        continue;
                    }
                    if (!(np.getEditor() instanceof NumericRangePropertyEditor)) continue;
                    de = (NumericRangePropertyEditor)np.getEditor();
                    this.checkNumericRange((NumericRangePropertyEditor)de, ary[i], np.getPropertyName(), ((NumericRangePropertyEditor)de).getToPropertyName(), errorPrefix);
                }
            }
        }
    }

    private void checkDateRange(DateRangePropertyEditor editor, Entity entity, String fromName, String toName, String errorPrefix) {
        Date from = (Date)entity.getValue(fromName);
        Date to = (Date)entity.getValue(editor.getToPropertyName());
        if (from == null && to != null) {
            if (!editor.isInputNullFrom()) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.detail.DetailCommandContext.inputDateRangeErr");
            }
        } else if (from != null && to == null) {
            if (!editor.isInputNullTo()) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.detail.DetailCommandContext.inputDateRangeErr");
            }
        } else if (from != null && to != null) {
            boolean result = false;
            if (editor.isEquivalentInput()) {
                result = from.compareTo(to) > 0;
            } else {
                boolean bl = result = from.compareTo(to) >= 0;
            }
            if (result) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.detail.DetailCommandContext.invalidDateRange");
            }
        }
    }

    private void checkNumericRange(NumericRangePropertyEditor editor, Entity entity, String fromName, String toName, String errorPrefix) {
        Number from = (Number)entity.getValue(fromName);
        Number to = (Number)entity.getValue(editor.getToPropertyName());
        BigDecimal from_tmp = this.castNumericRangeNumber(from);
        BigDecimal to_tmp = this.castNumericRangeNumber(to);
        if (from_tmp == null && to_tmp != null) {
            if (!editor.isInputNullFrom()) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.bulk.BulkCommandContext.inputNumericRangeErr");
            }
        } else if (from_tmp != null && to_tmp == null) {
            if (!editor.isInputNullTo()) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.bulk.BulkCommandContext.inputNumericRangeErr");
            }
        } else if (from_tmp != null && to_tmp != null) {
            boolean result = false;
            if (editor.isEquivalentInput()) {
                result = from_tmp.compareTo(to_tmp) > 0;
            } else {
                boolean bl = result = from_tmp.compareTo(to_tmp) >= 0;
            }
            if (result) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.bulk.BulkCommandContext.invalidNumericRange");
            }
        }
    }

    private BigDecimal castNumericRangeNumber(Number number) {
        if (number instanceof Double) {
            return new BigDecimal(number.doubleValue());
        }
        if (number instanceof Long) {
            return new BigDecimal(number.longValue());
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return null;
    }

    private void setValidateErrorMessage(RangePropertyEditor editor, String fromName, String errorPrefix, String resourceStringKey) {
        String errorMessage = TemplateUtil.getMultilingualString((String)editor.getErrorMessage(), editor.getLocalizedErrorMessageList());
        if (StringUtil.isBlank((String)errorMessage)) {
            errorMessage = BulkCommandContext.resourceString(resourceStringKey, new Object[0]);
        }
        ValidateError e = new ValidateError();
        e.setPropertyName(errorPrefix + fromName + "_" + editor.getToPropertyName());
        e.addErrorMessage(errorMessage);
        this.getErrors().add(e);
    }

    public List<PropertyColumn> getProperty() {
        ArrayList<PropertyColumn> propList = new ArrayList<PropertyColumn>();
        String updatePropName = this.getBulkUpdatePropName();
        if (StringUtil.isEmpty((String)updatePropName)) {
            this.getLogger().error("update property name is empty. updatePropName=" + updatePropName);
            throw new ApplicationException(BulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.propNameNullValueErr", new Object[0]));
        }
        PropertyDefinition pd = this.getEntityDefinition().getProperty(updatePropName);
        if (pd == null) {
            this.getLogger().error("can not find property definition. updatePropName=" + updatePropName);
            throw new ApplicationException(BulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.propDefNotFoundErr", new Object[0]));
        }
        SearchResultSection section = this.getView().getResultSection();
        List propertyColumns = section.getElements().stream().filter(e -> e instanceof PropertyColumn).map(e -> (PropertyColumn)e).filter(e -> this.getRegistrationPropertyBaseHandler().isDispProperty(e)).collect(Collectors.toList());
        for (PropertyColumn pc : propertyColumns) {
            if (!pc.getPropertyName().equals(updatePropName)) continue;
            propList.add(pc);
            if (pc.getBulkUpdateEditor() instanceof DateRangePropertyEditor) {
                DateRangePropertyEditor de = (DateRangePropertyEditor)pc.getBulkUpdateEditor();
                PropertyColumn dummy = new PropertyColumn();
                dummy.setDispFlag(true);
                dummy.setPropertyName(de.getToPropertyName());
                dummy.setBulkUpdateEditor(de.getEditor());
                propList.add(dummy);
                break;
            }
            if (pc.getBulkUpdateEditor() instanceof JoinPropertyEditor) {
                JoinPropertyEditor je = (JoinPropertyEditor)pc.getBulkUpdateEditor();
                for (NestProperty nest : je.getProperties()) {
                    PropertyColumn dummy = new PropertyColumn();
                    dummy.setDispFlag(true);
                    dummy.setPropertyName(nest.getPropertyName());
                    dummy.setBulkUpdateEditor(nest.getEditor());
                    propList.add(dummy);
                }
                break;
            }
            if (!(pc.getBulkUpdateEditor() instanceof NumericRangePropertyEditor)) break;
            NumericRangePropertyEditor de = (NumericRangePropertyEditor)pc.getBulkUpdateEditor();
            PropertyColumn dummy = new PropertyColumn();
            dummy.setDispFlag(true);
            dummy.setPropertyName(de.getToPropertyName());
            dummy.setBulkUpdateEditor(de.getEditor());
            propList.add(dummy);
            break;
        }
        return propList;
    }

    public List<PropertyColumn> getUpdateProperty() {
        return this.getProperty();
    }

    public List<Entity> getEntities() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (String oid : this.getOids()) {
            for (Long version : this.getVersions(oid)) {
                Entity entity = this.newEntity();
                entity.setOid(oid);
                entity.setVersion(version);
                entity.setUpdateDate(this.getTimestamp(oid, version));
                entities.add(entity);
            }
        }
        return entities;
    }

    public BulkUpdateInterrupterHandler getBulkUpdateInterrupterHandler() {
        if (this.bulkUpdateInterrupterHandler == null) {
            BulkOperationInterrupter bulkUpdateInterrupter = this.createBulkInterrupter(this.getBulkInterrupterName());
            this.bulkUpdateInterrupterHandler = new BulkUpdateInterrupterHandler(this.request, this, bulkUpdateInterrupter);
        }
        return this.bulkUpdateInterrupterHandler;
    }

    protected String getBulkInterrupterName() {
        return this.getView().getResultSection().getBulkUpdateInterrupterName();
    }

    protected BulkOperationInterrupter createBulkInterrupter(String className) {
        BulkOperationInterrupter interrupter = null;
        if (StringUtil.isNotEmpty((String)className)) {
            this.getLogger().debug("set bulk update operation interrupter. class=" + className);
            try {
                interrupter = (BulkOperationInterrupter)this.ucdm.createInstanceAs(BulkOperationInterrupter.class, className);
            }
            catch (ClassNotFoundException e) {
                this.getLogger().error(className + " can not instantiate.", (Throwable)e);
                throw new ApplicationException(BulkCommandContext.resourceString("command.generic.detail.BulkCommandContext.internalErr", new Object[0]));
            }
        }
        if (interrupter == null) {
            this.getLogger().debug("set default bulk update operation interrupter.");
            interrupter = new BulkOperationInterrupter(){};
        }
        return interrupter;
    }

    public static class BulkUpdatedProperty {
        private Map<String, Object> params;

        public BulkUpdatedProperty(Integer updateNo, String propertyName) {
            this(updateNo, propertyName, null);
        }

        public BulkUpdatedProperty(Integer updateNo, String propertyName, Object propertyValue) {
            this.setUpdateNo(updateNo);
            this.setPropertyName(propertyName);
            this.setPropertyValue(propertyValue);
        }

        public Integer getUpdateNo() {
            return (Integer)this.getValue("id");
        }

        public void setUpdateNo(Integer updateNo) {
            this.setValue("id", updateNo);
        }

        public String getPropertyName() {
            return (String)this.getValue("bulkUpdatedPropNm");
        }

        public void setPropertyName(String propertyName) {
            this.setValue("bulkUpdatedPropNm", propertyName);
        }

        public Object getPropertyValue() {
            return this.getValue("bulkUpdatedPropVl");
        }

        public void setPropertyValue(Object propertyValue) {
            this.setValue("bulkUpdatedPropVl", propertyValue);
        }

        public void setValue(String name, Object value) {
            if (value == null && this.getValue(name) == null) {
                return;
            }
            if (this.params == null) {
                this.params = new HashMap<String, Object>();
            }
            if (value == null) {
                this.params.remove(name);
            } else {
                this.params.put(name, value);
            }
        }

        public <T> T getValue(String name) {
            if (this.params != null) {
                return (T)this.params.get(name);
            }
            return null;
        }

        public String toString() {
            return "BulkUpdatedProperty [updateNo=" + this.getUpdateNo() + ", propertyName=" + this.getPropertyName() + "]";
        }
    }

    private class BulkCommandParams {
        private Map<String, Object> params;

        public BulkCommandParams(Integer row, String oid) {
            this.setRow(row);
            this.setOid(oid);
        }

        public Integer getRow() {
            return (Integer)this.getValue("id");
        }

        public void setRow(Integer row) {
            this.setValue("id", row);
        }

        public String getOid() {
            return (String)this.getValue("oid");
        }

        public void setOid(String oid) {
            this.setValue("oid", oid);
        }

        public Long getVersion() {
            return (Long)this.getValue("version");
        }

        public void setVersion(Long version) {
            this.setValue("version", version);
        }

        public Long getUpdateDate() {
            return (Long)this.getValue("timestamp");
        }

        public void setUpdateDate(Long updateDate) {
            this.setValue("timestamp", updateDate);
        }

        public void setValue(String name, Object value) {
            if (value == null && this.getValue(name) == null) {
                return;
            }
            if (this.params == null) {
                this.params = new HashMap<String, Object>();
            }
            if (value == null) {
                this.params.remove(name);
            } else {
                this.params.put(name, value);
            }
        }

        public <T> T getValue(String name) {
            if (this.params != null) {
                return (T)this.params.get(name);
            }
            return null;
        }

        public String toString() {
            return "BulkCommandParams [row=" + this.getRow() + ", oid=" + this.getOid() + ", version=" + this.getVersion() + ", updateDate=" + this.getUpdateDate() + "]";
        }
    }
}

