/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.bulk;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.iplass.gem.command.generic.ResultType;
import org.iplass.gem.command.generic.bulk.BulkCommandBase;
import org.iplass.gem.command.generic.bulk.BulkCommandContext;
import org.iplass.gem.command.generic.bulk.BulkUpdateFormViewData;
import org.iplass.gem.command.generic.detail.RegistrationCommandBase;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ActionMappings;
import org.iplass.mtp.command.annotation.action.ParamMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.action.TokenCheck;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionListener;
import org.iplass.mtp.transaction.TransactionManager;
import org.iplass.mtp.view.generic.BulkOperationContext;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.generic.element.property.PropertyColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMappings(value={@ActionMapping(name="gem/generic/bulk/bulkUpdate", displayName="\u66f4\u65b0", paramMapping={@ParamMapping(name="defName", mapFrom="${0}", condition="subPath.length==1"), @ParamMapping(name="viewName", mapFrom="${0}", condition="subPath.length==2"), @ParamMapping(name="defName", mapFrom="${1}", condition="subPath.length==2")}, result={@Result(status="SUCCESS", type=Result.Type.TEMPLATE, value="gem/generic/bulk/bulkEdit"), @Result(status="ERROR", type=Result.Type.TEMPLATE, value="gem/generic/bulk/bulkEdit"), @Result(status="ERROR_TOKEN", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/popupLayout"), @Result(status="ERROR_VIEW", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/popupLayout")}, tokenCheck=@TokenCheck)})
@CommandClass(name="gem/generic/bulk/BulkUpdateListCommand", displayName="\u4e00\u62ec\u66f4\u65b0")
public class BulkUpdateListCommand
extends BulkCommandBase {
    private static Logger logger = LoggerFactory.getLogger(BulkUpdateListCommand.class);
    public static final String BULK_UPDATE_ACTION_NAME = "gem/generic/bulk/bulkUpdate";

    @Override
    protected Logger getLogger() {
        return logger;
    }

    public String execute(final RequestContext request) {
        final BulkCommandContext context = this.getContext(request);
        this.evm.checkState(context.getDefinitionName());
        SearchFormView view = context.getView();
        if (view == null) {
            request.setAttribute("message", (Object)this.resourceString("command.generic.bulk.BulkUpdateViewCommand.viewErr", new Object[0]));
            return "ERROR_VIEW";
        }
        if (context.getProperty().size() == 0) {
            request.setAttribute("message", (Object)this.resourceString("command.generic.bulk.BulkUpdateViewCommand.canNotUpdateProp", new Object[0]));
            return "ERROR_VIEW";
        }
        RegistrationCommandBase.EditResult ret = new RegistrationCommandBase.EditResult(this);
        final BulkUpdateFormViewData data = new BulkUpdateFormViewData(context);
        data.setUpdatedProperties(context.getUpdatedProps());
        data.setView(context.getView());
        try {
            List<Entity> entities = context.getEntities();
            ArrayList<ValidateError> errors = new ArrayList<ValidateError>();
            final boolean isSearchCondUpdate = this.isSearchCondUpdate(request);
            if (!isSearchCondUpdate) {
                this.setSelectedData(data, entities, context);
                BulkOperationContext bulkContext = context.getBulkUpdateInterrupterHandler().beforeOperation(entities);
                errors.addAll(bulkContext.getErrors());
                entities = bulkContext.getEntities();
                request.setAttribute("bulkUpdatedCnt", (Object)0);
                request.setAttribute("bulkUpdateCnt", (Object)entities.size());
            }
            if (!errors.isEmpty()) {
                ret.setResultType(ResultType.ERROR);
                ret.setErrors(errors.toArray(new ValidateError[errors.size()]));
                ret.setMessage(this.resourceString("command.generic.bulk.BulkUpdateListCommand.inputErr", new Object[0]));
            } else if (entities.size() > 0) {
                for (Entity entity : entities) {
                    final String oid = entity.getOid();
                    final Long version = entity.getVersion();
                    Timestamp updateDate = entity.getUpdateDate();
                    Entity model = context.createEntity(oid, version, updateDate);
                    if (context.hasErrors()) {
                        if (ret.getResultType() != null) break;
                        ret.setResultType(ResultType.ERROR);
                        ret.setErrors(context.getErrors().toArray(new ValidateError[context.getErrors().size()]));
                        ret.setMessage(this.resourceString("command.generic.bulk.BulkUpdateListCommand.inputErr", new Object[0]));
                        break;
                    }
                    if (ret.getResultType() == null || ret.getResultType() == ResultType.SUCCESS) {
                        ret = this.updateEntity(context, model);
                    }
                    if (ret.getResultType() != ResultType.SUCCESS) continue;
                    Transaction transaction = ((TransactionManager)ManagerLocator.getInstance().getManager(TransactionManager.class)).currentTransaction();
                    transaction.addTransactionListener(new TransactionListener(){

                        public void afterCommit(Transaction t) {
                            Integer row;
                            if (!isSearchCondUpdate && (row = context.getRow(oid, version)) != null) {
                                data.setSelected(row, BulkUpdateListCommand.this.loadViewEntity(context, oid, version, context.getDefinitionName(), null));
                            }
                            BulkUpdateListCommand.this.countUp(request);
                        }
                    });
                }
            }
            if (!isSearchCondUpdate) {
                context.getBulkUpdateInterrupterHandler().afterOperation(entities);
            }
        }
        catch (ApplicationException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(e.getMessage(), (Throwable)e);
            }
            ret.setResultType(ResultType.ERROR);
            ret.setMessage(e.getMessage());
        }
        String retKey = "SUCCESS";
        if (ret.getResultType() == ResultType.SUCCESS) {
            List<PropertyColumn> updatedProps = context.getProperty();
            if (updatedProps.size() > 1) {
                LinkedHashMap updatedPropsMap = new LinkedHashMap();
                updatedProps.stream().forEach(pc -> updatedPropsMap.put(pc.getPropertyName(), context.getBulkUpdatePropertyValue(pc.getPropertyName())));
                data.addUpdatedProperty(context.getBulkUpdatePropName(), updatedPropsMap);
            } else {
                String updatedPropName = context.getBulkUpdatePropName();
                Object updatedPropValue = context.getBulkUpdatePropertyValue(updatedPropName);
                data.addUpdatedProperty(updatedPropName, updatedPropValue);
            }
        } else if (ret.getResultType() == ResultType.ERROR) {
            retKey = "ERROR";
            ArrayList<ValidateError> tmpList = new ArrayList<ValidateError>();
            if (ret.getErrors() != null) {
                tmpList.addAll(Arrays.asList(ret.getErrors()));
            }
            ValidateError[] _errors = tmpList.toArray(new ValidateError[tmpList.size()]);
            request.setAttribute("errorProperty", (Object)_errors);
            request.setAttribute("bulkUpdatePropNm", (Object)context.getBulkUpdatePropName());
            request.setAttribute("message", (Object)ret.getMessage());
        }
        request.setAttribute("data", (Object)data);
        request.setAttribute("searchCond", (Object)context.getSearchCond());
        request.setAttribute("selectAllType", (Object)context.getSelectAllType());
        request.setAttribute("selectAllPage", (Object)context.getSelectAllPage());
        return retKey;
    }

    private boolean isSearchCondUpdate(RequestContext request) {
        return request.getAttribute("oid") != null && request.getAttribute("version") != null && request.getAttribute("timestamp") != null;
    }

    private void setSelectedData(BulkUpdateFormViewData data, List<Entity> entities, BulkCommandContext context) {
        for (Entity entity : entities) {
            Integer row = context.getRow(entity.getOid(), entity.getVersion());
            data.setSelected(row, entity);
        }
    }

    private void countUp(RequestContext request) {
        Integer updated = (Integer)request.getAttribute("bulkUpdatedCnt");
        request.setAttribute("bulkUpdatedCnt", (Object)(updated + 1));
    }
}

