/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.bulk;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.iplass.gem.GemConfigService;
import org.iplass.gem.command.CommandUtil;
import org.iplass.gem.command.generic.bulk.BulkUpdateInterrupterHandler;
import org.iplass.gem.command.generic.detail.NestTableReferenceRegistHandler;
import org.iplass.gem.command.generic.detail.ReferenceRegistHandler;
import org.iplass.gem.command.generic.detail.ReferenceRegistOption;
import org.iplass.gem.command.generic.detail.RegistrationCommandContext;
import org.iplass.gem.command.generic.detail.RegistrationPropertyBaseHandler;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.BulkFormView;
import org.iplass.mtp.view.generic.BulkOperationInterrupter;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.FormViewUtil;
import org.iplass.mtp.view.generic.OutputType;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.generic.editor.CustomPropertyEditor;
import org.iplass.mtp.view.generic.editor.DateRangePropertyEditor;
import org.iplass.mtp.view.generic.editor.JoinPropertyEditor;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.NumericRangePropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.RangePropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.iplass.mtp.view.generic.element.section.DefaultSection;
import org.iplass.mtp.view.generic.element.section.SearchResultSection;
import org.iplass.mtp.view.generic.element.section.Section;
import org.iplass.mtp.web.template.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiBulkCommandContext
extends RegistrationCommandContext {
    private static Logger logger = LoggerFactory.getLogger(MultiBulkCommandContext.class);
    private BulkFormView view;
    private GemConfigService gemConfig = null;
    private BulkUpdateInterrupterHandler bulkInterrupterHandler = null;
    private List<BulkCommandParams> bulkCommandParams = new ArrayList<BulkCommandParams>();
    private List<PropertyItem> propList = null;
    private List<PropertyItem> blankPropList = null;
    private Set<String> skipProps = new HashSet<String>(){
        {
            this.add("oid");
            this.add("version");
            this.add("updateDate");
        }
    };

    @Override
    protected Logger getLogger() {
        return logger;
    }

    public MultiBulkCommandContext(RequestContext request, EntityManager entityLoader, EntityDefinitionManager definitionLoader) {
        super(request, entityLoader, definitionLoader);
        this.gemConfig = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        this.init();
    }

    private void init() {
        this.populateBulkCommandParam("oid", String.class, true, true, false);
        this.populateBulkCommandParam("version", Long.class, false, true, false);
        this.populateBulkCommandParam("timestamp", Long.class, false, false, true);
    }

    private void populateBulkCommandParam(String name, Class<?> cls, boolean create, boolean notBlank, boolean checkDiff) {
        String[] param = (String[])this.request.getAttribute(name);
        if (param == null || param.length == 0) {
            param = this.getParams(name);
        }
        if (param != null) {
            for (int i = 0; i < param.length; ++i) {
                boolean hasDiffPropValue;
                Object[] params = this.splitRowParam(param[i]);
                Integer targetRow = Integer.parseInt(params[0]);
                String targetParam = params[1];
                if (StringUtil.isBlank((String)targetParam) && notBlank) {
                    this.getLogger().error("can not be empty. name=" + name + ", param=" + param[i]);
                    throw new ApplicationException(MultiBulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.invalidFormat", new Object[0]));
                }
                BulkCommandParams bulkParams = this.getBulkCommandParams(targetRow);
                if (create) {
                    if (bulkParams != null) {
                        this.getLogger().error("duplicate row. row=" + targetRow);
                        throw new ApplicationException(MultiBulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.duplicateRow", new Object[0]));
                    }
                    this.bulkCommandParams.add(new BulkCommandParams(targetRow, targetParam));
                } else {
                    if (bulkParams == null) {
                        this.getLogger().error("selected row does not exist. params=" + Arrays.toString(params));
                        throw new ApplicationException(MultiBulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.invalidRow", new Object[0]));
                    }
                    bulkParams.setValue(name, ConvertUtil.convertFromString(cls, (String)targetParam));
                }
                if (!checkDiff || i != param.length - 1 || !(hasDiffPropValue = this.hasDifferentPropertyValue(name))) continue;
                this.getLogger().error("has different prop value. name=" + name + ", bulkCommandParams=" + this.bulkCommandParams.toString());
                throw new ApplicationException(MultiBulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.diffPropVal", new Object[0]));
            }
        }
    }

    private String[] splitRowParam(String rowParam) {
        if (rowParam.indexOf("_") == -1) {
            this.getLogger().error("invalid parameter format. rowParam=" + rowParam);
            throw new ApplicationException(MultiBulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.invalidFormat", new Object[0]));
        }
        String targetRow = rowParam.substring(0, rowParam.indexOf("_"));
        String targetParam = rowParam.substring(rowParam.indexOf("_") + 1);
        String[] params = new String[]{targetRow, targetParam};
        return params;
    }

    private BulkCommandParams getBulkCommandParams(Integer row) {
        List paramsList = this.bulkCommandParams.stream().filter(p -> p.getRow().equals(row)).collect(Collectors.toList());
        if (paramsList.size() == 0) {
            return null;
        }
        if (paramsList.size() > 1) {
            this.getLogger().error("duplicate row. paramsList=" + paramsList);
            throw new ApplicationException(MultiBulkCommandContext.resourceString("command.generic.bulk.BulkCommandContext.duplicateRow", new Object[0]));
        }
        return (BulkCommandParams)paramsList.get(0);
    }

    private boolean hasDifferentPropertyValue(String propName) {
        Set<String> oids = this.getOids();
        for (String oid : oids) {
            Iterator<Long> iterator = this.getVersions(oid).iterator();
            if (!iterator.hasNext()) continue;
            Long version = iterator.next();
            List propValues = this.bulkCommandParams.stream().filter(p -> p.getOid().equals(oid) && p.getVersion().equals(version)).map(p -> p.getValue(propName)).collect(Collectors.toList());
            Object first = propValues.get(0);
            if (first == null) {
                return propValues.stream().anyMatch(v -> v != null);
            }
            return propValues.stream().anyMatch(v -> !first.equals(v));
        }
        return false;
    }

    @Override
    protected Object createReference(PropertyDefinition p, String prefix) {
        ReferenceProperty rp = (ReferenceProperty)p;
        String defName = rp.getObjectDefinitionName();
        Long count = this.getLongValue(prefix + p.getName() + "_count");
        if (p.getMultiplicity() == 1) {
            Entity entity = null;
            if (count == null) {
                String key2 = this.getParam(prefix + p.getName());
                entity = this.getRefEntity(rp.getObjectDefinitionName(), key2);
            } else {
                List<Entity> list = this.getRefTableValues(rp, defName, count, prefix);
                if (list.size() > 0) {
                    entity = list.get(0);
                }
            }
            return entity;
        }
        List<Object> list = null;
        if (count == null) {
            String[] params = this.getParams(prefix + p.getName());
            if (params != null) {
                list = Arrays.stream(params).map(key -> this.getRefEntity(rp.getObjectDefinitionName(), (String)key)).filter(value -> value != null).collect(Collectors.toList());
            }
        } else {
            list = this.getRefTableValues(rp, defName, count, prefix);
        }
        if (list != null && !list.isEmpty()) {
            EntityDefinition ed = this.getEntityDefinition();
            this.setEntityDefinition(this.definitionManager.get(defName));
            Entity emptyEntity = this.newEntity();
            this.setEntityDefinition(ed);
            Object[] array = (Object[])Array.newInstance(emptyEntity.getClass(), list.size());
            return list.toArray(array);
        }
        return null;
    }

    private Entity getRefEntity(String definitionName, String key) {
        Entity entity = null;
        String oid = null;
        Long version = null;
        if (key != null) {
            int lastIndex = key.lastIndexOf("_");
            if (lastIndex < 0) {
                oid = key;
            } else {
                oid = key.substring(0, lastIndex);
                version = CommandUtil.getLong(key.substring(lastIndex + 1));
            }
        }
        if (StringUtil.isNotBlank(oid)) {
            entity = this.gemConfig.isLoadWithReference() ? this.entityManager.load(oid, version, definitionName) : this.entityManager.load(oid, version, definitionName, new LoadOption(false, false));
        }
        return entity;
    }

    private List<Entity> getRefTableValues(ReferenceProperty p, String defName, Long count, String prefix) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        EntityDefinition ed = this.getEntityDefinition();
        EntityDefinition red = this.definitionManager.get(defName);
        this.setEntityDefinition(red);
        int i = 0;
        while ((long)i < count) {
            String paramPrefix = prefix + p.getName() + "[" + Integer.toString(i) + "].";
            String errorPrefix = i != list.size() ? prefix + p.getName() + "[" + Integer.toString(list.size()) + "]." : null;
            Entity entity = this.createEntityInternal(paramPrefix, errorPrefix);
            entity.setValue("##refReload", (Object)Boolean.FALSE);
            if (entity.getOid() != null && entity.getOid().equals("null")) {
                entity.setOid(null);
            }
            String checkPrefix = errorPrefix != null ? errorPrefix : paramPrefix;
            boolean hasError = this.getErrors().stream().filter(error -> error.getPropertyName().startsWith(checkPrefix)).findFirst().isPresent();
            if (hasError || !this.isEmpty(entity)) {
                entity.setDefinitionName(defName);
                entity.setValue("##refIndex", (Object)list.size());
                Long orderIndex = this.getLongValue("tableOrderIndex[" + i + "]");
                if (orderIndex != null) {
                    entity.setValue("##refTableOrderIndex", (Object)orderIndex);
                }
                list.add(entity);
            }
            ++i;
        }
        this.setEntityDefinition(ed);
        Optional<PropertyItem> ret = this.getProperty().stream().filter(pc -> pc.getPropertyName().equals(p.getName())).findFirst();
        if (ret.isPresent() && !list.isEmpty()) {
            this.addNestTableRegistHandler(p, list, red, ret.get());
        }
        return list;
    }

    private void addNestTableRegistHandler(ReferenceProperty p, List<Entity> list, EntityDefinition red, PropertyItem property) {
        ReferenceRegistHandler handler;
        if (!NestTableReferenceRegistHandler.canRegist(property, this.getRegistrationPropertyBaseHandler())) {
            return;
        }
        ReferenceRegistOption option = this.getRegistrationInterrupterHandler().getNestTableRegistOption(red, p.getName());
        if (option.isSpecifyAllProperties() && !option.isSpecifiedAsReference() && option.getSpecifiedUpdateNestProperties().isEmpty()) {
            return;
        }
        ReferencePropertyEditor editor = (ReferencePropertyEditor)property.getEditor();
        List<Entity> target = null;
        if (StringUtil.isNotBlank((String)editor.getTableOrderPropertyName())) {
            PropertyDefinition pd = red.getProperty(editor.getTableOrderPropertyName());
            target = EntityViewUtil.sortByOrderProperty(list, "##refTableOrderIndex");
            for (int i = 0; i < target.size(); ++i) {
                target.get(i).setValue(editor.getTableOrderPropertyName(), ConvertUtil.convert((Class)pd.getJavaType(), (Object)i));
            }
        } else {
            target = list;
        }
        if ((handler = NestTableReferenceRegistHandler.get(this, list, red, p, property, editor.getNestProperties(), this.getRegistrationPropertyBaseHandler(), option)) != null) {
            handler.setForceUpdate(editor.isForceUpadte());
            this.getReferenceRegistHandlers().add(handler);
        }
    }

    private boolean isEmpty(Entity entity) {
        for (PropertyDefinition pd : this.getPropertyList()) {
            Object[] obj;
            if (!(pd.getMultiplicity() != 1 ? (obj = (Object[])entity.getValue(pd.getName())) != null && obj.length > 0 : entity.getValue(pd.getName()) != null)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getInterrupterName() {
        return this.getView().getInterrupterName();
    }

    @Override
    protected String getLoadEntityInterrupterName() {
        return this.getView().getLoadEntityInterrupterName();
    }

    protected RegistrationPropertyBaseHandler<PropertyItem> createRegistrationPropertyBaseHandler() {
        return new RegistrationPropertyBaseHandler<PropertyItem>(){

            @Override
            public boolean isDispProperty(PropertyItem property) {
                return EntityViewUtil.isDisplayElement(MultiBulkCommandContext.this.entityDefinition.getName(), property.getElementRuntimeId(), OutputType.BULK, null);
            }

            @Override
            public PropertyEditor getEditor(PropertyItem property) {
                return property.getEditor();
            }
        };
    }

    public Set<String> getOids() {
        return this.bulkCommandParams.stream().map(p -> p.getOid()).collect(Collectors.toSet());
    }

    public BulkFormView getView() {
        String viewName = this.getViewName();
        if (this.view == null) {
            this.view = FormViewUtil.getBulkFormView(this.entityDefinition, this.entityView, viewName);
        }
        return this.view;
    }

    public SearchResultSection.ExclusiveControlPoint getExclusiveControlPoint() {
        String viewName = this.getViewName();
        SearchFormView view = FormViewUtil.getSearchFormView(this.entityDefinition, this.entityView, viewName);
        return view.getResultSection().getExclusiveControlPoint();
    }

    public void setView(BulkFormView view) {
        this.view = view;
    }

    @Override
    public boolean isNewVersion() {
        return false;
    }

    @Override
    protected boolean isPurgeCompositionedEntity() {
        return this.getView().isPurgeCompositionedEntity();
    }

    @Override
    protected boolean isLocalizationData() {
        return this.getView().isLocalizationData();
    }

    @Override
    protected boolean isForceUpadte() {
        return this.getView().isForceUpadte();
    }

    @Override
    public boolean hasUpdatableMappedByReference() {
        List<PropertyItem> properties = this.getProperty();
        for (PropertyItem property : properties) {
            ReferencePropertyEditor editor;
            String mappedBy;
            PropertyDefinition pd = this.getProperty(property.getPropertyName());
            if (!(pd instanceof ReferenceProperty) || StringUtil.isBlank((String)(mappedBy = ((ReferenceProperty)pd).getMappedBy())) || !(property.getEditor() instanceof ReferencePropertyEditor) || (editor = (ReferencePropertyEditor)property.getEditor()).getDisplayType() != ReferencePropertyEditor.ReferenceDisplayType.NESTTABLE) continue;
            return true;
        }
        return false;
    }

    public String getSearchCond() {
        return this.getParam("searchCond");
    }

    public Integer getRow(String oid, Long version) {
        Integer row = null;
        Optional<Integer> rw = this.bulkCommandParams.stream().filter(p -> p.getOid().equals(oid) && p.getVersion().equals(version)).map(p -> p.getRow()).findFirst();
        if (rw.isPresent()) {
            row = rw.get();
        }
        return row;
    }

    public Set<Long> getVersions(String oid) {
        return this.bulkCommandParams.stream().filter(p -> p.getOid().equals(oid)).map(p -> p.getVersion()).collect(Collectors.toSet());
    }

    public Timestamp getTimestamp(String oid, Long version) {
        Timestamp ts = null;
        Optional<Long> updateDate = this.bulkCommandParams.stream().filter(p -> p.getOid().equals(oid) && p.getVersion().equals(version)).map(p -> p.getUpdateDate()).findFirst();
        if (updateDate.isPresent() && updateDate.get() != null) {
            ts = new Timestamp(updateDate.get());
        }
        return ts;
    }

    public Boolean getSelectAllPage() {
        return this.request.getParamAsBoolean("selectAllPage");
    }

    public String getSelectAllType() {
        return this.getParam("selectAllType");
    }

    public Entity createEntity() {
        return this.createEntityInternal("", null);
    }

    public Entity createEntity(String oid, Long version, Timestamp updateDate) {
        Entity entity = this.createEntityInternal("", null);
        entity.setOid(oid);
        entity.setUpdateDate(updateDate);
        entity.setVersion(version);
        this.getRegistrationInterrupterHandler().dataMapping(entity);
        this.validate(entity);
        if (this.blankPropList == null) {
            this.blankPropList = this.createBlankPropList(entity);
        }
        this.removePropIfBlank(entity);
        return this.getProperty().size() > 0 ? entity : null;
    }

    private Entity createEntityInternal(String paramPrefix, String errorPrefix) {
        Entity entity = this.newEntity();
        for (PropertyDefinition p : this.getPropertyList()) {
            if (this.skipProps.contains(p.getName())) continue;
            Object value = this.getPropValue(p, paramPrefix);
            entity.setValue(p.getName(), value);
            if (errorPrefix == null) continue;
            String name = paramPrefix + p.getName();
            String errorName = errorPrefix + p.getName();
            this.getErrors().stream().filter(error -> error.getPropertyName().equals(name)).forEach(error -> error.setPropertyName(errorName));
        }
        return entity;
    }

    protected void validate(Entity entity) {
        List<PropertyItem> properties = this.getDisplayProperty();
        for (PropertyItem property : properties) {
            PropertyEditor editor;
            if (property.getEditor() instanceof DateRangePropertyEditor) {
                editor = (DateRangePropertyEditor)property.getEditor();
                this.checkDateRange((DateRangePropertyEditor)editor, entity, property.getPropertyName(), ((DateRangePropertyEditor)editor).getToPropertyName(), "");
                continue;
            }
            if (property.getEditor() instanceof NumericRangePropertyEditor) {
                editor = (NumericRangePropertyEditor)property.getEditor();
                this.checkNumericRange((NumericRangePropertyEditor)editor, entity, property.getPropertyName(), ((NumericRangePropertyEditor)editor).getToPropertyName(), "");
                continue;
            }
            if (!(property.getEditor() instanceof ReferencePropertyEditor)) continue;
            editor = (ReferencePropertyEditor)property.getEditor();
            Object val = entity.getValue(property.getPropertyName());
            Entity[] ary = null;
            if (val != null) {
                if (val instanceof Entity) {
                    ary = new Entity[]{(Entity)val};
                } else if (val instanceof Entity[]) {
                    ary = (Entity[])val;
                }
            }
            if (((ReferencePropertyEditor)editor).getDisplayType() != ReferencePropertyEditor.ReferenceDisplayType.NESTTABLE || ary == null || ary.length <= 0 || ((ReferencePropertyEditor)editor).getNestProperties() == null || ((ReferencePropertyEditor)editor).getNestProperties().isEmpty()) continue;
            for (int i = 0; i < ary.length; ++i) {
                String errorPrefix = property.getPropertyName() + "[" + i + "].";
                for (NestProperty np : ((ReferencePropertyEditor)editor).getNestProperties()) {
                    CustomPropertyEditor de;
                    if (np.getEditor() instanceof DateRangePropertyEditor) {
                        de = (DateRangePropertyEditor)np.getEditor();
                        this.checkDateRange((DateRangePropertyEditor)de, ary[i], np.getPropertyName(), ((DateRangePropertyEditor)de).getToPropertyName(), errorPrefix);
                        continue;
                    }
                    if (!(np.getEditor() instanceof NumericRangePropertyEditor)) continue;
                    de = (NumericRangePropertyEditor)np.getEditor();
                    this.checkNumericRange((NumericRangePropertyEditor)de, ary[i], np.getPropertyName(), ((NumericRangePropertyEditor)de).getToPropertyName(), errorPrefix);
                }
            }
        }
    }

    private void checkDateRange(DateRangePropertyEditor editor, Entity entity, String fromName, String toName, String errorPrefix) {
        Date from = (Date)entity.getValue(fromName);
        Date to = (Date)entity.getValue(editor.getToPropertyName());
        if (from == null && to != null) {
            if (!editor.isInputNullFrom()) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.detail.DetailCommandContext.inputDateRangeErr");
            }
        } else if (from != null && to == null) {
            if (!editor.isInputNullTo()) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.detail.DetailCommandContext.inputDateRangeErr");
            }
        } else if (from != null && to != null) {
            boolean result = false;
            if (editor.isEquivalentInput()) {
                result = from.compareTo(to) > 0;
            } else {
                boolean bl = result = from.compareTo(to) >= 0;
            }
            if (result) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.detail.DetailCommandContext.invalidDateRange");
            }
        }
    }

    private void checkNumericRange(NumericRangePropertyEditor editor, Entity entity, String fromName, String toName, String errorPrefix) {
        Number from = (Number)entity.getValue(fromName);
        Number to = (Number)entity.getValue(editor.getToPropertyName());
        BigDecimal from_tmp = this.castNumericRangeNumber(from);
        BigDecimal to_tmp = this.castNumericRangeNumber(to);
        if (from_tmp == null && to_tmp != null) {
            if (!editor.isInputNullFrom()) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.bulk.BulkCommandContext.inputNumericRangeErr");
            }
        } else if (from_tmp != null && to_tmp == null) {
            if (!editor.isInputNullTo()) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.bulk.BulkCommandContext.inputNumericRangeErr");
            }
        } else if (from_tmp != null && to_tmp != null) {
            boolean result = false;
            if (editor.isEquivalentInput()) {
                result = from_tmp.compareTo(to_tmp) > 0;
            } else {
                boolean bl = result = from_tmp.compareTo(to_tmp) >= 0;
            }
            if (result) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.bulk.BulkCommandContext.invalidNumericRange");
            }
        }
    }

    private BigDecimal castNumericRangeNumber(Number number) {
        if (number instanceof Double) {
            return new BigDecimal(number.doubleValue());
        }
        if (number instanceof Long) {
            return new BigDecimal(number.longValue());
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return null;
    }

    private void setValidateErrorMessage(RangePropertyEditor editor, String fromName, String errorPrefix, String resourceStringKey) {
        String errorMessage = TemplateUtil.getMultilingualString((String)editor.getErrorMessage(), editor.getLocalizedErrorMessageList());
        if (StringUtil.isBlank((String)errorMessage)) {
            errorMessage = MultiBulkCommandContext.resourceString(resourceStringKey, new Object[0]);
        }
        ValidateError e = new ValidateError();
        e.setPropertyName(errorPrefix + fromName + "_" + editor.getToPropertyName());
        e.addErrorMessage(errorMessage);
        this.getErrors().add(e);
    }

    private void removePropIfBlank(Entity entity) {
        this.getProperty().removeIf(pi -> entity.getValue(pi.getPropertyName()) == null);
    }

    private List<PropertyItem> createBlankPropList(Entity entity) {
        return this.getProperty().stream().filter(pi -> entity.getValue(pi.getPropertyName()) == null).collect(Collectors.toList());
    }

    public List<PropertyItem> getProperty() {
        if (this.propList == null) {
            this.propList = new ArrayList<PropertyItem>();
            for (Section section : this.getView().getSections()) {
                if (!(section instanceof DefaultSection) || !EntityViewUtil.isDisplayElement(this.entityDefinition.getName(), section.getElementRuntimeId(), OutputType.BULK, null)) continue;
                this.propList.addAll(this.getProperty((DefaultSection)section));
            }
        }
        return this.propList;
    }

    public List<PropertyItem> getUpdateProperty() {
        return this.getProperty();
    }

    protected List<PropertyItem> getProperty(DefaultSection section) {
        ArrayList<PropertyItem> propList = new ArrayList<PropertyItem>();
        for (Element elem : section.getElements()) {
            if (elem instanceof PropertyItem) {
                PropertyItem dummy;
                CustomPropertyEditor de;
                PropertyItem prop = (PropertyItem)elem;
                if (!this.getRegistrationPropertyBaseHandler().isDispProperty(prop)) continue;
                if (prop.getEditor() instanceof JoinPropertyEditor) {
                    JoinPropertyEditor je = (JoinPropertyEditor)prop.getEditor();
                    for (NestProperty nest : je.getProperties()) {
                        PropertyItem dummy2 = new PropertyItem();
                        dummy2.setDispFlag(true);
                        dummy2.setPropertyName(nest.getPropertyName());
                        dummy2.setEditor(nest.getEditor());
                        propList.add(dummy2);
                    }
                } else if (prop.getEditor() instanceof DateRangePropertyEditor) {
                    de = (DateRangePropertyEditor)prop.getEditor();
                    dummy = new PropertyItem();
                    dummy.setDispFlag(true);
                    dummy.setPropertyName(((DateRangePropertyEditor)de).getToPropertyName());
                    dummy.setEditor(((DateRangePropertyEditor)de).getEditor());
                    propList.add(dummy);
                } else if (prop.getEditor() instanceof NumericRangePropertyEditor) {
                    de = (NumericRangePropertyEditor)prop.getEditor();
                    dummy = new PropertyItem();
                    dummy.setDispFlag(true);
                    dummy.setPropertyName(((NumericRangePropertyEditor)de).getToPropertyName());
                    dummy.setEditor(((NumericRangePropertyEditor)de).getEditor());
                    propList.add(dummy);
                }
                propList.add(prop);
                continue;
            }
            if (!(elem instanceof DefaultSection) || !EntityViewUtil.isDisplayElement(this.entityDefinition.getName(), elem.getElementRuntimeId(), OutputType.BULK, null)) continue;
            propList.addAll(this.getProperty((DefaultSection)elem));
        }
        return propList;
    }

    private List<PropertyItem> getDisplayProperty() {
        ArrayList<PropertyItem> propList = new ArrayList<PropertyItem>();
        for (Section section : this.getView().getSections()) {
            if (!EntityViewUtil.isDisplayElement(this.entityDefinition.getName(), section.getElementRuntimeId(), OutputType.BULK, null) || !(section instanceof DefaultSection)) continue;
            DefaultSection ds = (DefaultSection)section;
            propList.addAll(this.getDisplayProperty(ds));
        }
        return propList;
    }

    private List<PropertyItem> getDisplayProperty(DefaultSection section) {
        ArrayList<PropertyItem> propList = new ArrayList<PropertyItem>();
        for (Element elem : section.getElements()) {
            if (!EntityViewUtil.isDisplayElement(this.entityDefinition.getName(), elem.getElementRuntimeId(), OutputType.BULK, null)) continue;
            if (elem instanceof PropertyItem) {
                PropertyItem prop = (PropertyItem)elem;
                if (prop.getEditor() instanceof JoinPropertyEditor) {
                    JoinPropertyEditor je = (JoinPropertyEditor)prop.getEditor();
                    for (NestProperty nest : je.getProperties()) {
                        PropertyItem dummy = new PropertyItem();
                        dummy.setDispFlag(true);
                        dummy.setPropertyName(nest.getPropertyName());
                        dummy.setEditor(nest.getEditor());
                        propList.add(dummy);
                    }
                }
                propList.add(prop);
                continue;
            }
            if (!(elem instanceof DefaultSection)) continue;
            DefaultSection ds = (DefaultSection)elem;
            propList.addAll(this.getDisplayProperty(ds));
        }
        return propList;
    }

    public List<Entity> getEntities() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (String oid : this.getOids()) {
            for (Long version : this.getVersions(oid)) {
                Entity entity = this.newEntity();
                entity.setOid(oid);
                entity.setVersion(version);
                entity.setUpdateDate(this.getTimestamp(oid, version));
                entities.add(entity);
            }
        }
        return entities;
    }

    public BulkUpdateInterrupterHandler getBulkUpdateInterrupterHandler() {
        if (this.bulkInterrupterHandler == null) {
            BulkOperationInterrupter bulkInterrupter = this.createBulkInterrupter(this.getBulkInterrupterName());
            this.bulkInterrupterHandler = new BulkUpdateInterrupterHandler(this.request, this, bulkInterrupter);
        }
        return this.bulkInterrupterHandler;
    }

    protected String getBulkInterrupterName() {
        String viewName = this.getViewName();
        SearchFormView view = FormViewUtil.getSearchFormView(this.entityDefinition, this.entityView, viewName);
        return view.getResultSection().getBulkUpdateInterrupterName();
    }

    protected BulkOperationInterrupter createBulkInterrupter(String className) {
        BulkOperationInterrupter interrupter = null;
        if (StringUtil.isNotEmpty((String)className)) {
            this.getLogger().debug("set bulk operation interrupter. class=" + className);
            try {
                interrupter = (BulkOperationInterrupter)this.ucdm.createInstanceAs(BulkOperationInterrupter.class, className);
            }
            catch (ClassNotFoundException e) {
                this.getLogger().error(className + " can not instantiate.", (Throwable)e);
                throw new ApplicationException(MultiBulkCommandContext.resourceString("", new Object[0]));
            }
        }
        if (interrupter == null) {
            this.getLogger().debug("set default bulk operation interrupter.");
            interrupter = new BulkOperationInterrupter(){};
        }
        return interrupter;
    }

    public List<PropertyItem> getBlankPropList() {
        return this.blankPropList;
    }

    private class BulkCommandParams {
        private Map<String, Object> params;

        public BulkCommandParams(Integer row, String oid) {
            this.setRow(row);
            this.setOid(oid);
        }

        public Integer getRow() {
            return (Integer)this.getValue("id");
        }

        public void setRow(Integer row) {
            this.setValue("id", row);
        }

        public String getOid() {
            return (String)this.getValue("oid");
        }

        public void setOid(String oid) {
            this.setValue("oid", oid);
        }

        public Long getVersion() {
            return (Long)this.getValue("version");
        }

        public void setVersion(Long version) {
            this.setValue("version", version);
        }

        public Long getUpdateDate() {
            return (Long)this.getValue("timestamp");
        }

        public void setUpdateDate(Long updateDate) {
            this.setValue("timestamp", updateDate);
        }

        public void setValue(String name, Object value) {
            if (value == null && this.getValue(name) == null) {
                return;
            }
            if (this.params == null) {
                this.params = new HashMap<String, Object>();
            }
            if (value == null) {
                this.params.remove(name);
            } else {
                this.params.put(name, value);
            }
        }

        public <T> T getValue(String name) {
            if (this.params != null) {
                return (T)this.params.get(name);
            }
            return null;
        }

        public String toString() {
            return "BulkCommandParams [row=" + this.getRow() + ", oid=" + this.getOid() + ", version=" + this.getVersion() + ", updateDate=" + this.getUpdateDate() + "]";
        }
    }
}

