/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.bulk;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.iplass.gem.GemConfigService;
import org.iplass.gem.command.generic.bulk.MultiBulkCommandBase;
import org.iplass.gem.command.generic.bulk.MultiBulkCommandContext;
import org.iplass.gem.command.generic.bulk.MultiBulkUpdateFormViewData;
import org.iplass.gem.command.generic.bulk.MultiBulkUpdateListCommand;
import org.iplass.gem.command.generic.search.DetailSearchCommand;
import org.iplass.gem.command.generic.search.FixedSearchCommand;
import org.iplass.gem.command.generic.search.NormalSearchCommand;
import org.iplass.gem.command.generic.search.SearchCommandBase;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ActionMappings;
import org.iplass.mtp.command.annotation.action.ParamMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.action.TokenCheck;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.view.generic.BulkOperationContext;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.FormViewUtil;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.generic.element.section.SearchResultSection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMappings(value={@ActionMapping(name="gem/generic/bulk/updateAll", displayName="\u66f4\u65b0", paramMapping={@ParamMapping(name="defName", mapFrom="${0}", condition="subPath.length==1"), @ParamMapping(name="viewName", mapFrom="${0}", condition="subPath.length==2"), @ParamMapping(name="defName", mapFrom="${1}", condition="subPath.length==2")}, result={@Result(status="SUCCESS", type=Result.Type.TEMPLATE, value="gem/generic/bulk/edit"), @Result(status="ERROR", type=Result.Type.TEMPLATE, value="gem/generic/bulk/edit"), @Result(status="ERROR_SEARCH", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/popupLayout"), @Result(status="ERROR_TOKEN", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/popupLayout"), @Result(status="ERROR_VIEW", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/popupLayout")}, tokenCheck=@TokenCheck)})
@CommandClass(name="gem/generic/bulk/MultiBulkUpdateAllCommand", displayName="\u4e00\u62ec\u5168\u66f4\u65b0")
public class MultiBulkUpdateAllCommand
extends MultiBulkCommandBase {
    private static Logger logger = LoggerFactory.getLogger(MultiBulkUpdateAllCommand.class);
    public static final String BULK_UPDATE_ALL_ACTION_NAME = "gem/generic/bulk/updateAll";

    @Override
    protected Logger getLogger() {
        return logger;
    }

    public String execute(RequestContext request) {
        MultiBulkCommandContext context = this.getContext(request);
        this.evm.checkState(context.getDefinitionName());
        String searchType = request.getParam("searchType");
        SearchCommandBase command = null;
        if ("normal".equals(searchType)) {
            command = new NormalSearchCommand();
        } else if ("detail".equals(searchType)) {
            command = new DetailSearchCommand();
        } else if ("fixed".equals(searchType)) {
            command = new FixedSearchCommand();
        }
        String ret = "SUCCESS";
        if (command != null) {
            command.setSearchBulk(request, true);
            ret = command.execute(request);
            if (!"SUCCESS".equals(ret)) {
                return ret;
            }
            EntityDefinition ed = context.getEntityDefinition();
            EntityView view = (EntityView)this.evm.get(ed.getName());
            String viewName = request.getParam("viewName");
            SearchFormView form = FormViewUtil.getSearchFormView(ed, view, viewName);
            SearchResultSection.BulkUpdateAllCommandTransactionType transactionType = form.getResultSection().getBulkUpdateAllCommandTransactionType();
            try {
                SearchResult result = (SearchResult)request.getAttribute("result");
                BulkOperationContext bulkContext = context.getBulkUpdateInterrupterHandler().beforeOperation(result.getList());
                List<ValidateError> errors = bulkContext.getErrors();
                List<Entity> entities = bulkContext.getEntities();
                request.setAttribute("bulkUpdatedCnt", (Object)0);
                request.setAttribute("bulkUpdateCnt", (Object)entities.size());
                if (!errors.isEmpty()) {
                    ret = "ERROR";
                    request.setAttribute("errorProperty", (Object)errors.toArray(new ValidateError[errors.size()]));
                    request.setAttribute("message", (Object)this.resourceString("command.generic.bulk.BulkUpdateAllCommand.inputErr", new Object[0]));
                    this.setDefaultViewData(request, context);
                } else if (entities.size() > 0) {
                    List oid = IntStream.range(0, entities.size()).mapToObj(i -> i + "_" + ((Entity)entities.get(i)).getOid()).collect(Collectors.toList());
                    List version = IntStream.range(0, entities.size()).mapToObj(i -> i + "_" + ((Entity)entities.get(i)).getVersion()).collect(Collectors.toList());
                    List updateDate = IntStream.range(0, entities.size()).mapToObj(i -> i + "_" + ((Entity)entities.get(i)).getUpdateDate().getTime()).collect(Collectors.toList());
                    int count = oid.size();
                    int batchSize = ((GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class)).getBulkUpdateAllCommandBatchSize();
                    if (transactionType == SearchResultSection.BulkUpdateAllCommandTransactionType.ONCE) {
                        batchSize = count;
                    }
                    int countPerBatch = count / batchSize;
                    if (count % batchSize > 0) {
                        ++countPerBatch;
                    }
                    for (int i2 = 0; i2 < countPerBatch; ++i2) {
                        List subUpdateDate;
                        List subVersionList;
                        int current = i2 * batchSize;
                        List subOidList = oid.stream().skip(current).limit(batchSize).collect(Collectors.toList());
                        ret = (String)Transaction.requiresNew(arg_0 -> this.lambda$execute$3(request, subOidList, subVersionList = version.stream().skip(current).limit(batchSize).collect(Collectors.toList()), subUpdateDate = updateDate.stream().skip(current).limit(batchSize).collect(Collectors.toList()), arg_0));
                        if ("SUCCESS".equals(ret)) {
                            continue;
                        }
                        break;
                    }
                } else {
                    this.setDefaultViewData(request, context);
                }
                context.getBulkUpdateInterrupterHandler().afterOperation(entities);
            }
            catch (ApplicationException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(e.getMessage(), (Throwable)e);
                }
                ret = "ERROR";
                request.setAttribute("message", (Object)e.getMessage());
                this.setDefaultViewData(request, context);
            }
        }
        return ret;
    }

    private void setDefaultViewData(RequestContext request, MultiBulkCommandContext context) {
        request.setAttribute("data", (Object)new MultiBulkUpdateFormViewData(context));
        request.setAttribute("value", (Object)context.createEntity());
        request.setAttribute("searchCond", (Object)context.getSearchCond());
        request.setAttribute("selectAllType", (Object)context.getSelectAllType());
        request.setAttribute("selectAllPage", (Object)context.getSelectAllPage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ String lambda$execute$3(RequestContext request, List subOidList, List subVersionList, List subUpdateDate, Transaction t) {
        String r = null;
        try {
            request.setAttribute("oid", (Object)subOidList.toArray(new String[0]));
            request.setAttribute("version", (Object)subVersionList.toArray(new String[0]));
            request.setAttribute("timestamp", (Object)subUpdateDate.toArray(new String[0]));
            MultiBulkUpdateListCommand updateCommand = new MultiBulkUpdateListCommand();
            r = updateCommand.execute(request);
        }
        catch (ApplicationException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(e.getMessage(), (Throwable)e);
            }
            request.setAttribute("message", (Object)e.getMessage());
            t.rollback();
            String string = "ERROR";
            return string;
        }
        finally {
            request.removeAttribute("oid");
            request.removeAttribute("version");
            request.removeAttribute("timestamp");
        }
        return r;
    }
}

