/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.bulk;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.iplass.gem.command.generic.ResultType;
import org.iplass.gem.command.generic.bulk.MultiBulkCommandBase;
import org.iplass.gem.command.generic.bulk.MultiBulkCommandContext;
import org.iplass.gem.command.generic.bulk.MultiBulkUpdateFormViewData;
import org.iplass.gem.command.generic.detail.RegistrationCommandBase;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ActionMappings;
import org.iplass.mtp.command.annotation.action.ParamMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.action.TokenCheck;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionListener;
import org.iplass.mtp.transaction.TransactionManager;
import org.iplass.mtp.view.generic.BulkFormView;
import org.iplass.mtp.view.generic.BulkOperationContext;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMappings(value={@ActionMapping(name="gem/generic/bulk/update", displayName="\u66f4\u65b0", paramMapping={@ParamMapping(name="defName", mapFrom="${0}", condition="subPath.length==1"), @ParamMapping(name="viewName", mapFrom="${0}", condition="subPath.length==2"), @ParamMapping(name="defName", mapFrom="${1}", condition="subPath.length==2")}, result={@Result(status="SUCCESS", type=Result.Type.TEMPLATE, value="gem/generic/bulk/edit"), @Result(status="ERROR", type=Result.Type.TEMPLATE, value="gem/generic/bulk/edit"), @Result(status="ERROR_TOKEN", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/popupLayout"), @Result(status="ERROR_VIEW", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/popupLayout")}, tokenCheck=@TokenCheck)})
@CommandClass(name="gem/generic/bulk/MultiBulkUpdateListCommand", displayName="\u4e00\u62ec\u66f4\u65b0")
public class MultiBulkUpdateListCommand
extends MultiBulkCommandBase {
    private static Logger logger = LoggerFactory.getLogger(MultiBulkUpdateListCommand.class);
    public static final String BULK_UPDATE_ACTION_NAME = "gem/generic/bulk/update";

    @Override
    protected Logger getLogger() {
        return logger;
    }

    public String execute(final RequestContext request) {
        final MultiBulkCommandContext context = this.getContext(request);
        final boolean isSearchCondUpdate = this.isSearchCondUpdate(request);
        this.evm.checkState(context.getDefinitionName());
        BulkFormView view = context.getView();
        if (view == null) {
            request.setAttribute("message", (Object)this.resourceString("command.generic.bulk.BulkUpdateViewCommand.viewErr", new Object[0]));
            return "ERROR_VIEW";
        }
        if (context.getProperty().size() == 0) {
            request.setAttribute("message", (Object)this.resourceString("command.generic.bulk.BulkUpdateViewCommand.canNotUpdateProp", new Object[0]));
            return "ERROR_VIEW";
        }
        RegistrationCommandBase.EditResult ret = new RegistrationCommandBase.EditResult(this);
        final MultiBulkUpdateFormViewData data = new MultiBulkUpdateFormViewData(context);
        data.setView(context.getView());
        try {
            List<Entity> entities = context.getEntities();
            ArrayList<ValidateError> errors = new ArrayList<ValidateError>();
            if (!isSearchCondUpdate) {
                this.setSelectedData(data, entities, context);
                BulkOperationContext bulkContext = context.getBulkUpdateInterrupterHandler().beforeOperation(entities);
                errors.addAll(bulkContext.getErrors());
                entities = bulkContext.getEntities();
                request.setAttribute("bulkUpdatedCnt", (Object)0);
                request.setAttribute("bulkUpdateCnt", (Object)entities.size());
            }
            if (!errors.isEmpty()) {
                ret.setResultType(ResultType.ERROR);
                ret.setErrors(errors.toArray(new ValidateError[errors.size()]));
                ret.setMessage(this.resourceString("command.generic.bulk.BulkUpdateListCommand.inputErr", new Object[0]));
            } else if (entities.size() > 0) {
                for (Entity entity : entities) {
                    Timestamp updateDate;
                    Long version;
                    final String oid = entity.getOid();
                    Entity model = context.createEntity(oid, version = entity.getVersion(), updateDate = entity.getUpdateDate());
                    if (model == null) {
                        ret.setResultType(ResultType.ERROR);
                        ret.setMessage(this.resourceString("command.generic.bulk.BulkUpdateListCommand.pleaseInput", new Object[0]));
                        break;
                    }
                    if (context.hasErrors()) {
                        if (ret.getResultType() != null) break;
                        ret.setResultType(ResultType.ERROR);
                        ret.setErrors(context.getErrors().toArray(new ValidateError[context.getErrors().size()]));
                        ret.setMessage(this.resourceString("command.generic.bulk.BulkUpdateListCommand.inputErr", new Object[0]));
                        break;
                    }
                    if (ret.getResultType() == null || ret.getResultType() == ResultType.SUCCESS) {
                        ret = this.updateEntity(context, model);
                    }
                    if (ret.getResultType() == ResultType.SUCCESS) {
                        Transaction transaction = ((TransactionManager)ManagerLocator.getInstance().getManager(TransactionManager.class)).currentTransaction();
                        transaction.addTransactionListener(new TransactionListener(){

                            public void afterCommit(Transaction t) {
                                Integer row;
                                if (!isSearchCondUpdate && (row = context.getRow(oid, version)) != null) {
                                    data.setSelected(row, MultiBulkUpdateListCommand.this.loadViewEntity(context, oid, version, context.getDefinitionName(), null));
                                }
                                MultiBulkUpdateListCommand.this.countUp(request);
                            }
                        });
                    }
                    context.getReferenceRegistHandlers().clear();
                }
            }
            if (!isSearchCondUpdate) {
                context.getBulkUpdateInterrupterHandler().afterOperation(entities);
            }
        }
        catch (ApplicationException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(e.getMessage(), (Throwable)e);
            }
            ret.setResultType(ResultType.ERROR);
            ret.setMessage(e.getMessage());
        }
        String retKey = "SUCCESS";
        if (ret.getResultType() == ResultType.ERROR) {
            retKey = "ERROR";
            ArrayList<ValidateError> tmpList = new ArrayList<ValidateError>();
            if (ret.getErrors() != null) {
                tmpList.addAll(Arrays.asList(ret.getErrors()));
            }
            ValidateError[] _error = tmpList.toArray(new ValidateError[tmpList.size()]);
            request.setAttribute("errorProperty", (Object)_error);
            request.setAttribute("message", (Object)ret.getMessage());
        }
        request.setAttribute("data", (Object)data);
        request.setAttribute("value", (Object)context.createEntity());
        request.setAttribute("searchCond", (Object)context.getSearchCond());
        request.setAttribute("selectAllPage", (Object)context.getSelectAllPage());
        request.setAttribute("selectAllType", (Object)context.getSelectAllType());
        return retKey;
    }

    private boolean isSearchCondUpdate(RequestContext request) {
        return request.getAttribute("oid") != null && request.getAttribute("version") != null && request.getAttribute("timestamp") != null;
    }

    private void setSelectedData(MultiBulkUpdateFormViewData data, List<Entity> entities, MultiBulkCommandContext context) {
        for (Entity entity : entities) {
            Integer row = context.getRow(entity.getOid(), entity.getVersion());
            data.setSelected(row, entity);
        }
    }

    private void countUp(RequestContext request) {
        Integer updated = (Integer)request.getAttribute("bulkUpdatedCnt");
        request.setAttribute("bulkUpdatedCnt", (Object)(updated + 1));
    }

    @Override
    protected void checkUpdateOption(MultiBulkCommandContext context, UpdateOption option) {
        List updatePropNames = option.getUpdateProperties();
        for (PropertyItem prop : context.getBlankPropList()) {
            updatePropNames.remove(prop.getPropertyName());
        }
    }
}

