/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.bulk;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.iplass.gem.command.generic.bulk.MultiBulkCommandBase;
import org.iplass.gem.command.generic.bulk.MultiBulkCommandContext;
import org.iplass.gem.command.generic.bulk.MultiBulkUpdateFormViewData;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.CommandConfig;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ActionMappings;
import org.iplass.mtp.command.annotation.action.ParamMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.template.Template;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.view.generic.BulkFormView;
import org.iplass.mtp.view.generic.element.section.SearchResultSection;

@ActionMappings(value={@ActionMapping(name="gem/generic/bulk/edit", displayName="\u4e00\u62ec\u8a73\u7d30\u7de8\u96c6", paramMapping={@ParamMapping(name="defName", mapFrom="${0}", condition="subPath.length==1"), @ParamMapping(name="viewName", mapFrom="${0}", condition="subPath.length==2"), @ParamMapping(name="defName", mapFrom="${1}", condition="subPath.length==2")}, command={@CommandConfig(commandClass=MultiBulkUpdateViewCommand.class)}, result={@Result(status="SUCCESS", type=Result.Type.TEMPLATE, value="gem/generic/bulk/edit"), @Result(status="ERROR_VALIDATE", type=Result.Type.TEMPLATE, value="gem/generic/bulk/edit"), @Result(status="ERROR_VIEW", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/popupLayout"), @Result(status="ERROR_NODATA", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/popupLayout")})})
@CommandClass(name="gem/generic/bulk/MultiBulkUpdateViewCommand", displayName="\u4e00\u62ec\u8a73\u7d30\u8868\u793a")
@Template(name="gem/generic/bulk/edit", path="/jsp/gem/generic/bulk/edit.jsp", layoutActionName="gem/layout/popupLayout")
public class MultiBulkUpdateViewCommand
extends MultiBulkCommandBase {
    public static final String BULK_EDIT_ACTION_NAME = "gem/generic/bulk/edit";

    public String execute(RequestContext request) {
        MultiBulkCommandContext context = this.getContext(request);
        this.evm.checkState(context.getDefinitionName());
        Set<String> oids = context.getOids();
        BulkFormView view = context.getView();
        if (view == null) {
            request.setAttribute("message", (Object)this.resourceString("command.generic.bulk.BulkUpdateViewCommand.viewErr", new Object[0]));
            return "ERROR_VIEW";
        }
        MultiBulkUpdateFormViewData data = new MultiBulkUpdateFormViewData(context);
        ArrayList<Integer> alreadyUpdated = new ArrayList<Integer>();
        for (String oid : oids) {
            if (oid == null || oid.length() <= 0) continue;
            for (Long targetVersion : context.getVersions(oid)) {
                Integer targetRow = context.getRow(oid, targetVersion);
                Entity entity = this.loadViewEntity(context, oid, targetVersion, context.getDefinitionName(), null);
                if (entity == null) {
                    request.setAttribute("message", (Object)this.resourceString("command.generic.bulk.BulkUpdateViewCommand.noPermission", new Object[0]));
                    return "ERROR_NODATA";
                }
                if (context.getExclusiveControlPoint() == SearchResultSection.ExclusiveControlPoint.WHEN_SEARCH) {
                    Timestamp targetTimestamp = context.getTimestamp(oid, targetVersion);
                    if (!entity.getUpdateDate().equals(targetTimestamp)) {
                        alreadyUpdated.add(targetRow);
                        entity.setUpdateDate(targetTimestamp);
                    }
                }
                data.setSelected(targetRow, entity);
            }
        }
        request.setAttribute("data", (Object)data);
        request.setAttribute("value", (Object)context.createEntity());
        request.setAttribute("searchCond", (Object)context.getSearchCond());
        request.setAttribute("selectAllPage", (Object)context.getSelectAllPage());
        if (alreadyUpdated.size() > 0) {
            String param = this.convertRowListToStr(alreadyUpdated);
            request.setAttribute("message", (Object)this.resourceString("command.generic.bulk.BulkUpdateViewCommand.alreadyUpdated", param));
            request.setAttribute("bulkUpdateExCheckErr", (Object)Boolean.TRUE);
            return "ERROR_VALIDATE";
        }
        return "SUCCESS";
    }

    private String convertRowListToStr(List<Integer> alreadyUpdated) {
        return alreadyUpdated.stream().sorted((o1, o2) -> o1.compareTo((Integer)o2)).map(i -> i.toString()).collect(Collectors.joining(","));
    }
}

