/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.common;

import java.util.List;
import org.iplass.gem.command.ViewUtil;
import org.iplass.gem.command.generic.HasDisplayScriptBindings;
import org.iplass.gem.command.generic.common.GetEntityNameListEntityParameter;
import org.iplass.gem.command.generic.common.GetEntityNameListParameter;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.expr.Or;
import org.iplass.mtp.entity.query.condition.expr.Paren;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.FormView;
import org.iplass.mtp.view.generic.editor.JoinPropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/generic/common/getEntityNameList", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="params", parameterType=GetEntityNameListParameter.class), results={"value"}, checkXRequestedWithHeader=true)
@CommandClass(name="gem/generic/common/GetEntityNameListCommand", displayName="\u53c2\u7167\u30c7\u30fc\u30bf\u540d\u524d\u4e00\u62ec\u53d6\u5f97")
public final class GetEntityNameListCommand
implements Command,
HasDisplayScriptBindings {
    public static final String WEBAPI_NAME = "gem/generic/common/getEntityNameList";

    public String execute(RequestContext request) {
        GetEntityNameListParameter param = (GetEntityNameListParameter)request.getAttribute("params");
        String defName = param.getDefName();
        String parentDefName = param.getParentDefName();
        String parentViewName = param.getParentViewName();
        String parentPropName = param.getParentPropName();
        String viewType = param.getViewType();
        Integer refSectionIndex = param.getReferenceSectionIndex();
        List<GetEntityNameListEntityParameter> list = param.getList();
        List ret = null;
        if (defName != null && !defName.isEmpty() && list != null && !list.isEmpty()) {
            Entity e = this.getBindingEntity(request);
            String dispLabelProp = this.getDisplayLabelItem(parentDefName, parentViewName, parentPropName, viewType, refSectionIndex, e);
            String uniqueProp = this.getUniqueItem(parentDefName, parentViewName, parentPropName, viewType, refSectionIndex, e);
            Query query = new Query();
            query.select(new Object[]{"oid", "version"}).from(defName);
            if (dispLabelProp == null) {
                query.select().add((Object)"name");
            } else if (dispLabelProp.length() > 0) {
                query.select().add((Object)dispLabelProp);
            }
            if (uniqueProp != null) {
                query.select().add((Object)uniqueProp);
            }
            Or or = new Or();
            for (GetEntityNameListEntityParameter entity : list) {
                And and = new And(new Condition[]{new Equals("oid", (Object)entity.getOid()), new Equals("version", (Object)entity.getVersion())});
                or.addExpression((Condition)new Paren((Condition)and));
            }
            query.where((Condition)or);
            EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
            ret = em.searchEntity(query).getList();
            if (StringUtil.isNotBlank((String)dispLabelProp) || StringUtil.isNotBlank((String)uniqueProp)) {
                this.replacePropOutputName(ret, dispLabelProp, uniqueProp);
            }
        }
        request.setAttribute("value", ret);
        return "OK";
    }

    @Override
    public Entity getBindingEntity(RequestContext request) {
        GetEntityNameListParameter param = (GetEntityNameListParameter)request.getAttribute("params");
        GetEntityNameListEntityParameter entity = param.getEntity();
        if (entity != null) {
            GenericEntity e = new GenericEntity(param.getParentDefName());
            if (StringUtil.isNotBlank((String)entity.getOid())) {
                e.setOid(entity.getOid());
            }
            if (StringUtil.isNotBlank((String)entity.getVersion())) {
                e.setVersion(Long.valueOf(entity.getVersion()));
            }
            return e;
        }
        return null;
    }

    private String getDisplayLabelItem(String defName, String viewName, String propName, String viewType, Integer refSectionIndex, Entity entity) {
        FormView form = ViewUtil.getFormView(defName, viewName, viewType);
        if (form == null) {
            return null;
        }
        ReferencePropertyEditor rpe = this.getRefEditor(defName, viewName, propName, viewType, refSectionIndex, entity);
        if (rpe == null) {
            return "";
        }
        return rpe.getDisplayLabelItem();
    }

    private String getUniqueItem(String defName, String viewName, String propName, String viewType, Integer refSectionIndex, Entity entity) {
        FormView form = ViewUtil.getFormView(defName, viewName, viewType);
        if (form == null) {
            return null;
        }
        ReferencePropertyEditor rpe = this.getRefEditor(defName, viewName, propName, viewType, refSectionIndex, entity);
        if (rpe == null || rpe.getDisplayType() != ReferencePropertyEditor.ReferenceDisplayType.UNIQUE || rpe.getUniqueItem() == null) {
            return null;
        }
        if ("oid".equals(rpe.getUniqueItem())) {
            return "oid";
        }
        EntityDefinition ed = ((EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class)).get(rpe.getObjectName());
        PropertyDefinition pd = ed.getProperty(rpe.getUniqueItem());
        if (pd != null && (pd.getIndexType() == IndexType.UNIQUE || pd.getIndexType() == IndexType.UNIQUE_WITHOUT_NULL)) {
            return rpe.getUniqueItem();
        }
        return null;
    }

    private ReferencePropertyEditor getRefEditor(String defName, String viewName, String propName, String viewType, Integer refSectionIndex, Entity entity) {
        JoinPropertyEditor jpe;
        EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);
        PropertyEditor editor = evm.getPropertyEditor(defName, viewType, viewName, propName, refSectionIndex, entity);
        if (editor instanceof ReferencePropertyEditor) {
            return (ReferencePropertyEditor)editor;
        }
        if (editor instanceof JoinPropertyEditor && (jpe = (JoinPropertyEditor)editor).getEditor() instanceof ReferencePropertyEditor) {
            return (ReferencePropertyEditor)jpe.getEditor();
        }
        return null;
    }

    private void replacePropOutputName(List<Entity> entities, String dispLabelProp, String uniqueProp) {
        for (Entity entity : entities) {
            if (StringUtil.isNotBlank((String)dispLabelProp)) {
                entity.setValue("name", entity.getValue(dispLabelProp));
            }
            if (StringUtil.isNotBlank((String)uniqueProp)) {
                entity.setValue("uniqueValue", entity.getValue(uniqueProp));
            }
            if (StringUtil.isNotBlank((String)dispLabelProp) && !"name".equals(dispLabelProp) && !"oid".equals(dispLabelProp) && !"version".equals(dispLabelProp)) {
                entity.setValue(dispLabelProp, null);
            }
            if (!StringUtil.isNotBlank((String)uniqueProp) || "oid".equals(uniqueProp)) continue;
            entity.setValue(uniqueProp, null);
        }
    }
}

