/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.delete;

import java.util.List;
import org.iplass.gem.GemConfigService;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.generic.ResultType;
import org.iplass.gem.command.generic.delete.DeleteCommandBase;
import org.iplass.gem.command.generic.delete.DeleteCommandContext;
import org.iplass.gem.command.generic.search.DetailSearchCommand;
import org.iplass.gem.command.generic.search.FixedSearchCommand;
import org.iplass.gem.command.generic.search.NormalSearchCommand;
import org.iplass.gem.command.generic.search.SearchCommandBase;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.command.annotation.webapi.WebApiTokenCheck;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.view.generic.BulkOperationContext;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.generic.element.section.SearchResultSection;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebApi(name="gem/generic/delete/deleteAll", displayName="\u6761\u4ef6\u6307\u5b9a\u524a\u9664", accepts={RequestType.REST_FORM}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"message"}, tokenCheck=@WebApiTokenCheck(consume=false, useFixedToken=true), checkXRequestedWithHeader=true)
@CommandClass(name="gem/generic/delete/DeleteAllCommand", displayName="\u6761\u4ef6\u6307\u5b9a\u524a\u9664")
public final class DeleteAllCommand
extends DeleteCommandBase {
    private static Logger logger = LoggerFactory.getLogger(DeleteAllCommand.class);
    public static final String WEBAPI_NAME = "gem/generic/delete/deleteAll";

    public String execute(RequestContext request) {
        String ret;
        block15: {
            String searchType = request.getParam("searchType");
            SearchCommandBase command = null;
            if ("normal".equals(searchType)) {
                command = new NormalSearchCommand();
            } else if ("detail".equals(searchType)) {
                command = new DetailSearchCommand();
            } else if ("fixed".equals(searchType)) {
                command = new FixedSearchCommand();
            }
            ret = "SUCCESS";
            if (command != null) {
                DeleteCommandContext context = this.getContext(request);
                SearchFormView form = context.getView();
                command.setSearchDelete(request, true);
                ret = command.execute(request);
                if (!"SUCCESS".equals(ret)) {
                    return ret;
                }
                SearchResult result = (SearchResult)request.getAttribute("result");
                boolean isPurge = form.isPurge();
                try {
                    BulkOperationContext bulkContext = context.getDeleteInterrupterHandler().beforeOperation(result.getList());
                    List<ValidateError> errors = bulkContext.getErrors();
                    List<Entity> list = bulkContext.getEntities();
                    int count = list.size();
                    if (!errors.isEmpty()) {
                        request.setAttribute("message", (Object)DeleteAllCommand.resourceString("command.generic.delete.DeleteAllCommand.inputErr", new Object[0]));
                        ret = "ERROR";
                    } else if (list.size() > 0) {
                        SearchResultSection.DeleteAllCommandTransactionType transactionType = form.getResultSection().getDeleteAllCommandTransactionType();
                        int batchSize = 0;
                        batchSize = transactionType == SearchResultSection.DeleteAllCommandTransactionType.ONCE ? count : ((GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class)).getDeleteAllCommandBatchSize();
                        int countPerBatch = count / batchSize;
                        if (count % batchSize > 0) {
                            ++countPerBatch;
                        }
                        int current = 0;
                        for (int i = 0; i < countPerBatch; ++i) {
                            List<Entity> subList;
                            Boolean _ret;
                            current = i * batchSize;
                            int last = current + batchSize;
                            if (last > list.size()) {
                                last = list.size();
                            }
                            if (!(_ret = (Boolean)Transaction.requiresNew(arg_0 -> this.lambda$execute$0(subList = list.subList(current, last), isPurge, context, request, arg_0))).booleanValue()) break;
                        }
                    }
                    context.getDeleteInterrupterHandler().afterOperation(list);
                }
                catch (ApplicationException e) {
                    if (!logger.isDebugEnabled()) break block15;
                    logger.debug(e.getMessage(), (Throwable)e);
                    ret = "ERROR";
                    request.setAttribute("message", (Object)e.getMessage());
                }
            }
        }
        return ret;
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }

    private /* synthetic */ Boolean lambda$execute$0(List subList, boolean isPurge, DeleteCommandContext context, RequestContext request, Transaction t) {
        for (Entity entity : subList) {
            DeleteCommandBase.DeleteResult deleteResult = this.deleteEntity(entity, isPurge, context.getSearchDeleteTargetVersion());
            if (deleteResult.getResultType() != ResultType.ERROR) continue;
            request.setAttribute("message", (Object)deleteResult.getMessage());
            t.rollback();
            return false;
        }
        return true;
    }
}

