/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.delete;

import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.generic.ResultType;
import org.iplass.gem.command.generic.delete.DeleteCommandBase;
import org.iplass.gem.command.generic.delete.DeleteCommandContext;
import org.iplass.gem.command.generic.detail.DetailViewCommand;
import org.iplass.gem.command.generic.search.SearchViewCommand;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ParamMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.action.TokenCheck;
import org.iplass.mtp.entity.DeleteTargetVersion;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.transaction.TransactionManager;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.DetailFormView;
import org.iplass.mtp.web.actionmapping.definition.ActionMappingDefinitionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMapping(name="gem/generic/delete/delete", displayName="\u524a\u9664", paramMapping={@ParamMapping(name="defName", mapFrom="${0}", condition="subPath.length==1"), @ParamMapping(name="viewName", mapFrom="${0}", condition="subPath.length==2"), @ParamMapping(name="defName", mapFrom="${1}", condition="subPath.length==2")}, result={@Result(status="SUCCESS", type=Result.Type.TEMPLATE, value="gem/generic/search/search"), @Result(status="ERROR", type=Result.Type.TEMPLATE, value="gem/generic/detail/edit"), @Result(status="SUCCESS_BACK_PATH", type=Result.Type.JSP, value="/jsp/gem/generic/backPath.jsp", templateName="gem/generic/backPath")}, tokenCheck=@TokenCheck)
@CommandClass(name="gem/generic/delete/DeleteCommand", displayName="\u524a\u9664")
public final class DeleteCommand
extends DeleteCommandBase {
    private static Logger logger = LoggerFactory.getLogger(DeleteCommand.class);
    public static final String ACTION_NAME = "gem/generic/delete/delete";
    public static final String DELETE_SPECIFIC_VERSION = "deleteSpecificVersion";
    private DetailViewCommand detail = new DetailViewCommand();
    private SearchViewCommand search;
    private ActionMappingDefinitionManager amdm = null;

    public DeleteCommand() {
        this.detail.setDetail(true);
        this.search = new SearchViewCommand();
        this.amdm = (ActionMappingDefinitionManager)ManagerLocator.manager(ActionMappingDefinitionManager.class);
    }

    public String execute(RequestContext request) {
        DeleteCommandContext context = this.getContext(request);
        DetailFormView form = context.getDetailView();
        String defName = request.getParam("defName");
        String oid = request.getParam("oid");
        String version = request.getParam("version");
        String backPath = request.getParam("backPath");
        String searchCond = request.getParam("searchCond");
        String topViewListOffset = request.getParam("topViewListOffset");
        String deleteSpecificVersion = request.getParam(DELETE_SPECIFIC_VERSION);
        if (StringUtil.isNotEmpty((String)oid)) {
            DeleteCommandBase.DeleteResult ret;
            Entity entity;
            Long targetVersion = null;
            DeleteTargetVersion deleteTargetVersion = DeleteTargetVersion.ALL;
            if (context.getEntityDefinition().getVersionControlType() != VersionControlType.NONE && Boolean.valueOf(deleteSpecificVersion).booleanValue()) {
                targetVersion = Long.parseLong(version);
                deleteTargetVersion = DeleteTargetVersion.SPECIFIC;
            }
            if ((entity = this.loadEntity(defName, oid, targetVersion)) != null && (ret = this.deleteEntity(entity, form.isPurge(), deleteTargetVersion)).getResultType() == ResultType.ERROR) {
                request.setAttribute("message", (Object)ret.getMessage());
                ((TransactionManager)ManagerLocator.getInstance().getManager(TransactionManager.class)).currentTransaction().rollback();
                this.detail.execute(request);
                return "ERROR";
            }
        }
        if (StringUtil.isEmpty((String)backPath)) {
            this.search.execute(request);
            return "SUCCESS";
        }
        if (this.amdm.get(backPath) == null) {
            logger.error("backPath is invalid. value=[" + backPath + "]");
            throw new ApplicationException(GemResourceBundleUtil.resourceString("command.generic.detail.DeleteCommand.internalErr", new Object[0]));
        }
        request.setAttribute("defName", (Object)defName);
        request.setAttribute("searchCond", (Object)searchCond);
        request.setAttribute("backPath", (Object)backPath);
        if (StringUtil.isNotEmpty((String)topViewListOffset)) {
            request.setAttribute("topViewListOffset", (Object)topViewListOffset);
        }
        return "SUCCESS_BACK_PATH";
    }
}

