/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.delete;

import org.iplass.gem.command.generic.ResultType;
import org.iplass.gem.command.generic.delete.DeleteCommandContext;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.DeleteTargetVersion;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeleteCommandBase
implements Command {
    private static Logger logger = LoggerFactory.getLogger(DeleteCommandBase.class);
    protected EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
    protected EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);
    protected EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);

    public DeleteCommandContext getContext(RequestContext request) {
        DeleteCommandContext context = new DeleteCommandContext(request);
        context.setEntityDefinition(this.edm.get(context.getDefinitionName()));
        context.setEntityView((EntityView)this.evm.get(context.getDefinitionName()));
        return context;
    }

    protected Entity loadEntity(String defName, String oid) {
        return this.loadEntity(defName, oid, null);
    }

    protected Entity loadEntity(String defName, String oid, Long version) {
        Entity e;
        if (oid != null && (e = this.em.load(oid, version, defName, new LoadOption(false, false))) != null) {
            return e;
        }
        return null;
    }

    protected DeleteResult deleteEntity(Entity entity, boolean isPurge, DeleteTargetVersion targetVersion) {
        DeleteResult ret = new DeleteResult();
        try {
            DeleteOption option = new DeleteOption(false, targetVersion);
            if (targetVersion == DeleteTargetVersion.ALL) {
                option.setPurge(isPurge);
            }
            this.em.delete(entity, option);
            ret.setResultType(ResultType.SUCCESS);
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            ret.setResultType(ResultType.ERROR);
            ret.setMessage(e.getMessage());
        }
        return ret;
    }

    public class DeleteResult {
        private ResultType resultType;
        private String message;

        public ResultType getResultType() {
            return this.resultType;
        }

        public void setResultType(ResultType resultType) {
            this.resultType = resultType;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

