/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.delete;

import java.util.Collections;
import java.util.List;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.generic.GenericCommandContext;
import org.iplass.gem.command.generic.delete.DeleteInterrupterHandler;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.DeleteTargetVersion;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.utilityclass.definition.UtilityClassDefinitionManager;
import org.iplass.mtp.view.generic.BulkOperationInterrupter;
import org.iplass.mtp.view.generic.DetailFormView;
import org.iplass.mtp.view.generic.FormViewUtil;
import org.iplass.mtp.view.generic.SearchFormView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteCommandContext
extends GenericCommandContext {
    private static Logger logger = LoggerFactory.getLogger(DeleteCommandContext.class);
    protected UtilityClassDefinitionManager ucdm = (UtilityClassDefinitionManager)ManagerLocator.getInstance().getManager(UtilityClassDefinitionManager.class);
    private SearchFormView searchView;
    private DetailFormView detailView;
    private DeleteInterrupterHandler deleteInterrupterHandler = null;
    private DeleteTargetVersion deleteTargetVersion;

    protected Logger getLogger() {
        return logger;
    }

    public DeleteCommandContext(RequestContext request) {
        super(request);
    }

    @Override
    public List<ValidateError> getErrors() {
        return Collections.emptyList();
    }

    @Override
    public void addError(ValidateError error) {
    }

    @Override
    public boolean hasErrors() {
        return false;
    }

    public SearchFormView getView() {
        if (this.searchView == null) {
            String viewName = this.getViewName();
            this.searchView = FormViewUtil.getSearchFormView(this.entityDefinition, this.entityView, viewName);
        }
        return this.searchView;
    }

    public DetailFormView getDetailView() {
        if (this.detailView == null) {
            String viewName = this.getViewName();
            this.detailView = FormViewUtil.getDetailFormView(this.entityDefinition, this.entityView, viewName);
        }
        return this.detailView;
    }

    public DeleteInterrupterHandler getDeleteInterrupterHandler() {
        if (this.deleteInterrupterHandler == null) {
            BulkOperationInterrupter deleteInterrupter = this.createBulkInterrupter(this.getDeleteInterrupterName());
            this.deleteInterrupterHandler = new DeleteInterrupterHandler(this.request, this, deleteInterrupter);
        }
        return this.deleteInterrupterHandler;
    }

    protected String getDeleteInterrupterName() {
        return this.getView().getResultSection().getDeleteInterrupterName();
    }

    protected BulkOperationInterrupter createBulkInterrupter(String className) {
        BulkOperationInterrupter interrupter = null;
        if (StringUtil.isNotEmpty((String)className)) {
            this.getLogger().debug("set delete operation interrupter. class=" + className);
            try {
                interrupter = (BulkOperationInterrupter)this.ucdm.createInstanceAs(BulkOperationInterrupter.class, className);
            }
            catch (ClassNotFoundException e) {
                this.getLogger().error(className + " can not instantiate.", (Throwable)e);
                throw new ApplicationException(this.resourceString("command.generic.detail.DeleteCommandContext.internalErr", new Object[0]));
            }
        }
        if (interrupter == null) {
            this.getLogger().debug("set default delete operation interrupter.");
            interrupter = new BulkOperationInterrupter(){};
        }
        return interrupter;
    }

    protected DeleteTargetVersion getSearchDeleteTargetVersion() {
        if (this.deleteTargetVersion == null) {
            boolean isDeleteSpecificVersion;
            this.deleteTargetVersion = DeleteTargetVersion.ALL;
            if (this.getEntityDefinition().getVersionControlType() != VersionControlType.NONE && (isDeleteSpecificVersion = this.getView().isDeleteSpecificVersion())) {
                this.deleteTargetVersion = DeleteTargetVersion.SPECIFIC;
            }
        }
        return this.deleteTargetVersion;
    }

    protected String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

