/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.delete;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.generic.ResultType;
import org.iplass.gem.command.generic.delete.DeleteCommandBase;
import org.iplass.gem.command.generic.delete.DeleteCommandContext;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.command.annotation.webapi.WebApiTokenCheck;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.transaction.TransactionManager;
import org.iplass.mtp.view.generic.BulkOperationContext;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebApi(name="gem/generic/delete/deleteList", displayName="\u9078\u629e\u524a\u9664", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"message"}, tokenCheck=@WebApiTokenCheck(consume=false, useFixedToken=true), checkXRequestedWithHeader=true)
@CommandClass(name="gem/generic/delete/DeleteListCommand", displayName="\u9078\u629e\u524a\u9664")
public final class DeleteListCommand
extends DeleteCommandBase {
    private static Logger logger = LoggerFactory.getLogger(DeleteListCommand.class);
    public static final String WEBAPI_NAME = "gem/generic/delete/deleteList";

    public String execute(RequestContext request) {
        String retKey;
        block13: {
            String name = request.getParam("defName");
            String[] oidArray = null;
            Object val = request.getParamMap().get("oid");
            if (val instanceof String) {
                oidArray = new String[]{(String)val};
            } else if (val instanceof ArrayList) {
                ArrayList list = (ArrayList)val;
                oidArray = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    oidArray[i] = list.get(i).toString();
                }
            }
            DeleteCommandContext context = this.getContext(request);
            SearchFormView view = context.getView();
            boolean isPurge = view.isPurge();
            Map<String, Integer> rowIdMap = this.splitRowId(oidArray);
            List<Entity> entities = this.getEntities(context.getDefinitionName(), rowIdMap.keySet());
            retKey = "SUCCESS";
            try {
                BulkOperationContext bulkContext = context.getDeleteInterrupterHandler().beforeOperation(entities);
                List<ValidateError> errors = bulkContext.getErrors();
                entities = bulkContext.getEntities();
                if (!errors.isEmpty()) {
                    request.setAttribute("message", (Object)DeleteListCommand.resourceString("command.generic.delete.DeleteListCommand.inputErr", new Object[0]));
                    retKey = "ERROR";
                } else if (entities.size() > 0) {
                    for (Entity paramEntity : entities) {
                        Integer targetRow;
                        DeleteCommandBase.DeleteResult ret;
                        Entity entity = this.loadEntity(name, paramEntity.getOid(), paramEntity.getVersion());
                        if (entity == null || (ret = this.deleteEntity(entity, isPurge, context.getSearchDeleteTargetVersion())).getResultType() != ResultType.ERROR) continue;
                        String key = paramEntity.getOid();
                        if (paramEntity.getVersion() != null) {
                            key = key + "_" + paramEntity.getVersion();
                        }
                        if ((targetRow = rowIdMap.getOrDefault(key, -1)) > 0) {
                            request.setAttribute("message", (Object)DeleteListCommand.resourceString("command.generic.delete.DeleteListCommand.deleteListErr", ret.getMessage(), targetRow));
                        } else {
                            request.setAttribute("message", (Object)ret.getMessage());
                        }
                        ((TransactionManager)ManagerLocator.getInstance().getManager(TransactionManager.class)).currentTransaction().rollback();
                        break;
                    }
                }
                context.getDeleteInterrupterHandler().afterOperation(entities);
            }
            catch (ApplicationException e) {
                if (!logger.isDebugEnabled()) break block13;
                logger.debug(e.getMessage(), (Throwable)e);
                retKey = "ERROR";
                request.setAttribute("message", (Object)e.getMessage());
            }
        }
        return retKey;
    }

    private Map<String, Integer> splitRowId(String[] oidArray) {
        HashMap<String, Integer> rowIdMap = new HashMap<String, Integer>();
        if (oidArray != null) {
            for (int i = 0; i < oidArray.length; ++i) {
                int targetRow = -1;
                String targetOidVersion = oidArray[i];
                if (targetOidVersion.indexOf("_") != -1) {
                    targetRow = Integer.parseInt(targetOidVersion.substring(0, targetOidVersion.indexOf("_")));
                    targetOidVersion = targetOidVersion.substring(targetOidVersion.indexOf("_") + 1);
                }
                rowIdMap.putIfAbsent(targetOidVersion, targetRow);
            }
        }
        return rowIdMap;
    }

    private List<Entity> getEntities(String defName, Set<String> oidVersionSet) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Iterator<String> iterator = oidVersionSet.iterator();
        while (iterator.hasNext()) {
            String oidVersion;
            String targetOid = oidVersion = iterator.next();
            Long targetVersion = null;
            if (oidVersion.indexOf("_") != -1) {
                targetOid = oidVersion.substring(0, oidVersion.lastIndexOf("_"));
                targetVersion = Long.parseLong(oidVersion.substring(oidVersion.lastIndexOf("_") + 1));
            }
            GenericEntity entity = new GenericEntity(defName, targetOid, null);
            entity.setVersion(targetVersion);
            entities.add((Entity)entity);
        }
        return entities;
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

