/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.delete;

import java.util.ArrayList;
import org.iplass.gem.GemConfigService;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/generic/delete/getRecycleBin", displayName="\u524a\u9664\u30c7\u30fc\u30bf\u53d6\u5f97", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"entity"}, checkXRequestedWithHeader=true)
@CommandClass(name="gem/generic/delete/GetRecycleBinCommand", displayName="\u524a\u9664\u30c7\u30fc\u30bf\u53d6\u5f97")
public final class GetRecycleBinCommand
implements Command {
    public static final String WEBAPI_NAME = "gem/generic/delete/getRecycleBin";
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
    private EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);
    private GemConfigService gcs = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);

    public String execute(RequestContext request) {
        String defName = request.getParam("defName");
        String viewName = request.getParam("viewName");
        boolean isAllowTrashOperationToRecycleBy = this.isAllowTrashOperationToRecycleBy(defName, viewName);
        String userOid = AuthContext.getCurrentContext().getUser().getOid();
        ArrayList list = new ArrayList();
        this.em.getRecycleBin(defName, entity -> {
            if (isAllowTrashOperationToRecycleBy) {
                if (userOid.equals(entity.getUpdateBy())) {
                    list.add(entity);
                }
            } else {
                list.add(entity);
            }
            return this.gcs.getRecycleBinMaxCount() <= 0 || list.size() != this.gcs.getRecycleBinMaxCount();
        });
        request.setAttribute("entity", list);
        return "SUCCESS";
    }

    private boolean isAllowTrashOperationToRecycleBy(String defName, String viewName) {
        EntityView view = (EntityView)this.evm.get(defName);
        SearchFormView form = null;
        if (viewName == null || viewName.equals("")) {
            if (view != null && view.getSearchFormViewNames().length > 0) {
                form = view.getDefaultSearchFormView();
            }
        } else if (view != null) {
            form = view.getSearchFormView(viewName);
        }
        return form != null ? form.isAllowTrashOperationToRecycleBy() : false;
    }
}

