/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.delete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.iplass.gem.command.CommandUtil;
import org.iplass.gem.command.generic.delete.DeleteCommandBase;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.command.annotation.webapi.WebApiTokenCheck;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebApi(name="gem/generic/delete/purge", displayName="\u7269\u7406\u524a\u9664", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), tokenCheck=@WebApiTokenCheck(consume=false, useFixedToken=true), checkXRequestedWithHeader=true)
@CommandClass(name="gem/generic/delete/PurgeCommand", displayName="\u7269\u7406\u524a\u9664")
public final class PurgeCommand
extends DeleteCommandBase {
    private static Logger logger = LoggerFactory.getLogger(PurgeCommand.class);
    public static final String WEBAPI_NAME = "gem/generic/delete/purge";

    public String execute(RequestContext request) {
        String defName = request.getParam("defName");
        String viewName = request.getParam("viewName");
        Long[] rbid = null;
        Object val = request.getParamMap().get("rbid");
        if (val instanceof String) {
            rbid = new Long[]{CommandUtil.getLong((String)val)};
        } else if (val instanceof ArrayList) {
            ArrayList list = (ArrayList)val;
            rbid = new Long[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                rbid[i] = CommandUtil.getLong(list.get(i).toString());
            }
        }
        if (rbid != null && rbid.length > 0) {
            boolean isAllowTrashOperationToRecycleBy = this.isAllowTrashOperationToRecycleBy(defName, viewName);
            String userOid = AuthContext.getCurrentContext().getUser().getOid();
            int count = rbid.length;
            int countPerHundret = count / 100;
            if (count % 100 > 0) {
                ++countPerHundret;
            }
            int current = 0;
            for (int i = 0; i < countPerHundret; ++i) {
                List<Long> list;
                List<Long> subList;
                Boolean ret;
                current = i * 100;
                int last = current + 100;
                if (last > rbid.length) {
                    last = rbid.length;
                }
                if (!(ret = (Boolean)Transaction.requiresNew(arg_0 -> this.lambda$execute$0(subList = (list = Arrays.asList(rbid)).subList(current, last), isAllowTrashOperationToRecycleBy, defName, userOid, arg_0))).booleanValue()) break;
            }
        }
        return "SUCCESS";
    }

    private boolean isAllowTrashOperationToRecycleBy(String defName, String viewName) {
        EntityView view = (EntityView)this.evm.get(defName);
        SearchFormView form = null;
        if (viewName == null || viewName.equals("")) {
            if (view != null && view.getSearchFormViewNames().length > 0) {
                form = view.getDefaultSearchFormView();
            }
        } else if (view != null) {
            form = view.getSearchFormView(viewName);
        }
        return form != null ? form.isAllowTrashOperationToRecycleBy() : false;
    }

    private /* synthetic */ Boolean lambda$execute$0(List subList, boolean isAllowTrashOperationToRecycleBy, String defName, String userOid, Transaction transaction) {
        for (Long id : subList) {
            try {
                if (isAllowTrashOperationToRecycleBy) {
                    Entity rb = this.em.getRecycleBin(id.longValue(), defName);
                    if (!userOid.equals(rb.getUpdateBy())) continue;
                    this.em.purge(id.longValue(), defName);
                    continue;
                }
                this.em.purge(id.longValue(), defName);
            }
            catch (ApplicationException e) {
                transaction.rollback();
                logger.error("purge RecycleBin[rbid=" + id + "] is failed.", (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

