/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.detail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.iplass.gem.command.generic.detail.DetailCommandContext;
import org.iplass.gem.command.generic.detail.RegistrationCommandBase;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DetailCommandBase
extends RegistrationCommandBase<DetailCommandContext, PropertyItem> {
    private static Logger logger = LoggerFactory.getLogger(DetailCommandBase.class);

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected DetailCommandContext getContext(RequestContext request) {
        DetailCommandContext context = new DetailCommandContext(request, this.em, this.edm);
        context.setEntityDefinition(this.edm.get(context.getDefinitionName()));
        context.setEntityView((EntityView)this.evm.get(context.getDefinitionName()));
        return context;
    }

    protected void setUserInfoMap(DetailCommandContext context, Entity entity, boolean isDetail) {
        if (!context.isUseUserPropertyEditor(isDetail)) {
            return;
        }
        final ArrayList<String> userOidList = new ArrayList<String>();
        HashMap<String, UserRefData> datas = new HashMap<String, UserRefData>();
        for (String string : context.getUseUserPropertyEditorPropertyName(isDetail)) {
            int firstDotIndex = string.indexOf(".");
            if (firstDotIndex > -1) {
                Entity[] refEntities;
                String topPropName = string.substring(0, firstDotIndex);
                String subPropName = string.substring(firstDotIndex + 1);
                Object entityTemp = entity.getValue(topPropName);
                if (entityTemp == null) continue;
                if (entityTemp instanceof Entity) {
                    Entity refEntity = (Entity)entityTemp;
                    String defName = refEntity.getDefinitionName();
                    UserRefData data = null;
                    data = datas.containsKey(defName) ? (UserRefData)datas.get(defName) : new UserRefData();
                    data.set(refEntity.getOid(), subPropName);
                    datas.put(defName, data);
                    continue;
                }
                if (!(entityTemp instanceof Entity[])) continue;
                for (Entity refEntity : refEntities = (Entity[])entityTemp) {
                    String defName = refEntity.getDefinitionName();
                    UserRefData data = null;
                    data = datas.containsKey(defName) ? (UserRefData)datas.get(defName) : new UserRefData();
                    data.set(refEntity.getOid(), subPropName);
                    datas.put(defName, data);
                }
                continue;
            }
            String oid = (String)entity.getValue(string);
            if (oid == null || userOidList.contains(oid)) continue;
            userOidList.add(oid);
        }
        if (!datas.isEmpty()) {
            for (Map.Entry entry : datas.entrySet()) {
                final UserRefData userRef = (UserRefData)entry.getValue();
                Query q = new Query().select(userRef.getProps().toArray()).from((String)entry.getKey()).where((Condition)new In("oid", userRef.getOids().toArray()));
                this.em.searchEntity(q, (Predicate)new Predicate<Entity>(){

                    @Override
                    public boolean test(Entity entity) {
                        Map<String, List<String>> mapping = userRef.getMapping();
                        if (mapping.containsKey(entity.getOid())) {
                            List<String> props = mapping.get(entity.getOid());
                            for (String prop : props) {
                                if (userOidList.contains(entity.getValue(prop))) continue;
                                userOidList.add(entity.getValue(prop));
                            }
                        }
                        return true;
                    }
                });
            }
        }
        if (!userOidList.isEmpty()) {
            HashMap<String, Entity> userMap = new HashMap<String, Entity>();
            if (context.getView().isShowUserNameWithPrivilegedValue()) {
                AuthContext.doPrivileged(() -> this.searchUserMap(userMap, userOidList));
            } else {
                this.searchUserMap(userMap, userOidList);
            }
            context.setAttribute("userInfoMap", userMap);
        }
    }

    private void searchUserMap(final Map<String, Entity> userMap, List<String> userOidList) {
        Query q = new Query().select(new Object[]{"oid", "name"}).from("mtp.auth.User").where((Condition)new In("oid", userOidList.toArray()));
        this.em.searchEntity(q, (Predicate)new Predicate<Entity>(){

            @Override
            public boolean test(Entity dataModel) {
                if (!userMap.containsKey(dataModel.getOid())) {
                    userMap.put(dataModel.getOid(), dataModel);
                }
                return true;
            }
        });
    }

    private class UserRefData {
        private List<String> oids = new ArrayList<String>();
        private List<String> props = new ArrayList<String>();
        private Map<String, List<String>> mapping;

        UserRefData() {
            this.props.add("oid");
            this.mapping = new HashMap<String, List<String>>();
        }

        void set(String oid, String property) {
            if (!this.oids.contains(oid)) {
                this.oids.add(oid);
            }
            if (!this.props.contains(property)) {
                this.props.add(property);
            }
            if (this.mapping.containsKey(oid)) {
                List<String> list = this.mapping.get(oid);
                if (!list.contains(property)) {
                    list.add(property);
                    this.mapping.put(oid, list);
                }
            } else {
                ArrayList<String> list = new ArrayList<String>();
                list.add(property);
                this.mapping.put(oid, list);
            }
        }

        List<String> getOids() {
            return this.oids;
        }

        List<String> getProps() {
            return this.props;
        }

        Map<String, List<String>> getMapping() {
            return this.mapping;
        }
    }
}

