/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.detail;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.iplass.gem.GemConfigService;
import org.iplass.gem.command.CommandUtil;
import org.iplass.gem.command.ViewUtil;
import org.iplass.gem.command.generic.detail.DetailFormViewData;
import org.iplass.gem.command.generic.detail.NestTableReferenceRegistHandler;
import org.iplass.gem.command.generic.detail.ReferenceRegistHandler;
import org.iplass.gem.command.generic.detail.ReferenceRegistOption;
import org.iplass.gem.command.generic.detail.ReferenceSectionReferenceRegistHandler;
import org.iplass.gem.command.generic.detail.RegistrationCommandContext;
import org.iplass.gem.command.generic.detail.RegistrationPropertyBaseHandler;
import org.iplass.gem.command.generic.detail.handler.CheckPermissionLimitConditionOfButtonHandler;
import org.iplass.gem.command.generic.detail.handler.ShowDetailLayoutViewEvent;
import org.iplass.gem.command.generic.detail.handler.ShowDetailViewEventHandler;
import org.iplass.gem.command.generic.detail.handler.ShowEditViewEventHandler;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.BooleanProperty;
import org.iplass.mtp.entity.definition.properties.DateProperty;
import org.iplass.mtp.entity.definition.properties.DateTimeProperty;
import org.iplass.mtp.entity.definition.properties.DecimalProperty;
import org.iplass.mtp.entity.definition.properties.FloatProperty;
import org.iplass.mtp.entity.definition.properties.IntegerProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.definition.properties.SelectProperty;
import org.iplass.mtp.entity.definition.properties.StringProperty;
import org.iplass.mtp.entity.definition.properties.TimeProperty;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.DetailFormView;
import org.iplass.mtp.view.generic.DetailFormViewHandler;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.FormViewUtil;
import org.iplass.mtp.view.generic.OutputType;
import org.iplass.mtp.view.generic.editor.CustomPropertyEditor;
import org.iplass.mtp.view.generic.editor.DateRangePropertyEditor;
import org.iplass.mtp.view.generic.editor.JoinPropertyEditor;
import org.iplass.mtp.view.generic.editor.LabelablePropertyEditor;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.NumericRangePropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.RangePropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.editor.UserPropertyEditor;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.VirtualPropertyItem;
import org.iplass.mtp.view.generic.element.property.PropertyBase;
import org.iplass.mtp.view.generic.element.property.PropertyElement;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.iplass.mtp.view.generic.element.section.DefaultSection;
import org.iplass.mtp.view.generic.element.section.ReferenceSection;
import org.iplass.mtp.view.generic.element.section.Section;
import org.iplass.mtp.web.template.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailCommandContext
extends RegistrationCommandContext
implements ShowDetailViewEventHandler,
ShowEditViewEventHandler {
    private static Logger logger = LoggerFactory.getLogger(DetailCommandContext.class);
    private DetailFormView view;
    private List<DetailFormViewHandler> detailFormViewHandlers;
    private GemConfigService gemConfig = null;
    private Set<String> useUserPropertyEditorPropertyNameList;
    private List<PropertyElement> excludeLabelableProperties;
    private Entity currentEntity;
    private Entity editedEntity;

    @Override
    protected Logger getLogger() {
        return logger;
    }

    public DetailCommandContext(RequestContext request, EntityManager entityLoader, EntityDefinitionManager definitionLoader) {
        super(request, entityLoader, definitionLoader);
        this.init();
    }

    public DetailCommandContext(RequestContext request, String defName, String viewName, EntityManager entityLoader, EntityDefinitionManager definitionLoader) {
        super(request, defName, viewName, entityLoader, definitionLoader);
        this.init();
    }

    private void init() {
        this.gemConfig = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
    }

    public DetailFormView getView() {
        String viewName = this.getViewName();
        if (this.view == null) {
            this.view = FormViewUtil.getDetailFormView(this.entityDefinition, this.entityView, viewName);
        }
        return this.view;
    }

    public void setView(DetailFormView view) {
        this.view = view;
    }

    public Entity getDispControlBindEntity() {
        if (logger.isTraceEnabled()) {
            logger.trace("Bind display control entity is :" + (this.editedEntity != null ? "edited" : "loaded"));
        }
        return this.editedEntity != null ? this.editedEntity : this.currentEntity;
    }

    public void setCurrentEntity(Entity currentEntity) {
        this.currentEntity = currentEntity;
    }

    protected void setEditedEntity(Entity editedEntity) {
        this.editedEntity = editedEntity;
    }

    @Override
    protected String getInterrupterName() {
        return this.getView().getInterrupterName();
    }

    @Override
    protected String getLoadEntityInterrupterName() {
        return this.getView().getLoadEntityInterrupterName();
    }

    protected RegistrationPropertyBaseHandler<PropertyItem> createRegistrationPropertyBaseHandler() {
        return new RegistrationPropertyBaseHandler<PropertyItem>(){

            @Override
            public boolean isDispProperty(PropertyItem property) {
                return EntityViewUtil.isDisplayElement(DetailCommandContext.this.entityDefinition.getName(), property.getElementRuntimeId(), OutputType.EDIT, DetailCommandContext.this.getDispControlBindEntity()) && !property.isHideDetail();
            }

            @Override
            public PropertyEditor getEditor(PropertyItem property) {
                return property.getEditor();
            }
        };
    }

    public List<PropertyItem> getProperty() {
        String execType = this.getExecType();
        ArrayList<PropertyItem> propList = new ArrayList<PropertyItem>();
        for (Section section : this.getView().getSections()) {
            if (section instanceof DefaultSection) {
                if (!EntityViewUtil.isDisplayElement(this.getDefinitionName(), section.getElementRuntimeId(), OutputType.EDIT, this.getDispControlBindEntity()) || ((DefaultSection)section).isHideDetail() || !ViewUtil.dispElement(execType, (Element)section)) continue;
                propList.addAll(this.getProperty((DefaultSection)section));
                continue;
            }
            if (!(section instanceof ReferenceSection)) continue;
            ReferenceSection rs = (ReferenceSection)section;
            if (!EntityViewUtil.isDisplayElement(this.getDefinitionName(), section.getElementRuntimeId(), OutputType.EDIT, this.getDispControlBindEntity()) || rs.isHideDetail() || !ViewUtil.dispElement(execType, (Element)rs)) continue;
            Optional<ReferenceSectionPropertyItem> ret = propList.stream().filter(p -> p instanceof ReferenceSectionPropertyItem).map(p -> (ReferenceSectionPropertyItem)p).filter(p -> p.getPropertyName().equals(rs.getPropertyName())).findFirst();
            if (ret.isPresent()) {
                ret.get().getSections().add(rs);
                continue;
            }
            propList.add(this.createReferenceSectionPropertyItem(rs));
        }
        return propList;
    }

    public List<PropertyItem> getUpdateProperty() {
        List<PropertyItem> propList = this.getProperty();
        List<PropertyItem> updateList = propList.stream().filter(property -> {
            LabelablePropertyEditor editor;
            return !(property.getEditor() instanceof LabelablePropertyEditor) || !(editor = (LabelablePropertyEditor)((Object)property.getEditor())).isLabel() || editor.isUpdateWithLabelValue();
        }).collect(Collectors.toList());
        return updateList;
    }

    private List<PropertyItem> getProperty(DefaultSection section) {
        String execType = this.getExecType();
        ArrayList<PropertyItem> propList = new ArrayList<PropertyItem>();
        for (Element elem : section.getElements()) {
            if (elem instanceof PropertyItem) {
                PropertyItem prop = (PropertyItem)elem;
                if (!this.getRegistrationPropertyBaseHandler().isDispProperty(prop) || !ViewUtil.dispElement(execType, (Element)prop)) continue;
                if (prop.getEditor() instanceof JoinPropertyEditor) {
                    JoinPropertyEditor je = (JoinPropertyEditor)prop.getEditor();
                    for (NestProperty nest : je.getProperties()) {
                        PropertyItem dummy = new PropertyItem();
                        dummy.setDispFlag(true);
                        dummy.setPropertyName(nest.getPropertyName());
                        dummy.setEditor(nest.getEditor());
                        propList.add(dummy);
                    }
                } else if (prop.getEditor() instanceof RangePropertyEditor) {
                    RangePropertyEditor de = (RangePropertyEditor)((Object)prop.getEditor());
                    PropertyItem dummy = new PropertyItem();
                    dummy.setDispFlag(true);
                    dummy.setPropertyName(de.getToPropertyName());
                    dummy.setEditor(de.getEditor());
                    propList.add(dummy);
                }
                propList.add(prop);
                continue;
            }
            if (elem instanceof DefaultSection) {
                if (!EntityViewUtil.isDisplayElement(this.getDefinitionName(), elem.getElementRuntimeId(), OutputType.EDIT, this.getDispControlBindEntity()) || ((DefaultSection)elem).isHideDetail() || !ViewUtil.dispElement(execType, elem)) continue;
                propList.addAll(this.getProperty((DefaultSection)elem));
                continue;
            }
            if (!(elem instanceof ReferenceSection)) continue;
            ReferenceSection rs = (ReferenceSection)elem;
            if (!EntityViewUtil.isDisplayElement(this.getDefinitionName(), elem.getElementRuntimeId(), OutputType.EDIT, this.getDispControlBindEntity()) || rs.isHideDetail() || !ViewUtil.dispElement(execType, (Element)rs)) continue;
            Optional<ReferenceSectionPropertyItem> ret = propList.stream().filter(p -> p instanceof ReferenceSectionPropertyItem).map(p -> (ReferenceSectionPropertyItem)p).filter(p -> p.getPropertyName().equals(rs.getPropertyName())).findFirst();
            if (ret.isPresent()) {
                ret.get().getSections().add(rs);
                continue;
            }
            propList.add(this.createReferenceSectionPropertyItem(rs));
        }
        return propList;
    }

    private ReferenceSectionPropertyItem createReferenceSectionPropertyItem(ReferenceSection section) {
        ReferenceSectionPropertyItem property = new ReferenceSectionPropertyItem();
        property.setPropertyName(section.getPropertyName());
        property.getSections().add(section);
        return property;
    }

    public List<String> getReferencePropertyName() {
        HashSet<String> loadReferences = new HashSet<String>();
        for (Section section : this.getView().getSections()) {
            if (section instanceof DefaultSection) {
                this.getReferencePropertyName((DefaultSection)section, loadReferences);
                continue;
            }
            if (!(section instanceof ReferenceSection)) continue;
            ReferenceSection rs = (ReferenceSection)section;
            loadReferences.add(rs.getPropertyName());
        }
        return new ArrayList<String>(loadReferences);
    }

    private void getReferencePropertyName(DefaultSection section, Set<String> loadReferences) {
        for (Element element : section.getElements()) {
            if (element instanceof PropertyItem) {
                PropertyItem property = (PropertyItem)element;
                PropertyDefinition pd = this.getProperty(property.getPropertyName());
                if (pd instanceof ReferenceProperty) {
                    loadReferences.add(property.getPropertyName());
                }
                if (!(property.getEditor() instanceof JoinPropertyEditor)) continue;
                JoinPropertyEditor jpe = (JoinPropertyEditor)property.getEditor();
                for (NestProperty nest : jpe.getProperties()) {
                    if (!(nest.getEditor() instanceof ReferencePropertyEditor)) continue;
                    loadReferences.add(nest.getPropertyName());
                }
                continue;
            }
            if (element instanceof DefaultSection) {
                this.getReferencePropertyName((DefaultSection)element, loadReferences);
                continue;
            }
            if (!(element instanceof ReferenceSection)) continue;
            ReferenceSection rs = (ReferenceSection)element;
            loadReferences.add(rs.getPropertyName());
        }
    }

    public String getOid() {
        return this.getParam("oid");
    }

    public Long getVersion() {
        return this.getLongValue("version");
    }

    public String getFilterName() {
        return this.getParam("filterName");
    }

    public boolean isCopy() {
        String copy = this.getParam("copy");
        return copy != null && "true".equals(copy);
    }

    public DetailFormView.CopyTarget getCopyTarget() {
        String copyTarget = this.getParam("copyTarget");
        if (copyTarget == null || copyTarget.isEmpty()) {
            return DetailFormView.CopyTarget.SHALLOW;
        }
        return DetailFormView.CopyTarget.getEnum(copyTarget);
    }

    @Override
    public boolean isNewVersion() {
        String newVersion = this.getParam("newversion");
        return newVersion != null && "true".equals(newVersion);
    }

    @Override
    protected boolean isPurgeCompositionedEntity() {
        return this.getView().isPurgeCompositionedEntity();
    }

    @Override
    protected boolean isLocalizationData() {
        return this.getView().isLocalizationData();
    }

    @Override
    protected boolean isForceUpadte() {
        return this.getView().isForceUpadte();
    }

    @Override
    public boolean hasUpdatableMappedByReference() {
        List<PropertyItem> properties = this.getProperty();
        for (PropertyItem property : properties) {
            ReferencePropertyEditor editor;
            String mappedBy;
            PropertyDefinition pd = this.getProperty(property.getPropertyName());
            if (!(pd instanceof ReferenceProperty) || StringUtil.isBlank((String)(mappedBy = ((ReferenceProperty)pd).getMappedBy()))) continue;
            if (property instanceof ReferenceSectionPropertyItem) {
                return true;
            }
            if (!(property.getEditor() instanceof ReferencePropertyEditor) || (editor = (ReferencePropertyEditor)property.getEditor()).getDisplayType() != ReferencePropertyEditor.ReferenceDisplayType.NESTTABLE) continue;
            return true;
        }
        return false;
    }

    public String getSearchCond() {
        return this.getParam("searchCond");
    }

    public String getExecType() {
        return this.getParam("execType");
    }

    public String getBackPath() {
        return this.getParam("backPath");
    }

    public boolean isUpdateByParam() {
        String updateByParam = this.getParam("updateByParam");
        return updateByParam != null && "true".equals(updateByParam);
    }

    public Entity createEntity() {
        Entity entity = this.createEntity("", null);
        entity.setUpdateDate(this.getTimestamp());
        if (this.isVersioned()) {
            entity.setVersion(this.getVersion());
        }
        this.setVirtualPropertyValue(entity);
        this.setLabelablePropertyValue(entity);
        this.getRegistrationInterrupterHandler().dataMapping(entity);
        this.validate(entity);
        this.setEditedEntity(entity);
        return entity;
    }

    private Entity createEntity(String paramPrefix, String errorPrefix) {
        Entity entity = this.newEntity();
        for (PropertyDefinition p : this.getPropertyList()) {
            Object value = this.getPropValue(p, paramPrefix);
            entity.setValue(p.getName(), value);
            if (errorPrefix == null) continue;
            String name = paramPrefix + p.getName();
            String errorName = errorPrefix + p.getName();
            this.getErrors().stream().filter(error -> error.getPropertyName().equals(name)).forEach(error -> error.setPropertyName(errorName));
        }
        return entity;
    }

    private Timestamp getTimestamp() {
        Timestamp ts = null;
        Long l = this.getLongValue("timestamp");
        if (l != null) {
            ts = new Timestamp(l);
        }
        return ts;
    }

    @Override
    protected Object createReference(PropertyDefinition p, String prefix) {
        ReferenceProperty rp = (ReferenceProperty)p;
        String defName = rp.getObjectDefinitionName();
        Long count = this.getLongValue(prefix + p.getName() + "_count");
        String isRs = this.getParam("isReferenceSection_" + prefix + p.getName());
        if (p.getMultiplicity() == 1) {
            Entity entity = null;
            if (count == null) {
                String key2 = this.getParam(prefix + p.getName());
                entity = this.getRefEntity(rp.getObjectDefinitionName(), key2);
            } else {
                List<Entity> list = null;
                list = isRs != null && "true".equals(isRs) ? this.getRefSectionValues(rp, defName, count, prefix) : this.getRefTableValues(rp, defName, count, prefix);
                if (list.size() > 0) {
                    entity = list.get(0);
                }
            }
            return entity;
        }
        List<Object> list = null;
        if (count == null) {
            String[] params = this.getParams(prefix + p.getName());
            if (params != null) {
                list = Arrays.stream(params).map(key -> this.getRefEntity(rp.getObjectDefinitionName(), (String)key)).filter(value -> value != null).collect(Collectors.toList());
            }
        } else {
            list = isRs != null && "true".equals(isRs) ? this.getRefSectionValues(rp, defName, count, prefix) : this.getRefTableValues(rp, defName, count, prefix);
        }
        if (list != null && !list.isEmpty()) {
            EntityDefinition ed = this.getEntityDefinition();
            this.setEntityDefinition(this.definitionManager.get(defName));
            Entity emptyEntity = this.newEntity();
            this.setEntityDefinition(ed);
            Object[] array = (Object[])Array.newInstance(emptyEntity.getClass(), list.size());
            return list.toArray(array);
        }
        return null;
    }

    private Entity getRefEntity(String definitionName, String key) {
        Entity entity = null;
        String oid = null;
        Long version = null;
        if (key != null) {
            int lastIndex = key.lastIndexOf("_");
            if (lastIndex < 0) {
                oid = key;
            } else {
                oid = key.substring(0, lastIndex);
                version = CommandUtil.getLong(key.substring(lastIndex + 1));
            }
        }
        if (StringUtil.isNotBlank(oid)) {
            entity = this.gemConfig.isLoadWithReference() ? this.entityManager.load(oid, version, definitionName) : this.entityManager.load(oid, version, definitionName, new LoadOption(false, false));
        }
        return entity;
    }

    private List<Entity> getRefTableValues(ReferenceProperty p, String defName, Long count, String prefix) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        EntityDefinition ed = this.getEntityDefinition();
        EntityDefinition red = this.definitionManager.get(defName);
        this.setEntityDefinition(red);
        int i = 0;
        while ((long)i < count) {
            String paramPrefix = prefix + p.getName() + "[" + Integer.toString(i) + "].";
            String errorPrefix = i != list.size() ? prefix + p.getName() + "[" + Integer.toString(list.size()) + "]." : null;
            Entity entity = this.createEntity(paramPrefix, errorPrefix);
            entity.setValue("##refReload", (Object)Boolean.FALSE);
            if (entity.getOid() != null && entity.getOid().equals("null")) {
                entity.setOid(null);
            }
            String checkPrefix = errorPrefix != null ? errorPrefix : paramPrefix;
            boolean hasError = this.getErrors().stream().filter(error -> error.getPropertyName().startsWith(checkPrefix)).findFirst().isPresent();
            if (hasError || !this.isEmpty(entity)) {
                entity.setDefinitionName(defName);
                entity.setValue("##refIndex", (Object)list.size());
                Long orderIndex = this.getLongValue("tableOrderIndex[" + i + "]");
                if (orderIndex != null) {
                    entity.setValue("##refTableOrderIndex", (Object)orderIndex);
                }
                list.add(entity);
            }
            ++i;
        }
        this.setEntityDefinition(ed);
        Optional<PropertyItem> ret = this.getProperty().stream().filter(pi -> pi.getPropertyName().equals(p.getName())).findFirst();
        if (ret.isPresent()) {
            this.addNestTableRegistHandler(p, list, red, ret.get());
        }
        return list;
    }

    private void addNestTableRegistHandler(ReferenceProperty p, List<Entity> list, EntityDefinition red, PropertyItem property) {
        ReferenceRegistHandler handler;
        if (!NestTableReferenceRegistHandler.canRegist(property, this.getRegistrationPropertyBaseHandler())) {
            return;
        }
        ReferenceRegistOption option = null;
        if (this.currentEntity != null && (option = this.getRegistrationInterrupterHandler().getNestTableRegistOption(red, p.getName())).isSpecifyAllProperties() && !option.isSpecifiedAsReference() && option.getSpecifiedUpdateNestProperties().isEmpty()) {
            return;
        }
        ReferencePropertyEditor editor = (ReferencePropertyEditor)property.getEditor();
        List<Entity> target = null;
        if (StringUtil.isNotBlank((String)editor.getTableOrderPropertyName())) {
            PropertyDefinition pd = red.getProperty(editor.getTableOrderPropertyName());
            target = EntityViewUtil.sortByOrderProperty(list, "##refTableOrderIndex");
            for (int i = 0; i < target.size(); ++i) {
                target.get(i).setValue(editor.getTableOrderPropertyName(), ConvertUtil.convert((Class)pd.getJavaType(), (Object)i));
            }
        } else {
            target = list;
        }
        if ((handler = NestTableReferenceRegistHandler.get(this, list, red, p, property, editor.getNestProperties(), this.getRegistrationPropertyBaseHandler(), option)) != null) {
            handler.setForceUpdate(editor.isForceUpadte());
            this.getReferenceRegistHandlers().add(handler);
        }
    }

    private List<Entity> getRefSectionValues(ReferenceProperty p, String defName, Long count, String prefix) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        EntityDefinition ed = this.getEntityDefinition();
        EntityDefinition red = this.definitionManager.get(defName);
        this.setEntityDefinition(red);
        List<PropertyItem> properties = this.getProperty();
        ArrayList<ReferenceSectionValue> valList = new ArrayList<ReferenceSectionValue>();
        Optional<ReferenceSectionPropertyItem> ret = properties.stream().filter(pi -> pi instanceof ReferenceSectionPropertyItem).map(pi -> (ReferenceSectionPropertyItem)pi).filter(pi -> pi.getPropertyName().equals(p.getName())).findFirst();
        ReferenceSectionPropertyItem rsProperty = ret.isPresent() ? ret.get() : null;
        int i = 0;
        while ((long)i < count) {
            String paramPrefix = prefix + p.getName() + "[" + Integer.toString(i) + "].";
            String errorPrefix = i != list.size() ? prefix + p.getName() + "[" + Integer.toString(list.size()) + "]." : null;
            Entity entity = this.createEntity(paramPrefix, errorPrefix);
            entity.setValue("##refReload", (Object)Boolean.FALSE);
            if (entity.getOid() != null && entity.getOid().equals("null")) {
                entity.setOid(null);
            }
            String checkPrefix = errorPrefix != null ? errorPrefix : paramPrefix;
            boolean hasError = this.getErrors().stream().filter(error -> error.getPropertyName().startsWith(checkPrefix)).findFirst().isPresent();
            if (hasError || !this.isEmpty(entity)) {
                entity.setDefinitionName(defName);
                entity.setValue("##refIndex", (Object)list.size());
                if (rsProperty != null) {
                    if (p.getMultiplicity() == 1) {
                        if (rsProperty.getSections().size() > 0) {
                            ReferenceSection section = rsProperty.getSections().get(0);
                            ReferenceSectionValue rsv = new ReferenceSectionValue();
                            rsv.entity = entity;
                            rsv.section = section;
                            valList.add(rsv);
                        }
                    } else {
                        String idx = this.getParam("referenceSectionIndex_" + prefix + p.getName() + "[" + Integer.toString(i) + "]");
                        int index = CommandUtil.getInteger(idx);
                        ReferenceSection section = rsProperty.getSection(index);
                        if (section != null) {
                            ReferenceSectionValue rsv = new ReferenceSectionValue();
                            rsv.index = index;
                            rsv.entity = entity;
                            rsv.section = section;
                            valList.add(rsv);
                        }
                    }
                }
                list.add(entity);
            }
            ++i;
        }
        this.setEntityDefinition(ed);
        if (rsProperty != null) {
            this.addReferenceSectionRegistHandler(p, valList, red, rsProperty);
        }
        return list;
    }

    private void addReferenceSectionRegistHandler(ReferenceProperty p, List<ReferenceSectionValue> list, EntityDefinition red, ReferenceSectionPropertyItem property) {
        if (!ReferenceSectionReferenceRegistHandler.canRegist(property)) {
            return;
        }
        ReferenceRegistOption option = null;
        if (this.currentEntity != null && (option = this.getRegistrationInterrupterHandler().getNestTableRegistOption(red, p.getName())).isSpecifyAllProperties() && !option.isSpecifiedAsReference() && option.getSpecifiedUpdateNestProperties().isEmpty()) {
            return;
        }
        ReferenceRegistHandler handler = ReferenceSectionReferenceRegistHandler.get(this, list, red, p, property, option);
        if (handler != null) {
            this.getReferenceRegistHandlers().add(handler);
        }
    }

    private boolean isEmpty(Entity entity) {
        for (PropertyDefinition pd : this.getPropertyList()) {
            Object[] obj;
            if (!(pd.getMultiplicity() != 1 ? (obj = (Object[])entity.getValue(pd.getName())) != null && obj.length > 0 : entity.getValue(pd.getName()) != null)) continue;
            return false;
        }
        return true;
    }

    private void setVirtualPropertyValue(Entity entity) {
        List<VirtualPropertyItem> virtualProperties = this.getVirtualProperty();
        for (VirtualPropertyItem property : virtualProperties) {
            PropertyDefinition p = EntityViewUtil.getPropertyDefinition(property);
            Object value = null;
            boolean isMultiple = p.getMultiplicity() != 1;
            String name = p.getName();
            if (p instanceof BooleanProperty) {
                value = isMultiple ? this.getBooleanValues(name, p.getMultiplicity()) : this.getBooleanValue(name);
            } else if (p instanceof DateProperty) {
                value = isMultiple ? this.getDateValues(name) : this.getDateValue(name);
            } else if (p instanceof DateTimeProperty) {
                value = isMultiple ? this.getTimestampValues(name) : this.getTimestampValue(name);
            } else if (p instanceof DecimalProperty) {
                value = isMultiple ? this.getDecimalValues(name) : this.getDecimalValue(name);
            } else if (p instanceof FloatProperty) {
                value = isMultiple ? this.getDoubleValues(name) : this.getDoubleValue(name);
            } else if (p instanceof IntegerProperty) {
                value = isMultiple ? this.getLongValues(name) : this.getLongValue(name);
            } else if (p instanceof SelectProperty) {
                value = isMultiple ? this.getSelectValues(name) : this.getSelectValue(name);
            } else if (p instanceof StringProperty) {
                value = isMultiple ? this.getStringValues(name) : this.getStringValue(name);
            } else if (p instanceof TimeProperty) {
                value = isMultiple ? this.getTimeValues(name) : this.getTimeValue(name);
            }
            entity.setValue(p.getName(), value);
        }
    }

    private List<VirtualPropertyItem> getVirtualProperty() {
        String execType = this.getExecType();
        ArrayList<VirtualPropertyItem> propList = new ArrayList<VirtualPropertyItem>();
        for (Section section : this.getView().getSections()) {
            if (!(section instanceof DefaultSection) || !EntityViewUtil.isDisplayElement(this.getDefinitionName(), section.getElementRuntimeId(), OutputType.EDIT, this.getDispControlBindEntity()) || ((DefaultSection)section).isHideDetail() || !ViewUtil.dispElement(execType, (Element)section)) continue;
            propList.addAll(this.getVirtualProperty((DefaultSection)section));
        }
        return propList;
    }

    private List<VirtualPropertyItem> getVirtualProperty(DefaultSection section) {
        String execType = this.getExecType();
        ArrayList<VirtualPropertyItem> propList = new ArrayList<VirtualPropertyItem>();
        for (Element elem : section.getElements()) {
            if (elem instanceof VirtualPropertyItem) {
                VirtualPropertyItem prop = (VirtualPropertyItem)elem;
                if (!EntityViewUtil.isDisplayElement(this.getDefinitionName(), prop.getElementRuntimeId(), OutputType.EDIT, this.getDispControlBindEntity()) || prop.isHideDetail() || !ViewUtil.dispElement(execType, (Element)prop)) continue;
                propList.add(prop);
                continue;
            }
            if (!(elem instanceof DefaultSection) || !EntityViewUtil.isDisplayElement(this.getDefinitionName(), elem.getElementRuntimeId(), OutputType.EDIT, this.getDispControlBindEntity()) || ((DefaultSection)elem).isHideDetail() || !ViewUtil.dispElement(execType, elem)) continue;
            propList.addAll(this.getVirtualProperty((DefaultSection)elem));
        }
        return propList;
    }

    private void setLabelablePropertyValue(Entity entity) {
        List<PropertyElement> excludeProperties = this.getExcludeLabelableProperty();
        for (PropertyElement element : excludeProperties) {
            entity.setValue("##labelValue_" + element.getPropertyName(), entity.getValue(element.getPropertyName()));
            entity.setValue(element.getPropertyName(), null);
        }
    }

    public void rollbackEntity(Entity entity) {
        List<PropertyElement> excludeProperties = this.getExcludeLabelableProperty();
        for (PropertyElement element : excludeProperties) {
            entity.setValue(element.getPropertyName(), entity.getValue("##labelValue_" + element.getPropertyName()));
            entity.setValue("##labelValue_" + element.getPropertyName(), null);
        }
    }

    private List<PropertyElement> getExcludeLabelableProperty() {
        if (this.excludeLabelableProperties != null) {
            return this.excludeLabelableProperties;
        }
        ArrayList<PropertyElement> excludeList = new ArrayList<PropertyElement>();
        for (Section section : this.getView().getSections()) {
            if (!(section instanceof DefaultSection)) continue;
            excludeList.addAll(this.getExcludeLabelableProperty((DefaultSection)section));
        }
        this.excludeLabelableProperties = excludeList;
        return this.excludeLabelableProperties;
    }

    private List<PropertyElement> getExcludeLabelableProperty(DefaultSection section) {
        String execType = this.getExecType();
        ArrayList<PropertyElement> excludeList = new ArrayList<PropertyElement>();
        if (EntityViewUtil.isDisplayElement(this.getDefinitionName(), section.getElementRuntimeId(), OutputType.EDIT, this.getDispControlBindEntity()) && !section.isHideDetail() && ViewUtil.dispElement(execType, (Element)section)) {
            boolean isInsert = this.currentEntity == null;
            for (Element element : section.getElements()) {
                LabelablePropertyEditor editor;
                Element prop;
                if (element instanceof DefaultSection) {
                    excludeList.addAll(this.getExcludeLabelableProperty((DefaultSection)element));
                    continue;
                }
                if (element instanceof PropertyItem) {
                    prop = (PropertyItem)element;
                    if (!(((PropertyBase)prop).getEditor() instanceof LabelablePropertyEditor)) continue;
                    editor = (LabelablePropertyEditor)((Object)((PropertyBase)prop).getEditor());
                    if (!isInsert || !editor.isLabel() || !EntityViewUtil.isDisplayElement(this.getDefinitionName(), prop.getElementRuntimeId(), OutputType.EDIT, this.getDispControlBindEntity()) || ((PropertyItem)prop).isHideDetail() || !ViewUtil.dispElement(execType, prop) || editor.isInsertWithLabelValue()) continue;
                    excludeList.add((PropertyElement)((Object)prop));
                    continue;
                }
                if (!(element instanceof VirtualPropertyItem) || !(((VirtualPropertyItem)(prop = (VirtualPropertyItem)element)).getEditor() instanceof LabelablePropertyEditor)) continue;
                editor = (LabelablePropertyEditor)((Object)((VirtualPropertyItem)prop).getEditor());
                if (!isInsert || !editor.isLabel() || !EntityViewUtil.isDisplayElement(this.getDefinitionName(), prop.getElementRuntimeId(), OutputType.EDIT, this.getDispControlBindEntity()) || ((VirtualPropertyItem)prop).isHideDetail() || !ViewUtil.dispElement(execType, prop) || editor.isInsertWithLabelValue()) continue;
                excludeList.add((PropertyElement)((Object)prop));
            }
        }
        return excludeList;
    }

    public boolean isUseUserPropertyEditor(boolean isDetail) {
        Set<String> propNameList = this.getUseUserPropertyEditorPropertyName(isDetail);
        return !propNameList.isEmpty();
    }

    public Set<String> getUseUserPropertyEditorPropertyName(boolean isDetail) {
        if (this.useUserPropertyEditorPropertyNameList != null) {
            return this.useUserPropertyEditorPropertyNameList;
        }
        this.useUserPropertyEditorPropertyNameList = new HashSet<String>();
        for (PropertyItem property : this.getDisplayProperty(isDetail)) {
            String propertyName = property.getPropertyName();
            if (property.getEditor() instanceof ReferencePropertyEditor) {
                ReferencePropertyEditor editor = (ReferencePropertyEditor)property.getEditor();
                if (editor.getNestProperties().isEmpty()) continue;
                Set<String> nest = this.getUseUserPropertyEditorNestPropertyName(editor);
                for (String nestPropertyName : nest) {
                    String _nestPropertyName = propertyName + "." + nestPropertyName;
                    this.useUserPropertyEditorPropertyNameList.add(_nestPropertyName);
                }
                continue;
            }
            if (!(property.getEditor() instanceof UserPropertyEditor)) continue;
            this.useUserPropertyEditorPropertyNameList.add(propertyName);
        }
        return this.useUserPropertyEditorPropertyNameList;
    }

    private Set<String> getUseUserPropertyEditorNestPropertyName(ReferencePropertyEditor editor) {
        HashSet<String> ret = new HashSet<String>();
        for (NestProperty property : editor.getNestProperties()) {
            if (property.getEditor() instanceof ReferencePropertyEditor) {
                ReferencePropertyEditor nestEditor = (ReferencePropertyEditor)property.getEditor();
                if (nestEditor.getNestProperties().isEmpty()) continue;
                Set<String> nest = this.getUseUserPropertyEditorNestPropertyName(nestEditor);
                for (String nestPropertyName : nest) {
                    String _nestPropertyName = property.getPropertyName() + "." + nestPropertyName;
                    ret.add(_nestPropertyName);
                }
                continue;
            }
            if (!(property.getEditor() instanceof UserPropertyEditor)) continue;
            ret.add(property.getPropertyName());
        }
        return ret;
    }

    protected void validate(Entity entity) {
        List<PropertyItem> properties = this.getDisplayProperty(true);
        for (PropertyItem property : properties) {
            PropertyEditor editor;
            if (property.getEditor() instanceof DateRangePropertyEditor) {
                editor = (DateRangePropertyEditor)property.getEditor();
                this.checkDateRange((DateRangePropertyEditor)editor, entity, property.getPropertyName(), ((DateRangePropertyEditor)editor).getToPropertyName(), "");
                continue;
            }
            if (property.getEditor() instanceof NumericRangePropertyEditor) {
                editor = (NumericRangePropertyEditor)property.getEditor();
                this.checkNumericRange((NumericRangePropertyEditor)editor, entity, property.getPropertyName(), ((NumericRangePropertyEditor)editor).getToPropertyName(), "");
                continue;
            }
            if (!(property.getEditor() instanceof ReferencePropertyEditor)) continue;
            editor = (ReferencePropertyEditor)property.getEditor();
            Object val = entity.getValue(property.getPropertyName());
            Entity[] ary = null;
            if (val != null) {
                if (val instanceof Entity) {
                    ary = new Entity[]{(Entity)val};
                } else if (val instanceof Entity[]) {
                    ary = (Entity[])val;
                }
            }
            if (((ReferencePropertyEditor)editor).getDisplayType() != ReferencePropertyEditor.ReferenceDisplayType.NESTTABLE || ary == null || ary.length <= 0 || ((ReferencePropertyEditor)editor).getNestProperties() == null || ((ReferencePropertyEditor)editor).getNestProperties().isEmpty()) continue;
            for (int i = 0; i < ary.length; ++i) {
                String errorPrefix = property.getPropertyName() + "[" + i + "].";
                for (NestProperty np : ((ReferencePropertyEditor)editor).getNestProperties()) {
                    CustomPropertyEditor de;
                    if (np.getEditor() instanceof DateRangePropertyEditor) {
                        de = (DateRangePropertyEditor)np.getEditor();
                        this.checkDateRange((DateRangePropertyEditor)de, ary[i], np.getPropertyName(), ((DateRangePropertyEditor)de).getToPropertyName(), errorPrefix);
                        continue;
                    }
                    if (!(np.getEditor() instanceof NumericRangePropertyEditor)) continue;
                    de = (NumericRangePropertyEditor)np.getEditor();
                    this.checkNumericRange((NumericRangePropertyEditor)de, ary[i], np.getPropertyName(), ((NumericRangePropertyEditor)de).getToPropertyName(), errorPrefix);
                }
            }
        }
    }

    private void checkDateRange(DateRangePropertyEditor editor, Entity entity, String fromName, String toName, String errorPrefix) {
        Date from = (Date)entity.getValue(fromName);
        Date to = (Date)entity.getValue(editor.getToPropertyName());
        if (from == null && to != null) {
            if (!editor.isInputNullFrom()) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.detail.DetailCommandContext.inputDateRangeErr");
            }
        } else if (from != null && to == null) {
            if (!editor.isInputNullTo()) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.detail.DetailCommandContext.inputDateRangeErr");
            }
        } else if (from != null && to != null) {
            boolean result = false;
            if (editor.isEquivalentInput()) {
                result = from.compareTo(to) > 0;
            } else {
                boolean bl = result = from.compareTo(to) >= 0;
            }
            if (result) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.detail.DetailCommandContext.invalidDateRange");
            }
        }
    }

    private void checkNumericRange(NumericRangePropertyEditor editor, Entity entity, String fromName, String toName, String errorPrefix) {
        Number from = (Number)entity.getValue(fromName);
        Number to = (Number)entity.getValue(editor.getToPropertyName());
        BigDecimal from_tmp = this.castNumericRangeNumber(from);
        BigDecimal to_tmp = this.castNumericRangeNumber(to);
        if (from_tmp == null && to_tmp != null) {
            if (!editor.isInputNullFrom()) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.detail.DetailCommandContext.inputNumericRangeErr");
            }
        } else if (from_tmp != null && to_tmp == null) {
            if (!editor.isInputNullTo()) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.detail.DetailCommandContext.inputNumericRangeErr");
            }
        } else if (from_tmp != null && to_tmp != null) {
            boolean result = false;
            if (editor.isEquivalentInput()) {
                result = from_tmp.compareTo(to_tmp) > 0;
            } else {
                boolean bl = result = from_tmp.compareTo(to_tmp) >= 0;
            }
            if (result) {
                this.setValidateErrorMessage(editor, fromName, errorPrefix, "command.generic.detail.DetailCommandContext.invalidNumericRange");
            }
        }
    }

    private BigDecimal castNumericRangeNumber(Number number) {
        if (number instanceof Double) {
            return new BigDecimal(number.doubleValue());
        }
        if (number instanceof Long) {
            return new BigDecimal(number.longValue());
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return null;
    }

    private void setValidateErrorMessage(RangePropertyEditor editor, String fromName, String errorPrefix, String resourceStringKey) {
        String errorMessage = TemplateUtil.getMultilingualString((String)editor.getErrorMessage(), editor.getLocalizedErrorMessageList());
        if (StringUtil.isBlank((String)errorMessage)) {
            errorMessage = DetailCommandContext.resourceString(resourceStringKey, new Object[0]);
        }
        ValidateError e = new ValidateError();
        e.setPropertyName(errorPrefix + fromName + "_" + editor.getToPropertyName());
        e.addErrorMessage(errorMessage);
        this.getErrors().add(e);
    }

    private List<PropertyItem> getDisplayProperty(boolean isDetail) {
        ArrayList<PropertyItem> propList = new ArrayList<PropertyItem>();
        String execType = this.getExecType();
        OutputType outputType = isDetail ? OutputType.EDIT : OutputType.VIEW;
        for (Section section : this.getView().getSections()) {
            if (!EntityViewUtil.isDisplayElement(this.getDefinitionName(), section.getElementRuntimeId(), outputType, this.getDispControlBindEntity())) continue;
            if (section instanceof DefaultSection) {
                DefaultSection ds = (DefaultSection)section;
                if ((!isDetail || ds.isHideDetail() || !ViewUtil.dispElement(execType, (Element)ds)) && (isDetail || ds.isHideView())) continue;
                propList.addAll(this.getDisplayProperty(ds, isDetail));
                continue;
            }
            if (!(section instanceof ReferenceSection)) continue;
            ReferenceSection rs = (ReferenceSection)section;
            if ((!isDetail || rs.isHideDetail() || !ViewUtil.dispElement(execType, (Element)rs)) && (isDetail || rs.isHideView())) continue;
            propList.add(this.getDisplayProperty(rs, outputType));
        }
        return propList;
    }

    private List<PropertyItem> getDisplayProperty(DefaultSection section, boolean isDetail) {
        ArrayList<PropertyItem> propList = new ArrayList<PropertyItem>();
        String execType = this.getExecType();
        OutputType outputType = isDetail ? OutputType.EDIT : OutputType.VIEW;
        for (Element elem : section.getElements()) {
            if (!EntityViewUtil.isDisplayElement(this.getDefinitionName(), elem.getElementRuntimeId(), outputType, this.getDispControlBindEntity())) continue;
            if (elem instanceof PropertyItem) {
                PropertyItem prop = (PropertyItem)elem;
                if ((!isDetail || prop.isHideDetail() || !ViewUtil.dispElement(execType, (Element)prop)) && (isDetail || prop.isHideView())) continue;
                if (prop.getEditor() instanceof JoinPropertyEditor) {
                    JoinPropertyEditor je = (JoinPropertyEditor)prop.getEditor();
                    for (NestProperty nest : je.getProperties()) {
                        PropertyItem dummy = new PropertyItem();
                        dummy.setDispFlag(true);
                        dummy.setPropertyName(nest.getPropertyName());
                        dummy.setEditor(nest.getEditor());
                        propList.add(dummy);
                    }
                }
                propList.add(prop);
                continue;
            }
            if (elem instanceof DefaultSection) {
                DefaultSection ds = (DefaultSection)elem;
                if ((!isDetail || ds.isHideDetail() || !ViewUtil.dispElement(execType, (Element)ds)) && (isDetail || ds.isHideView())) continue;
                propList.addAll(this.getDisplayProperty(ds, isDetail));
                continue;
            }
            if (!(elem instanceof ReferenceSection)) continue;
            ReferenceSection rs = (ReferenceSection)elem;
            if ((!isDetail || rs.isHideDetail() || !ViewUtil.dispElement(execType, (Element)rs)) && (isDetail || rs.isHideView())) continue;
            propList.add(this.getDisplayProperty(rs, outputType));
        }
        return propList;
    }

    private PropertyItem getDisplayProperty(ReferenceSection section, OutputType outputType) {
        PropertyItem property = new PropertyItem();
        property.setPropertyName(section.getPropertyName());
        property.setDispFlag(EntityViewUtil.isDisplayElement(this.getDefinitionName(), section.getElementRuntimeId(), outputType, this.getDispControlBindEntity()));
        ReferencePropertyEditor editor = new ReferencePropertyEditor();
        editor.setDisplayType(ReferencePropertyEditor.ReferenceDisplayType.NESTTABLE);
        editor.setObjectName(section.getDefintionName());
        editor.setNestProperties(section.getProperties());
        property.setEditor(editor);
        return property;
    }

    public boolean isShallowCopyLobData() {
        return this.gemConfig.isShallowCopyLobData();
    }

    @Override
    public void fireShowDetailViewEvent(DetailFormViewData detailFormViewData) {
        ShowDetailLayoutViewEvent event = new ShowDetailLayoutViewEvent(this.getRequest(), this.getDefinitionName(), this.getViewName(), detailFormViewData);
        for (DetailFormViewHandler handler : this.getDetailFormViewHandlers()) {
            handler.onShowDetailView(event);
        }
    }

    @Override
    public void fireShowEditViewEvent(DetailFormViewData detailFormViewData) {
        ShowDetailLayoutViewEvent event = new ShowDetailLayoutViewEvent(this.getRequest(), this.getDefinitionName(), this.getViewName(), detailFormViewData);
        for (DetailFormViewHandler handler : this.getDetailFormViewHandlers()) {
            handler.onShowEditView(event);
        }
    }

    private List<DetailFormViewHandler> getDetailFormViewHandlers() {
        if (this.detailFormViewHandlers == null) {
            this.detailFormViewHandlers = new ArrayList<DetailFormViewHandler>();
            if (this.getView().getDetailFormViewHandlerName() != null) {
                for (String handlerClassName : this.getView().getDetailFormViewHandlerName()) {
                    this.detailFormViewHandlers.add(this.createDetailFormViewHandler(handlerClassName));
                }
            }
            if (this.getView().isCheckEntityPermissionLimitConditionOfButton()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("add CheckPermissionLimitConditionOfButtonHandler to the first of detail form view handler.");
                }
                this.detailFormViewHandlers.add(0, new CheckPermissionLimitConditionOfButtonHandler());
            }
        }
        return this.detailFormViewHandlers;
    }

    private DetailFormViewHandler createDetailFormViewHandler(String handlerClassName) {
        DetailFormViewHandler handler = null;
        if (StringUtil.isNotEmpty((String)handlerClassName)) {
            if (logger.isDebugEnabled()) {
                logger.debug("create detail form view handler. class=" + handlerClassName);
            }
            try {
                handler = (DetailFormViewHandler)this.ucdm.createInstanceAs(DetailFormViewHandler.class, handlerClassName);
            }
            catch (ClassNotFoundException e) {
                logger.error(handlerClassName + " can not instantiate.", (Throwable)e);
                throw new EntityRuntimeException(DetailCommandContext.resourceString("command.generic.detail.DetailCommandContext.internalErr", new Object[0]));
            }
        }
        return handler;
    }

    public class ReferenceSectionValue {
        private Integer index;
        private Entity entity;
        private ReferenceSection section;

        public Integer getIndex() {
            return this.index;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public void setEntity(Entity entity) {
            this.entity = entity;
        }

        public ReferenceSection getSection() {
            return this.section;
        }
    }

    public class ReferenceSectionPropertyItem
    extends PropertyItem {
        private static final long serialVersionUID = -2527968770756351039L;
        private List<ReferenceSection> sections = new ArrayList<ReferenceSection>();

        public List<ReferenceSection> getSections() {
            return this.sections;
        }

        public ReferenceSection getFirstSection() {
            return this.sections.size() > 0 ? this.sections.get(0) : null;
        }

        public ReferenceSection getSection(int index) {
            Optional<ReferenceSection> ret = this.sections.stream().filter(s -> s.getIndex() == index).findFirst();
            if (ret.isPresent()) {
                return ret.get();
            }
            return null;
        }

        @Override
        public boolean isDispFlag() {
            for (ReferenceSection section : this.sections) {
                if (EntityViewUtil.isDisplayElement(DetailCommandContext.this.getDefinitionName(), section.getElementRuntimeId(), OutputType.EDIT, DetailCommandContext.this.getDispControlBindEntity())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isHideDetail() {
            for (ReferenceSection section : this.sections) {
                if (section.isHideDetail()) continue;
                return false;
            }
            return true;
        }
    }
}

