/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.detail;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.iplass.gem.command.generic.HasDisplayScriptBindings;
import org.iplass.gem.command.generic.detail.DetailCommandBase;
import org.iplass.gem.command.generic.detail.DetailCommandContext;
import org.iplass.gem.command.generic.detail.LoadEntityInterrupterHandler;
import org.iplass.gem.command.generic.search.ResponseUtil;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.DetailFormView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.NullOrderType;
import org.iplass.mtp.view.generic.OutputType;
import org.iplass.mtp.view.generic.SearchQueryContext;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.RangePropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.editor.UserPropertyEditor;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.section.DefaultSection;
import org.iplass.mtp.view.generic.element.section.MassReferenceSection;
import org.iplass.mtp.view.generic.element.section.Section;
import org.iplass.mtp.view.generic.element.section.SortSetting;
import org.iplass.mtp.web.template.TemplateUtil;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/generic/detail/getMassReference", displayName="\u5927\u898f\u6a21\u53c2\u7167\u30d7\u30ed\u30d1\u30c6\u30a3\u691c\u7d22", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"dispInfo", "count", "htmlData"}, checkXRequestedWithHeader=true)
@CommandClass(name="gem/generic/detail/GetMassReferencesCommand", displayName="\u53c2\u7167\u30d7\u30ed\u30d1\u30c6\u30a3\u691c\u7d22")
public final class GetMassReferencesCommand
extends DetailCommandBase
implements HasDisplayScriptBindings {
    public static final String WEBAPI_NAME = "gem/generic/detail/getMassReference";
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);

    public String execute(RequestContext request) {
        DetailCommandContext context = this.getContext(request);
        String defName = context.getDefinitionName();
        String propName = request.getParam("propName");
        String viewName = request.getParam("viewName");
        String sortKey = request.getParam("sortKey");
        String sortType = request.getParam("sortType");
        String offsetStr = request.getParam("offset");
        String isCount = request.getParam("isCount");
        String outputTypeStr = request.getParam("outputType");
        String elementId = request.getParam("elementId");
        int offset = 0;
        try {
            offset = Integer.parseInt(offsetStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        OutputType outputType = OutputType.valueOf(outputTypeStr);
        PropertyDefinition pd = context.getProperty(propName);
        if (pd instanceof ReferenceProperty) {
            ReferenceProperty rp = (ReferenceProperty)pd;
            Entity entity = this.getBindingEntity(request);
            List<MassReferenceSection> sections = this.getMassReferenceSection(context.getEntityDefinition(), outputType, context.getView(), context.getViewName(), entity);
            MassReferenceSection section = null;
            if (StringUtil.isNotEmpty((String)elementId)) {
                for (MassReferenceSection _section : sections) {
                    if (!elementId.equals(_section.getElementRuntimeId())) continue;
                    if (!_section.getPropertyName().equals(rp.getName())) break;
                    section = _section;
                    break;
                }
            } else {
                for (MassReferenceSection _section : sections) {
                    if (!_section.getPropertyName().equals(rp.getName())) continue;
                    section = _section;
                    break;
                }
            }
            if (section != null) {
                Condition filterCond;
                ArrayList<String> props = new ArrayList<String>();
                props.add("oid");
                props.add("name");
                props.add("version");
                ArrayList<DisplayInfo> dispInfo = new ArrayList<DisplayInfo>();
                EntityDefinition red = this.edm.get(rp.getObjectDefinitionName());
                for (NestProperty np : section.getProperties()) {
                    if (OutputType.EDIT != outputType ? OutputType.VIEW == outputType && np.isHideView() : np.isHideDetail()) continue;
                    PropertyDefinition rpd = red.getProperty(np.getPropertyName());
                    if (rpd instanceof ReferenceProperty) {
                        this.addReferenceProperty(props, dispInfo, (ReferenceProperty)rpd, np, null, outputType);
                        continue;
                    }
                    if (!props.contains(np.getPropertyName())) {
                        props.add(np.getPropertyName());
                        if (np.getEditor() instanceof RangePropertyEditor) {
                            RangePropertyEditor rpe = (RangePropertyEditor)((Object)np.getEditor());
                            props.add(rpe.getToPropertyName());
                        }
                    }
                    DisplayInfo di = new DisplayInfo();
                    di.setName(np.getPropertyName());
                    if (StringUtil.isNotBlank((String)np.getDisplayLabel())) {
                        di.setDisplayName(TemplateUtil.getMultilingualString((String)np.getDisplayLabel(), np.getLocalizedDisplayLabelList()));
                    } else {
                        di.setDisplayName(TemplateUtil.getMultilingualString((String)rpd.getDisplayName(), (List)rpd.getLocalizedDisplayNameList()));
                    }
                    di.setWidth(np.getWidth());
                    if (np.getEditor() != null && np.getEditor().isHide()) {
                        di.setHide(true);
                    } else {
                        di.setHide(false);
                    }
                    dispInfo.add(di);
                }
                request.setAttribute("dispInfo", dispInfo);
                Query query = new Query();
                query.select(props.toArray());
                query.from(rp.getObjectDefinitionName());
                And cond = new And(new Condition[]{new Equals(rp.getMappedBy() + ".oid", (Object)context.getOid())});
                if (StringUtil.isNotBlank((String)section.getFilterConditionScript()) && (filterCond = this.evm.getMassReferenceSectionCondition(defName, section)) != null) {
                    cond.addExpression(filterCond);
                }
                query.where((Condition)cond);
                if (!section.isHidePaging()) {
                    int limit;
                    if ("true".equals(isCount)) {
                        int count = this.countEntity(context.getLoadEntityInterrupterHandler(), query, rp, section, outputType);
                        request.setAttribute("count", (Object)count);
                    }
                    if ((limit = section.getLimit()) == 0) {
                        limit = 10;
                    }
                    query.limit(limit, offset);
                }
                OrderBy orderBy = this.getOrderBy(section, red, sortKey, sortType);
                query.setOrderBy(orderBy);
                Set<String> userNameProperties = this.getUseUserPropertyEditorPropertyName(section.getProperties(), OutputType.EDIT == outputType);
                ArrayList<String> userOids = new ArrayList<String>();
                List<Entity> entityList = this.search(context.getLoadEntityInterrupterHandler(), query, rp, section, outputType, userNameProperties, userOids);
                if (!userOids.isEmpty()) {
                    this.setUserInfoMap(context, userOids);
                }
                try {
                    this.getHtmlData(request, defName, viewName, propName, rp, section.getProperties(), entityList, outputType);
                }
                catch (IOException e) {
                    throw new SystemException((Throwable)e);
                }
                catch (ServletException e) {
                    throw new SystemException((Throwable)e);
                }
            }
        }
        return null;
    }

    private OrderBy getOrderBy(MassReferenceSection section, EntityDefinition red, String sortKey, String sortType) {
        OrderBy orderBy = new OrderBy();
        HashSet<String> addNames = new HashSet<String>();
        if (StringUtil.isNotEmpty((String)sortKey)) {
            String key = this.getSortKey(section, red, sortKey);
            orderBy.add(new SortSpec(key, this.getSortType(sortType)));
            addNames.add(key);
        }
        if (!section.getSortSetting().isEmpty()) {
            List<SortSetting> setting = section.getSortSetting();
            for (SortSetting ss : setting) {
                String key;
                if (ss.getSortKey() == null || addNames.contains(key = this.getSortSettingKey(section, red, ss.getSortKey()))) continue;
                orderBy.add((Object)key, this.getSortType(ss.getSortType().name()), this.getNullOrderingSpec(ss.getNullOrderType()));
                addNames.add(key);
            }
        }
        if (orderBy.getSortSpecList().isEmpty()) {
            orderBy.add(new SortSpec(this.getSortKey(section, red, null), this.getSortType(null)));
        }
        return orderBy;
    }

    private String getSortKey(MassReferenceSection section, EntityDefinition ed, String sortKey) {
        String ret = sortKey;
        if (StringUtil.isBlank((String)sortKey)) {
            return "oid";
        }
        NestProperty property = this.getLayoutNestProperty(section, sortKey);
        if (property == null) {
            return "oid";
        }
        PropertyDefinition pd = ed.getProperty(ret);
        if (pd == null) {
            ret = "oid";
            pd = ed.getProperty(ret);
        }
        if (pd instanceof ReferenceProperty && property != null) {
            ret = sortKey + "." + this.getDisplayNestProperty(property);
        }
        return ret;
    }

    private String getSortSettingKey(MassReferenceSection section, EntityDefinition ed, String sortKey) {
        PropertyDefinition pd;
        String ret = sortKey;
        if (StringUtil.isBlank((String)ret)) {
            ret = "oid";
        }
        if ((pd = ed.getProperty(ret)) == null) {
            ret = "oid";
            pd = ed.getProperty(ret);
        }
        if (pd instanceof ReferenceProperty) {
            NestProperty property = this.getLayoutNestProperty(section, sortKey);
            ret = property != null ? sortKey + "." + this.getDisplayNestProperty(property) : sortKey + "." + "name";
        }
        return ret;
    }

    private SortSpec.SortType getSortType(String sortType) {
        if (StringUtil.isBlank((String)sortType)) {
            return SortSpec.SortType.DESC;
        }
        return SortSpec.SortType.valueOf((String)sortType);
    }

    private SortSpec.NullOrderingSpec getNullOrderingSpec(NullOrderType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case FIRST: {
                return SortSpec.NullOrderingSpec.FIRST;
            }
            case LAST: {
                return SortSpec.NullOrderingSpec.LAST;
            }
        }
        return null;
    }

    private int countEntity(LoadEntityInterrupterHandler handler, Query query, ReferenceProperty rp, MassReferenceSection section, OutputType outputType) {
        SearchQueryContext sqContext = handler.beforeSearchMassReference(query.copy(), rp, section, outputType);
        Integer count = null;
        count = sqContext.isDoPrivileged() ? (Integer)AuthContext.doPrivileged(() -> this.em.count(sqContext.getQuery())) : (sqContext.getWithoutConditionReferenceName() != null ? (Integer)EntityPermission.doQueryAs((String[])sqContext.getWithoutConditionReferenceName(), () -> this.em.count(sqContext.getQuery())) : Integer.valueOf(this.em.count(sqContext.getQuery())));
        return count;
    }

    private List<Entity> search(LoadEntityInterrupterHandler handler, Query query, ReferenceProperty rp, MassReferenceSection section, OutputType outputType, Set<String> userNameProperties, List<String> userOids) {
        SearchQueryContext sqContext = handler.beforeSearchMassReference(query.copy(), rp, section, outputType);
        List result = null;
        result = sqContext.isDoPrivileged() ? (List)AuthContext.doPrivileged(() -> this.searchEntity(handler, sqContext.getQuery(), rp, section, outputType, userNameProperties, userOids)) : (sqContext.getWithoutConditionReferenceName() != null ? (List)EntityPermission.doQueryAs((String[])sqContext.getWithoutConditionReferenceName(), () -> this.searchEntity(handler, sqContext.getQuery(), rp, section, outputType, userNameProperties, userOids)) : this.searchEntity(handler, sqContext.getQuery(), rp, section, outputType, userNameProperties, userOids));
        return result;
    }

    private List<Entity> searchEntity(LoadEntityInterrupterHandler handler, Query query, ReferenceProperty rp, MassReferenceSection section, OutputType outputType, Set<String> userNameProperties, List<String> userOids) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        this.em.searchEntity(query, entity -> {
            handler.afterSearchMassReference(query, rp, section, (Entity)entity, outputType);
            for (String propertyName : userNameProperties) {
                String oid = (String)entity.getValue(propertyName);
                if (oid == null || userOids.contains(oid)) continue;
                userOids.add(oid);
            }
            result.add((Entity)entity);
            return true;
        });
        return result;
    }

    private void getHtmlData(RequestContext request, final String defName, final String viewName, String propName, ReferenceProperty rp, List<NestProperty> props, List<Entity> result, OutputType outputType) throws IOException, ServletException {
        final EntityDefinition ed = this.edm.get(rp.getObjectDefinitionName());
        String editorPrefix = propName + ".";
        ArrayList<Map<String, String>> ret = new ArrayList<Map<String, String>>();
        for (final Entity entity : result) {
            final LinkedHashMap<String, String> eval = new LinkedHashMap<String, String>();
            eval.put("orgOid", entity.getOid());
            eval.put("orgVersion", entity.getVersion().toString());
            for (NestProperty property : props) {
                PropertyEditor editor;
                String path;
                final PropertyDefinition pd = ed.getProperty(property.getPropertyName());
                if (!this.isDispProperty(pd, property, outputType) || (path = EntityViewUtil.getJspPath(editor = property.getEditor(), "gem")) == null) continue;
                final Object propValue = entity.getValue(property.getPropertyName());
                ResponseUtil.Func beforeFunc = new ResponseUtil.Func(){

                    @Override
                    public void execute(HttpServletRequest req, HttpServletResponse res) {
                        req.setAttribute("outputType", (Object)OutputType.SEARCHRESULT);
                        req.setAttribute("editor", (Object)editor);
                        req.setAttribute("value", (Object)entity);
                        req.setAttribute("propValue", propValue);
                        req.setAttribute("entityDefinition", (Object)ed);
                        req.setAttribute("propertyDefinition", (Object)pd);
                        req.setAttribute("entityValueMap", (Object)eval);
                        req.setAttribute("viewName", (Object)viewName);
                        req.setAttribute("rootDefName", (Object)defName);
                        req.setAttribute("viewType", (Object)"detail");
                    }
                };
                ResponseUtil.Func afterFunc = new ResponseUtil.Func(){

                    @Override
                    public void execute(HttpServletRequest req, HttpServletResponse res) {
                        req.removeAttribute("outputType");
                        req.removeAttribute("editor");
                        req.removeAttribute("value");
                        req.removeAttribute("propValue");
                        req.removeAttribute("entityDefinition");
                        req.removeAttribute("propertyDefinition");
                        req.removeAttribute("viewName");
                        req.removeAttribute("rootDefName");
                        req.removeAttribute("viewType");
                    }
                };
                if (property.getEditor() instanceof RangePropertyEditor) {
                    property.getEditor().setPropertyName(property.getPropertyName());
                } else {
                    property.getEditor().setPropertyName(editorPrefix + property.getPropertyName());
                }
                String html = ResponseUtil.getIncludeJspContents(path, beforeFunc, afterFunc).replace("\r\n", "").replace("\n", "").replace("\r", "");
                WebRequestStack stack = WebRequestStack.getCurrent();
                HttpServletRequest req = stack.getRequest();
                Boolean isNest = (Boolean)req.getAttribute("nest_" + editorPrefix + property.getPropertyName());
                if (isNest != null && isNest.booleanValue()) {
                    eval.put(property.getPropertyName() + ".name", html);
                    continue;
                }
                eval.put(property.getPropertyName(), html);
            }
            Map<String, String> ajustData = eval.entrySet().stream().collect(Collectors.toMap(e -> {
                if (((String)e.getKey()).startsWith(editorPrefix)) {
                    return ((String)e.getKey()).substring(editorPrefix.length());
                }
                return (String)e.getKey();
            }, Map.Entry::getValue));
            ret.add(ajustData);
        }
        request.setAttribute("htmlData", ret);
    }

    private boolean isDispProperty(PropertyDefinition pd, NestProperty property, OutputType outputType) {
        if (property.getEditor() == null) {
            return false;
        }
        return !(OutputType.EDIT == outputType ? property.isHideDetail() : OutputType.VIEW == outputType && property.isHideView());
    }

    private List<MassReferenceSection> getMassReferenceSection(EntityDefinition ed, OutputType outputType, DetailFormView view, String viewName, Entity entity) {
        ArrayList<MassReferenceSection> sections = new ArrayList<MassReferenceSection>();
        for (Section section : view.getSections()) {
            if (section instanceof DefaultSection && EntityViewUtil.isDisplayElement(ed.getName(), section.getElementRuntimeId(), outputType, entity)) {
                sections.addAll(this.getMassReferenceSection(ed, outputType, (DefaultSection)section, entity));
                continue;
            }
            if (!(section instanceof MassReferenceSection)) continue;
            sections.add((MassReferenceSection)section);
        }
        return sections;
    }

    private List<MassReferenceSection> getMassReferenceSection(EntityDefinition ed, OutputType outputType, DefaultSection section, Entity entity) {
        ArrayList<MassReferenceSection> sections = new ArrayList<MassReferenceSection>();
        for (Element elem : section.getElements()) {
            if (elem instanceof MassReferenceSection) {
                MassReferenceSection _section = (MassReferenceSection)elem;
                if (!EntityViewUtil.isDisplayElement(ed.getName(), _section.getElementRuntimeId(), outputType, entity)) continue;
                sections.add(_section);
                continue;
            }
            if (!(elem instanceof DefaultSection)) continue;
            sections.addAll(this.getMassReferenceSection(ed, outputType, (DefaultSection)elem, entity));
        }
        return sections;
    }

    private void addReferenceProperty(List<String> select, List<DisplayInfo> dispInfo, ReferenceProperty rp, NestProperty np, String parent, OutputType outputType) {
        boolean hasNest = false;
        List<NestProperty> nest = null;
        String dispLabelItem = null;
        if (np.getEditor() instanceof ReferencePropertyEditor) {
            ReferencePropertyEditor rpe = (ReferencePropertyEditor)np.getEditor();
            nest = rpe.getNestProperties();
            hasNest = !nest.isEmpty();
            dispLabelItem = rpe.getDisplayLabelItem();
        }
        String name = null;
        name = StringUtil.isNotBlank((String)parent) ? parent + "." + np.getPropertyName() : np.getPropertyName();
        if (!select.contains(name + "." + "name")) {
            select.add(name + "." + "name");
        }
        if (!select.contains(name + "." + "oid")) {
            select.add(name + "." + "oid");
        }
        if (!select.contains(name + "." + "version")) {
            select.add(name + "." + "version");
        }
        if (dispLabelItem != null && !select.contains(name + "." + dispLabelItem)) {
            select.add(name + "." + dispLabelItem);
        }
        if (hasNest) {
            EntityDefinition red = this.getReferenceEntityDefinition(rp);
            for (NestProperty _np : nest) {
                if (OutputType.EDIT != outputType ? OutputType.VIEW == outputType && _np.isHideView() : _np.isHideDetail()) continue;
                PropertyDefinition rpd = red.getProperty(_np.getPropertyName());
                if (rpd instanceof ReferenceProperty) {
                    this.addReferenceProperty(select, dispInfo, (ReferenceProperty)rpd, _np, name, outputType);
                    continue;
                }
                if (!select.contains(name + "." + _np.getPropertyName())) {
                    select.add(name + "." + _np.getPropertyName());
                    if (_np.getEditor() instanceof RangePropertyEditor) {
                        RangePropertyEditor rpe = (RangePropertyEditor)((Object)_np.getEditor());
                        select.add(name + "." + rpe.getToPropertyName());
                    }
                }
                DisplayInfo di = new DisplayInfo();
                di.setName(name + "." + _np.getPropertyName());
                if (StringUtil.isNotBlank((String)_np.getDisplayLabel())) {
                    di.setDisplayName(TemplateUtil.getMultilingualString((String)_np.getDisplayLabel(), _np.getLocalizedDisplayLabelList()));
                } else {
                    di.setDisplayName(TemplateUtil.getMultilingualString((String)rpd.getDisplayName(), (List)rpd.getLocalizedDisplayNameList()));
                }
                di.setWidth(_np.getWidth());
                if (_np.getEditor() != null && _np.getEditor().isHide()) {
                    di.setHide(true);
                } else {
                    di.setHide(false);
                }
                dispInfo.add(di);
            }
        } else {
            DisplayInfo di = new DisplayInfo();
            di.setName(name);
            if (StringUtil.isNotBlank((String)np.getDisplayLabel())) {
                di.setDisplayName(TemplateUtil.getMultilingualString((String)np.getDisplayLabel(), np.getLocalizedDisplayLabelList()));
            } else {
                di.setDisplayName(TemplateUtil.getMultilingualString((String)rp.getDisplayName(), (List)rp.getLocalizedDisplayNameList()));
            }
            di.setWidth(np.getWidth());
            if (np.getEditor() != null && np.getEditor().isHide()) {
                di.setHide(true);
            } else {
                di.setHide(false);
            }
            dispInfo.add(di);
        }
    }

    private EntityDefinition getReferenceEntityDefinition(ReferenceProperty pd) {
        EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
        return edm.get(pd.getObjectDefinitionName());
    }

    private Set<String> getUseUserPropertyEditorPropertyName(List<NestProperty> nestProperties, boolean isDetail) {
        HashSet<String> ret = new HashSet<String>();
        for (NestProperty property : nestProperties) {
            if (isDetail && property.isHideDetail() || !isDetail && property.isHideView()) continue;
            String propertyName = property.getPropertyName();
            if (property.getEditor() instanceof ReferencePropertyEditor) {
                ReferencePropertyEditor editor = (ReferencePropertyEditor)property.getEditor();
                if (editor.getNestProperties().isEmpty()) continue;
                Set<String> nest = this.getUseUserPropertyEditorPropertyName(editor.getNestProperties(), isDetail);
                for (String nestPropertyName : nest) {
                    String _nestPropertyName = propertyName + "." + nestPropertyName;
                    ret.add(_nestPropertyName);
                }
                continue;
            }
            if (!(property.getEditor() instanceof UserPropertyEditor)) continue;
            ret.add(propertyName);
        }
        return ret;
    }

    private void setUserInfoMap(DetailCommandContext context, List<String> userOidList) {
        final HashMap userMap = new HashMap();
        Query q = new Query().select(new Object[]{"oid", "name"}).from("mtp.auth.User").where((Condition)new In("oid", userOidList.toArray()));
        if (context.getView().isShowUserNameWithPrivilegedValue()) {
            AuthContext.doPrivileged(() -> this.em.searchEntity(q, (Predicate)new Predicate<Entity>(){

                @Override
                public boolean test(Entity dataModel) {
                    if (!userMap.containsKey(dataModel.getOid())) {
                        userMap.put(dataModel.getOid(), dataModel);
                    }
                    return true;
                }
            }));
        } else {
            this.em.searchEntity(q, (Predicate)new Predicate<Entity>(){

                @Override
                public boolean test(Entity dataModel) {
                    if (!userMap.containsKey(dataModel.getOid())) {
                        userMap.put(dataModel.getOid(), dataModel);
                    }
                    return true;
                }
            });
        }
        context.setAttribute("userInfoMap", userMap);
    }

    private NestProperty getLayoutNestProperty(MassReferenceSection section, String propName) {
        Optional<NestProperty> property = section.getProperties().stream().filter(e -> propName.equals(e.getPropertyName())).findFirst();
        if (property.isPresent()) {
            return property.get();
        }
        return null;
    }

    private String getDisplayNestProperty(NestProperty refProp) {
        PropertyEditor editor = refProp.getEditor();
        if (editor instanceof ReferencePropertyEditor && StringUtil.isNotEmpty((String)((ReferencePropertyEditor)editor).getDisplayLabelItem())) {
            return ((ReferencePropertyEditor)editor).getDisplayLabelItem();
        }
        return "name";
    }

    public static class DisplayInfo {
        private String name;
        private String displayName;
        private int width;
        private boolean hide;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public boolean isHide() {
            return this.hide;
        }

        public void setHide(boolean hide) {
            this.hide = hide;
        }
    }
}

