/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.detail;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.iplass.gem.command.generic.detail.DetailCommandContext;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.editor.DateRangePropertyEditor;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/generic/detail/getNestTableData", displayName="Entity\u30c7\u30fc\u30bf\u53d6\u5f97", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"data"}, checkXRequestedWithHeader=true)
@CommandClass(name="gem/generic/detail/GetNestTableDataCommand", displayName="NestTable\u30c7\u30fc\u30bf\u53d6\u5f97")
public final class GetNestTableDataCommand
implements Command {
    public static final String WEBAPI_NAME = "gem/generic/detail/getNestTableData";
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);

    public String execute(RequestContext request) {
        DetailCommandContext context = new DetailCommandContext(request, this.em, this.edm);
        context.setEntityDefinition(this.edm.get(context.getDefinitionName()));
        context.setEntityView((EntityView)this.evm.get(context.getDefinitionName()));
        if (context.getView() == null) {
            return "ERROR_VIEW";
        }
        String propName = request.getParam("propName");
        PropertyItem property = this.getProperty(context, propName);
        if (property == null) {
            return "ERROR_VIEW";
        }
        PropertyDefinition pd = context.getProperty(property.getPropertyName());
        if (pd == null || !(pd instanceof ReferenceProperty)) {
            return "ERROR_VIEW";
        }
        ReferenceProperty rp = (ReferenceProperty)pd;
        ArrayList<String> nestDispLabelProps = new ArrayList<String>();
        List<String> properties = this.getNestProperty(context, property, rp, nestDispLabelProps);
        String targetDefName = rp.getObjectDefinitionName();
        String oid = request.getParam("oid");
        Query query = new Query().select(properties.toArray()).from(targetDefName).where((Condition)new Equals("oid", (Object)oid));
        Entity entity = (Entity)this.em.searchEntity(query).getFirst();
        this.replaceNestPropOutputName(entity, nestDispLabelProps);
        request.setAttribute("data", (Object)entity);
        return "SUCCESS";
    }

    private List<String> getNestProperty(DetailCommandContext context, PropertyItem property, ReferenceProperty rp, List<String> nestDispLabelProps) {
        ReferencePropertyEditor rpe = (ReferencePropertyEditor)property.getEditor();
        if (!(property.getEditor() instanceof ReferencePropertyEditor)) {
            return null;
        }
        if (rpe.getDisplayType() != ReferencePropertyEditor.ReferenceDisplayType.NESTTABLE) {
            return null;
        }
        if (rpe.getNestProperties().isEmpty()) {
            return null;
        }
        ArrayList<String> propNames = new ArrayList<String>();
        propNames.add("oid");
        propNames.add("version");
        rpe.getNestProperties().stream().filter(np -> this.isDispProperty(context, rp, (NestProperty)np)).forEach(np -> {
            if (np.getEditor() instanceof ReferencePropertyEditor) {
                String displayLabelProp;
                if (!propNames.contains(np.getPropertyName() + "." + "oid")) {
                    propNames.add(np.getPropertyName() + "." + "oid");
                }
                if (!propNames.contains(np.getPropertyName() + "." + "name")) {
                    propNames.add(np.getPropertyName() + "." + "name");
                }
                if (!propNames.contains(np.getPropertyName() + "." + "version")) {
                    propNames.add(np.getPropertyName() + "." + "version");
                }
                if ((displayLabelProp = ((ReferencePropertyEditor)np.getEditor()).getDisplayLabelItem()) != null && !propNames.contains(np.getPropertyName() + "." + displayLabelProp)) {
                    propNames.add(np.getPropertyName() + "." + displayLabelProp);
                    nestDispLabelProps.add(np.getPropertyName() + "." + displayLabelProp);
                }
            } else if (np.getEditor() instanceof DateRangePropertyEditor) {
                DateRangePropertyEditor editor = (DateRangePropertyEditor)np.getEditor();
                if (!propNames.contains(np.getPropertyName())) {
                    propNames.add(np.getPropertyName());
                }
                if (!propNames.contains(editor.getToPropertyName())) {
                    propNames.add(editor.getToPropertyName());
                }
            } else if (!propNames.contains(np.getPropertyName())) {
                propNames.add(np.getPropertyName());
            }
        });
        return propNames;
    }

    private PropertyItem getProperty(DetailCommandContext context, String propName) {
        Optional<PropertyItem> property = context.getProperty().stream().filter(pi -> propName.equals(pi.getPropertyName())).findFirst();
        if (property.isPresent()) {
            return property.get();
        }
        return null;
    }

    private boolean isDispProperty(DetailCommandContext context, ReferenceProperty rp, NestProperty np) {
        if (np.isHideDetail()) {
            return false;
        }
        if (np.getEditor() == null) {
            return false;
        }
        String propName = rp.getName() + "." + np.getPropertyName();
        PropertyDefinition pd = EntityViewUtil.getPropertyDefinition(propName, context.getEntityDefinition());
        if (pd == null) {
            return false;
        }
        if (pd.getMultiplicity() != 1) {
            return false;
        }
        return !(pd instanceof ReferenceProperty) || rp.getMappedBy() == null || !pd.getName().equals(rp.getMappedBy());
    }

    private void replaceNestPropOutputName(Entity entity, List<String> nestDisplayLabelProps) {
        if (entity == null || nestDisplayLabelProps == null || nestDisplayLabelProps.isEmpty()) {
            return;
        }
        for (String displayLabelProp : nestDisplayLabelProps) {
            String currentPropName = displayLabelProp.substring(0, displayLabelProp.indexOf("."));
            String subPropName = displayLabelProp.substring(displayLabelProp.indexOf(".") + 1);
            if ("name".equals(subPropName)) continue;
            entity.setValue(currentPropName + "." + "name", entity.getValue(displayLabelProp));
            entity.setValue(displayLabelProp, null);
        }
    }
}

