/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.detail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.iplass.gem.command.generic.detail.ReferenceRegistHandler;
import org.iplass.gem.command.generic.detail.ReferenceRegistHandlerBase;
import org.iplass.gem.command.generic.detail.ReferenceRegistHandlerFunction;
import org.iplass.gem.command.generic.detail.ReferenceRegistOption;
import org.iplass.gem.command.generic.detail.RegistrationCommandContext;
import org.iplass.gem.command.generic.detail.RegistrationPropertyBaseHandler;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceType;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.element.property.PropertyBase;

public abstract class NestTableReferenceRegistHandler
extends ReferenceRegistHandlerBase {
    protected List<Entity> references;

    public static boolean canRegist(PropertyBase property, RegistrationPropertyBaseHandler propBaseHandler) {
        if (!propBaseHandler.isDispProperty(property)) {
            return false;
        }
        if (!(propBaseHandler.getEditor(property) instanceof ReferencePropertyEditor)) {
            return false;
        }
        ReferencePropertyEditor editor = (ReferencePropertyEditor)propBaseHandler.getEditor(property);
        if (editor.getDisplayType() != ReferencePropertyEditor.ReferenceDisplayType.NESTTABLE) {
            return false;
        }
        return editor.getEditPage() != ReferencePropertyEditor.EditPage.VIEW;
    }

    public static ReferenceRegistHandler get(RegistrationCommandContext context, List<Entity> refs, EntityDefinition ed, ReferenceProperty rp, PropertyBase property, List<NestProperty> nestProperties, RegistrationPropertyBaseHandler propBaseHandler) {
        return NestTableReferenceRegistHandler.getInternal(context, refs, ed, rp, property, nestProperties, propBaseHandler, null);
    }

    public static ReferenceRegistHandler get(RegistrationCommandContext context, List<Entity> refs, EntityDefinition ed, ReferenceProperty rp, PropertyBase property, List<NestProperty> nestProperties, RegistrationPropertyBaseHandler propBaseHandler, ReferenceRegistOption option) {
        return NestTableReferenceRegistHandler.getInternal(context, refs, ed, rp, property, nestProperties, propBaseHandler, option);
    }

    protected static ReferenceRegistHandler getInternal(final RegistrationCommandContext context, final List<Entity> refs, final EntityDefinition ed, final ReferenceProperty rp, final PropertyBase property, List<NestProperty> nestProperties, RegistrationPropertyBaseHandler propBaseHandler, final ReferenceRegistOption option) {
        if (rp.getMappedBy() == null || rp.getMappedBy().isEmpty()) {
            return new NestTableReferenceRegistHandler(){

                @Override
                public void regist(ReferenceRegistHandlerFunction function, Entity inputEntity, Entity loadedEntity) {
                    this.references = refs;
                    this.registOption = option;
                    ArrayList<ValidateError> errors = new ArrayList<ValidateError>();
                    if (this.checkMultiple(rp, errors)) {
                        this.registReference(context, inputEntity, loadedEntity, ed, property, rp, errors);
                    }
                    function.execute(errors);
                }
            };
        }
        return new NestTableReferenceRegistHandler(){

            @Override
            public void registMappedby(ReferenceRegistHandlerFunction function, Entity inputEntity, Entity loadedEntity) {
                this.references = refs;
                this.registOption = option;
                ArrayList<ValidateError> errors = new ArrayList<ValidateError>();
                if (this.checkMultiple(rp, errors)) {
                    this.registMappedbyReference(context, inputEntity, loadedEntity, ed, property, rp, errors);
                }
                function.execute(errors);
            }
        };
    }

    protected void registReference(RegistrationCommandContext context, Entity inputEntity, Entity loadedEntity, EntityDefinition ed, PropertyBase property, ReferenceProperty rp, List<ValidateError> errors) {
        ArrayList<String> updateProperties = new ArrayList<String>();
        this.applyRegistOption(updateProperties, (ReferencePropertyEditor)property.getEditor(), ed);
        for (Entity entity : this.references) {
            errors.addAll(this.registReference(context, entity, updateProperties, rp.getName()));
        }
    }

    protected void registMappedbyReference(RegistrationCommandContext context, Entity inputEntity, Entity loadedEntity, EntityDefinition ed, PropertyBase property, ReferenceProperty rp, List<ValidateError> errors) {
        block6: {
            ArrayList<String> updateProperties = new ArrayList<String>();
            this.applyRegistOption(updateProperties, (ReferencePropertyEditor)property.getEditor(), ed);
            String mappedBy = rp.getMappedBy();
            if (!updateProperties.contains(mappedBy)) {
                updateProperties.add(mappedBy);
            }
            String defName = rp.getObjectDefinitionName();
            ReferenceProperty mpd = (ReferenceProperty)this.edm.get(defName).getProperty(mappedBy);
            ArrayList<Entity> registList = new ArrayList<Entity>();
            ArrayList<Entity> deleteList = new ArrayList<Entity>();
            this.diffMappedbyReference(loadedEntity, (PropertyDefinition)rp, registList, deleteList);
            for (Entity entity : registList) {
                this.setMappedByValue(context, loadedEntity, mappedBy, defName, mpd, property, entity);
                errors.addAll(this.registReference(context, entity, updateProperties, rp.getName()));
            }
            if (deleteList.isEmpty() || this.registOption != null && this.registOption.isSpecifyAllProperties() && !this.registOption.isSpecifiedAsReference()) break block6;
            if (ReferenceType.COMPOSITION.equals((Object)rp.getReferenceType())) {
                for (Entity de : deleteList) {
                    this.em.delete(de, new DeleteOption(false));
                }
            } else {
                for (Entity de : deleteList) {
                    this.delMappedByValue(context, inputEntity, mappedBy, defName, mpd, property, de);
                    ArrayList<String> delProperties = new ArrayList<String>();
                    delProperties.add(mappedBy);
                    errors.addAll(this.registReference(context, de, delProperties, rp.getName()));
                }
            }
        }
    }

    protected void applyRegistOption(List<String> updateProperties, ReferencePropertyEditor editor, EntityDefinition ed) {
        block6: {
            block5: {
                if (this.registOption == null) {
                    updateProperties.addAll(NestTableReferenceRegistHandler.getUpdateProperties(editor.getNestProperties(), ed));
                    this.addTableOrderProperty(updateProperties, editor);
                    return;
                }
                this.getUpdatePropertiesWithOption(updateProperties, editor.getNestProperties(), ed);
                this.addTableOrderProperty(updateProperties, editor);
                if (!this.registOption.isSpecifiedAsReference() || this.registOption.getSpecifiedUpdateNestProperties().isEmpty()) break block5;
                block0: for (Entity entity : this.references) {
                    if (entity.getOid() != null) continue;
                    for (PropertyDefinition pd : ed.getPropertyList()) {
                        if (StringUtil.isNotBlank((String)editor.getTableOrderPropertyName()) && pd.getName().equals(editor.getTableOrderPropertyName())) continue block0;
                        boolean specified = false;
                        for (String specifiedProperty : this.registOption.getSpecifiedUpdateNestProperties()) {
                            if (!pd.getName().equals(specifiedProperty)) continue;
                            specified = true;
                            break;
                        }
                        if (specified) continue;
                        entity.setValue(pd.getName(), null);
                    }
                }
                break block6;
            }
            if (this.registOption.isSpecifiedAsReference() || this.registOption.getSpecifiedUpdateNestProperties().isEmpty()) break block6;
            for (Entity entity : this.references.toArray(new Entity[this.references.size()])) {
                if (entity.getOid() != null) continue;
                this.references.remove(this.references.indexOf(entity));
            }
        }
    }

    protected void addTableOrderProperty(List<String> updateProperties, ReferencePropertyEditor editor) {
        if (StringUtil.isNotBlank((String)editor.getTableOrderPropertyName()) && !updateProperties.contains(editor.getTableOrderPropertyName())) {
            updateProperties.add(editor.getTableOrderPropertyName());
        }
    }

    protected void diffMappedbyReference(Entity loadedEntity, PropertyDefinition pd, List<Entity> registRefList, List<Entity> deleteRefList) {
        Entity in;
        ArrayList<Entity> storedRefList = new ArrayList<Entity>();
        if (pd.getMultiplicity() != 1) {
            Entity[] entityArray;
            in = this.references.toArray(new Entity[0]);
            if (in != null) {
                registRefList.addAll(Arrays.asList(in));
            }
            if (loadedEntity != null && (entityArray = (Entity[])loadedEntity.getValue(pd.getName())) != null) {
                storedRefList.addAll(Arrays.asList(entityArray));
            }
        } else {
            Entity entity;
            Entity entity2 = in = !this.references.isEmpty() ? this.references.get(0) : null;
            if (in != null) {
                registRefList.add(in);
            }
            if (loadedEntity != null && (entity = (Entity)loadedEntity.getValue(pd.getName())) != null) {
                storedRefList.add(entity);
            }
        }
        for (Entity entity : storedRefList) {
            boolean match = registRefList.stream().anyMatch(regist -> regist.getOid() != null && stored.getOid().equals(regist.getOid()));
            if (match) continue;
            deleteRefList.add(entity);
        }
    }

    protected boolean checkMultiple(ReferenceProperty p, List<ValidateError> errors) {
        if (p.getMultiplicity() != -1 && this.references.size() > p.getMultiplicity()) {
            ValidateError error = new ValidateError();
            error.setPropertyName(p.getName());
            error.addErrorMessage("\u767b\u9332\u53ef\u80fd\u306a\u30c7\u30fc\u30bf\u306f" + p.getMultiplicity() + "\u4ef6\u307e\u3067\u3067\u3059\u3002");
            errors.add(error);
            return false;
        }
        return true;
    }
}

