/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.detail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.iplass.gem.command.generic.detail.ReferenceRegistHandler;
import org.iplass.gem.command.generic.detail.ReferenceRegistOption;
import org.iplass.gem.command.generic.detail.RegistrationCommandContext;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.EntityValidationException;
import org.iplass.mtp.entity.InsertOption;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.TargetVersion;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.ValidateResult;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.view.generic.LoadEntityContext;
import org.iplass.mtp.view.generic.LoadEntityInterrupter;
import org.iplass.mtp.view.generic.editor.JoinPropertyEditor;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.RangePropertyEditor;
import org.iplass.mtp.view.generic.element.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReferenceRegistHandlerBase
implements ReferenceRegistHandler {
    private static Logger logger = LoggerFactory.getLogger(ReferenceRegistHandlerBase.class);
    protected EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    protected EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
    protected ReferenceRegistOption registOption;
    private boolean forceUpdate;

    protected Entity loadReference(RegistrationCommandContext context, Entity entity, LoadOption loadOption, ReferenceProperty property, Element element) {
        Entity e = null;
        if (entity.getOid() != null) {
            LoadEntityContext leContext = context.getLoadEntityInterrupterHandler().beforeLoadReference(entity.getDefinitionName(), loadOption, property, element, LoadEntityInterrupter.LoadType.UPDATE);
            e = leContext.isDoPrivileged() ? (Entity)AuthContext.doPrivileged(() -> this.em.load(entity.getOid(), entity.getVersion(), entity.getDefinitionName(), leContext.getLoadOption())) : this.em.load(entity.getOid(), entity.getVersion(), entity.getDefinitionName(), leContext.getLoadOption());
            context.getLoadEntityInterrupterHandler().afterLoadReference(e, loadOption, property, element, LoadEntityInterrupter.LoadType.UPDATE);
        }
        return e;
    }

    protected List<ValidateError> registReference(RegistrationCommandContext context, Entity entity, List<String> updateProperties, String propertyName) {
        ArrayList<ValidateError> errors;
        block13: {
            errors = new ArrayList<ValidateError>();
            List occurredErrors = (List)context.getAttribute("validErrorList");
            if (entity != null) {
                if (occurredErrors.isEmpty()) {
                    try {
                        if (entity.getOid() == null) {
                            InsertOption option = new InsertOption();
                            option.setLocalized(context.isLocalizationData());
                            this.em.insert(entity, option);
                            entity.setValue("##deleteOidFlag", (Object)Boolean.TRUE);
                            break block13;
                        }
                        UpdateOption option = new UpdateOption(false, TargetVersion.SPECIFIC);
                        option.setForceUpdate(this.forceUpdate);
                        option.setUpdateProperties(updateProperties);
                        option.setPurgeCompositionedEntity(context.isPurgeCompositionedEntity());
                        option.setLocalized(context.isLocalizationData());
                        this.em.update(entity, option);
                    }
                    catch (EntityValidationException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(e.getMessage(), (Throwable)e);
                        }
                        if (e.getValidateResults() != null && !e.getValidateResults().isEmpty()) {
                            for (ValidateError ve : e.getValidateResults()) {
                                Integer refIndex = (Integer)entity.getValue("##refIndex");
                                String nestPropertyName = propertyName + "." + ve.getPropertyName();
                                if (refIndex != null) {
                                    nestPropertyName = propertyName + "[" + refIndex + "]." + ve.getPropertyName();
                                }
                                ve.setPropertyName(nestPropertyName);
                            }
                        }
                        errors.addAll(e.getValidateResults());
                    }
                } else {
                    ValidateResult vr = null;
                    vr = entity.getOid() == null ? this.em.validate(entity) : this.em.validate(entity, updateProperties);
                    if (vr != null && vr.hasError()) {
                        for (ValidateError ve : vr.getErrors()) {
                            Integer refIndex = (Integer)entity.getValue("##refIndex");
                            String nestPropertyName = propertyName + "." + ve.getPropertyName();
                            if (refIndex != null) {
                                nestPropertyName = propertyName + "[" + refIndex + "]." + ve.getPropertyName();
                            }
                            ve.setPropertyName(nestPropertyName);
                        }
                        errors.addAll(vr.getErrors());
                    }
                }
            }
        }
        return errors;
    }

    protected void setMappedByValue(RegistrationCommandContext context, Entity entity, String mappedBy, String defName, ReferenceProperty rpd, Element element, Entity refEntity) {
        if (rpd.getMultiplicity() != 1) {
            if (refEntity.getOid() == null) {
                refEntity.setValue(mappedBy, (Object)new Entity[]{entity});
            } else {
                Entity tmp = this.loadReference(context, refEntity, new LoadOption(true, false), rpd, element);
                if (tmp != null && tmp.getValue(mappedBy) != null) {
                    Entity[] entities = (Entity[])tmp.getValue(mappedBy);
                    ArrayList<Entity> list = new ArrayList<Entity>(Arrays.asList(entities));
                    boolean isAdded = false;
                    for (Entity _entity : list) {
                        if (!_entity.getOid().equals(entity.getOid())) continue;
                        isAdded = true;
                    }
                    if (!isAdded) {
                        list.add(entity);
                    }
                    refEntity.setValue(mappedBy, (Object)list.toArray(new Entity[list.size()]));
                } else {
                    refEntity.setValue(mappedBy, (Object)new Entity[]{entity});
                }
            }
        } else {
            refEntity.setValue(mappedBy, (Object)entity);
        }
    }

    protected void delMappedByValue(RegistrationCommandContext context, Entity entity, String mappedBy, String defName, ReferenceProperty rpd, Element element, Entity refEntity) {
        if (rpd.getMultiplicity() != 1) {
            Entity tmp = this.loadReference(context, refEntity, new LoadOption(true, false), rpd, element);
            Entity[] entities = (Entity[])tmp.getValue(mappedBy);
            ArrayList<Entity> list = new ArrayList<Entity>();
            if (entities != null) {
                for (Entity e : entities) {
                    if (e.getOid().equals(entity.getOid())) continue;
                    list.add(e);
                }
            }
            refEntity.setValue(mappedBy, (Object)list.toArray(new Entity[list.size()]));
        } else {
            refEntity.setValue(mappedBy, null);
        }
    }

    protected void getUpdatePropertiesWithOption(List<String> updateProperties, List<NestProperty> nestProperties, EntityDefinition ed) {
        if (!this.registOption.isSpecifyAllProperties()) {
            updateProperties.addAll(ReferenceRegistHandlerBase.getUpdateProperties(nestProperties, ed));
            for (String prop : this.registOption.getSpecifiedUpdateNestProperties()) {
                if (updateProperties.contains(prop)) continue;
                updateProperties.add(prop);
            }
            return;
        }
        if (this.registOption.isSpecifiedAsReference() && this.registOption.getSpecifiedUpdateNestProperties().isEmpty()) {
            updateProperties.addAll(ReferenceRegistHandlerBase.getUpdateProperties(nestProperties, ed));
            return;
        }
        updateProperties.addAll(this.registOption.getSpecifiedUpdateNestProperties());
    }

    protected static List<String> getUpdateProperties(List<NestProperty> nestProperties, EntityDefinition ed) {
        ArrayList<String> updateProperties = new ArrayList<String>();
        for (NestProperty nProp : nestProperties) {
            RangePropertyEditor rangeTo;
            PropertyDefinition toNpd;
            PropertyDefinition npd;
            if (nProp.isHideDetail()) continue;
            if (nProp.getEditor() instanceof JoinPropertyEditor) {
                updateProperties.addAll(ReferenceRegistHandlerBase.checkJoinProperty(ed, (JoinPropertyEditor)nProp.getEditor()));
            }
            if ((npd = ed.getProperty(nProp.getPropertyName())) != null && npd.isUpdatable()) {
                updateProperties.add(nProp.getPropertyName());
            }
            if (!(nProp.getEditor() instanceof RangePropertyEditor) || (toNpd = ed.getProperty((rangeTo = (RangePropertyEditor)((Object)nProp.getEditor())).getToPropertyName())) == null || !toNpd.isUpdatable()) continue;
            updateProperties.add(rangeTo.getToPropertyName());
        }
        return updateProperties;
    }

    private static List<String> checkJoinProperty(EntityDefinition ed, JoinPropertyEditor editor) {
        ArrayList<String> updateProperties = new ArrayList<String>();
        for (NestProperty nest : editor.getProperties()) {
            PropertyDefinition pd = ed.getProperty(nest.getPropertyName());
            if (pd == null || !pd.isUpdatable()) continue;
            updateProperties.add(nest.getPropertyName());
        }
        return updateProperties;
    }

    @Override
    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }
}

