/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.detail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.iplass.gem.command.generic.detail.DetailCommandContext;
import org.iplass.gem.command.generic.detail.ReferenceRegistHandler;
import org.iplass.gem.command.generic.detail.ReferenceRegistHandlerBase;
import org.iplass.gem.command.generic.detail.ReferenceRegistHandlerFunction;
import org.iplass.gem.command.generic.detail.ReferenceRegistOption;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.OutputType;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.iplass.mtp.view.generic.element.section.ReferenceSection;

public abstract class ReferenceSectionReferenceRegistHandler
extends ReferenceRegistHandlerBase {
    protected List<DetailCommandContext.ReferenceSectionValue> references;

    public static boolean canRegist(DetailCommandContext.ReferenceSectionPropertyItem property) {
        return property.isDispFlag() && !property.isHideDetail();
    }

    public static ReferenceRegistHandler get(DetailCommandContext context, List<DetailCommandContext.ReferenceSectionValue> refs, EntityDefinition ed, ReferenceProperty rp, PropertyItem property) {
        return ReferenceSectionReferenceRegistHandler.getInternal(context, refs, ed, rp, property, null);
    }

    public static ReferenceRegistHandler get(DetailCommandContext context, List<DetailCommandContext.ReferenceSectionValue> refs, EntityDefinition ed, ReferenceProperty rp, PropertyItem property, ReferenceRegistOption option) {
        return ReferenceSectionReferenceRegistHandler.getInternal(context, refs, ed, rp, property, option);
    }

    private static ReferenceRegistHandler getInternal(final DetailCommandContext context, final List<DetailCommandContext.ReferenceSectionValue> refs, final EntityDefinition ed, final ReferenceProperty rp, final PropertyItem property, final ReferenceRegistOption option) {
        if (rp.getMappedBy() == null || rp.getMappedBy().isEmpty()) {
            return new ReferenceSectionReferenceRegistHandler(){

                @Override
                public void regist(ReferenceRegistHandlerFunction function, Entity inputEntity, Entity loadedEntity) {
                    this.references = refs;
                    this.registOption = option;
                    ArrayList<ValidateError> errors = new ArrayList<ValidateError>();
                    this.registReference(context, inputEntity, loadedEntity, ed, property, rp, errors);
                    function.execute(errors);
                }
            };
        }
        return new ReferenceSectionReferenceRegistHandler(){

            @Override
            public void registMappedby(ReferenceRegistHandlerFunction function, Entity inputEntity, Entity loadedEntity) {
                this.references = refs;
                this.registOption = option;
                ArrayList<ValidateError> errors = new ArrayList<ValidateError>();
                this.registMappedbyReference(context, inputEntity, loadedEntity, ed, property, rp, errors);
                function.execute(errors);
            }
        };
    }

    protected void registReference(DetailCommandContext context, Entity inputEntity, Entity loadedEntity, EntityDefinition ed, PropertyItem property, ReferenceProperty rp, List<ValidateError> errors) {
        if (rp.getMultiplicity() != 1) {
            List usList = this.references.stream().filter(r -> r.getEntity().getOid() == null).map(r -> r.getEntity()).collect(Collectors.toList());
            ArrayList<Object> loadedList = new ArrayList<Object>();
            if (loadedEntity != null && loadedEntity.getValue(rp.getName()) != null) {
                Entity[] ary = (Entity[])loadedEntity.getValue(rp.getName());
                loadedList.addAll(Arrays.asList(ary));
            }
            loadedList.addAll(usList);
            inputEntity.setValue(rp.getName(), (Object)loadedList.toArray(new Entity[0]));
        }
        for (DetailCommandContext.ReferenceSectionValue val : this.references) {
            if (!EntityViewUtil.isDisplayElement(context.getDefinitionName(), val.getSection().getElementRuntimeId(), OutputType.EDIT, inputEntity) || val.getSection().isHideDetail()) continue;
            ArrayList<String> updateProperties = new ArrayList<String>();
            if (this.registOption != null) {
                this.applyRegistOption(val, updateProperties, ed);
            }
            this.setIndex(ed, val);
            this.setForceUpdate(val.getSection().isForceUpadte());
            errors.addAll(this.registReference(context, val.getEntity(), updateProperties, rp.getName()));
        }
    }

    protected void registMappedbyReference(DetailCommandContext context, Entity inputEntity, Entity loadedEntity, EntityDefinition ed, PropertyItem property, ReferenceProperty rp, List<ValidateError> errors) {
        String defName = rp.getObjectDefinitionName();
        String mappedBy = rp.getMappedBy();
        ReferenceProperty mpd = (ReferenceProperty)this.edm.get(defName).getProperty(mappedBy);
        ArrayList<UpdateSet> usList = new ArrayList<UpdateSet>();
        for (DetailCommandContext.ReferenceSectionValue val : this.references) {
            if (!EntityViewUtil.isDisplayElement(context.getDefinitionName(), val.getSection().getElementRuntimeId(), OutputType.EDIT, inputEntity) || val.getSection().isHideDetail()) continue;
            ArrayList<String> updateProperties = new ArrayList<String>();
            if (this.registOption != null) {
                this.applyRegistOption(val, updateProperties, ed);
            }
            this.setIndex(ed, val);
            if (!updateProperties.contains(mappedBy)) {
                updateProperties.add(mappedBy);
            }
            usList.add(new UpdateSet(val.getEntity(), updateProperties, val.getSection()));
        }
        ArrayList<UpdateSet> registList = new ArrayList<UpdateSet>();
        ArrayList<Entity> deleteList = new ArrayList<Entity>();
        this.difference(usList, loadedEntity, (PropertyDefinition)rp, registList, deleteList);
        for (UpdateSet us : registList) {
            this.setMappedByValue(context, loadedEntity, mappedBy, defName, mpd, us.section, us.entity);
            errors.addAll(this.registReference(context, us.entity, us.updateProperty, rp.getName()));
        }
    }

    public void setIndex(EntityDefinition ed, DetailCommandContext.ReferenceSectionValue val) {
        PropertyDefinition pd;
        if (val.getIndex() != null && StringUtil.isNotBlank((String)val.getSection().getOrderPropName()) && (pd = ed.getProperty(val.getSection().getOrderPropName())) != null && val.getEntity() != null) {
            val.getEntity().setValue(val.getSection().getOrderPropName(), ConvertUtil.convert((Class)pd.getJavaType(), (Object)val.getIndex()));
        }
    }

    protected void applyRegistOption(DetailCommandContext.ReferenceSectionValue val, List<String> updateProperties, EntityDefinition ed) {
        this.getUpdatePropertiesWithOption(updateProperties, val.getSection().getProperties(), ed);
        if (this.registOption.isSpecifiedAsReference() && !this.registOption.getSpecifiedUpdateNestProperties().isEmpty()) {
            Entity entity = val.getEntity();
            if (entity.getOid() == null) {
                for (PropertyDefinition pd : ed.getPropertyList()) {
                    boolean specified = false;
                    for (String specifiedProperty : this.registOption.getSpecifiedUpdateNestProperties()) {
                        if (!pd.getName().equals(specifiedProperty)) continue;
                        specified = true;
                        break;
                    }
                    if (specified) continue;
                    entity.setValue(pd.getName(), null);
                }
            }
        } else if (!this.registOption.isSpecifiedAsReference() && !this.registOption.getSpecifiedUpdateNestProperties().isEmpty() && val.getEntity().getOid() == null) {
            val.setEntity(null);
        }
    }

    protected void difference(List<UpdateSet> usList, Entity loadedEntity, PropertyDefinition pd, List<UpdateSet> registList, List<Entity> deleteList) {
        Entity load;
        ArrayList<UpdateSet> list1 = new ArrayList<UpdateSet>();
        ArrayList<Object> list2 = new ArrayList<Object>();
        if (pd.getMultiplicity() != 1) {
            if (usList != null) {
                list1.addAll(usList);
            }
            if (loadedEntity != null && (load = (Entity)loadedEntity.getValue(pd.getName())) != null) {
                list2.addAll(Arrays.asList(load));
            }
        } else {
            if (usList != null) {
                list1.addAll(usList);
            }
            if (loadedEntity != null && (load = (Entity)loadedEntity.getValue(pd.getName())) != null) {
                list2.add(load);
            }
        }
        for (UpdateSet updateSet : list1) {
            if (updateSet.entity == null || updateSet.entity.getOid() != null) continue;
            registList.add(updateSet);
        }
        for (Entity entity : list2) {
            boolean match = false;
            UpdateSet usSet = null;
            for (UpdateSet in : list1) {
                if (in.entity == null || in.entity.getOid() == null || !entity.getOid().equals(in.entity.getOid())) continue;
                match = true;
                usSet = in;
                break;
            }
            if (match) {
                registList.add(usSet);
                continue;
            }
            deleteList.add(entity);
        }
    }

    private class UpdateSet {
        Entity entity;
        List<String> updateProperty;
        ReferenceSection section;

        public UpdateSet(Entity entity, List<String> updateProperty, ReferenceSection section) {
            this.entity = entity;
            this.updateProperty = updateProperty;
            this.section = section;
        }
    }
}

