/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.detail;

import java.util.ArrayList;
import java.util.List;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.generic.GenericCommandContext;
import org.iplass.gem.command.generic.ResultType;
import org.iplass.gem.command.generic.detail.RegistrationCommandContext;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.EntityValidationException;
import org.iplass.mtp.entity.InsertOption;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.TargetVersion;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.ValidateResult;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.AutoNumberProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.transaction.TransactionManager;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.FormView;
import org.iplass.mtp.view.generic.LoadEntityContext;
import org.iplass.mtp.view.generic.LoadEntityInterrupter;
import org.iplass.mtp.view.generic.RegistrationInterrupter;
import org.iplass.mtp.view.generic.element.property.PropertyBase;
import org.slf4j.Logger;

public abstract class RegistrationCommandBase<T extends RegistrationCommandContext, V extends PropertyBase>
implements Command {
    protected EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    protected EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);
    protected EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);

    protected abstract Logger getLogger();

    protected abstract T getContext(RequestContext var1);

    protected Entity loadEntity(T context, String oid, Long version, String defName, LoadOption loadOption, LoadEntityInterrupter.LoadType type) {
        Entity e = null;
        if (oid != null) {
            LoadEntityContext leContext = ((RegistrationCommandContext)context).getLoadEntityInterrupterHandler().beforeLoadEntity(defName, loadOption, type);
            e = leContext.isDoPrivileged() ? (Entity)AuthContext.doPrivileged(() -> this.em.load(oid, version, defName, leContext.getLoadOption())) : this.em.load(oid, version, defName, leContext.getLoadOption());
            ((RegistrationCommandContext)context).getLoadEntityInterrupterHandler().afterLoadEntity(e, loadOption, type);
        }
        return e;
    }

    protected Entity loadViewEntity(T context, String oid, Long version, String defName, List<String> loadReferences) {
        return this.loadEntity(context, oid, version, defName, new LoadOption(loadReferences), LoadEntityInterrupter.LoadType.VIEW);
    }

    protected Entity loadBeforeUpdateEntity(T context, String oid, Long version, String defName, List<String> loadReferences) {
        return this.loadEntity(context, oid, version, defName, new LoadOption(loadReferences), LoadEntityInterrupter.LoadType.BEFORE_UPDATE);
    }

    protected Entity getLockedByUser(Entity target) {
        if (target.getLockedBy() != null) {
            Entity user = this.em.load(target.getLockedBy(), null, "mtp.auth.User", new LoadOption(false, false));
            return user;
        }
        return null;
    }

    private Entity loadUpdateEntity(T context, Entity entity, LoadOption loadOption) {
        return this.loadEntity(context, entity.getOid(), entity.getVersion(), entity.getDefinitionName(), loadOption, LoadEntityInterrupter.LoadType.UPDATE);
    }

    protected EditResult updateEntity(T context, Entity entity) {
        EditResult ret = new EditResult();
        ArrayList<ValidateError> errors = new ArrayList<ValidateError>();
        ((GenericCommandContext)context).setAttribute("validErrorList", errors);
        try {
            Entity loadEntity = this.loadUpdateEntity(context, entity, new LoadOption(true, ((RegistrationCommandContext)context).hasUpdatableMappedByReference()));
            errors.addAll(this.beforeRegistRefEntity(context, entity, loadEntity));
            errors.addAll(((RegistrationCommandContext)context).getRegistrationInterrupterHandler().beforeRegist(entity, RegistrationInterrupter.RegistrationType.UPDATE));
            errors.addAll(this.update(context, entity));
            errors.addAll(this.afterRegistRefEntity(context, entity, loadEntity));
            errors.addAll(((RegistrationCommandContext)context).getRegistrationInterrupterHandler().afterRegist(entity, RegistrationInterrupter.RegistrationType.UPDATE));
            if (errors.isEmpty()) {
                ret.setResultType(ResultType.SUCCESS);
            } else {
                ret.setResultType(ResultType.ERROR);
                ret.setErrors(errors.toArray(new ValidateError[errors.size()]));
                ret.setMessage(RegistrationCommandBase.resourceString("command.generic.detail.DetailCommandBase.inputErr", new Object[0]));
                this.rollBack(context, entity);
            }
        }
        catch (ApplicationException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(e.getMessage(), (Throwable)e);
            }
            ret.setResultType(ResultType.ERROR);
            ret.setMessage(e.getMessage());
            this.rollBack(context, entity);
        }
        return ret;
    }

    private List<ValidateError> update(T context, Entity entity) {
        List occurredErrors;
        ArrayList<ValidateError> errors = new ArrayList<ValidateError>();
        ArrayList<String> updatePropNames = new ArrayList<String>();
        List propList = ((RegistrationCommandContext)context).getUpdateProperty();
        for (PropertyBase prop : propList) {
            PropertyDefinition pd;
            if (!((RegistrationCommandContext)context).getRegistrationPropertyBaseHandler().isDispProperty(prop) || (pd = ((GenericCommandContext)context).getProperty(prop.getPropertyName())) == null || !pd.isUpdatable()) continue;
            if (pd instanceof ReferenceProperty) {
                String mappedBy = ((ReferenceProperty)pd).getMappedBy();
                if (mappedBy != null && !mappedBy.isEmpty()) continue;
                updatePropNames.add(pd.getName());
                continue;
            }
            updatePropNames.add(pd.getName());
        }
        TargetVersion targetVersion = TargetVersion.CURRENT_VALID;
        if (((GenericCommandContext)context).isVersioned()) {
            targetVersion = ((RegistrationCommandContext)context).isNewVersion() ? TargetVersion.NEW : TargetVersion.SPECIFIC;
        }
        if ((occurredErrors = (List)((GenericCommandContext)context).getAttribute("validErrorList")).isEmpty()) {
            UpdateOption option = new UpdateOption(true, targetVersion);
            option.setUpdateProperties(((RegistrationCommandContext)context).getRegistrationInterrupterHandler().getAdditionalProperties(updatePropNames));
            option.setPurgeCompositionedEntity(((RegistrationCommandContext)context).isPurgeCompositionedEntity());
            option.setLocalized(((RegistrationCommandContext)context).isLocalizationData());
            option.setForceUpdate(((RegistrationCommandContext)context).isForceUpadte());
            this.checkUpdateOption(context, option);
            try {
                this.em.update(entity, option);
            }
            catch (EntityValidationException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(e.getMessage(), (Throwable)e);
                }
                errors.addAll(e.getValidateResults());
            }
        } else {
            ValidateResult vr = this.em.validate(entity, updatePropNames);
            if (vr != null && vr.hasError()) {
                errors.addAll(vr.getErrors());
            }
        }
        return errors;
    }

    protected void checkUpdateOption(T context, UpdateOption option) {
    }

    protected EditResult insertEntity(T context, Entity entity) {
        EditResult ret = new EditResult();
        ArrayList<ValidateError> errors = new ArrayList<ValidateError>();
        ((GenericCommandContext)context).setAttribute("validErrorList", errors);
        try {
            errors.addAll(this.beforeRegistRefEntity(context, entity, null));
            errors.addAll(((RegistrationCommandContext)context).getRegistrationInterrupterHandler().beforeRegist(entity, RegistrationInterrupter.RegistrationType.INSERT));
            errors.addAll(this.insert(context, entity));
            errors.addAll(this.afterRegistRefEntity(context, entity, this.loadUpdateEntity(context, entity, new LoadOption(true, false))));
            errors.addAll(((RegistrationCommandContext)context).getRegistrationInterrupterHandler().afterRegist(entity, RegistrationInterrupter.RegistrationType.INSERT));
            if (errors.isEmpty()) {
                ret.setResultType(ResultType.SUCCESS);
            } else {
                ret.setResultType(ResultType.ERROR);
                ret.setErrors(errors.toArray(new ValidateError[errors.size()]));
                ret.setMessage(RegistrationCommandBase.resourceString("command.generic.detail.DetailCommandBase.inputErr", new Object[0]));
                this.rollBack(context, entity);
            }
        }
        catch (ApplicationException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(e.getMessage(), (Throwable)e);
            }
            ret.setResultType(ResultType.ERROR);
            ret.setMessage(e.getMessage());
            this.rollBack(context, entity);
        }
        return ret;
    }

    private List<ValidateError> insert(T context, Entity entity) {
        ArrayList<ValidateError> errors = new ArrayList<ValidateError>();
        List occurredErrors = (List)((GenericCommandContext)context).getAttribute("validErrorList");
        if (occurredErrors.isEmpty()) {
            try {
                InsertOption option = new InsertOption();
                option.setLocalized(((FormView)((GenericCommandContext)context).getView()).isLocalizationData());
                this.em.insert(entity, option);
            }
            catch (EntityValidationException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(e.getMessage(), (Throwable)e);
                }
                errors.addAll(e.getValidateResults());
            }
        } else {
            ValidateResult vr = this.em.validate(entity);
            if (vr != null && vr.hasError()) {
                errors.addAll(vr.getErrors());
            }
        }
        return errors;
    }

    private void rollBack(T context, Entity entity) {
        ((TransactionManager)ManagerLocator.getInstance().getManager(TransactionManager.class)).currentTransaction().setRollbackOnly();
        this.resetOid(context, entity);
    }

    private void resetOid(T context, Entity entity) {
        for (PropertyDefinition pd : ((GenericCommandContext)context).getPropertyList()) {
            Entity[] rEntities;
            Object val;
            if (!(pd instanceof ReferenceProperty) || (val = entity.getValue(pd.getName())) == null) continue;
            if (val instanceof Entity) {
                Entity rEntity = (Entity)val;
                Boolean deleteOidFlag = (Boolean)rEntity.getValue("##deleteOidFlag");
                if (deleteOidFlag == null || !deleteOidFlag.booleanValue()) continue;
                rEntity.setOid(null);
                this.resetAutoNumber(rEntity, (ReferenceProperty)pd);
                continue;
            }
            if (!(val instanceof Entity[])) continue;
            for (Entity rEntity : rEntities = (Entity[])val) {
                Boolean deleteOidFlag = (Boolean)rEntity.getValue("##deleteOidFlag");
                if (deleteOidFlag == null || !deleteOidFlag.booleanValue()) continue;
                rEntity.setOid(null);
                this.resetAutoNumber(rEntity, (ReferenceProperty)pd);
            }
        }
    }

    private void resetAutoNumber(Entity entity, ReferenceProperty rp) {
        EntityDefinition ned = this.edm.get(rp.getObjectDefinitionName());
        for (PropertyDefinition pd : ned.getPropertyList()) {
            if (!(pd instanceof AutoNumberProperty)) continue;
            entity.setValue(pd.getName(), null);
        }
    }

    private List<ValidateError> beforeRegistRefEntity(T context, Entity entity, Entity loadedEntity) {
        ArrayList<ValidateError> errors = new ArrayList<ValidateError>();
        ((RegistrationCommandContext)context).regist(err -> errors.addAll(err), entity, loadedEntity);
        return errors;
    }

    private List<ValidateError> afterRegistRefEntity(T context, Entity entity, Entity loadedEntity) {
        ArrayList<ValidateError> errors = new ArrayList<ValidateError>();
        ((RegistrationCommandContext)context).registMappedby(err -> errors.addAll(err), entity, loadedEntity);
        return errors;
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }

    protected class EditResult {
        private ResultType resultType;
        private ValidateError[] errors;
        private String message;

        public ResultType getResultType() {
            return this.resultType;
        }

        public void setResultType(ResultType resultType) {
            this.resultType = resultType;
        }

        public ValidateError[] getErrors() {
            return this.errors;
        }

        public void setErrors(ValidateError[] errors) {
            this.errors = errors;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

