/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.detail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.generic.GenericCommandContext;
import org.iplass.gem.command.generic.detail.LoadEntityInterrupterHandler;
import org.iplass.gem.command.generic.detail.ReferenceRegistHandler;
import org.iplass.gem.command.generic.detail.ReferenceRegistHandlerFunction;
import org.iplass.gem.command.generic.detail.RegistrationInterrupterHandler;
import org.iplass.gem.command.generic.detail.RegistrationPropertyBaseHandler;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.AutoNumberProperty;
import org.iplass.mtp.entity.definition.properties.BinaryProperty;
import org.iplass.mtp.entity.definition.properties.BooleanProperty;
import org.iplass.mtp.entity.definition.properties.DateProperty;
import org.iplass.mtp.entity.definition.properties.DateTimeProperty;
import org.iplass.mtp.entity.definition.properties.DecimalProperty;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.entity.definition.properties.FloatProperty;
import org.iplass.mtp.entity.definition.properties.IntegerProperty;
import org.iplass.mtp.entity.definition.properties.LongTextProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.definition.properties.SelectProperty;
import org.iplass.mtp.entity.definition.properties.StringProperty;
import org.iplass.mtp.entity.definition.properties.TimeProperty;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.utilityclass.definition.UtilityClassDefinitionManager;
import org.iplass.mtp.view.generic.LoadEntityInterrupter;
import org.iplass.mtp.view.generic.RegistrationInterrupter;
import org.iplass.mtp.view.generic.editor.BooleanPropertyEditor;
import org.iplass.mtp.view.generic.editor.DatePropertyEditor;
import org.iplass.mtp.view.generic.editor.DecimalPropertyEditor;
import org.iplass.mtp.view.generic.editor.FloatPropertyEditor;
import org.iplass.mtp.view.generic.editor.IntegerPropertyEditor;
import org.iplass.mtp.view.generic.editor.SelectPropertyEditor;
import org.iplass.mtp.view.generic.editor.StringPropertyEditor;
import org.iplass.mtp.view.generic.editor.TimePropertyEditor;
import org.iplass.mtp.view.generic.editor.TimestampPropertyEditor;
import org.iplass.mtp.view.generic.element.property.PropertyBase;
import org.slf4j.Logger;

public abstract class RegistrationCommandContext
extends GenericCommandContext {
    protected EntityManager entityManager;
    protected EntityDefinitionManager definitionManager;
    protected UtilityClassDefinitionManager ucdm;
    private List<ValidateError> errors;
    private RegistrationInterrupterHandler interrupterHandler;
    private LoadEntityInterrupterHandler loadEntityInterrupterHandler;
    private List<ReferenceRegistHandler> referenceRegistHandlers = new ArrayList<ReferenceRegistHandler>();
    private RegistrationPropertyBaseHandler registrationPropertyBaseHandler;

    protected abstract Logger getLogger();

    public RegistrationCommandContext(RequestContext request, EntityManager entityLoader, EntityDefinitionManager definitionLoader) {
        super(request);
        this.init(entityLoader, definitionLoader);
    }

    public RegistrationCommandContext(RequestContext request, String defName, String viewName, EntityManager entityLoader, EntityDefinitionManager definitionLoader) {
        super(request, defName, viewName);
        this.init(entityLoader, definitionLoader);
    }

    private void init(EntityManager entityLoader, EntityDefinitionManager definitionLoader) {
        this.entityManager = entityLoader;
        this.definitionManager = definitionLoader;
        this.ucdm = (UtilityClassDefinitionManager)ManagerLocator.getInstance().getManager(UtilityClassDefinitionManager.class);
    }

    protected Entity newEntity() {
        GenericEntity res = null;
        if (this.entityDefinition.getMapping() != null && this.entityDefinition.getMapping().getMappingModelClass() != null) {
            try {
                res = (Entity)Class.forName(this.entityDefinition.getMapping().getMappingModelClass()).newInstance();
            }
            catch (InstantiationException e) {
                throw new EntityRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new EntityRuntimeException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new EntityRuntimeException((Throwable)e);
            }
        } else {
            res = new GenericEntity();
        }
        res.setDefinitionName(this.entityDefinition.getName());
        return res;
    }

    protected Object getPropValue(PropertyDefinition p, String paramPrefix) {
        Object value = null;
        boolean isMultiple = p.getMultiplicity() != 1;
        String name = paramPrefix + p.getName();
        if (p instanceof BinaryProperty) {
            value = isMultiple ? this.getBinaryReferenceValues(name) : this.getBinaryReferenceValue(name);
        } else if (p instanceof BooleanProperty) {
            value = isMultiple ? this.getBooleanValues(name, p.getMultiplicity()) : this.getBooleanValue(name);
        } else if (p instanceof DateProperty) {
            value = isMultiple ? this.getDateValues(name) : this.getDateValue(name);
        } else if (p instanceof DateTimeProperty) {
            value = isMultiple ? this.getTimestampValues(name) : this.getTimestampValue(name);
        } else if (p instanceof DecimalProperty) {
            value = isMultiple ? this.getDecimalValues(name) : this.getDecimalValue(name);
        } else if (p instanceof ExpressionProperty) {
            value = this.getExpressionValue((ExpressionProperty)p, name);
        } else if (p instanceof FloatProperty) {
            value = isMultiple ? this.getDoubleValues(name) : this.getDoubleValue(name);
        } else if (p instanceof IntegerProperty) {
            value = isMultiple ? this.getLongValues(name) : this.getLongValue(name);
        } else if (p instanceof LongTextProperty) {
            value = isMultiple ? this.getStringValues(name) : this.getStringValue(name);
        } else if (p instanceof ReferenceProperty) {
            value = this.createReference(p, paramPrefix);
        } else if (p instanceof SelectProperty) {
            SelectProperty selectProperty = (SelectProperty)p;
            value = isMultiple ? this.getSelectValues(name, selectProperty) : this.getSelectValue(name, selectProperty);
        } else if (p instanceof StringProperty) {
            value = isMultiple ? this.getStringValues(name) : this.getStringValue(name);
        } else if (p instanceof TimeProperty) {
            value = isMultiple ? this.getTimeValues(name) : this.getTimeValue(name);
        } else if (p instanceof AutoNumberProperty) {
            value = this.getStringValue(name);
        }
        return value;
    }

    private BinaryReference getBinaryReferenceValue(String name) {
        BinaryReference br = null;
        Long lobId = this.getLongValue(name);
        if (lobId != null) {
            br = this.entityManager.loadBinaryReference(lobId.longValue());
        }
        return br;
    }

    private BinaryReference[] getBinaryReferenceValues(String name) {
        Long[] params = this.getLongValues(name);
        if (params != null) {
            BinaryReference[] ret = (BinaryReference[])Arrays.stream(params).filter(lobId -> lobId != null).map(lobId -> {
                BinaryReference br = this.entityManager.loadBinaryReference(lobId.longValue());
                br.setLobId(lobId.longValue());
                return br;
            }).toArray(BinaryReference[]::new);
            return ret.length > 0 ? ret : null;
        }
        return null;
    }

    private Object getExpressionValue(ExpressionProperty ep, String name) {
        String editorType = this.getParam(name + "_editorType");
        if (editorType != null) {
            if (ep.getResultType() == PropertyDefinitionType.BOOLEAN && BooleanPropertyEditor.class.getSimpleName().equals(editorType)) {
                return this.getBooleanValue(name);
            }
            if (ep.getResultType() == PropertyDefinitionType.DATE && DatePropertyEditor.class.getSimpleName().equals(editorType)) {
                return this.getDateValue(name);
            }
            if (ep.getResultType() == PropertyDefinitionType.DATETIME && TimestampPropertyEditor.class.getSimpleName().equals(editorType)) {
                return this.getTimestampValue(name);
            }
            if (ep.getResultType() == PropertyDefinitionType.DECIMAL && DecimalPropertyEditor.class.getSimpleName().equals(editorType)) {
                return this.getDecimalValue(name);
            }
            if (ep.getResultType() == PropertyDefinitionType.FLOAT && FloatPropertyEditor.class.getSimpleName().equals(editorType)) {
                return this.getDoubleValue(name);
            }
            if (ep.getResultType() == PropertyDefinitionType.INTEGER && IntegerPropertyEditor.class.getSimpleName().equals(editorType)) {
                return this.getLongValue(name);
            }
            if (ep.getResultType() == PropertyDefinitionType.SELECT && SelectPropertyEditor.class.getSimpleName().equals(editorType)) {
                return this.getSelectValue(name);
            }
            if (ep.getResultType() == PropertyDefinitionType.STRING && StringPropertyEditor.class.getSimpleName().equals(editorType)) {
                return this.getStringValue(name);
            }
            if (ep.getResultType() == PropertyDefinitionType.TIME && TimePropertyEditor.class.getSimpleName().equals(editorType)) {
                return this.getTimeValue(name);
            }
        }
        return this.getStringValue(name);
    }

    protected Boolean getBooleanValue(String name) {
        String param = this.getParam(name);
        String _type = this.getParam(name + "Type");
        BooleanPropertyEditor.BooleanDisplayType type = StringUtil.isNotEmpty((String)_type) ? BooleanPropertyEditor.BooleanDisplayType.valueOf(_type) : null;
        Boolean ret = null;
        if (type == BooleanPropertyEditor.BooleanDisplayType.SELECT || type == BooleanPropertyEditor.BooleanDisplayType.LABEL || type == BooleanPropertyEditor.BooleanDisplayType.HIDDEN) {
            ret = StringUtil.isNotBlank((String)param) ? Boolean.valueOf(Boolean.parseBoolean(param)) : null;
        } else {
            Boolean bl = ret = param != null ? Boolean.valueOf(Boolean.parseBoolean(param)) : null;
            if (ret == null && type == BooleanPropertyEditor.BooleanDisplayType.CHECKBOX) {
                ret = false;
            }
        }
        return ret;
    }

    protected Boolean[] getBooleanValues(String name, int multiplicity) {
        String _type = this.getParam(name + "Type");
        BooleanPropertyEditor.BooleanDisplayType type = StringUtil.isNotEmpty((String)_type) ? BooleanPropertyEditor.BooleanDisplayType.valueOf(_type) : null;
        Boolean[] ret = null;
        if (type == BooleanPropertyEditor.BooleanDisplayType.SELECT || type == BooleanPropertyEditor.BooleanDisplayType.LABEL || type == BooleanPropertyEditor.BooleanDisplayType.HIDDEN) {
            String[] params = this.getParams(name);
            if (params != null) {
                ret = (Boolean[])Arrays.stream(params).map(value -> {
                    if (StringUtil.isEmpty((String)value)) {
                        return null;
                    }
                    return Boolean.parseBoolean(value);
                }).toArray(Boolean[]::new);
            }
        } else {
            ArrayList<Boolean> list = new ArrayList<Boolean>();
            for (int i = 0; i < multiplicity; ++i) {
                Boolean b;
                String param = this.getParam(name + i);
                Boolean bl = b = param != null ? Boolean.valueOf(Boolean.parseBoolean(param)) : null;
                if (b == null && type == BooleanPropertyEditor.BooleanDisplayType.CHECKBOX) {
                    b = false;
                }
                list.add(b);
            }
            boolean hasValue = list.stream().anyMatch(value -> value != null);
            if (hasValue) {
                ret = list.toArray(new Boolean[0]);
            }
        }
        return ret != null && ret.length > 0 ? ret : null;
    }

    protected SelectValue getSelectValue(String name) {
        return this.getSelectValue(name, null);
    }

    protected SelectValue[] getSelectValues(String name) {
        return this.getSelectValues(name, null);
    }

    protected SelectValue getSelectValue(String name, SelectProperty selectProperty) {
        String param = this.getParam(name);
        String lang = I18nUtil.getLanguageIfUseMultilingual();
        if (StringUtil.isNotBlank((String)param)) {
            if (selectProperty == null) {
                return new SelectValue(param);
            }
            SelectValue selectValue = selectProperty.getLocalizedSelectValue(param, lang);
            return selectValue == null ? new SelectValue(param) : selectValue;
        }
        return null;
    }

    protected SelectValue[] getSelectValues(String name, SelectProperty selectProperty) {
        String[] params = this.getParams(name);
        String lang = I18nUtil.getLanguageIfUseMultilingual();
        if (params != null) {
            SelectValue[] ret = (SelectValue[])Arrays.stream(params).map(param -> {
                if (selectProperty == null) {
                    return new SelectValue(param);
                }
                SelectValue selectValue = selectProperty.getLocalizedSelectValue(param, lang);
                return selectValue == null ? new SelectValue(param) : selectValue;
            }).toArray(SelectValue[]::new);
            return ret.length > 0 ? ret : null;
        }
        return null;
    }

    protected String getStringValue(String name) {
        String value = this.getParam(name);
        if (StringUtil.isBlank((String)value)) {
            return null;
        }
        return value;
    }

    protected String[] getStringValues(String name) {
        String[] params = this.getParams(name);
        if (params == null || params.length == 0) {
            return null;
        }
        return params;
    }

    protected abstract Object createReference(PropertyDefinition var1, String var2);

    public RegistrationInterrupterHandler getRegistrationInterrupterHandler() {
        if (this.interrupterHandler == null) {
            RegistrationInterrupter interrupter = this.createInterrupter(this.getInterrupterName());
            this.interrupterHandler = new RegistrationInterrupterHandler(this.request, this, interrupter);
        }
        return this.interrupterHandler;
    }

    protected abstract String getInterrupterName();

    private RegistrationInterrupter createInterrupter(String className) {
        RegistrationInterrupter interrupter = null;
        if (StringUtil.isNotEmpty((String)className)) {
            this.getLogger().debug("set registration interrupter. class=" + className);
            try {
                interrupter = (RegistrationInterrupter)this.ucdm.createInstanceAs(RegistrationInterrupter.class, className);
            }
            catch (ClassNotFoundException e) {
                this.getLogger().error(className + " can not instantiate.", (Throwable)e);
                throw new ApplicationException(RegistrationCommandContext.resourceString("command.generic.detail.RegistrationCommandContext.internalErr", new Object[0]));
            }
        }
        if (interrupter == null) {
            this.getLogger().debug("set defaul registration interrupter.");
            interrupter = new RegistrationInterrupter(){};
        }
        return interrupter;
    }

    public LoadEntityInterrupterHandler getLoadEntityInterrupterHandler() {
        if (this.loadEntityInterrupterHandler == null) {
            LoadEntityInterrupter interrupter = this.createLoadEntityInterrupter(this.getLoadEntityInterrupterName());
            this.loadEntityInterrupterHandler = new LoadEntityInterrupterHandler(this.request, this, interrupter);
        }
        return this.loadEntityInterrupterHandler;
    }

    protected abstract String getLoadEntityInterrupterName();

    private LoadEntityInterrupter createLoadEntityInterrupter(String className) {
        LoadEntityInterrupter interrupter = null;
        if (StringUtil.isNotEmpty((String)className)) {
            this.getLogger().debug("set load entity interrupter. class=" + className);
            try {
                interrupter = (LoadEntityInterrupter)this.ucdm.createInstanceAs(LoadEntityInterrupter.class, className);
            }
            catch (ClassNotFoundException e) {
                this.getLogger().error(className + " can not instantiate.", (Throwable)e);
                throw new ApplicationException(RegistrationCommandContext.resourceString("command.generic.detail.RegistrationCommandContext.internalErr", new Object[0]));
            }
        }
        if (interrupter == null) {
            this.getLogger().debug("set defaul load entity interrupter.");
            interrupter = new LoadEntityInterrupter(){};
        }
        return interrupter;
    }

    public List<ReferenceRegistHandler> getReferenceRegistHandlers() {
        return this.referenceRegistHandlers;
    }

    public void regist(ReferenceRegistHandlerFunction function, Entity inputEntity, Entity loadedEntity) {
        for (ReferenceRegistHandler handler : this.referenceRegistHandlers) {
            handler.regist(function, inputEntity, loadedEntity);
        }
    }

    public void registMappedby(ReferenceRegistHandlerFunction fucntion, Entity inputEntity, Entity loadedEntity) {
        for (ReferenceRegistHandler handler : this.referenceRegistHandlers) {
            handler.registMappedby(fucntion, inputEntity, loadedEntity);
        }
    }

    public RegistrationPropertyBaseHandler getRegistrationPropertyBaseHandler() {
        if (this.registrationPropertyBaseHandler == null) {
            this.registrationPropertyBaseHandler = this.createRegistrationPropertyBaseHandler();
        }
        return this.registrationPropertyBaseHandler;
    }

    protected abstract <T extends PropertyBase> RegistrationPropertyBaseHandler<T> createRegistrationPropertyBaseHandler();

    public abstract <T extends PropertyBase> List<T> getProperty();

    public abstract <T extends PropertyBase> List<T> getUpdateProperty();

    protected abstract boolean isNewVersion();

    protected abstract boolean isPurgeCompositionedEntity();

    protected abstract boolean isLocalizationData();

    protected abstract boolean isForceUpadte();

    protected abstract boolean hasUpdatableMappedByReference();

    protected static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }

    @Override
    public void addError(ValidateError error) {
        for (ValidateError e : this.getErrors()) {
            if (!e.getPropertyName().equals(error.getPropertyName())) continue;
            e.getErrorMessages().addAll(error.getErrorMessages());
            return;
        }
        this.getErrors().add(error);
    }

    @Override
    public List<ValidateError> getErrors() {
        if (this.errors == null) {
            this.errors = new ArrayList<ValidateError>();
        }
        return this.errors;
    }

    @Override
    public boolean hasErrors() {
        return this.errors == null ? false : !this.errors.isEmpty();
    }
}

