/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.detail;

import java.util.ArrayList;
import org.iplass.gem.command.CommandUtil;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.command.annotation.webapi.WebApiTokenCheck;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.EntityValidationException;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceType;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.template.TemplateUtil;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebApi(name="gem/generic/detail/UpdateMappedbyReference", displayName="\u88ab\u53c2\u7167\u30d7\u30ed\u30d1\u30c6\u30a3\u66f4\u65b0", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"errorProperty", "_t"}, tokenCheck=@WebApiTokenCheck(consume=true, useFixedToken=false), checkXRequestedWithHeader=true)
@CommandClass(name="gem/generic/detail/UpdateMappedbyReferenceCommand", displayName="\u88ab\u53c2\u7167\u30d7\u30ed\u30d1\u30c6\u30a3\u66f4\u65b0")
public final class UpdateMappedbyReferenceCommand
implements Command {
    private static Logger logger = LoggerFactory.getLogger(UpdateMappedbyReferenceCommand.class);
    public static final String WEBAPI_NAME = "gem/generic/detail/UpdateMappedbyReference";
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);

    public String execute(RequestContext request) {
        String defName = request.getParam("defName");
        String oid = request.getParam("oid");
        String updatePropertyName = request.getParam("updatePropertyName");
        String delCountStr = request.getParam("delCount");
        boolean purge = Boolean.parseBoolean(request.getParam("purge"));
        int delCount = 0;
        try {
            delCount = Integer.parseInt(delCountStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        EntityDefinition ed = this.edm.get(defName);
        PropertyDefinition pd = ed.getProperty(updatePropertyName);
        if (pd instanceof ReferenceProperty) {
            ReferenceProperty rp = (ReferenceProperty)pd;
            EntityDefinition red = this.edm.get(rp.getObjectDefinitionName());
            if (rp.getMappedBy() != null && !rp.getMappedBy().isEmpty()) {
                for (int i = 0; i < delCount; ++i) {
                    String refEntityKey = request.getParam("refEntityKey_" + i);
                    try {
                        if (rp.getReferenceType() == ReferenceType.ASSOCIATION) {
                            this.update(oid, refEntityKey, rp, red);
                            continue;
                        }
                        if (rp.getReferenceType() != ReferenceType.COMPOSITION) continue;
                        this.delete(refEntityKey, rp, purge);
                        continue;
                    }
                    catch (EntityValidationException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(e.getMessage(), (Throwable)e);
                        }
                        ArrayList errors = new ArrayList();
                        errors.addAll(e.getValidateResults());
                        request.setAttribute("errorProperty", errors);
                        return "ERROR";
                    }
                }
            }
        }
        String token = TemplateUtil.outputToken((TemplateUtil.TokenOutputType)TemplateUtil.TokenOutputType.VALUE);
        request.setAttribute("_t", (Object)token);
        return "SUCCESS";
    }

    private void update(String oid, String refEntityKey, ReferenceProperty rp, EntityDefinition red) {
        if (StringUtil.isBlank((String)refEntityKey)) {
            return;
        }
        int lastIndex = refEntityKey.lastIndexOf("_");
        String roid = refEntityKey.substring(0, lastIndex);
        Long rversion = CommandUtil.getLong(refEntityKey.substring(lastIndex + 1));
        Entity refEntity = this.em.load(roid, rversion, rp.getObjectDefinitionName());
        ReferenceProperty rrp = (ReferenceProperty)red.getProperty(rp.getMappedBy());
        if (rrp.getMultiplicity() == 1) {
            Entity entity = (Entity)refEntity.getValue(rrp.getName());
            if (entity != null && entity.getOid().equals(oid)) {
                refEntity.setValue(rrp.getName(), null);
            }
        } else {
            Entity[] array = (Entity[])refEntity.getValue(rrp.getName());
            if (array != null) {
                ArrayList<Entity> entityList = new ArrayList<Entity>();
                for (Entity entity : array) {
                    if (entity == null || entity.getOid().equals(oid)) continue;
                    entityList.add(entity);
                }
                refEntity.setValue(rrp.getName(), (Object)entityList.toArray(new Entity[entityList.size()]));
            }
        }
        UpdateOption option = new UpdateOption(true);
        option.setUpdateProperties(new String[]{rrp.getName()});
        this.em.update(refEntity, option);
    }

    private void delete(String refEntityKey, ReferenceProperty rp, boolean purge) {
        Long rversion;
        if (StringUtil.isBlank((String)refEntityKey)) {
            return;
        }
        int lastIndex = refEntityKey.lastIndexOf("_");
        String roid = refEntityKey.substring(0, lastIndex);
        Entity refEntity = this.em.load(roid, rversion = CommandUtil.getLong(refEntityKey.substring(lastIndex + 1)), rp.getObjectDefinitionName());
        if (refEntity != null) {
            DeleteOption option = new DeleteOption();
            option.setCheckTimestamp(false);
            option.setPurge(purge);
            this.em.delete(refEntity, option);
        }
    }
}

