/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.detail;

import java.sql.Timestamp;
import java.util.ArrayList;
import org.iplass.gem.command.CommandUtil;
import org.iplass.gem.command.generic.detail.DetailCommandContext;
import org.iplass.gem.command.generic.detail.DetailViewCommand;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.CommandConfig;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ActionMappings;
import org.iplass.mtp.command.annotation.action.ParamMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.EntityValidationException;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceType;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMappings(value={@ActionMapping(name="gem/generic/detail/updateReferenceProperty", displayName="\u53c2\u7167\u30d7\u30ed\u30d1\u30c6\u30a3\u66f4\u65b0", command={@CommandConfig(commandClass=UpdateReferencePropertyCommand.class), @CommandConfig(commandClass=DetailViewCommand.class, value="cmd.detail=false;")}, paramMapping={@ParamMapping(name="viewName", mapFrom="${0}")}, result={@Result(status="SUCCESS", type=Result.Type.TEMPLATE, value="gem/generic/detail/view"), @Result(status="ERROR", type=Result.Type.TEMPLATE, value="gem/generic/detail/view"), @Result(status="ERROR_TOKEN", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/defaultLayout"), @Result(status="ERROR_VIEW", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/defaultLayout")}), @ActionMapping(name="gem/generic/detail/ref/updateReferenceProperty", displayName="\u53c2\u7167\u30c0\u30a4\u30a2\u30ed\u30b0\u53c2\u7167\u30d7\u30ed\u30d1\u30c6\u30a3\u66f4\u65b0", command={@CommandConfig(commandClass=UpdateReferencePropertyCommand.class), @CommandConfig(commandClass=DetailViewCommand.class, value="cmd.detail=false;")}, paramMapping={@ParamMapping(name="viewName", mapFrom="${0}")}, result={@Result(status="SUCCESS", type=Result.Type.TEMPLATE, value="gem/generic/detail/ref/view"), @Result(status="ERROR", type=Result.Type.TEMPLATE, value="gem/generic/detail/ref/view"), @Result(status="ERROR_TOKEN", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/popupLayout"), @Result(status="ERROR_VIEW", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/popupLayout")})})
@CommandClass(name="gem/generic/detail/UpdateReferencePropertyCommand", displayName="\u53c2\u7167\u30d7\u30ed\u30d1\u30c6\u30a3\u66f4\u65b0")
public final class UpdateReferencePropertyCommand
implements Command {
    private static Logger logger = LoggerFactory.getLogger(UpdateReferencePropertyCommand.class);
    public static final String ACTION_NAME = "gem/generic/detail/updateReferenceProperty";
    public static final String REF_ACTION_NAME = "gem/generic/detail/ref/updateReferenceProperty";
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);

    public String execute(RequestContext request) {
        PropertyDefinition pd;
        DetailCommandContext context = new DetailCommandContext(request, this.em, this.edm);
        context.setEntityDefinition(this.edm.get(context.getDefinitionName()));
        context.setEntityView((EntityView)this.evm.get(context.getDefinitionName()));
        String oid = request.getParam("oid");
        String updatePropertyName = request.getParam("updatePropertyName");
        String reloadUrl = request.getParam("reloadUrl");
        if (StringUtil.isNotBlank((String)reloadUrl)) {
            request.setAttribute("reloadUrl", (Object)reloadUrl);
        }
        if ((pd = context.getProperty(updatePropertyName)) instanceof ReferenceProperty) {
            ReferenceProperty rp = (ReferenceProperty)pd;
            EntityDefinition red = this.edm.get(rp.getObjectDefinitionName());
            if (rp.getMappedBy() == null || rp.getMappedBy().isEmpty()) {
                return this.updateEntity(context, oid, red, rp);
            }
            return this.updateMappedbyEntity(context, oid, rp, red);
        }
        return "SUCCESS";
    }

    private String updateEntity(DetailCommandContext context, String oid, EntityDefinition red, ReferenceProperty rp) {
        Long version = context.getLongValue("version");
        Long updateDate = context.getLongValue("timestamp");
        Entity entity = this.createEntity(context.getEntityDefinition(), oid, version, updateDate);
        String[] values = context.getParams(rp.getName());
        ArrayList<Entity> list = new ArrayList<Entity>();
        if (values != null) {
            for (String value : values) {
                String roid = null;
                Long rversion = null;
                int lastIndex = value.lastIndexOf("_");
                if (lastIndex < 0) {
                    roid = value;
                } else {
                    roid = value.substring(0, lastIndex);
                    rversion = CommandUtil.getLong(value.substring(lastIndex + 1));
                }
                Entity refEntity = this.createEntity(red, roid, rversion, null);
                list.add(refEntity);
            }
        }
        if (rp.getMultiplicity() == 1) {
            entity.setValue(rp.getName(), list.size() > 0 ? list.get(0) : null);
        } else {
            entity.setValue(rp.getName(), (Object)list.toArray(new Entity[list.size()]));
        }
        UpdateOption option = new UpdateOption(true);
        option.setUpdateProperties(new String[]{rp.getName()});
        option.setPurgeCompositionedEntity(context.getView().isPurgeCompositionedEntity());
        try {
            this.em.update(entity, option);
        }
        catch (EntityValidationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            ArrayList errors = new ArrayList();
            errors.addAll(e.getValidateResults());
            context.setAttribute("errorProperty", errors);
            return "ERROR";
        }
        return "SUCCESS";
    }

    private String updateMappedbyEntity(DetailCommandContext context, String oid, ReferenceProperty rp, EntityDefinition red) {
        String refEntityKey = context.getParam("refEntityKey");
        if (refEntityKey != null && !refEntityKey.isEmpty()) {
            String roid = null;
            Long rversion = null;
            int lastIndex = refEntityKey.lastIndexOf("_");
            if (lastIndex < 0) {
                roid = refEntityKey;
            } else {
                roid = refEntityKey.substring(0, lastIndex);
                rversion = CommandUtil.getLong(refEntityKey.substring(lastIndex + 1));
            }
            Entity refEntity = this.em.load(roid, rversion, rp.getObjectDefinitionName());
            if (rp.getReferenceType() == ReferenceType.ASSOCIATION) {
                ReferenceProperty rrp = (ReferenceProperty)red.getProperty(rp.getMappedBy());
                if (rrp.getMultiplicity() == 1) {
                    Entity entity = (Entity)refEntity.getValue(rrp.getName());
                    if (entity != null && entity.getOid().equals(oid)) {
                        refEntity.setValue(rrp.getName(), null);
                    }
                } else {
                    Entity[] array = (Entity[])refEntity.getValue(rrp.getName());
                    if (array != null) {
                        ArrayList<Entity> entityList = new ArrayList<Entity>();
                        for (Entity entity : array) {
                            if (entity == null || entity.getOid().equals(oid)) continue;
                            entityList.add(entity);
                        }
                        refEntity.setValue(rrp.getName(), (Object)entityList.toArray(new Entity[entityList.size()]));
                    }
                }
                UpdateOption option = new UpdateOption(true);
                option.setUpdateProperties(new String[]{rrp.getName()});
                option.setPurgeCompositionedEntity(context.getView().isPurgeCompositionedEntity());
                try {
                    this.em.update(refEntity, option);
                }
                catch (EntityValidationException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                    ArrayList errors = new ArrayList();
                    errors.addAll(e.getValidateResults());
                    context.setAttribute("errorProperty", errors);
                    return "ERROR";
                }
            } else {
                DeleteOption option = new DeleteOption(false);
                option.setPurge(context.getView().isPurgeCompositionedEntity());
                this.em.delete(refEntity, option);
            }
        }
        return "SUCCESS";
    }

    private Entity createEntity(EntityDefinition ed, String oid, Long version, Long updateDate) {
        GenericEntity entity = null;
        if (ed.getMapping() != null && ed.getMapping().getMappingModelClass() != null) {
            try {
                entity = (Entity)Class.forName(ed.getMapping().getMappingModelClass()).newInstance();
            }
            catch (InstantiationException e) {
                throw new EntityRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new EntityRuntimeException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new EntityRuntimeException((Throwable)e);
            }
        } else {
            entity = new GenericEntity();
        }
        entity.setDefinitionName(ed.getName());
        entity.setOid(oid);
        entity.setVersion(version);
        if (updateDate != null) {
            entity.setUpdateDate(new Timestamp(updateDate));
        }
        return entity;
    }
}

