/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.detail;

import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.command.annotation.webapi.WebApiTokenCheck;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/generic/detail/UpdateTableOrder", displayName="\u30c6\u30fc\u30d6\u30eb\u8868\u793a\u9806\u66f4\u65b0", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"errorProperty", "_t"}, tokenCheck=@WebApiTokenCheck(consume=true, useFixedToken=false), checkXRequestedWithHeader=true)
@CommandClass(name="gem/generic/detail/UpdateTableOrderCommand", displayName="\u30c6\u30fc\u30d6\u30eb\u8868\u793a\u9806\u66f4\u65b0")
public final class UpdateTableOrderCommand
implements Command {
    public static final String WEBAPI_NAME = "gem/generic/detail/UpdateTableOrder";
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);

    public String execute(RequestContext request) {
        String defName = request.getParam("refDefName");
        String targetKey = request.getParam("targetKey");
        String shiftKey = request.getParam("shiftKey");
        String orderPropName = request.getParam("orderPropName");
        boolean shiftUp = request.getParamAsBoolean("shiftUp");
        Long orderPropValue = request.getParamAsLong("orderPropValue");
        String[] targetParam = targetKey.split("_");
        String targetOid = targetParam[0];
        Long targetVersion = (Long)ConvertUtil.convert(Long.class, (Object)targetParam[1]);
        Entity target = this.em.load(targetOid, targetVersion, defName);
        String[] shiftParam = shiftKey.split("_");
        String shiftOid = shiftParam[0];
        Long shiftVersion = (Long)ConvertUtil.convert(Long.class, (Object)shiftParam[1]);
        Entity shift = this.em.load(shiftOid, shiftVersion, defName);
        if (target != null && shift != null) {
            if (shiftUp) {
                this.shiftToUp(target, shift, orderPropName);
            } else {
                this.shiftToDown(target, shift, orderPropName);
            }
            UpdateOption option = new UpdateOption();
            option.add(orderPropName);
            this.em.update(target, option);
            this.em.update(shift, option);
        } else if (target != null && orderPropValue != null) {
            target.setValue(orderPropName, (Object)orderPropValue);
            UpdateOption option = new UpdateOption();
            option.add(orderPropName);
            this.em.update(target, option);
        }
        return null;
    }

    private void shiftToUp(Entity target, Entity shift, String orderPropName) {
        Object targetOrderValue = target.getValue(orderPropName);
        Object shiftOrderValue = shift.getValue(orderPropName);
        EntityDefinition ed = this.edm.get(target.getDefinitionName());
        PropertyDefinition pd = ed.getProperty(orderPropName);
        if (targetOrderValue != null) {
            Integer order = (Integer)ConvertUtil.convert(Integer.class, (Object)targetOrderValue);
            target.setValue(orderPropName, ConvertUtil.convert((Class)pd.getJavaType(), (Object)(order - 1)));
            shift.setValue(orderPropName, targetOrderValue);
        } else if (shiftOrderValue != null) {
            Integer order = (Integer)ConvertUtil.convert(Integer.class, (Object)shiftOrderValue);
            target.setValue(orderPropName, shiftOrderValue);
            shift.setValue(orderPropName, ConvertUtil.convert((Class)pd.getJavaType(), (Object)(order + 1)));
        } else {
            target.setValue(orderPropName, ConvertUtil.convert((Class)pd.getJavaType(), (Object)0));
            shift.setValue(orderPropName, ConvertUtil.convert((Class)pd.getJavaType(), (Object)1));
        }
    }

    private void shiftToDown(Entity target, Entity shift, String orderPropName) {
        Object targetOrderValue = target.getValue(orderPropName);
        Object shiftOrderValue = shift.getValue(orderPropName);
        EntityDefinition ed = this.edm.get(target.getDefinitionName());
        PropertyDefinition pd = ed.getProperty(orderPropName);
        if (targetOrderValue != null) {
            Integer order = (Integer)ConvertUtil.convert(Integer.class, (Object)targetOrderValue);
            target.setValue(orderPropName, ConvertUtil.convert((Class)pd.getJavaType(), (Object)(order + 1)));
            shift.setValue(orderPropName, targetOrderValue);
        } else if (shiftOrderValue != null) {
            Integer order = (Integer)ConvertUtil.convert(Integer.class, (Object)shiftOrderValue);
            target.setValue(orderPropName, shiftOrderValue);
            shift.setValue(orderPropName, ConvertUtil.convert((Class)pd.getJavaType(), (Object)(order - 1)));
        } else {
            target.setValue(orderPropName, ConvertUtil.convert((Class)pd.getJavaType(), (Object)1));
            shift.setValue(orderPropName, ConvertUtil.convert((Class)pd.getJavaType(), (Object)0));
        }
    }
}

