/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.detail.handler;

import java.util.ArrayList;
import java.util.function.Predicate;
import org.iplass.gem.command.generic.detail.DetailFormViewData;
import org.iplass.gem.command.generic.detail.handler.DetailFormViewAdapter;
import org.iplass.gem.command.generic.detail.handler.ShowDetailLayoutViewEvent;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.SearchOption;
import org.iplass.mtp.entity.interceptor.InvocationType;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.entity.auth.EntityAuthContext;
import org.iplass.mtp.impl.entity.interceptor.EntityQueryInvocationImpl;
import org.iplass.mtp.spi.ServiceRegistry;

public class CheckPermissionLimitConditionOfButtonHandler
extends DetailFormViewAdapter {
    @Override
    protected void onShowDetailView(ShowDetailLayoutViewEvent event) {
        DetailFormViewData detailFormViewData = event.getDetailFormViewData();
        AuthContextHolder user = AuthContextHolder.getAuthContext();
        EntityHandler handler = ((EntityService)ServiceRegistry.getRegistry().getService(EntityService.class)).getRuntimeByName(event.getEntityName());
        if (detailFormViewData.getEntity() != null && detailFormViewData.getEntity().getOid() != null && !user.isPrivilegedExecution()) {
            this.checkUpdatePermission(handler, detailFormViewData, user);
            this.checkDeletePermission(handler, detailFormViewData, user);
        }
    }

    @Override
    protected void onShowEditView(ShowDetailLayoutViewEvent event) {
        DetailFormViewData detailFormViewData = event.getDetailFormViewData();
        AuthContextHolder user = AuthContextHolder.getAuthContext();
        EntityHandler handler = ((EntityService)ServiceRegistry.getRegistry().getService(EntityService.class)).getRuntimeByName(event.getEntityName());
        if (detailFormViewData.getEntity() != null && detailFormViewData.getEntity().getOid() != null && !user.isPrivilegedExecution()) {
            this.checkUpdatePermission(handler, detailFormViewData, user);
            this.checkDeletePermission(handler, detailFormViewData, user);
        }
    }

    private void checkUpdatePermission(EntityHandler handler, DetailFormViewData detailFormViewData, AuthContextHolder user) {
        EntityPermission permission = new EntityPermission(handler.getMetaData().getName(), EntityPermission.Action.UPDATE);
        if (!detailFormViewData.isCanUpdate()) {
            return;
        }
        detailFormViewData.setCanUpdate(this.checkLimitCondition(handler, detailFormViewData, permission, user));
    }

    private void checkDeletePermission(EntityHandler handler, DetailFormViewData detailFormViewData, AuthContextHolder user) {
        EntityPermission permission = new EntityPermission(handler.getMetaData().getName(), EntityPermission.Action.DELETE);
        if (!detailFormViewData.isCanDelete()) {
            return;
        }
        detailFormViewData.setCanDelete(this.checkLimitCondition(handler, detailFormViewData, permission, user));
    }

    private boolean checkLimitCondition(EntityHandler handler, DetailFormViewData detailFormViewData, EntityPermission permission, AuthContextHolder user) {
        EntityAuthContext eac = (EntityAuthContext)user.getAuthorizationContext((Permission)permission);
        if (eac.hasLimitCondition(permission, user)) {
            final boolean versionSpecified = handler.isVersioned() && detailFormViewData.getEntity().getVersion() != null;
            Query q = new Query().select(new Object[]{"oid"}).from(handler.getMetaData().getName());
            if (versionSpecified) {
                q.select().add((Object)"version");
            }
            Object cond = versionSpecified ? new And(new Condition[]{new Equals("oid", (Object)detailFormViewData.getEntity().getOid()), new Equals("version", (Object)detailFormViewData.getEntity().getVersion())}) : new Equals("oid", (Object)detailFormViewData.getEntity().getOid());
            q.where((Condition)cond);
            Query transQuery = eac.modifyQuery(q, permission.getAction(), user);
            final ArrayList oids = new ArrayList(1);
            AuthContext.doPrivileged(() -> new EntityQueryInvocationImpl(transQuery, new SearchOption().unnotifyListeners(), (Predicate)new Predicate<Object[]>(){

                @Override
                public boolean test(Object[] dataModel) {
                    if (versionSpecified) {
                        oids.add((String)dataModel[0] + "." + dataModel[1]);
                    } else {
                        oids.add((String)dataModel[0]);
                    }
                    return true;
                }
            }, InvocationType.SEARCH, handler.getService().getInterceptors(), handler).proceed());
            Entity entity = detailFormViewData.getEntity();
            String ct = versionSpecified ? entity.getOid() + "." + entity.getVersion() : entity.getOid();
            if (!oids.contains(ct)) {
                return false;
            }
        }
        return true;
    }
}

