/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.refcombo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.iplass.gem.command.generic.HasDisplayScriptBindings;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.PreparedQuery;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferenceComboSetting;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/generic/refcombo/referenceCombo", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"selName", "data"}, checkXRequestedWithHeader=true)
@CommandClass(name="gem/generic/refcombo/ReferenceComboCommand", displayName="\u53c2\u7167\u30b3\u30f3\u30dc\u9078\u629e\u30ea\u30b9\u30c8\u53d6\u5f97")
public final class ReferenceComboCommand
implements Command,
HasDisplayScriptBindings {
    public static final String WEBAPI_NAME = "gem/generic/refcombo/referenceCombo";
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);

    public String execute(RequestContext request) {
        block1: {
            Map<String, List<SimpleEntity>> map;
            Iterator<String> iterator;
            String defName = request.getParam("defName");
            String viewName = request.getParam("viewName");
            String propName = request.getParam("propName");
            String viewType = request.getParam("viewType");
            Entity entity = this.getBindingEntity(request);
            PropertyEditor editor = this.evm.getPropertyEditor(defName, viewType, viewName, propName, entity);
            ReferencePropertyEditor rpe = null;
            if (editor instanceof ReferencePropertyEditor) {
                rpe = (ReferencePropertyEditor)editor;
            }
            if (rpe == null || !(iterator = (map = this.getData(rpe, request)).keySet().iterator()).hasNext()) break block1;
            String key = iterator.next();
            request.setAttribute("selName", (Object)key);
            request.setAttribute("data", map.get(key));
        }
        return "SUCCESS";
    }

    private Map<String, List<SimpleEntity>> getData(final ReferencePropertyEditor editor, RequestContext request) {
        LinkedHashMap<String, List<SimpleEntity>> map = new LinkedHashMap<String, List<SimpleEntity>>();
        String defName = editor.getObjectName();
        String propName = editor.getPropertyName();
        ReferenceComboSetting setting = editor.getReferenceComboSetting();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (setting != null && setting.getPropertyName() != null) {
            EntityDefinition red = this.edm.get(defName);
            conditions.addAll(this.getMappedByData(propName, red, setting, map, request));
        }
        if (!conditions.isEmpty() && map.isEmpty()) {
            if (editor.getCondition() != null) {
                conditions.add(new PreparedQuery(editor.getCondition()).condition(null));
            }
            Query q = new Query();
            q.select(new Object[]{"oid"});
            if (editor.getDisplayLabelItem() != null) {
                q.select().add((Object)editor.getDisplayLabelItem());
            } else {
                q.select().add((Object)"name");
            }
            q.from(defName).where((Condition)new And(conditions));
            String sortItem = editor.getSortItem();
            if (sortItem == null || sortItem.isEmpty()) {
                sortItem = "oid";
            }
            SortSpec.SortType sortType = null;
            sortType = editor.getSortType() == null || editor.getSortType() == ReferencePropertyEditor.RefSortType.ASC ? SortSpec.SortType.ASC : SortSpec.SortType.DESC;
            q.order(new SortSpec[]{new SortSpec(sortItem, sortType)});
            final ArrayList list = new ArrayList();
            this.em.searchEntity(q, (Predicate)new Predicate<Entity>(){

                @Override
                public boolean test(Entity dataModel) {
                    if (editor.getDisplayLabelItem() != null) {
                        String displayLabelItem = editor.getDisplayLabelItem();
                        list.add(new SimpleEntity(dataModel.getOid(), (String)dataModel.getValue(displayLabelItem)));
                    } else {
                        list.add(new SimpleEntity(dataModel));
                    }
                    return true;
                }
            });
            map.put(propName, list);
        }
        return map;
    }

    private List<Condition> getMappedByData(String childComboName, EntityDefinition ed, final ReferenceComboSetting setting, Map<String, List<SimpleEntity>> map, RequestContext request) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        String propName = setting.getPropertyName();
        ReferenceProperty rp = (ReferenceProperty)ed.getProperty(propName);
        EntityDefinition red = this.edm.get(rp.getObjectDefinitionName());
        String comboName = childComboName + "." + propName;
        String val = request.getParam(comboName);
        if (StringUtil.isEmpty((String)val)) {
            ReferenceComboSetting parent = setting.getParent();
            if (parent != null && parent.getPropertyName() != null) {
                conditions.addAll(this.getMappedByData(comboName, red, parent, map, request));
            }
            if (parent == null || !conditions.isEmpty()) {
                String sortItem;
                Query query = new Query();
                query.select(new Object[]{"oid"});
                if (setting.getDisplayLabelItem() != null) {
                    query.select().add((Object)setting.getDisplayLabelItem());
                } else {
                    query.select().add((Object)"name");
                }
                query.from(red.getName());
                ArrayList<Condition> condition = new ArrayList<Condition>();
                if (setting.getCondition() != null) {
                    condition.add(new PreparedQuery(setting.getCondition()).condition(null));
                }
                if (!conditions.isEmpty()) {
                    condition.addAll(conditions);
                }
                if (!condition.isEmpty()) {
                    And and = new And(condition);
                    query.where((Condition)and);
                }
                if ((sortItem = setting.getSortItem()) == null || sortItem.isEmpty()) {
                    sortItem = "oid";
                }
                SortSpec.SortType sortType = null;
                sortType = setting.getSortType() == null || setting.getSortType() == ReferencePropertyEditor.RefSortType.ASC ? SortSpec.SortType.ASC : SortSpec.SortType.DESC;
                query.order(new SortSpec[]{new SortSpec(sortItem, sortType)});
                final ArrayList list = new ArrayList();
                this.em.searchEntity(query, (Predicate)new Predicate<Entity>(){

                    @Override
                    public boolean test(Entity dataModel) {
                        if (setting.getDisplayLabelItem() != null) {
                            String displayLabelItem = setting.getDisplayLabelItem();
                            list.add(new SimpleEntity(dataModel.getOid(), (String)dataModel.getValue(displayLabelItem)));
                        } else {
                            list.add(new SimpleEntity(dataModel));
                        }
                        return true;
                    }
                });
                map.put(comboName, list);
            }
        } else {
            conditions.add((Condition)new Equals(propName + ".oid", (Object)val));
        }
        return conditions;
    }

    class SimpleEntity {
        private String oid;
        private String name;

        public SimpleEntity(Entity entity) {
            this.oid = entity.getOid();
            this.name = entity.getName();
        }

        public SimpleEntity(String oid, String name) {
            this.oid = oid;
            this.name = name;
        }

        public String getOid() {
            return this.oid;
        }

        public void setOid(String oid) {
            this.oid = oid;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

